/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ExecutorUtils {
    public static ForkJoinPool createForkJoinPool(int parallelism) {
        return new ForkJoinPool(parallelism, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }

    public static void awaitWithGracefulShutdown(ExecutorService pool) {
        if (pool == null) {
            return;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static <Type> Type await(Future<?> future, ExecutorService pool) throws InterruptedException, ExecutionException, TimeoutException {
        if (pool != null) {
            ExecutorUtils.awaitWithGracefulShutdown(pool);
        }
        if (future == null) {
            return null;
        }
        return (Type)future.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }
}

