/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.authentication.basic;

import com.kms.katalon.core.webui.authentication.basic.BasicAuthenticationStrategy;
import com.kms.katalon.core.webui.authentication.basic.BiDiBasicAuth;
import com.kms.katalon.core.webui.authentication.basic.CdpBasicAuth;
import com.kms.katalon.core.webui.authentication.basic.EmbeddedCredentialsUrlBasicAuth;
import com.kms.katalon.core.webui.authentication.basic.NoOpBasicAuth;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.bidi.BiDiDriverUtil;
import com.kms.katalon.core.webui.util.WebDriverUtil;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class BasicAuthenticationStrategyFactory {
    private final String CHROME_BROWSER_NAME = "chrome";
    private final String FIREFOX_BROWSER_NAME = "firefox";
    private final String EDGE_BROWSER_NAME = "edge";

    public BasicAuthenticationStrategy getBasicAuthenticationStrategy() {
        String browserName = WebDriverUtil.getBrowserName(DriverFactory.getWebDriver());
        if (!StringUtils.isEmpty((CharSequence)browserName)) {
            if (StringUtils.containsIgnoreCase((CharSequence)browserName, (CharSequence)"firefox")) {
                if (this.useBiDi()) {
                    return new BiDiBasicAuth();
                }
                return new EmbeddedCredentialsUrlBasicAuth();
            }
            if (StringUtils.containsIgnoreCase((CharSequence)browserName, (CharSequence)"chrome") || StringUtils.containsIgnoreCase((CharSequence)browserName, (CharSequence)"edge")) {
                return new CdpBasicAuth();
            }
        }
        return new NoOpBasicAuth();
    }

    private boolean useBiDi() {
        WebDriver webDriver = DriverFactory.getWebDriver();
        if (webDriver instanceof RemoteWebDriver) {
            RemoteWebDriver remoteDriver = (RemoteWebDriver)webDriver;
            return BiDiDriverUtil.getBiDiCapability(remoteDriver.getCapabilities());
        }
        return false;
    }
}

