/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.WebElement;

public class FindElementsResult {
    private List<WebElement> elements;
    private String locator;
    private SelectorMethod locatorMethod;
    private String screenshot;

    public FindElementsResult() {
    }

    public FindElementsResult(List<WebElement> elements, String locator, SelectorMethod locatorMethod, String screenshot) {
        this.locatorMethod = locatorMethod;
        this.locator = locator;
        this.elements = elements;
        this.screenshot = screenshot;
    }

    public FindElementsResult(WebElement element, String locator, SelectorMethod locatorMethod, String screenshot) {
        this(new ArrayList<WebElement>(), locator, locatorMethod, screenshot);
        if (element != null) {
            this.elements.add(element);
        }
    }

    public static FindElementsResult from(List<WebElement> elements, String locator, SelectorMethod locatorMethod, String screenshot) {
        return new FindElementsResult(elements, locator, locatorMethod, screenshot);
    }

    public static FindElementsResult from(List<WebElement> elements, String locator, SelectorMethod locatorMethod) {
        return new FindElementsResult(elements, locator, locatorMethod, "");
    }

    public static FindElementsResult from(WebElement element, String locator, SelectorMethod locatorMethod, String screenshot) {
        return new FindElementsResult(element, locator, locatorMethod, screenshot);
    }

    public static FindElementsResult from(String locator, SelectorMethod locatorMethod, String screenshot) {
        return FindElementsResult.from(Collections.emptyList(), locator, locatorMethod, screenshot);
    }

    public static FindElementsResult from(String locator, SelectorMethod locatorMethod) {
        return FindElementsResult.from(locator, locatorMethod, "");
    }

    public static FindElementsResult from(SelectorMethod locatorMethod) {
        return FindElementsResult.from("", locatorMethod, "");
    }

    public static FindElementsResult from(List<WebElement> elements, TestObject healedTestObject) {
        SelectorMethod method = healedTestObject.getSelectorMethod();
        String locator = (String)healedTestObject.getSelectorCollection().get(method);
        return FindElementsResult.from(elements, locator, method);
    }

    public SelectorMethod getLocatorMethod() {
        return this.locatorMethod;
    }

    public void setLocatorMethod(SelectorMethod locatorMethod) {
        this.locatorMethod = locatorMethod;
    }

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }

    public List<WebElement> getElements() {
        return this.elements;
    }

    public void setElements(List<WebElement> elements) {
        this.elements = elements;
    }

    public WebElement getElement() {
        return this.elements != null && this.elements.size() > 0 ? this.elements.get(0) : null;
    }

    public void setElement(WebElement element) {
        if (this.elements == null) {
            this.elements = new ArrayList<WebElement>();
        } else {
            this.elements.clear();
        }
        this.elements.add(element);
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }
}

