/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common.controller;

import com.kms.katalon.core.webui.driver.bidi.BiDiDriverUtil;
import com.kms.katalon.core.webui.model.ElementWaitingInteractableState;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public class ElementWaitingPhase {
    private final String INTERACTABLE_WAIT_UTIL_SCRIPT_NAME = "interactable-wait-util.js";
    protected JavascriptExecutor executor;

    public ElementWaitingPhase() {
    }

    public ElementWaitingPhase(JavascriptExecutor executor) {
        this.executor = executor;
    }

    protected String getInteractableWaitUtilScript() throws IOException {
        return BiDiDriverUtil.getScriptContent("interactable-wait-util.js");
    }

    protected String getWaitingScript() {
        return "async function waitWithDOMMutation(validator, timeout) {\n    return new Promise((resolve, reject) => {\n        try {\n            if (timeout <= 0) {\n                resolve(false);\n                return;\n            }\n\n            if (validator()) {\n                resolve(true);\n                return;\n            }\n\n            const observer = new MutationObserver((mutations) => {\n                if (validator()) {\n                    observer.disconnect();\n                    resolve(true);\n                }\n            });\n\n            observer.observe(document.body, { childList: true, attributes: true, subtree: true });\n\n            setTimeout(() => {\n                resolve(false);\n                observer.disconnect();\n            }, timeout);\n        } catch (error) {\n            reject(error);\n        }\n    });\n}\nconst notifyWaitingResult = arguments[arguments.length - 1];\nconst element = arguments[0];\nconst timeout = arguments[1];\n\nconst ElementWaitingInteractableState = {\n    DONE: 'DONE',\n    ELEMENT_DETACHED: 'ELEMENT_DETACHED',\n    TIMED_OUT: 'TIMED_OUT',\n    ERROR: 'ERROR',\n};\n\nfunction notifyWaitingError(error) {\n    notifyWaitingResult({ result: ElementWaitingInteractableState.ERROR, error: error.message });\n}\n\n\n// Wait for detached\nwaitWithDOMMutation(() => {\n    if (!element || !element.isConnected) {\n        return true;\n    }\n    return false;\n}, timeout).then((isDetached) => {\n    notifyWaitingResult({ result: isDetached\n        ? ElementWaitingInteractableState.ELEMENT_DETACHED\n        : ElementWaitingInteractableState.TIMED_OUT });\n}).catch(notifyWaitingError);\n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean wait(WebElement element, long timeoutInMillis) {
        if (this.executor == null) {
            throw new IllegalStateException("JavascriptExecutor is not found.");
        }
        String runningScript = this.getWaitingScript();
        try {
            LinkedHashMap resultMap;
            Object result = this.executor.executeAsyncScript(runningScript, new Object[]{element, timeoutInMillis});
            if (result instanceof LinkedHashMap && (resultMap = (LinkedHashMap)result).containsKey("result")) {
                switch (ElementWaitingInteractableState.valueOf(resultMap.get("result").toString())) {
                    case DONE: {
                        return true;
                    }
                    case ELEMENT_DETACHED: {
                        throw new IllegalStateException("Element is detached from the DOM while waiting interactable");
                    }
                    case TIMED_OUT: {
                        throw new IllegalStateException("Waiting for element timed out");
                    }
                    case ERROR: {
                        throw new IllegalStateException("Error during waiting interactable: " + String.valueOf(resultMap.get("error")));
                    }
                }
                return false;
            }
            return false;
        }
        catch (JavascriptException e) {
            throw new IllegalStateException("Error executing waiting script: " + e.getMessage(), e);
        }
    }
}

