/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.webui.driver.BaseDriverBuilder;
import com.kms.katalon.core.webui.driver.bidi.BiDiDriverUtil;
import com.kms.katalon.core.webui.driver.smart.SmartDriverUtil;
import com.kms.katalon.core.webui.util.WebDriverProxyUtil;
import com.kms.katalon.selenium.validator.W3CCapabilitiesValidator;
import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.AbstractDriverOptions;

public abstract class AbstractDriverBuilder
extends BaseDriverBuilder {
    @Override
    public WebDriver build() throws Exception {
        Capabilities capabilities = this.prepareCapabilities(this.capabilities);
        W3CCapabilitiesValidator.validate((Capabilities)capabilities);
        boolean useBiDi = this.canUseBiDi() && BiDiDriverUtil.getBiDiCapability(capabilities);
        boolean useExtension = !useBiDi;
        AbstractDriverOptions<?> options = this.createOptions(capabilities);
        if (useExtension) {
            if (this.withSmartLocator) {
                options = this.addSmartLocatorExtension(options);
            }
            if (this.withSmartWait) {
                options = this.addSmartWaitExtension(options);
            }
            if (this.withFlutterAppTesting) {
                options = this.addFlutterAppTestingExtension(options);
            }
            if (this.withCanvasTextExtraction) {
                options = this.addCanvasTextExtractionExtension(options);
            }
            if (this.withClosedShadowDOMTesting) {
                options = this.addClosedShadowDOMTestingExtension(options);
            }
        }
        options = this.applyProxy(options);
        WebDriver driver = this.createDriver(options);
        if (useBiDi) {
            this.injectSmartExtensions(driver);
        }
        driver = SmartDriverUtil.createSmartDriver(driver);
        return driver;
    }

    protected boolean canUseBiDi() {
        return false;
    }

    protected Capabilities prepareCapabilities(Capabilities capabilities) {
        if (this.canUseBiDi()) {
            capabilities = this.enableDefaultBiDi(capabilities);
        }
        capabilities = this.ignoreUnhandledPrompt(capabilities);
        return capabilities;
    }

    protected abstract AbstractDriverOptions<?> createOptions(Capabilities var1);

    protected AbstractDriverOptions<?> addSmartWaitExtension(AbstractDriverOptions<?> options) throws IOException {
        return options;
    }

    protected AbstractDriverOptions<?> addSmartLocatorExtension(AbstractDriverOptions<?> options) throws IOException {
        return options;
    }

    protected AbstractDriverOptions<?> addFlutterAppTestingExtension(AbstractDriverOptions<?> options) throws IOException {
        return options;
    }

    protected AbstractDriverOptions<?> addCanvasTextExtractionExtension(AbstractDriverOptions<?> options) throws IOException {
        return options;
    }

    protected AbstractDriverOptions<?> addClosedShadowDOMTestingExtension(AbstractDriverOptions<?> options) throws IOException {
        return options;
    }

    protected AbstractDriverOptions<?> applyProxy(AbstractDriverOptions<?> options) throws IOException {
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        if (proxyInfo != null && !ProxyOption.NO_PROXY.equals((Object)ProxyOption.valueOf((String)proxyInfo.getProxyOption())) && proxyInfo.isApplyToDesiredCapabilities()) {
            options.setProxy(WebDriverProxyUtil.getSeleniumProxy(proxyInfo));
        }
        return options;
    }

    protected abstract WebDriver createDriver(AbstractDriverOptions<?> var1) throws Exception;

    protected Capabilities enableDefaultBiDi(Capabilities capabilities) {
        boolean hasBiDi = BiDiDriverUtil.hasBiDiCapability(capabilities);
        if (!hasBiDi) {
            MutableCapabilities newCaps = new MutableCapabilities(capabilities);
            newCaps.setCapability("webSocketUrl", true);
            return newCaps;
        }
        return capabilities;
    }

    protected abstract Capabilities ignoreUnhandledPrompt(Capabilities var1);
}

