/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.appium.exception.AppiumStartException;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import io.appium.java_client.AppiumDriver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebMobileDriverFactory {
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebMobileDriverFactory.class);
    private static final String CHROME = "Chrome";
    private static final String SAFARI = "Safari";
    private static final int DEFAULT_APPIUM_NEW_COMMAND_TIMEOUT = 1800;
    public static final String MOBILE_DRIVER_PROPERTY = "Mobile";
    public static final String EXECUTED_MOBILE_PLATFORM = "devicePlatform";
    public static final String EXECUTED_MOBILE_DEVICE_ID = "deviceId";

    public static void cleanup() throws InterruptedException, IOException {
        AppiumDriverManager.cleanup();
    }

    public static AppiumDriver getDriver() throws StepFailedException {
        return AppiumDriverManager.getDriver();
    }

    public static void setDriver(AppiumDriver driver) {
        AppiumDriverManager.setDriver((AppiumDriver)driver);
    }

    public static void closeDriver() {
        AppiumDriverManager.closeDriver();
    }

    private static DesiredCapabilities toDesireCapabilities(Map<String, Object> propertyMap, WebUIDriverType WebUIDriverType2) {
        DesiredCapabilities desireCapabilities = new DesiredCapabilities();
        String prefix = AppiumVersionUtil.getInstance().getAppiumDesiredCapabilityPrefix();
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
            String key = property.getKey();
            desireCapabilities.setCapability((String)(key.contains(":") ? key : prefix + key), property.getValue());
        }
        return desireCapabilities;
    }

    private static DesiredCapabilities createCapabilities(WebUIDriverType osType, String platformVersion) {
        String deviceName;
        String prefix;
        String deviceId;
        DesiredCapabilities capabilities;
        block11: {
            capabilities = new DesiredCapabilities();
            Map driverPreferences = RunConfiguration.getDriverPreferencesProperties((String)MOBILE_DRIVER_PROPERTY);
            deviceId = WebMobileDriverFactory.getDeviceId();
            prefix = AppiumVersionUtil.getInstance().getAppiumDesiredCapabilityPrefix();
            if (StringUtils.isNotEmpty((CharSequence)platformVersion)) {
                capabilities.setCapability(prefix + "platformVersion", platformVersion);
            }
            int finalNewCommandTimeout = RunConfiguration.getAppiumNewCommandTimeout().orElse(1800);
            capabilities.setCapability(prefix + "newCommandTimeout", (Object)finalNewCommandTimeout);
            if (driverPreferences != null && osType == WebUIDriverType.IOS_DRIVER) {
                capabilities.merge((Capabilities)WebMobileDriverFactory.toDesireCapabilities(driverPreferences, WebUIDriverType.IOS_DRIVER));
                capabilities.setCapability(prefix + "browserName", SAFARI);
                if (deviceId == null) {
                    capabilities.setCapability("platformName", WebMobileDriverFactory.getDeviceOS());
                }
                try {
                    int XCodeVersion = AppiumDriverManager.getXCodeVersion();
                    if (XCodeVersion < 8) break block11;
                    capabilities.setCapability(prefix + "automationName", "XCUITest");
                    capabilities.setCapability(prefix + "wdaLocalPort", (Object)AppiumDriverManager.getFreePort());
                    if (XCodeVersion < 15) {
                        capabilities.setCapability(prefix + "realDeviceLogger", RunConfiguration.getDeviceConsoleExecutable());
                    }
                }
                catch (ExecutionException executionException) {}
            } else if (driverPreferences != null && osType == WebUIDriverType.ANDROID_DRIVER) {
                capabilities.merge((Capabilities)WebMobileDriverFactory.toDesireCapabilities(driverPreferences, WebUIDriverType.ANDROID_DRIVER));
                capabilities.setCapability("platformName", Platform.ANDROID);
                capabilities.setCapability(prefix + "browserName", CHROME);
                capabilities.setCapability(prefix + "automationName", "uiautomator2");
                Map defaultChromeCapabilities = new ChromeOptions().asMap();
                HashMap defaultChromeOptions = new HashMap();
                defaultChromeOptions.putAll((Map)defaultChromeCapabilities.get("goog:chromeOptions"));
                Map userChromeOptions = (Map)capabilities.getCapability("goog:chromeOptions");
                if (userChromeOptions != null) {
                    defaultChromeOptions.putAll(userChromeOptions);
                }
                HashMap<String, Object> allChromeCapabilities = new HashMap<String, Object>();
                allChromeCapabilities.putAll(defaultChromeCapabilities);
                allChromeCapabilities.put("goog:chromeOptions", defaultChromeOptions);
                capabilities.setCapability("goog:chromeOptions", (Object)WebMobileDriverFactory.toDesireCapabilities(allChromeCapabilities, null));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(deviceName = WebMobileDriverFactory.getDeviceName()))) {
            capabilities.setCapability(prefix + "deviceName", deviceName);
        }
        if (deviceId != null) {
            capabilities.setCapability(prefix + "udid", deviceId);
        }
        return capabilities;
    }

    public static AppiumDriver startExisitingMobileDriver(IDriverType driverType, String sessionId, String remoteServerUrl) throws MalformedURLException, MobileDriverInitializeException {
        return AppiumDriverManager.startExisitingMobileDriver((IDriverType)driverType, (String)sessionId, (String)remoteServerUrl);
    }

    public static AppiumDriver createMobileDriver(WebUIDriverType osType) throws MobileDriverInitializeException, IOException, InterruptedException, AppiumStartException {
        return AppiumDriverManager.createMobileDriver((IDriverType)osType, (String)WebMobileDriverFactory.getDeviceId(), (DesiredCapabilities)WebMobileDriverFactory.createCapabilities(osType, WebMobileDriverFactory.getDeviceOSVersion()));
    }

    public static WebUIDriverType getWebMobileDriverType() {
        return WebUIDriverType.valueOf(RunConfiguration.getDriverSystemProperty((String)"WebUI", (String)EXECUTED_MOBILE_PLATFORM));
    }

    public static String getDevicePlatform() {
        return WebMobileDriverFactory.getWebMobileDriverType().toString();
    }

    public static String getDeviceId() {
        return AppiumDriverManager.getDeviceId((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceName() {
        return AppiumDriverManager.getDeviceName((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceModel() {
        return AppiumDriverManager.getDeviceModel((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceManufacturer() {
        return AppiumDriverManager.getDeviceManufacturer((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceOSVersion() {
        return AppiumDriverManager.getDeviceOSVersion((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceOS() {
        return AppiumDriverManager.getDeviceOS((String)MOBILE_DRIVER_PROPERTY);
    }
}

