/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver.firefox;

import com.kms.katalon.core.webui.driver.AbstractDriverBuilder;
import com.kms.katalon.core.webui.driver.firefox.FirefoxDriverUtil;
import com.kms.katalon.core.webui.util.FileUtil;
import com.kms.katalon.selenium.driver.CFirefoxDriver;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class FirefoxDriverBuilder
extends AbstractDriverBuilder {
    private static final String SMART_LOCATOR_ADDON_PATH = "Firefox" + File.separator + "smartlocator.xpi";
    private static final String SMART_WAIT_ADDON_PATH = "Firefox" + File.separator + "smartwait.xpi";
    protected FirefoxOptions options;
    protected FirefoxProfile profile;
    protected GeckoDriverService driverService;

    public FirefoxDriverBuilder options(FirefoxOptions options) {
        this.options = options;
        return this;
    }

    public FirefoxDriverBuilder profile(FirefoxProfile profile) {
        this.profile = profile;
        return this;
    }

    public FirefoxDriverBuilder driverService(GeckoDriverService driverService) {
        this.driverService = driverService;
        return this;
    }

    @Override
    protected boolean canUseBiDi() {
        return true;
    }

    @Override
    protected AbstractDriverOptions<?> createOptions(Capabilities capabilities) {
        FirefoxOptions options = this.options;
        if (options == null) {
            options = new FirefoxOptions(capabilities);
        }
        if (this.profile != null) {
            options.setProfile(this.profile);
        }
        return options;
    }

    @Override
    protected AbstractDriverOptions<?> addSmartWaitExtension(AbstractDriverOptions<?> options) throws IOException {
        return this.addExtension(options, SMART_WAIT_ADDON_PATH);
    }

    @Override
    protected AbstractDriverOptions<?> addSmartLocatorExtension(AbstractDriverOptions<?> options) throws IOException {
        return this.addExtension(options, SMART_LOCATOR_ADDON_PATH);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected WebDriver createDriver(AbstractDriverOptions<?> options) {
        String driverPath;
        void firefoxOptions;
        if (!(options instanceof FirefoxOptions)) {
            return null;
        }
        FirefoxOptions firefoxOptions2 = (FirefoxOptions)options;
        if (Platform.getCurrent().is(Platform.MAC)) {
            firefoxOptions.setBinary("/Applications/Firefox.app/Contents/MacOS/firefox");
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverPath = FirefoxDriverUtil.getDriverPath()))) {
            System.setProperty("webdriver.gecko.driver", driverPath);
        }
        if (this.driverService == null) {
            return new CFirefoxDriver((FirefoxOptions)firefoxOptions, driverConfigProvider.getActionDelayInMilisecond());
        }
        return new CFirefoxDriver(this.driverService, (FirefoxOptions)firefoxOptions, driverConfigProvider.getActionDelayInMilisecond());
    }

    /*
     * WARNING - void declaration
     */
    private AbstractDriverOptions<?> addExtension(AbstractDriverOptions<?> options, String extensionPath) throws IOException {
        void firefoxOptions;
        if (!(options instanceof FirefoxOptions)) {
            return options;
        }
        FirefoxOptions firefoxOptions2 = (FirefoxOptions)options;
        FirefoxProfile profile = firefoxOptions.getProfile();
        if (profile == null) {
            profile = new FirefoxProfile();
            firefoxOptions.setProfile(profile);
        }
        File extension = new File(FileUtil.getExtensionsDirectory(), extensionPath);
        profile.addExtension(extension);
        firefoxOptions.setProfile(profile);
        return firefoxOptions;
    }

    @Override
    protected Capabilities ignoreUnhandledPrompt(Capabilities capabilities) {
        Object currentBehavior = capabilities.getCapability("unhandledPromptBehavior");
        if (currentBehavior != null) {
            return capabilities;
        }
        Map<String, String> userPromptHandler = Map.of("alert", "ignore", "beforeUnload", "ignore", "confirm", "ignore", "default", "ignore", "prompt", "ignore");
        MutableCapabilities newCaps = new MutableCapabilities(capabilities);
        newCaps.setCapability("unhandledPromptBehavior", userPromptHandler);
        return newCaps;
    }
}

