/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.model;

import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.core.webui.common.controller.AbortController;
import com.kms.katalon.core.webui.exception.WebElementNotFoundException;
import com.kms.katalon.core.webui.exception.WebElementNotInteractableException;
import com.kms.katalon.util.ExecutorUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.WebDriverException;

public class SeleniumActionRetryController {
    public static final long DEFAULT_RETRY_DELAY = 0L;

    public <ReturnType> ReturnType retry(RetryableAction<ReturnType> action, int maxRetries) throws Exception {
        return this.retry(action, maxRetries, 0L);
    }

    public <ReturnType> ReturnType retry(RetryableAction<ReturnType> action, int maxRetries, long delayBetweenRetries) throws Exception {
        return this.performAction(action, delayBetweenRetries, retryContext -> retryContext.retryCount < maxRetries);
    }

    public <ReturnType> ReturnType retry(RetryableAction<ReturnType> action, long timeout) throws Exception {
        return this.retry(action, timeout, 0L);
    }

    public <ReturnType> ReturnType retry(RetryableAction<ReturnType> action, long timeout, long delayBetweenRetries) throws Exception {
        AbortController abortController = new AbortController();
        TimeUtil.setTimeout(() -> abortController.abort("Action timed out"), (long)timeout);
        Exception[] lastException = new Exception[1];
        ExecutorService actionExecutor = Executors.newSingleThreadExecutor();
        abortController.getSignal().addListener(signal -> actionExecutor.shutdownNow());
        Future<Object> actionFuture = actionExecutor.submit(() -> this.performAction(action, delayBetweenRetries, currentRetryCount -> true, lastException));
        try {
            return (ReturnType)ExecutorUtils.await(actionFuture, (ExecutorService)actionExecutor);
        }
        catch (InterruptedException | ExecutionException exception) {
            if (lastException[0] != null) {
                throw lastException[0];
            }
            return null;
        }
    }

    public <ReturnType> ReturnType performAction(RetryableAction<ReturnType> action, long delayBetweenRetries, ShouldRetryCondition shouldRetry) throws Exception {
        return this.performAction(action, delayBetweenRetries, shouldRetry, new Exception[1]);
    }

    public <ReturnType> ReturnType performAction(RetryableAction<ReturnType> action, long delayBetweenRetries, ShouldRetryCondition shouldRetry, Exception[] lastException) throws Exception {
        AtomicInteger retryCount = new AtomicInteger(0);
        long startTime = System.currentTimeMillis();
        RetryContext retryContext = null;
        do {
            int currentRetryCount = retryCount.get();
            retryContext = new RetryContext(currentRetryCount, startTime);
            try {
                return action.execute(retryContext);
            }
            catch (InterruptedException error) {
                throw error;
            }
            catch (WebElementNotFoundException | WebElementNotInteractableException | WebDriverException error) {
                lastException[0] = error;
                if (!shouldRetry.get(retryContext)) {
                    throw error;
                }
            }
            catch (Exception error) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)error);
                if (rootCause instanceof InterruptedException) {
                    throw (InterruptedException)rootCause;
                }
                lastException[0] = error;
                throw error;
            }
            Thread.sleep(delayBetweenRetries);
        } while (shouldRetry.get(retryContext = new RetryContext(retryCount.getAndIncrement(), startTime)));
        if (lastException[0] != null) {
            throw lastException[0];
        }
        return null;
    }

    public static class RetryContext {
        public int retryCount;
        public long startTime;

        public RetryContext(int retryCount, long startTime) {
            this.retryCount = retryCount;
            this.startTime = startTime;
        }

        public long getElapsedTime() {
            return System.currentTimeMillis() - this.startTime;
        }
    }

    public static interface RetryableAction<ReturnType> {
        public ReturnType execute(RetryContext var1) throws Exception;
    }

    public static interface ShouldRetryCondition {
        public boolean get(RetryContext var1);
    }
}

