/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.OSUtil;
import java.io.File;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;

public class WebDriverPropertyUtil {
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebDriverPropertyUtil.class);
    public static final String CHROME_SWITCHES = "chrome.switches";
    public static final String CHROME_NO_SANDBOX = "--no-sandbox";
    private static final String CHROME_ARGUMENT_PROPERTY_KEY = "args";
    public static final String CHROME_BINARY_PROPERTY_KEY = "binary";
    private static final String CHROME_EXTENSIONS_PROPERTY_KEY = "extensions";
    private static final String CHROME_PREFERENCES_PROPERTY_KEY = "prefs";
    private static final String CHROME_LOCALSTATE_PROPERTY_KEY = "localState";
    private static final String CHROME_DETACH_PROPERTY_KEY = "detach";
    private static final String CHROME_DEBUGGER_ADDRESS_PROPERTY_KEY = "debuggerAddress";
    private static final String CHROME_EXCLUDE_SWITCHES_PROPERTY_KEY = "excludeSwitches";
    private static final String CHROME_MINI_DUMP_PATH_PROPERTY_KEY = "minidumpPath";
    private static final String CHROME_MOBILE_EMULATION_PROPERTY_KEY = "mobileEmulation";
    private static final String CHROME_PREF_LOGGING_PREFS_PROPERTY_KEY = "perfLoggingPrefs";
    private static final String[] CHROME_CAPABILITIES = new String[]{"args", "binary", "extensions", "prefs", "localState", "detach", "debuggerAddress", "excludeSwitches", "minidumpPath", "mobileEmulation", "perfLoggingPrefs"};
    private static final String STARTUP_HOMEPAGE_WELCOME_URL_ADDITIONAL_PREFERENCE = "startup.homepage_welcome_url.additional";
    private static final String STARTUP_HOMEPAGE_WELCOME_URL_PREFERENCE = "startup.homepage_welcome_url";
    public static final String BROWSER_STARTUP_HOMEPAGE_PREFERENCE = "browser.startup.homepage";
    private static final String FIREFOX_BLANK_PAGE = "about:blank";
    private static final String FIREFOX_PROFILE_KEY = "profile";
    private static final String EDGE_BINARY_PROPERTY_KEY = "binary";
    public static final String KATALON_DOCKER_ENV_KEY = "KATALON_DOCKER";
    private static final String CHROME_PROPERTY_USER_DATA_DIR = "user-data-dir=";
    private static final String CHROME_PROPERTY_PROFILE_DIR = "profile-directory=";
    private static final String CHROME_KATALON_COMPACT_UTILITY_EXTENSION_RELATIVE_PATH = "Extensions" + File.separator + "gkihajmjffefinkmpokfepcdbhnpflee";
    private static final String EDGE_CHROMIUM_KATALON_COMPACT_UTILITY_EXTENSION_RELATIVE_PATH = "Extensions" + File.separator + "kkmafoknllgdaapbegpkpmbncidodkaa";

    public static MutableCapabilities toDesireCapabilities(Map<String, Object> propertyMap, WebUIDriverType webUIDriverType) {
        if (propertyMap == null) {
            return null;
        }
        switch (webUIDriverType) {
            case CHROME_DRIVER: 
            case HEADLESS_DRIVER: {
                return WebDriverPropertyUtil.getDesireCapabilitiesForChrome(propertyMap);
            }
            case FIREFOX_DRIVER: 
            case FIREFOX_HEADLESS_DRIVER: {
                return WebDriverPropertyUtil.getDesireCapabilitiesForFirefox(propertyMap);
            }
            case EDGE_CHROMIUM_DRIVER: {
                return WebDriverPropertyUtil.getDesiredCapabilitiesForEdgeChromium(propertyMap, true);
            }
        }
        return WebDriverPropertyUtil.toDesireCapabilities(propertyMap);
    }

    public static MutableCapabilities toDesireCapabilities(Map<String, Object> propertyMap) {
        return WebDriverPropertyUtil.toDesireCapabilities(propertyMap, new MutableCapabilities(), true);
    }

    public static MutableCapabilities toDesireCapabilities(Map<String, Object> propertyMap, MutableCapabilities desireCapabilities, boolean isLog) {
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            desireCapabilities.setCapability(property.getKey(), property.getValue());
            if (!isLog || WebDriverPropertyUtil.isRunFromTestCloudWithSauceLabs(property)) continue;
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
        }
        return desireCapabilities;
    }

    public static MutableCapabilities getDesiredCapabilitiesForEdgeChromium(Map<String, Object> propertyMap, boolean isLog) {
        EdgeOptions options = new EdgeOptions();
        MutableCapabilities mutableCapabilities = new MutableCapabilities();
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            if (isLog) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
            }
            mutableCapabilities.setCapability(property.getKey(), property.getValue());
        }
        options = options.merge((Capabilities)mutableCapabilities);
        if (OSUtil.isMac()) {
            options.setPlatformName(Platform.MAC.toString());
        } else if (OSUtil.isWindows()) {
            options.setPlatformName(Platform.WINDOWS.toString());
        } else {
            options.setPlatformName(Platform.LINUX.toString());
        }
        if (options.getPlatformName() == Platform.LINUX) {
            HashMap msEdgeOptions = (HashMap)options.getCapability("ms:edgeOptions");
            if (msEdgeOptions == null) {
                msEdgeOptions = new HashMap();
            }
            if (!msEdgeOptions.containsKey("binary")) {
                File msEdgeBinaryFilePath;
                String msEdgeBinary = ConsoleCommandExecutor.safeWhere((String)"microsoft-edge");
                if (StringUtils.isEmpty((CharSequence)msEdgeBinary)) {
                    msEdgeBinary = "/usr/bin/microsoft-edge";
                }
                if ((msEdgeBinaryFilePath = new File(msEdgeBinary)).exists()) {
                    options.setBinary(msEdgeBinaryFilePath);
                }
            }
        }
        return options;
    }

    public static MutableCapabilities getDesireCapabilitiesForFirefox(Map<String, Object> propertyMap) {
        MutableCapabilities mutableCapabilities = new MutableCapabilities();
        FirefoxProfile firefoxProfile = WebDriverPropertyUtil.createDefaultFirefoxProfile();
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            if (property.getKey().equals(FIREFOX_PROFILE_KEY) && property.getValue() instanceof Map) {
                WebDriverPropertyUtil.processFirefoxPreferencesSetting(firefoxProfile, (Map)property.getValue());
                continue;
            }
            mutableCapabilities.setCapability(property.getKey(), property.getValue());
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
        }
        FirefoxOptions options = new FirefoxOptions((Capabilities)mutableCapabilities);
        options = options.merge((Capabilities)mutableCapabilities);
        options.setProfile(firefoxProfile);
        return options;
    }

    private static void processFirefoxPreferencesSetting(FirefoxProfile firefoxProfile, Map<?, ?> firefoxPropertyMap) {
        for (Map.Entry<?, ?> entry : firefoxPropertyMap.entrySet()) {
            String entryKey;
            if (!(entry.getKey() instanceof String) || !WebDriverPropertyUtil.setFirefoxPreferenceValue(firefoxProfile, entryKey = (String)entry.getKey(), entry.getValue())) continue;
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FIREFOX_PROPERTY_SETTING, entryKey, entry.getValue()));
        }
    }

    private static boolean setFirefoxPreferenceValue(FirefoxProfile firefoxProfile, String entryKey, Object entryValue) {
        if (entryValue instanceof Number) {
            firefoxProfile.setPreference(entryKey, (Object)((Number)entryValue).intValue());
            return true;
        }
        if (entryValue instanceof Boolean) {
            firefoxProfile.setPreference(entryKey, (Object)((Boolean)entryValue));
            return true;
        }
        if (entryValue instanceof String) {
            firefoxProfile.setPreference(entryKey, (Object)((String)entryValue));
            return true;
        }
        return false;
    }

    public static FirefoxProfile createDefaultFirefoxProfile() {
        FirefoxProfile firefoxProfile = new FirefoxProfile();
        firefoxProfile.setPreference(BROWSER_STARTUP_HOMEPAGE_PREFERENCE, (Object)FIREFOX_BLANK_PAGE);
        firefoxProfile.setPreference(STARTUP_HOMEPAGE_WELCOME_URL_PREFERENCE, (Object)FIREFOX_BLANK_PAGE);
        firefoxProfile.setPreference(STARTUP_HOMEPAGE_WELCOME_URL_ADDITIONAL_PREFERENCE, (Object)FIREFOX_BLANK_PAGE);
        return firefoxProfile;
    }

    public static MutableCapabilities getDesireCapabilitiesForChrome(Map<String, Object> propertyMap) {
        MutableCapabilities mutableCapabilities = new MutableCapabilities();
        HashMap<String, Object> chromeOptions = new HashMap<String, Object>();
        for (Map.Entry<String, Object> driverProperty : propertyMap.entrySet()) {
            if (Arrays.asList(CHROME_CAPABILITIES).contains(driverProperty.getKey())) {
                chromeOptions.put(driverProperty.getKey(), driverProperty.getValue());
            } else {
                mutableCapabilities.setCapability(driverProperty.getKey(), driverProperty.getValue());
            }
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, driverProperty.getKey(), driverProperty.getValue()));
        }
        WebDriverPropertyUtil.injectAddtionalArgumentsForChrome(chromeOptions);
        mutableCapabilities.setCapability("goog:chromeOptions", chromeOptions);
        return WebDriverPropertyUtil.generateDefaultChromeOptions().merge((Capabilities)mutableCapabilities);
    }

    private static void injectAddtionalArgumentsForChrome(Map<String, Object> chromeOptions) {
        if (chromeOptions == null) {
            return;
        }
        ArrayList<String> argumentsList = new ArrayList<String>();
        if (chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY) instanceof List) {
            argumentsList.addAll((List)chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY));
        }
        if (WebDriverPropertyUtil.isRunningInDocker()) {
            argumentsList.add(CHROME_NO_SANDBOX);
        }
        chromeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argumentsList);
    }

    public static boolean isRunningInDocker() {
        if (System.getenv().containsKey(KATALON_DOCKER_ENV_KEY)) {
            return Boolean.valueOf(System.getenv(KATALON_DOCKER_ENV_KEY));
        }
        return false;
    }

    private static boolean isRunFromTestCloudWithSauceLabs(Map.Entry<String, Object> property) {
        return TestCloudPropertyUtil.getInstance().isRunFromTestCloud() && (property.getKey().equals("accessKey") || property.getKey().equals("username"));
    }

    public static boolean didUserProfileInstallKatalonCompactUtility(WebUIDriverType driverType, Capabilities capabilities) {
        String capabilityKey = "";
        switch (driverType) {
            case CHROME_DRIVER: {
                capabilityKey = "goog:chromeOptions";
                break;
            }
            case EDGE_CHROMIUM_DRIVER: {
                capabilityKey = "ms:edgeOptions";
                break;
            }
            default: {
                return false;
            }
        }
        Map options = (Map)capabilities.getCapability(capabilityKey);
        if (options == null) {
            return false;
        }
        List argsEntry = (List)options.get(CHROME_ARGUMENT_PROPERTY_KEY);
        if (argsEntry == null) {
            return false;
        }
        Optional<String> userDataDirOptional = argsEntry.stream().filter(arg -> arg.contains(CHROME_PROPERTY_USER_DATA_DIR)).map(arg -> arg.replace(CHROME_PROPERTY_USER_DATA_DIR, "")).findAny();
        if (!userDataDirOptional.isPresent() || userDataDirOptional.get().isEmpty()) {
            return false;
        }
        Optional<String> profileDirOptional = argsEntry.stream().filter(arg -> arg.contains(CHROME_PROPERTY_PROFILE_DIR)).map(arg -> arg.replace(CHROME_PROPERTY_PROFILE_DIR, "")).findAny();
        if (!profileDirOptional.isPresent() || profileDirOptional.get().isEmpty()) {
            return false;
        }
        String userDataDir = userDataDirOptional.get().replace(CHROME_PROPERTY_USER_DATA_DIR, "");
        String profileDir = Paths.get(userDataDir, profileDirOptional.get().replace(CHROME_PROPERTY_PROFILE_DIR, "")).toString();
        switch (driverType) {
            case CHROME_DRIVER: {
                File extensionChromeKCUFolder = new File(profileDir, CHROME_KATALON_COMPACT_UTILITY_EXTENSION_RELATIVE_PATH);
                return extensionChromeKCUFolder.exists();
            }
            case EDGE_CHROMIUM_DRIVER: {
                File extensionEdgeKCUFolder = new File(profileDir, EDGE_CHROMIUM_KATALON_COMPACT_UTILITY_EXTENSION_RELATIVE_PATH);
                return extensionEdgeKCUFolder.exists();
            }
        }
        return false;
    }

    public static ChromeOptions generateDefaultChromeOptions() {
        return (ChromeOptions)new ChromeOptions().addArguments(new String[]{"disable-features=DisableLoadExtensionCommandLineSwitch"});
    }
}

