/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.component;

import com.kms.katalon.ai.core.model.apigen.ApiEndpoint;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationEndpoint;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationEndpointStatus;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationTask;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationTaskStatus;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationTestObjectMap;
import com.kms.katalon.ai.core.model.exception.TestArtifactGenerationException;
import com.kms.katalon.ai.core.services.ITestArtifactGenerationController;
import com.kms.katalon.composer.ai.component.ConnectivityStatus;
import com.kms.katalon.composer.ai.generation.dialogs.TestArtifactGenerationDialog;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.services.IAdminService;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ui.progress.IProgressConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestArtifactGenerationMonitoringJob
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(TestArtifactGenerationMonitoringJob.class);
    @Inject
    private IAdminService adminService;
    private Map<String, TestArtifactGenerationEndpoint> completedEndpoints = new HashMap<String, TestArtifactGenerationEndpoint>();
    @Inject
    private ITestArtifactGenerationController controller;
    private TestArtifactGenerationDialog dialog;
    private IStatus status;
    private TestArtifactGenerationTask task;
    String payload;
    List<ApiEndpoint> selectedApiEndPoints;
    List<TestArtifactGenerationTestObjectMap> testObjectMaps;

    public TestArtifactGenerationMonitoringJob(String name) {
        super(name);
    }

    public boolean isModal(Job job) {
        Boolean isModal = (Boolean)job.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    public void setDialog(TestArtifactGenerationDialog dialog) {
        this.dialog = dialog;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setSelectedApiEndPoints(List<ApiEndpoint> selectedApiEndPoints) {
        this.selectedApiEndPoints = selectedApiEndPoints;
    }

    public void setTestObjectMaps(List<TestArtifactGenerationTestObjectMap> testObjectMaps) {
        this.testObjectMaps = testObjectMaps;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block18: {
            this.setProperty(IProgressConstants.ICON_PROPERTY, Dialog.getImage((String)"genai/auto_generate_testcase_ai.png"));
            this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action("View generation progress"){

                public void run() {
                    UISynchronizeService.syncExec(() -> TestArtifactGenerationMonitoringJob.this.dialog.show());
                }
            });
            boolean isOnline = false;
            try {
                UISynchronizeService.syncExec(() -> this.dialog.setConnectivityStatus(ConnectivityStatus.CHECKING));
                isOnline = this.adminService.testAdminConnection();
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
            if (!isOnline) {
                UISynchronizeService.syncExec(() -> this.dialog.setConnectivityStatus(ConnectivityStatus.DISCONNECTED));
                return Status.warning((String)"DISCONNECTED");
            }
            UISynchronizeService.syncExec(() -> this.dialog.setConnectivityStatus(ConnectivityStatus.CONNECTED));
            try {
                this.task = this.controller.submitTask(this.payload, this.selectedApiEndPoints, this.testObjectMaps);
            }
            catch (TestArtifactGenerationException e) {
                logger.error(e.getMessage());
                UISynchronizeService.syncExec(() -> this.dialog.setGenerationFailedStatus());
                return Status.warning((String)"SUBMIT");
            }
            UISynchronizeService.syncExec(() -> this.dialog.setGenerationTask(this.task));
            monitor.beginTask("Generate tests using AI...", this.task.getEndpoints().size());
            while (true) {
                if (monitor.isCanceled()) {
                    this.status = Status.CANCEL_STATUS;
                    break block18;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                if (monitor.isCanceled()) {
                    this.status = Status.CANCEL_STATUS;
                    break block18;
                }
                try {
                    this.task = this.controller.getTask(this.task.getId());
                }
                catch (TestArtifactGenerationException e) {
                    logger.error("Cannot get generation task: " + this.task.getId(), (Throwable)e);
                    continue;
                }
                if (this.task.getStatus() == TestArtifactGenerationTaskStatus.CANCELLED) {
                    this.status = Status.CANCEL_STATUS;
                    break block18;
                }
                for (TestArtifactGenerationEndpoint endpoint : this.task.getEndpoints()) {
                    if (monitor.isCanceled()) {
                        this.status = Status.OK_STATUS;
                        break;
                    }
                    TestArtifactGenerationEndpointStatus status = endpoint.getStatus();
                    if (status == TestArtifactGenerationEndpointStatus.CANCELLED) {
                        this.status = Status.CANCEL_STATUS;
                        break;
                    }
                    if (this.completedEndpoints.containsKey(endpoint.getId()) || status != TestArtifactGenerationEndpointStatus.COMPLETED) continue;
                    try {
                        endpoint = this.controller.getEndpoint(this.task.getId(), endpoint.getId());
                    }
                    catch (TestArtifactGenerationException e) {
                        logger.error("Cannot get endpoint generation: " + endpoint.getId(), (Throwable)e);
                        continue;
                    }
                    if (status != TestArtifactGenerationEndpointStatus.COMPLETED) continue;
                    this.completedEndpoints.put(endpoint.getId(), endpoint);
                    TestArtifactGenerationEndpoint finalEndpoint = endpoint;
                    UISynchronizeService.asyncExec(() -> this.dialog.updateEndpointStatus(this.task, finalEndpoint));
                    monitor.worked(1);
                }
                if (this.completedEndpoints.size() == this.task.getEndpoints().size()) break;
            }
            this.status = Status.OK_STATUS;
        }
        return this.status;
    }
}

