/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.part;

import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.composer.ai.studioassist.part.StudioAssistChatNavigator;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.StudioAssistSetting;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.webserver.WebViewController;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatPart
extends StudioAssistChatNavigator
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatPart.class);
    @Inject
    EPartService partService;
    @Inject
    IEventBroker eventBroker;
    private Composite mainComposite;

    @PostConstruct
    public void render(Composite parent) {
        this.mainComposite = (Composite)ComponentBuilder.fillContainer((Composite)parent).build();
        boolean hasOpenedProject = ProjectController.getInstance().getCurrentProject() != null;
        boolean objectRepositoryEnabled = hasOpenedProject && StudioAssistSetting.isProjectContextObjectRepositoriesEnabled();
        boolean customKeywordEnabled = hasOpenedProject && StudioAssistSetting.isProjectContextCustomKeywordsEnabled();
        boolean isIncludeFocusingFile = StudioAssistSetting.isIncludeFocusingFileEnabled();
        boolean isOfflineOrOP = !ApplicationInfo.getLoginMethod().equals((Object)LoginMethod.SSO);
        boolean shouldDisplayAttachmentBadge = StudioAssistSetting.shouldDisplayAttachmentBadge();
        StudioAssistConfigType type = null;
        try {
            StudioAssistConfig config = this.studioAssistController.getConfig();
            if (config != null) {
                type = config.getType();
            }
        }
        catch (Exception exception) {
            this.logger.warn("Unable to load Studio Assist Config Type");
        }
        try {
            URIBuilder uriBuilder = WebViewController.getInstance().buildURIBuilder("StudioAssistChat.html");
            uriBuilder.addParameter("status", "LOADING");
            uriBuilder.addParameter("port", String.valueOf(WebViewController.getInstance().getPort()));
            uriBuilder.addParameter("isOfflineOrOP", Boolean.toString(isOfflineOrOP));
            uriBuilder.addParameter("objectRepositoryProjectContextEnabled", Boolean.toString(objectRepositoryEnabled));
            uriBuilder.addParameter("customKeywordProjectContextEnabled", Boolean.toString(customKeywordEnabled));
            uriBuilder.addParameter("isIncludeFocusingFileEnabled", Boolean.toString(isIncludeFocusingFile));
            uriBuilder.addParameter("allowAttachFromProject", Boolean.toString(hasOpenedProject));
            uriBuilder.addParameter("shouldDisplayAttachmentBadge", Boolean.toString(shouldDisplayAttachmentBadge));
            uriBuilder.addParameter("chatMode", ChatMode.ASK.getName());
            if (type != null) {
                uriBuilder.addParameter("studioAssistConfigType", type.getDisplayName());
            }
            String url = uriBuilder.toString();
            this.logger.trace("studio assist url -> " + url);
            this.browser = (Browser)ComponentBuilder.browser((Composite)this.mainComposite).url(url).defaultBrowserConfig().fill().build();
            this.browser.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if ((e.stateMask & 0x400000) != 0 && e.keyCode == 97) {
                        StudioAssistChatPart.this.browser.execute("document.execCommand('selectAll');");
                        e.doit = false;
                    }
                }
            });
        }
        catch (URISyntaxException e) {
            this.logger.error("Fail while getting URL to render StudioAssist Chat Part.", (Throwable)e);
        }
        this.registerListener();
    }

    @Override
    protected Composite getMainComposite() {
        return this.mainComposite;
    }

    private void registerListener() {
        this.partService.addPartListener((IPartListener)this);
    }

    @PreDestroy
    public void onDestroy() {
        try {
            this.eventBroker.send("ON_STUDIO_ASSIST_CLOSE_CHAT", null);
            this.close();
        }
        catch (Exception e) {
            this.logger.error("Exception while onDestroy processing", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)String.format("[Warn] Having unexpected error when the object %s is being removed from DI Container", this.getClass().getName()));
        }
    }

    @Focus
    public void onFocus() {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite)) {
            this.mainComposite.forceFocus();
        }
    }

    @Override
    public void close() throws Exception {
        try {
            MUIElement toolControl = this.modelService.find("com.kms.katalon.partstack.rightsidebar(com.kms.katalon.composer.window.main).(com.kms.katalon.composer.perspective.keyword)", (MUIElement)this.application);
            if (toolControl != null) {
                toolControl.setVisible(false);
            }
            this.partService.removePartListener((IPartListener)this);
            this.studioAssistChatController.close();
            this.sessionContext.disposeSession();
            this.mainComposite.dispose();
            this.browser.dispose();
            this.referenceContextController.clear();
            if (this.answerWorker != null) {
                this.answerWorker.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while close processing", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)String.format("[Warn] Having unexpected error when closing the object %s", this.studioAssistChatController.getClass().getName()));
        }
    }
}

