/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.part;

import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentStatus;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.controller.IStudioAssistReferenceContextController;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.util.AttachmentUtil;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.part.FileEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistPartListener
implements IPartListener {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistPartListener.class);
    private static final String UPDATE_FOCUSING_FILE_NAME = "updateFocusingFile(%s);";
    private static final String CLEAN_FOCUSING_FILE_NAME = "updateFocusingFile();";
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Inject
    protected IStudioAssistReferenceContextController referenceContextController;
    protected Browser browser;

    public void partBroughtToTop(MPart part) {
        FileEditorInput fileInput;
        IFile file;
        EditorInformation detectedInformation = this.detectEditorPart((MElementContainer<MUIElement>)part.getParent());
        if (!detectedInformation.isEditorPart()) {
            return;
        }
        boolean isFeatureFile = GroovyEditorUtil.isFeatureFileEditorPart((MPart)part);
        boolean isGroovyFile = GroovyEditorUtil.isGroovyEditorPart((MPart)part);
        boolean isJavaFile = GroovyEditorUtil.isJavaEditorPart((MPart)part);
        if ((isGroovyFile || isFeatureFile || isJavaFile) && (file = (fileInput = (FileEditorInput)GroovyEditorUtil.getEditor((MPart)part).getEditorInput()).getFile()) != null) {
            if (file.getProjectRelativePath().toString().startsWith("Scripts/") || file.getProjectRelativePath().toString().startsWith("Test Suites/")) {
                return;
            }
            StudioAssistFileType fileType = isFeatureFile ? StudioAssistFileType.FEATURE_FILE : (isGroovyFile ? StudioAssistFileType.GROOVY : StudioAssistFileType.JAVA);
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject == null) {
                this.browser.evaluate(this.prepareEvaluationUpdateFocusingFileScript(null));
                return;
            }
            Path path = Paths.get(currentProject.getFolderLocation(), new String[0]).resolve(file.getProjectRelativePath().toOSString());
            this.browser.evaluate(this.prepareEvaluationUpdateFocusingFileScript(new StudioAssistChatAttachment(fileType, path.toString(), AttachmentUtil.checkAttachmentStatus((String)path.toString()), StudioAssistAttachmentSource.FOCUSING_FILE)));
            return;
        }
        if (detectedInformation.isFocusingFileSupported()) {
            StudioAssistAttachmentStatus attachmentStatus = StudioAssistAttachmentStatus.VALID;
            try {
                attachmentStatus = this.referenceContextController.validateAttachment(detectedInformation.filePath, detectedInformation.fileType);
            }
            catch (StudioAssistBaseException studioAssistBaseException) {
                attachmentStatus = StudioAssistAttachmentStatus.NOT_EXIST;
            }
            this.browser.evaluate(this.prepareEvaluationUpdateFocusingFileScript(new StudioAssistChatAttachment(detectedInformation.getFileType(), detectedInformation.getFilePath(), attachmentStatus, StudioAssistAttachmentSource.FOCUSING_FILE)));
            return;
        }
        this.browser.evaluate(this.prepareEvaluationUpdateFocusingFileScript(null));
    }

    public void partDeactivated(MPart part) {
    }

    public void partHidden(MPart part) {
    }

    public void partActivated(MPart part) {
        this.showStudioAssistPart(part);
    }

    public void partVisible(MPart part) {
        this.showStudioAssistPart(part);
    }

    private String prepareEvaluationUpdateFocusingFileScript(StudioAssistChatAttachment attachment) {
        if (attachment == null || StringUtils.isBlank((CharSequence)attachment.getFilePath())) {
            this.logger.trace("evaluateUpdateFocusingFile -> " + null);
            return CLEAN_FOCUSING_FILE_NAME;
        }
        String script = UPDATE_FOCUSING_FILE_NAME.formatted(JsonUtil.toJson((Object)attachment));
        this.logger.trace("evaluateUpdateFocusingFile -> " + JsonUtil.toJson((Object)attachment));
        return script;
    }

    private void showStudioAssistPart(MPart part) {
        MUIElement toolControl;
        MPartStack partStack = (MPartStack)this.modelService.find("com.kms.katalon.partstack.rightsidebar", (MUIElement)this.application);
        if (partStack != null && "com.kms.katalon.composer.ai.studioassist.view".equals(part.getElementId())) {
            partStack.getTags().remove("Minimized");
            partStack.setSelectedElement((MUIElement)part);
        }
        if ((toolControl = this.modelService.find("com.kms.katalon.partstack.rightsidebar(com.kms.katalon.composer.window.main).(com.kms.katalon.composer.perspective.keyword)", (MUIElement)this.application)) != null && "com.kms.katalon.composer.ai.studioassist.view".equals(part.getElementId())) {
            toolControl.setVisible(true);
        }
    }

    private EditorInformation detectEditorPart(MElementContainer<MUIElement> part) {
        MPart mPart;
        if (part == null) {
            return new EditorInformation();
        }
        if (!part.getElementId().equals("com.kms.katalon.composer.content")) {
            return this.detectEditorPart((MElementContainer<MUIElement>)part.getParent());
        }
        MUIElement focusingPart = part.getSelectedElement();
        if (focusingPart == null) {
            return new EditorInformation();
        }
        String elementId = focusingPart.getElementId();
        if (elementId.contains("com.kms.katalon.composer.content.executionProfile")) {
            Pattern pattern = Pattern.compile("com.kms.katalon.composer.content.executionProfile\\((.+)\\)");
            Matcher matcher = pattern.matcher(elementId);
            if (matcher.find()) {
                String filePath = matcher.group(1);
                return new EditorInformation(StudioAssistFileType.PROFILE, filePath);
            }
        } else if (elementId.contains("com.kms.katalon.composer.content.testobject") && focusingPart instanceof MPart && (mPart = (MPart)focusingPart).getContributionURI().contains("com.kms.katalon.composer.webservice")) {
            Pattern pattern = Pattern.compile("com.kms.katalon.composer.content.testobject\\((.+)\\)");
            Matcher matcher = pattern.matcher(elementId);
            if (matcher.find()) {
                String filePath = matcher.group(1);
                return new EditorInformation(StudioAssistFileType.WEB_SERVICE_OBJECT, filePath);
            }
        } else {
            Pattern pattern;
            Matcher matcher;
            MPart mPart2;
            Object object;
            if (elementId.contains("com.kms.katalon.composer.content.testcase") && focusingPart instanceof MPart && (object = (mPart2 = (MPart)focusingPart).getObject()) instanceof TestCaseCompositePart) {
                TestCaseCompositePart testCasePart = (TestCaseCompositePart)object;
                TestCaseEntity testCase = testCasePart.getTestCase();
                return new EditorInformation(StudioAssistFileType.TEST_CASE, testCase.getId());
            }
            if (elementId.contains("com.kms.katalon.composer.content.testsuite") && (matcher = (pattern = Pattern.compile("com.kms.katalon.composer.content.testsuite\\((.+)\\)")).matcher(elementId)).find()) {
                String filePath = matcher.group(1);
                return new EditorInformation(StudioAssistFileType.TEST_SUITE, filePath);
            }
        }
        return new EditorInformation(StudioAssistFileType.OTHER, null);
    }

    private class EditorInformation {
        private StudioAssistFileType fileType;
        private String filePath;

        public EditorInformation() {
        }

        public EditorInformation(StudioAssistFileType fileType, String filePath) {
            this.fileType = fileType;
            this.filePath = filePath;
        }

        public StudioAssistFileType getFileType() {
            return this.fileType;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public boolean isEditorPart() {
            return this.fileType != null;
        }

        public boolean isFocusingFileSupported() {
            return this.fileType != StudioAssistFileType.OTHER && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.filePath});
        }
    }
}

