/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.composer.ai.studioassist.preference.AiAutoTagComponent;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AdminControlTag;
import com.kms.katalon.session.core.model.AiAutoTagSetting;
import java.util.Map;
import java.util.Optional;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class AdminManagedAiAutoTagComponent
extends AiAutoTagComponent {
    private static final Map<AdminControlTag, String> TAG_LABELS = Map.of(AdminControlTag.API_TEST_CASE_GENERATION, "API Test Case Generation", AdminControlTag.STUDIO_ASSIST_CODE_GENERATION, "StudioAssist Code Generation");

    public AdminManagedAiAutoTagComponent(Composite parent, AiAutoTagSetting aiAutoTaggingSetting, IStudioAssistController controller) {
        super(parent, aiAutoTaggingSetting, controller);
    }

    @Override
    protected Composite createContent(Composite parent) {
        ComponentBuilder.label((Composite)parent).text("Auto-tagging is enabled and managed by Admin").color(ColorUtil.themeColor((Color)ColorUtil.INFO_LABEL_LIGHT_THEME, (Color)ColorUtil.INFO_LABEL_DARK_THEME)).marginTop(5).build();
        Composite component = (Composite)ComponentBuilder.gridContainer((Composite)parent).gridLayout(1).fillHorizontal().build();
        this.createTagCheckBox(component, AdminControlTag.API_TEST_CASE_GENERATION);
        this.createTagCheckBox(component, AdminControlTag.STUDIO_ASSIST_CODE_GENERATION);
        return component;
    }

    private Button createTagCheckBox(Composite parent, AdminControlTag tag) {
        Button checkBox = (Button)ComponentBuilder.checkBox((Composite)parent).text(TAG_LABELS.get(tag)).color(ColorUtil.themeColor((Color)ColorUtil.INFO_LABEL_LIGHT_THEME, (Color)ColorUtil.INFO_LABEL_DARK_THEME)).marginTop(5).disable().build();
        Optional<String> tagValue = this.findTagValue(tag);
        checkBox.setSelection(tagValue.isPresent());
        tagValue.ifPresent(value -> this.createTagNameComposite(parent, (String)value));
        return checkBox;
    }

    private Optional<String> findTagValue(AdminControlTag tag) {
        return this.aiAutoTaggingSetting.getAdministrationManagedAiAutoTag().stream().filter(autoTag -> tag.equals((Object)autoTag.getKey())).findFirst().map(autoTag -> autoTag.getValue());
    }

    private void createTagNameComposite(Composite parent, String tagName) {
        Composite component = (Composite)ComponentBuilder.group((Composite)parent).gridLayout(2).borderRadius(10).border(1).margin(0).color(ColorUtil.themeColor((Color)ColorUtil.INFO_LABEL_LIGHT_THEME, (Color)ColorUtil.INFO_LABEL_DARK_THEME)).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Tag Name").color(ColorUtil.themeColor((Color)ColorUtil.INFO_LABEL_LIGHT_THEME, (Color)ColorUtil.INFO_LABEL_DARK_THEME)).bold().margin(0, 0, 10, 5).build();
        ComponentBuilder.text((Composite)component).text(tagName).marginLeft(20).color(ColorUtil.themeColor((Color)ColorUtil.INFO_LABEL_LIGHT_THEME, (Color)ColorUtil.INFO_LABEL_DARK_THEME)).marginBottom(10).disable().build();
    }

    @Override
    public void saveConfig() {
    }

    @Override
    public void resetConfig() {
    }
}

