/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.EdgeChromiumDriverConnector;
import com.kms.katalon.execution.webui.driver.WebDriverUpdateManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class EdgeChromiumRunConfiguration
extends WebUiRunConfiguration {
    private String driverPath = WebDriverUpdateManager.getInstance().getEdgeChromiumDriverPath();

    public EdgeChromiumRunConfiguration(String projectDir) throws IOException {
        super(projectDir, new EdgeChromiumDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof EdgeChromiumDriverConnector)) continue;
            EdgeChromiumDriverConnector driverConnector = (EdgeChromiumDriverConnector)entry.getValue();
            driverConnector.setEdgeDriverPath(this.driverPath);
        }
        return driverConnectors;
    }

    public Map<String, String> getAdditionalEnvironmentVariables() throws IOException, ExecutionException {
        HashMap<String, String> environmentVariables = new HashMap<String, String>(super.getAdditionalEnvironmentVariables());
        environmentVariables.put("KATALON_DOCKER", String.valueOf(WebDriverPropertyUtil.isRunningInDocker()));
        return environmentVariables;
    }

    public IRunConfiguration cloneConfig() throws IOException, ExecutionException {
        return new EdgeChromiumRunConfiguration(this.projectDir);
    }
}

