/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.util.internal.ProcessUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerInfo;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.DownloadErrorException;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class WebDriverManagerRunConfiguration {
    private File logFile;
    private File errorLogFile;
    IHttpClient httpClient = ApacheHttpClient.getInstance();
    INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();

    public File getWebDriverManagerFatJar() throws IOException {
        String filePath = "resources/tools/webdriver/webdrivermanager-6.3.2-fat.jar";
        if (Platform.inDevelopmentMode()) {
            File parentFolder = new File(ClassPathResolver.getBundleLocation((Bundle)FrameworkUtil.getBundle(WebDriverManagerRunConfiguration.class)));
            return new File(parentFolder, filePath);
        }
        File parentFolder = ClassPathResolver.getConfigurationFolder();
        return new File(parentFolder, filePath);
    }

    public void downloadDriver(WebUIDriverType webUIDriverType, File driverLocation) throws IOException, InterruptedException {
        String osArg;
        String architecture;
        if (ProcessUtil.isKRE() && !this.getWebDriverManagerFatJar().exists()) {
            this.printLog("\nWARNING: Unable to find WebDriverManager, the auto-update WebDriver process is skipped.\n");
            return;
        }
        if (!driverLocation.exists()) {
            driverLocation.mkdirs();
        }
        File webDriverManagerFile = null;
        try {
            webDriverManagerFile = this.downloadWebDriverManager();
        }
        catch (DownloadErrorException e) {
            this.printErrorLog("Failed to download WebDriverManager, error: " + e.getMessage() + "\n");
        }
        if (webDriverManagerFile == null || !webDriverManagerFile.exists()) {
            this.printLog("Use built-in WebDriverManager\n");
            webDriverManagerFile = this.getWebDriverManagerFatJar();
        }
        String proxyCommand = this.getProxyCommand();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(ClassPathResolver.getInstalledJRE((boolean)false));
        commands.add(String.format("-Dwdm.cachePath=%s", driverLocation.getCanonicalPath()));
        commands.add("-Dwdm.forceDownload=true");
        if (!OSUtil.isMac() && !OSUtil.isWindows()) {
            commands.add("-Dwdm.avoidBrowserDetection=false");
        }
        commands.add(String.format("-Dwdm.geckoDriverUrl=%s", "https://raw.githubusercontent.com/katalon-studio/katalon-studio/master/gecko-releases.json"));
        if (StringUtils.isNotEmpty((String)proxyCommand)) {
            commands.add(proxyCommand);
        }
        if (StringUtils.isNotEmpty((String)(architecture = this.getArchitecture(webUIDriverType)))) {
            commands.add(architecture);
        }
        if (StringUtils.isNotBlank((String)(osArg = this.getOSArgument()))) {
            commands.add(osArg);
        }
        commands.add("-jar");
        commands.add(webDriverManagerFile.getName());
        commands.add("resolveDriverFor");
        commands.add(this.getDriverName(webUIDriverType));
        ProcessBuilder builder = new ProcessBuilder(commands).directory(new File(webDriverManagerFile.getParent()));
        if (this.getLogFile() != null) {
            builder.redirectOutput(ProcessBuilder.Redirect.appendTo(this.getLogFile()));
        }
        if (this.getErrorLogFile() != null) {
            builder.redirectError(ProcessBuilder.Redirect.appendTo(this.getErrorLogFile()));
        }
        builder.start().waitFor();
    }

    private String getArchitecture(WebUIDriverType webUIDriverType) {
        return "";
    }

    private String getOSArgument() {
        if (OSUtil.isMac()) {
            return "-Dwdm.os=MAC";
        }
        if (OSUtil.isWindows()) {
            return "-Dwdm.os=WIN";
        }
        if (OSUtil.isUnix() || OSUtil.isSolaris()) {
            return "-Dwdm.os=LINUX";
        }
        return "";
    }

    private String getDriverName(WebUIDriverType webUIDriverType) {
        switch (webUIDriverType) {
            case CHROME_DRIVER: 
            case HEADLESS_DRIVER: {
                return "chrome";
            }
            case EDGE_CHROMIUM_DRIVER: {
                return "edge";
            }
            case FIREFOX_DRIVER: 
            case FIREFOX_HEADLESS_DRIVER: {
                return "firefox";
            }
        }
        throw new IllegalArgumentException("Driver is not supported");
    }

    private String getProxyCommand() {
        ProxyInformation proxy = ProxyPreferences.getSystemProxyInformation();
        switch (ProxyOption.valueOf((String)proxy.getProxyOption())) {
            case NO_PROXY: 
            case USE_SYSTEM: {
                return "";
            }
            case MANUAL_CONFIG: {
                String url = proxy.getProxyServerAddress();
                String port = Integer.toString(proxy.getProxyServerPort());
                String userName = proxy.getUsername();
                String password = proxy.getPassword();
                if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)password)) {
                    return "-Dwdm.proxy=" + userName + ":" + password + "@" + url + ":" + port;
                }
                return "-Dwdm.proxy=" + url + ":" + port;
            }
        }
        return "";
    }

    public File getErrorLogFile() {
        return this.errorLogFile;
    }

    public void setErrorLogFile(File errorLogFile) {
        this.errorLogFile = errorLogFile;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    private File downloadWebDriverManager() throws DownloadErrorException {
        File downloadedFile = null;
        try {
            this.printLog("Checking WebDriverManager");
            WebDriverManagerInfo webDriverManagerInfo = this.downloadWebDriverManagerInfo();
            if (Objects.nonNull(webDriverManagerInfo)) {
                String checksum;
                File downloadedFolder;
                File webDriverManagerBuiltinFile = this.getWebDriverManagerFatJar();
                if (Objects.nonNull(webDriverManagerBuiltinFile) && webDriverManagerBuiltinFile.exists()) {
                    this.printLog("Verify built-in web driver manager");
                    String fileName = FilenameUtils.getName((String)webDriverManagerBuiltinFile.getAbsolutePath());
                    if (StringUtils.equalsIgnoreCase((String)fileName, (String)webDriverManagerInfo.getFile())) {
                        this.printLog("Using built-in file");
                        return webDriverManagerBuiltinFile;
                    }
                    this.printLog("file name mismatch");
                }
                if (Objects.nonNull(downloadedFile = Paths.get((downloadedFolder = new File(GlobalStringConstants.APP_USER_DIR_LOCATION)).getAbsolutePath(), webDriverManagerInfo.getFile()).toFile()) && downloadedFile.exists()) {
                    this.printLog("The caching file exists");
                    checksum = this.hashSha256(downloadedFile);
                    if (StringUtils.equalsIgnoreCase((String)checksum, (String)webDriverManagerInfo.getSha256())) {
                        this.printLog("Using caching file");
                        return downloadedFile;
                    }
                    this.printLog("checksum mismatch");
                }
                this.printLog("Downloading file from S3...");
                downloadedFile = this.downloadWebDriverManagerFromS3(webDriverManagerInfo.getFile());
                if (Objects.nonNull(downloadedFile) && downloadedFile.exists()) {
                    this.printLog("The file download was successful");
                    checksum = this.hashSha256(downloadedFile);
                    if (!StringUtils.equalsIgnoreCase((String)checksum, (String)webDriverManagerInfo.getSha256())) {
                        throw new IOException("checksum mismatch");
                    }
                    return downloadedFile;
                }
                this.printErrorLog("Failed to download the WebDriverManager from S3!");
            }
        }
        catch (Exception e) {
            throw new DownloadErrorException((Throwable)e);
        }
        return null;
    }

    private WebDriverManagerInfo downloadWebDriverManagerInfo() {
        URI uri = null;
        try {
            uri = new URI("https://download.katalon.com/webdrivermanager/jdk17/update.json");
        }
        catch (URISyntaxException e) {
            this.printErrorLog(e.getMessage());
            return null;
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(new HashMap()).proxy(proxyConfig).build();
        try {
            HttpResponse response = this.httpClient.get(uri, httpOptions);
            return (WebDriverManagerInfo)response.json(WebDriverManagerInfo.class);
        }
        catch (HttpException e) {
            this.printErrorLog(e.getMessage());
            return null;
        }
    }

    private File downloadWebDriverManagerFromS3(String fileName) {
        URI uri = null;
        try {
            URI jsonUri = new URI("https://download.katalon.com/webdrivermanager/jdk17/update.json");
            URIBuilder uriBuilder = new URIBuilder().setScheme(jsonUri.getScheme()).setHost(jsonUri.getHost()).setPort(jsonUri.getPort());
            CharSequence[] paths = jsonUri.getPath().split("/");
            paths[paths.length - 1] = fileName;
            uriBuilder.setPath(String.join((CharSequence)"/", paths));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            this.printErrorLog(e.getMessage());
            return null;
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(new HashMap()).proxy(proxyConfig).build();
        File downloadedFolder = new File(GlobalStringConstants.APP_USER_DIR_LOCATION);
        File downloadedFile = Paths.get(downloadedFolder.getAbsolutePath(), fileName).toFile();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(downloadedFile);
        }
        catch (FileNotFoundException e) {
            this.printErrorLog(e.getMessage());
            return null;
        }
        try {
            this.httpClient.download(uri, (OutputStream)outputStream, httpOptions, null);
            return downloadedFile;
        }
        catch (HttpException e) {
            this.printErrorLog(e.getMessage());
            return null;
        }
    }

    private void printLog(String log) {
        try {
            if (Objects.nonNull(this.logFile) && this.logFile.exists()) {
                FileUtils.writeStringToFile((File)this.logFile, (String)(log + "\n"), (boolean)true);
            } else {
                LogUtil.printOutputLine((String)log);
            }
        }
        catch (IOException iOException) {}
    }

    private void printErrorLog(String log) {
        try {
            if (Objects.nonNull(this.errorLogFile) && this.errorLogFile.exists()) {
                FileUtils.writeStringToFile((File)this.errorLogFile, (String)(log + "\n"), (boolean)true);
            } else {
                LogUtil.printErrorLine((String)log);
            }
        }
        catch (IOException iOException) {}
    }

    private String hashSha256(File file) {
        byte[] data = null;
        try {
            data = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
        }
        catch (IOException iOException) {}
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("SHA-256").digest(data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return Hex.encodeHexString(hash);
    }
}

