/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.windows;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.windows.WindowsDriverConnector;
import com.kms.katalon.execution.windows.configuration.impl.WindowsExecutionSetting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WindowsRunConfiguration
extends AbstractRunConfiguration {
    private WindowsDriverConnector driverConnector;
    private ServerOwnership serverOwnership = ServerOwnership.BY_USER;

    public WindowsRunConfiguration(WindowsDriverConnector driverConnector) {
        this.driverConnector = driverConnector;
        this.doInitExecutionSetting();
    }

    public Map<String, IDriverConnector> getDriverConnectors() {
        HashMap<String, IDriverConnector> driverConnectors = new HashMap<String, IDriverConnector>();
        driverConnectors.put("Windows", this.driverConnector);
        return driverConnectors;
    }

    public IRunConfiguration cloneConfig() throws IOException, ExecutionException {
        return new WindowsRunConfiguration(this.driverConnector.clone());
    }

    public boolean shouldTerminateDriverAfterTestSuite() {
        return super.shouldTerminateDriverAfterTestSuite() && ServerOwnership.BY_KATALON.equals((Object)this.serverOwnership);
    }

    public boolean shouldReloadDriverConnectorsBeforeLaunch() {
        return this.shouldTerminateDriverAfterTestSuite();
    }

    public void copyDriverConnectorsFrom(AbstractRunConfiguration otherRunConfig) {
        if (otherRunConfig instanceof WindowsRunConfiguration) {
            WindowsRunConfiguration otherWindowsRunConfig = (WindowsRunConfiguration)otherRunConfig;
            this.driverConnector = otherWindowsRunConfig.driverConnector.clone();
            this.serverOwnership = otherWindowsRunConfig.serverOwnership;
        }
    }

    protected void initExecutionSetting() {
        this.executionSetting = new WindowsExecutionSetting();
    }

    public WindowsDriverConnector getDriverConnector() {
        return this.driverConnector;
    }

    public ServerOwnership getServerOwnership() {
        return this.serverOwnership;
    }

    public void useSelfHostedServer(String serverUrl) {
        this.driverConnector.setDriverUrl(serverUrl);
        this.serverOwnership = ServerOwnership.BY_KATALON;
    }

    public static enum ServerOwnership {
        BY_USER,
        BY_KATALON;

    }
}

