/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.handlers;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.ApiCollectionTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.folder.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameApiCollectionHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EPartService partService;
    @Named(value="activeShell")
    Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof ApiCollectionTreeEntity) {
                    RenameApiCollectionHandler.this.execute((ApiCollectionTreeEntity)object);
                }
            }
        });
    }

    private void execute(ApiCollectionTreeEntity apiCollectionTreeEntity) {
        block7: {
            try {
                ApiCollectionEntity oldApiCollection = apiCollectionTreeEntity.getObject();
                if (oldApiCollection == null) break block7;
                if (oldApiCollection.getParentFolder() == null) {
                    this.renameRootApiCollection(apiCollectionTreeEntity);
                    return;
                }
                RenameWizard renameWizard = new RenameWizard((ITreeEntity)apiCollectionTreeEntity, FolderController.getInstance().getChildrenNames(oldApiCollection.getParentFolder()));
                CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
                int code = wizardDialog.open();
                if (code != 0) break block7;
                ApiCollectionEntity folder = apiCollectionTreeEntity.getObject();
                String oldName = folder.getName();
                String oldFolderId = folder.getId();
                try {
                    if (renameWizard.getNewNameValue() != null && !renameWizard.getNewNameValue().equals("") && !renameWizard.getNewNameValue().equals(oldName)) {
                        String folderParentPath = folder.getParentFolder().getRelativePathForUI().replace('\\', '/') + "/";
                        GroovyUtil.getTestCaseScriptSourceFolder((ProjectEntity)folder.getProject()).refreshLocal(2, null);
                        FolderController.getInstance().updateFolderName((FolderEntity)folder, renameWizard.getNewNameValue());
                        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{folderParentPath + oldName + "/", folderParentPath + renameWizard.getNewNameValue() + "/"});
                        folder.setName(renameWizard.getNewNameValue());
                        this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new Object[]{oldFolderId, folder});
                        if (apiCollectionTreeEntity.getParent() != null) {
                            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)apiCollectionTreeEntity.getParent());
                            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)apiCollectionTreeEntity);
                        }
                        this.partService.saveAll(false);
                    }
                }
                catch (Exception ex) {
                    folder.setName(oldName);
                    LoggerSingleton.getInstance().getLogger().error((Throwable)ex);
                    Object errorMessage = "";
                    errorMessage = ex instanceof FilePathTooLongException ? ex.getMessage() : StringConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_API_COLLECTION + ": " + ex.getMessage();
                    MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR_TITLE, (String)errorMessage);
                }
            }
            catch (Exception e) {
                LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            }
        }
    }

    private void renameRootApiCollection(ApiCollectionTreeEntity apiCollectionTreeEntity) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        List existingNames = FolderController.getInstance().getRootFileOrFolderNames(project);
        ApiCollectionEntity oldFolder = apiCollectionTreeEntity.getObject();
        RenameWizard renameWizard = new RenameWizard((ITreeEntity)apiCollectionTreeEntity, existingNames);
        CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
        if (wizardDialog.open() == 0) {
            String newNameValue = renameWizard.getNewNameValue();
            String oldName = oldFolder.getName();
            String oldFolderId = oldFolder.getId();
            if (!StringUtils.isBlank((String)newNameValue) && !newNameValue.equalsIgnoreCase(oldName)) {
                File newFolder = new File(project.getFolderLocation(), newNameValue);
                oldFolder.toFile().renameTo(newFolder);
                apiCollectionTreeEntity.getObject().setName(newNameValue);
                this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new Object[]{oldFolderId, oldFolder});
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)apiCollectionTreeEntity);
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)apiCollectionTreeEntity);
                this.partService.saveAll(false);
            }
        }
    }
}

