/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.util.HarFileWriter;
import com.kms.katalon.core.util.KatalonHarEntry;
import com.kms.katalon.core.util.RequestInformation;
import com.kms.katalon.core.util.internal.NamingUtil;
import com.kms.katalon.core.webservice.common.HarConverter;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarLog;

public class HarLogger {
    private static String HAR_FILE_REPORT_SUB_FOLDER = "requests";
    private static final KeywordLogger logger = KeywordLogger.getInstance(HarLogger.class);
    private static final AtomicLong requestNumber = new AtomicLong(0L);
    private HarConverter harConverter;

    public void initHarFile() {
        this.harConverter = new HarConverter();
        this.harConverter.initHarFile();
    }

    public File logHarFile(RequestObject request, ResponseObject response, String logFolder) {
        try {
            Har har = this.harConverter.endHar(request, response);
            String requestName = MessageFormat.format("{0}_{1}", request.getName(), String.valueOf(requestNumber.getAndIncrement()));
            RequestInformation requestInformation = new RequestInformation();
            requestInformation.setName(requestName);
            String harId = UUID.randomUUID().toString();
            requestInformation.setHarId(harId);
            requestInformation.setTestObjectId(request.getObjectId());
            String directoryPath = logFolder;
            File directory = Path.of(directoryPath, HAR_FILE_REPORT_SUB_FOLDER, Thread.currentThread().getName()).toFile();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File file = NamingUtil.truncateAndSanitizePath((File)new File(directory, requestInformation.getName() + ".har"));
            file.createNewFile();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("harId", harId);
            logger.logInfo("HAR: " + file.getAbsolutePath(), attributes);
            HarLog harLog = har.getLog();
            List originalEntries = harLog.getEntries();
            List newEntries = originalEntries.stream().map(entry -> {
                KatalonHarEntry katalonEntry = new KatalonHarEntry(entry, logger.getSecureValuesPattern());
                katalonEntry.set_katalonRequestInformation(requestInformation);
                return katalonEntry;
            }).collect(Collectors.toList());
            originalEntries.clear();
            originalEntries.addAll(newEntries);
            HarFileWriter.write((Har)har, (File)file);
            return file;
        }
        catch (Exception error) {
            logger.logError("Cannot create HAR file", null, (Throwable)error);
            return null;
        }
    }
}

