/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.helper;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.ValidationDataType;
import com.kms.katalon.core.util.FileUtil;
import com.kms.katalon.core.webservice.common.ServiceRequestFactory;
import com.kms.katalon.core.webservice.constants.StringConstants;
import com.kms.katalon.core.webservice.util.OpenAPIUtil;
import com.kms.katalon.core.webservice.util.WebServiceCommonUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class WebServiceCommonHelper {
    public static final LocalFileProvider DEFAULT_LOCAL_FILE_PROVIDER = path -> {
        File schemaFile = FileUtil.getFile((String)path);
        if (schemaFile.exists() && schemaFile.isFile()) {
            return FileUtils.readFileToString((File)schemaFile);
        }
        return null;
    };
    public static final RemoteFileProvider DEFAULT_REMOTE_FILE_PROVIDER = url -> {
        RequestObject request = new RequestObject("dummy-id");
        request.setFollowRedirects(true);
        request.setRestRequestMethod("GET");
        request.setRestUrl(url);
        return WebServiceCommonHelper.sendRequest(request).getResponseText();
    };
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebServiceCommonHelper.class);

    public static ResponseObject sendRequest(RequestObject request) throws Exception {
        WebServiceCommonHelper.configRequestTimeout(request);
        WebServiceCommonHelper.configRequestResponseSizeLimit(request);
        ResponseObject responseObject = ServiceRequestFactory.getInstance(request).send(request);
        return responseObject;
    }

    public static void configRequestTimeout(RequestObject request) {
        if (RunConfiguration.canCustomizeRequestTimeout()) {
            Object socketTimeout;
            Object connectionTimeout;
            Map executionSettings = RunConfiguration.getExecutionGeneralProperties();
            if (WebServiceCommonUtil.isUnsetRequestTimeout(request.getConnectionTimeout()) && (connectionTimeout = executionSettings.get("requestConnectionTimeout")) != null) {
                int connectionTimeoutIntVal = ((Number)connectionTimeout).intValue();
                request.setConnectionTimeout(connectionTimeoutIntVal);
            }
            if (WebServiceCommonUtil.isUnsetRequestTimeout(request.getSocketTimeout()) && (socketTimeout = executionSettings.get("requestSocketTimeout")) != null) {
                int socketTimeoutIntVal = ((Number)socketTimeout).intValue();
                request.setSocketTimeout(socketTimeoutIntVal);
            }
        } else {
            request.setConnectionTimeout(-1);
            request.setSocketTimeout(-1);
        }
    }

    public static void configRequestResponseSizeLimit(RequestObject request) {
        if (RunConfiguration.canCustomizeRequestResponseSizeLimit()) {
            Object maxResponseSize;
            Map executionSettings = RunConfiguration.getExecutionGeneralProperties();
            if (WebServiceCommonUtil.isUnsetMaxRequestResponseSize(request.getMaxResponseSize()) && (maxResponseSize = executionSettings.get("maxResponseSize")) != null) {
                long maxResponseSizeLongVal = ((Number)maxResponseSize).longValue();
                request.setMaxResponseSize(maxResponseSizeLongVal);
            }
        } else {
            request.setMaxResponseSize(-1L);
        }
    }

    public static void checkRequestObject(RequestObject requestObject) throws IllegalArgumentException {
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_REQUEST_OBJECT);
        if (requestObject == null) {
            throw new IllegalArgumentException(StringConstants.KW_LOG_FAILED_REQUEST_OBJECT_IS_NULL);
        }
    }

    public static void checkRequestObjectBody(RequestObject requestObject) throws Exception {
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_REQUEST_BODY_OBJECT);
        if (requestObject.getBodyContent() == null) {
            throw new IllegalArgumentException(StringConstants.KW_LOG_FAILED_REQUEST_OBJECT_IS_NULL);
        }
    }

    public static void checkResponseObject(ResponseObject responseObject) throws IllegalArgumentException {
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_RESPONSE_OBJECT);
        if (responseObject == null) {
            throw new IllegalArgumentException(StringConstants.KW_LOG_FAILED_RESPONSE_OBJECT_IS_NULL);
        }
    }

    public static void checkResponseObjectContent(ResponseObject responseObject) throws Exception {
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_RESPONSE_OBJECT_CONTENT);
        if (responseObject.getResponseBodyContent() == null) {
            throw new IllegalArgumentException(StringConstants.KW_LOG_FAILED_RESPONSE_OBJECT_CONTENT_IS_NULL);
        }
    }

    public static Object parseAndExecuteExpressionForXml(String locator, String groovyFunction, String xmlText) {
        String[] tokens = locator.split("\\.");
        String rootName = "";
        Object locatorExp = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            locatorExp = (String)locatorExp + token;
            if (i < tokens.length - 1) {
                locatorExp = (String)locatorExp + ".";
            } else if (i == tokens.length - 1) {
                locatorExp = (String)locatorExp + "." + groovyFunction;
            }
            if (i == 0) {
                rootName = token;
            }
            ++i;
        }
        StringBuilder groovyScript = new StringBuilder();
        groovyScript.append("def " + rootName + " = new XmlSlurper().parseText(xmlText);");
        groovyScript.append("return " + (String)locatorExp);
        Binding binding = new Binding();
        binding.setVariable("xmlText", (Object)xmlText);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(groovyScript.toString());
    }

    public static Object parseAndGetPropertyValueForXml(String locator, String xmlText) {
        String[] tokens = locator.split("\\.");
        String rootName = "";
        Object locatorExp = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            locatorExp = (String)locatorExp + token;
            if (i < tokens.length - 1) {
                locatorExp = (String)locatorExp + ".";
            }
            if (i == 0) {
                rootName = token;
            }
            ++i;
        }
        StringBuilder groovyScript = new StringBuilder();
        groovyScript.append("def " + rootName + " = new XmlSlurper().parseText(xmlText);");
        groovyScript.append("return " + (String)locatorExp);
        Binding binding = new Binding();
        binding.setVariable("xmlText", (Object)xmlText);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(groovyScript.toString());
    }

    public static Object parseAndExecuteExpressionForJson(String locator, String groovyFunction, String jsonText) {
        boolean needAppendRoot = true;
        String[] tokens = locator.split("\\.");
        Object locatorExp = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            locatorExp = (String)locatorExp + token;
            if (i == 0 && token.matches("\\[\\d+\\]")) {
                needAppendRoot = false;
            }
            if (i < tokens.length - 1) {
                locatorExp = (String)locatorExp + ".";
            } else if (i == tokens.length - 1) {
                if (!((String)locatorExp).equals("")) {
                    locatorExp = (String)locatorExp + ".";
                }
                locatorExp = (String)locatorExp + groovyFunction;
            }
            ++i;
        }
        StringBuilder groovyScript = new StringBuilder();
        groovyScript.append("import groovy.json.JsonSlurper;");
        groovyScript.append("def root = new JsonSlurper().parseText(jsonText);");
        if (needAppendRoot) {
            groovyScript.append("return root." + (String)locatorExp + ";");
        } else {
            groovyScript.append("return root" + (String)locatorExp + ";");
        }
        Binding binding = new Binding();
        binding.setVariable("jsonText", (Object)jsonText);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(groovyScript.toString());
    }

    public static Object parseAndGetPropertyValueForJson(String locator, String jsonText) {
        boolean needAppendRoot = true;
        String[] tokens = locator.split("\\.");
        Object locatorExp = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            locatorExp = (String)locatorExp + token;
            if (i == 0 && token.matches("\\[\\d+\\]")) {
                needAppendRoot = false;
            }
            if (i < tokens.length - 1) {
                locatorExp = (String)locatorExp + ".";
            }
            ++i;
        }
        StringBuilder groovyScript = new StringBuilder();
        groovyScript.append("import groovy.json.JsonSlurper;");
        groovyScript.append("def root = new JsonSlurper().parseText(jsonText);");
        if (needAppendRoot) {
            groovyScript.append("return root." + (String)locatorExp + ";");
        } else {
            groovyScript.append("return root" + (String)locatorExp + ";");
        }
        Binding binding = new Binding();
        binding.setVariable("jsonText", (Object)jsonText);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(groovyScript.toString());
    }

    public static long calculateHeaderLength(HttpURLConnection conn) {
        long headerLength = conn.getHeaderFields().entrySet().stream().mapToLong(e -> {
            String key = (String)e.getKey();
            if (StringUtils.isEmpty((String)key)) {
                return 0L;
            }
            long length = key.getBytes().length;
            return length += ((List)e.getValue()).stream().mapToLong(v -> v.getBytes().length).sum();
        }).sum();
        return headerLength;
    }

    public static long calculateHeaderLength(HttpResponse httpResponse) {
        Header[] headers = httpResponse.getAllHeaders();
        long headerLength = 0L;
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String key = header.getName();
            if (StringUtils.isEmpty((String)key)) {
                return 0L;
            }
            headerLength += (long)key.getBytes().length;
            headerLength += (long)header.getValue().getBytes().length;
            ++n2;
        }
        return headerLength;
    }

    public static String smartGetData(String data) throws Exception {
        return WebServiceCommonHelper.smartGetData(data, ValidationDataType.AUTO, null, null);
    }

    public static String smartGetData(String data, ValidationDataType dataType, LocalFileProvider localFileProvider, RemoteFileProvider remoteFileProvider) throws Exception {
        if (localFileProvider == null) {
            localFileProvider = DEFAULT_LOCAL_FILE_PROVIDER;
        }
        if (remoteFileProvider == null) {
            remoteFileProvider = DEFAULT_REMOTE_FILE_PROVIDER;
        }
        if (dataType == null || dataType == ValidationDataType.AUTO) {
            if (OpenAPIUtil.isUrl(data)) {
                dataType = ValidationDataType.URL;
            } else if (localFileProvider.read(data) != null) {
                dataType = ValidationDataType.FILE;
            }
        }
        if (dataType == ValidationDataType.FILE) {
            return localFileProvider.read(data);
        }
        if (dataType == ValidationDataType.URL) {
            return remoteFileProvider.fetch(data);
        }
        return data;
    }

    public static String getResponseText(ResponseObject response) throws Exception {
        if (response.isSOAPResponse()) {
            return response.extractSOAPBodyAsContent();
        }
        return response.getResponseText();
    }

    public static interface LocalFileProvider {
        public String read(String var1) throws Exception;
    }

    public static interface RemoteFileProvider {
        public String fetch(String var1) throws Exception;
    }
}

