/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.helper;

import com.atlassian.oai.validator.report.ValidationReport;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.ValidationResult;
import com.kms.katalon.core.testobject.ValidationStatus;
import com.kms.katalon.core.testobject.ValidationStep;
import com.kms.katalon.core.testobject.ValidationTarget;
import com.kms.katalon.core.testobject.ValidationType;
import com.kms.katalon.core.testobject.impl.HttpGraphQLBodyContent;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.util.internal.GraphQLUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.util.internal.XMLUtil;
import com.kms.katalon.core.webservice.common.ResourceResolver;
import com.kms.katalon.core.webservice.constants.CoreWebserviceMessageConstants;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper;
import com.kms.katalon.core.webservice.util.OpenAPIUtil;
import com.kms.katalon.core.webservice.util.WebServiceCommonUtil;
import com.kms.katalon.util.DocumentBuilderProvider;
import com.kms.katalon.util.TransformerFactoryProvider;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import graphql.language.Document;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.UnExecutableSchemaGenerator;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebServiceValidationHelper {
    private WebServiceValidationHelper() {
    }

    public static List<ValidationResult> getProblems(ValidationStep step) {
        return step.results.stream().filter(resultI -> WebServiceValidationHelper.isFailedResult(resultI)).collect(Collectors.toList());
    }

    public static boolean isFailedResult(ValidationResult result) {
        List<ValidationStatus> statusList = Arrays.asList(ValidationStatus.ERROR, ValidationStatus.FAIL);
        return statusList.contains(result.status);
    }

    public static boolean isFailedStep(ValidationStep step) {
        if (step.results == null) {
            return false;
        }
        return WebServiceValidationHelper.testAnyStatus(step, ValidationStatus.ERROR, ValidationStatus.FAIL);
    }

    public static boolean isSkippedStep(ValidationStep step) {
        if (step.results == null) {
            return false;
        }
        return WebServiceValidationHelper.testAllStatus(step, ValidationStatus.SKIP);
    }

    public static boolean isPassedStep(ValidationStep step) {
        if (step.results == null) {
            return false;
        }
        return WebServiceValidationHelper.testAllStatus(step, ValidationStatus.PASS);
    }

    public static boolean testAllStatus(ValidationStep step, ValidationStatus ... status) {
        List<ValidationStatus> statusList = Arrays.asList(status);
        return step.results.stream().allMatch(resultI -> statusList.contains(resultI.status));
    }

    public static boolean testAnyStatus(ValidationStep step, ValidationStatus ... status) {
        List<ValidationStatus> statusList = Arrays.asList(status);
        return step.results.stream().anyMatch(resultI -> statusList.contains(resultI.status));
    }

    public static void executeValidationSteps(RequestObject requestObject, ResponseObject responseObject, String projectLocation) throws Exception {
        WebServiceValidationHelper.executeValidationSteps(requestObject, responseObject, null, null, projectLocation);
    }

    public static void executeValidationSteps(RequestObject request, ResponseObject response, WebServiceCommonHelper.LocalFileProvider localFileProvider, WebServiceCommonHelper.RemoteFileProvider remoteFileProvider, String projectLocation) throws Exception {
        List steps = request.getValidationSteps();
        if (steps == null) {
            return;
        }
        for (ValidationStep stepI : steps) {
            try {
                boolean isInvalidStep;
                stepI.results = new ArrayList();
                if (!stepI.activate) {
                    stepI.results.add(new ValidationResult("", ValidationStatus.SKIP));
                    continue;
                }
                if (stepI.target == null) {
                    stepI.target = ValidationTarget.RESPONSE;
                }
                boolean bl = isInvalidStep = StringUtils.isBlank((String)stepI.data) || stepI.target == null;
                if (isInvalidStep) {
                    stepI.results.add(new ValidationResult(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_LOCATION_OR_VALUE_IS_BLANK, ValidationStatus.ERROR));
                    continue;
                }
                boolean isSOAP = response.isSOAPResponse();
                List<String> validationTargets = WebServiceValidationHelper.getValidationTarget(request, response, stepI.target);
                String schemaContent = WebServiceCommonHelper.smartGetData(stepI.data.trim(), stepI.dataType, localFileProvider, remoteFileProvider);
                ValidationType validationType = stepI.type;
                if (validationType == null || validationType == ValidationType.AUTO_DETECT) {
                    if (JsonUtil.isValidJsonSchema((String)schemaContent)) {
                        validationType = ValidationType.JSON_SCHEMA;
                    } else if (XMLUtil.isValidXml((String)schemaContent)) {
                        validationType = ValidationType.XML_SCHEMA;
                    } else if (GraphQLUtil.isValidGraphQLSchema((String)schemaContent)) {
                        validationType = ValidationType.GRAPHQL_SCHEMA;
                    } else if (OpenAPIUtil.isValidOpenAPISpecification(stepI.data.trim(), stepI.dataType, projectLocation)) {
                        validationType = ValidationType.OPEN_API_SPEC;
                    }
                }
                if (validationType == null || validationType == ValidationType.AUTO_DETECT) {
                    stepI.results.add(new ValidationResult(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_CANNOT_DETECT_CHEMA, ValidationStatus.ERROR));
                }
                if ((validationTargets == null || validationTargets.isEmpty()) && validationType != ValidationType.OPEN_API_SPEC) {
                    stepI.results.add(new ValidationResult(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_CANNOT_FIND_TARGET, ValidationStatus.ERROR));
                }
                if (validationType == ValidationType.OPEN_API_SPEC && stepI.target == ValidationTarget.REQUEST) {
                    String specSrc = OpenAPIUtil.getFullSpecLocation(stepI.dataType, stepI.data.trim(), projectLocation);
                    ValidationReport report = OpenAPIUtil.validateRequest(request, specSrc);
                    if (report.hasErrors()) {
                        List results = report.getMessages().stream().map(err -> new ValidationResult(err.getMessage(), ValidationStatus.FAIL)).collect(Collectors.toList());
                        stepI.results.addAll(results);
                        continue;
                    }
                    stepI.results.add(new ValidationResult(ValidationStatus.PASS));
                    continue;
                }
                for (String validationTargetI : validationTargets) {
                    Collection<Object> errors;
                    if (validationType == ValidationType.JSON_SCHEMA) {
                        errors = WebServiceValidationHelper.validateJsonSchema(validationTargetI, schemaContent);
                        if (errors == null || errors.isEmpty()) {
                            stepI.results.add(new ValidationResult(ValidationStatus.PASS));
                            continue;
                        }
                        List results = errors.stream().map(errorI -> new ValidationResult(errorI.getMessage(), ValidationStatus.FAIL)).collect(Collectors.toList());
                        stepI.results.addAll(results);
                        continue;
                    }
                    if (validationType == ValidationType.XML_SCHEMA) {
                        ResourceResolver resourceResolver = new ResourceResolver(localFileProvider, remoteFileProvider);
                        String errorString = null;
                        errorString = !isSOAP && WebServiceValidationHelper.isWSDLSchema(schemaContent) ? CoreWebserviceMessageConstants.KW_LOG_VALIDATION_CANNOT_VALIDATE_XML_AGAINST_WSDL : (WebServiceValidationHelper.isWSDLSchema(schemaContent) ? WebServiceValidationHelper.validateWSDLSchema(validationTargetI, schemaContent) : WebServiceValidationHelper.validateXmlSchema(validationTargetI, schemaContent, resourceResolver));
                        if (StringUtils.isBlank((String)errorString)) {
                            stepI.results.add(new ValidationResult(ValidationStatus.PASS));
                            continue;
                        }
                        errorString = WebServiceCommonUtil.getXmlValidationErrorString(errorString);
                        errorString = StringUtils.trim((String)errorString);
                        List<String> list = Arrays.asList(errorString.split("\\. "));
                        List xmlResults = list.stream().map(str -> new ValidationResult(str, ValidationStatus.FAIL)).collect(Collectors.toList());
                        stepI.results.addAll(xmlResults);
                        continue;
                    }
                    if (validationType == ValidationType.GRAPHQL_SCHEMA) {
                        if (stepI.target != ValidationTarget.REQUEST) continue;
                        errors = WebServiceValidationHelper.validateGraphQLBodyWithSchema(validationTargetI, schemaContent);
                        if (errors == null) {
                            stepI.results.add(new ValidationResult(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_INVALID_GRAPHQL_SCHEMA, ValidationStatus.FAIL));
                            continue;
                        }
                        if (errors.isEmpty()) {
                            stepI.results.add(new ValidationResult(ValidationStatus.PASS));
                            continue;
                        }
                        ArrayList<ValidationResult> graphQLResults = new ArrayList<ValidationResult>();
                        for (ValidationError validationError : errors) {
                            graphQLResults.add(new ValidationResult(validationError.getMessage(), ValidationStatus.FAIL));
                        }
                        stepI.results.addAll(graphQLResults);
                        continue;
                    }
                    if (validationType == ValidationType.OPEN_API_SPEC) {
                        if (stepI.target != ValidationTarget.RESPONSE) continue;
                        String specSrc = OpenAPIUtil.getFullSpecLocation(stepI.dataType, stepI.data.trim(), projectLocation);
                        ValidationReport report = OpenAPIUtil.validateResponse(response, request, specSrc);
                        if (report.hasErrors()) {
                            List list = report.getMessages().stream().map(err -> new ValidationResult(err.getMessage(), ValidationStatus.FAIL)).collect(Collectors.toList());
                            stepI.results.addAll(list);
                            continue;
                        }
                        stepI.results.add(new ValidationResult(ValidationStatus.PASS));
                        continue;
                    }
                    stepI.results.add(new ValidationResult(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_VALIDATE_GRAPHQL_SCHEMA_FAILED, ValidationStatus.FAIL));
                }
            }
            catch (Exception error) {
                stepI.results.add(new ValidationResult(error.getMessage(), ValidationStatus.ERROR));
            }
        }
    }

    public static List<String> getValidationTarget(RequestObject request, ResponseObject response, ValidationTarget targetType) throws Exception {
        if (targetType == ValidationTarget.RESPONSE) {
            if (response.isSOAPResponse()) {
                return Arrays.asList(response.extractSOAPBodyAsContent());
            }
            return Arrays.asList(response.getResponseText());
        }
        if (WebServiceCommonUtil.isSOAPRequest(request)) {
            return Arrays.asList(StringUtils.defaultString((String)request.getSoapBody()));
        }
        HttpBodyContent requestBody = request.getBodyContent();
        if (requestBody == null) {
            return Collections.emptyList();
        }
        if (requestBody instanceof HttpGraphQLBodyContent) {
            return Arrays.asList(StringUtils.defaultString((String)((HttpGraphQLBodyContent)requestBody).getDisplayText()));
        }
        if (requestBody instanceof HttpTextBodyContent) {
            return Arrays.asList(StringUtils.defaultString((String)((HttpTextBodyContent)requestBody).getText()));
        }
        return Collections.emptyList();
    }

    public static Set<ValidationMessage> validateJsonSchema(String jsonObject, String rawJsonSchema) throws JsonMappingException, JsonProcessingException {
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setTypeLoose(false);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaNode = mapper.readTree(rawJsonSchema);
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909);
        JsonSchema schema = factory.getSchema(schemaNode, config);
        schema.initializeValidators();
        JsonNode responseNode = mapper.readTree(jsonObject);
        Set errors = schema.validate(responseNode);
        return errors;
    }

    public static String validateXmlSchema(String responseText, String schemaContent) {
        return WebServiceValidationHelper.validateXmlSchema(responseText, schemaContent, new ResourceResolver(WebServiceCommonHelper.DEFAULT_LOCAL_FILE_PROVIDER, WebServiceCommonHelper.DEFAULT_REMOTE_FILE_PROVIDER));
    }

    public static String validateXmlSchema(String responseText, String schemaContent, ResourceResolver resourceResolver) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver(resourceResolver);
            StreamSource schemaSource = new StreamSource(new StringReader(schemaContent));
            Schema schema = factory.newSchema(schemaSource);
            javax.xml.validation.Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(new StringReader(responseText));
            validator.validate(source);
            return "";
        }
        catch (SAXException e) {
            return e.getMessage();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static String validateWSDLSchema(String responseText, String schemaContent) {
        block9: {
            File f = null;
            try {
                Map ns;
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
                f = File.createTempFile("temp", ".wsdl");
                FileUtils.writeStringToFile((File)f, (String)schemaContent, (Charset)StandardCharsets.UTF_8);
                Definition wsdlDefinition = wsdlReader.readWSDL(f.getPath());
                DocumentBuilder docBuilder = DocumentBuilderProvider.newBuilderInstance();
                org.w3c.dom.Document doc = docBuilder.newDocument();
                if (wsdlDefinition.getTypes() != null) {
                    for (Object o : wsdlDefinition.getTypes().getExtensibilityElements()) {
                        if (!(o instanceof javax.wsdl.extensions.schema.Schema)) continue;
                        Element ele = ((javax.wsdl.extensions.schema.Schema)o).getElement();
                        Node newNode = doc.importNode(ele, true);
                        doc.appendChild(newNode);
                    }
                }
                if ((ns = wsdlDefinition.getNamespaces()) != null) {
                    for (Map.Entry e : ns.entrySet()) {
                        if (e.getKey() == null || ((String)e.getKey()).isEmpty()) continue;
                        doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)e.getKey(), (String)e.getValue());
                    }
                }
                StringWriter writer = new StringWriter();
                TransformerFactory tf = TransformerFactoryProvider.newInstance();
                Transformer t = tf.newTransformer();
                t.setOutputProperty("indent", "yes");
                t.transform(new DOMSource(doc), new StreamResult(writer));
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = factory.newSchema(new StreamSource(new StringReader(writer.toString())));
                javax.xml.validation.Validator validator = schema.newValidator();
                StreamSource source = new StreamSource(new StringReader(responseText));
                validator.validate(source);
                if (f == null) break block9;
            }
            catch (Exception e) {
                String string;
                block10: {
                    try {
                        string = e.getMessage();
                        if (f == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (f != null) {
                            FileUtils.deleteQuietly(f);
                        }
                        throw throwable;
                    }
                    FileUtils.deleteQuietly((File)f);
                }
                return string;
            }
            FileUtils.deleteQuietly((File)f);
        }
        return "";
    }

    public static boolean isWSDLSchema(String schema) {
        Pattern wsdlPattern = Pattern.compile(":definitions>");
        Matcher wsdlMatcher = wsdlPattern.matcher(schema);
        return wsdlMatcher.find();
    }

    public static List<ValidationError> validateGraphQLBodyWithSchema(String GraphQLQuery, String schema) {
        Validator validator = new Validator();
        TypeDefinitionRegistry definitionRegistry = new SchemaParser().parse(schema);
        GraphQLSchema qlSchema = UnExecutableSchemaGenerator.makeUnExecutableSchema((TypeDefinitionRegistry)definitionRegistry);
        Document doc = Parser.parse((String)GraphQLQuery);
        List errors = validator.validateDocument(qlSchema, doc, Locale.getDefault());
        return errors;
    }
}

