/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.util.Arrays;
import org.apache.commons.lang.SystemUtils;
import org.zeroturnaround.process.AndProcess;
import org.zeroturnaround.process.Java8Process;
import org.zeroturnaround.process.JavaProcess;
import org.zeroturnaround.process.OrProcess;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.PidUtil;
import org.zeroturnaround.process.SolarisProcess;
import org.zeroturnaround.process.SystemProcess;
import org.zeroturnaround.process.UnixProcess;
import org.zeroturnaround.process.WindowsProcess;

public class Processes {
    public static SystemProcess newStandardProcess(Process process) {
        return Processes.newStandardProcess(process, PidUtil.getPid(process));
    }

    public static SystemProcess newStandardProcess(Process process, int pid) {
        return Processes.newProcessWithAtlernatives(Processes.newJavaProcess(process), Processes.newPidProcess(pid));
    }

    public static JavaProcess newJavaProcess(Process process) {
        if (Java8Process.isSupported()) {
            return new Java8Process(process);
        }
        return new JavaProcess(process);
    }

    public static PidProcess newPidProcess(Process process) {
        return Processes.newPidProcess(PidUtil.getPid(process));
    }

    public static PidProcess newPidProcess(int pid) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new WindowsProcess(pid);
        }
        if (SystemUtils.IS_OS_SOLARIS || SystemUtils.IS_OS_SUN_OS) {
            return new SolarisProcess(pid);
        }
        return new UnixProcess(pid);
    }

    public static SystemProcess newProcessWithAtlernatives(SystemProcess ... processes) {
        return new OrProcess(Arrays.asList(processes));
    }

    public static SystemProcess newProcessForMultiple(SystemProcess ... processes) {
        return new AndProcess(Arrays.asList(processes));
    }
}

