/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import java.util.Objects;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StyledTextMessage {
    private static final int MARGIN = 2;
    private static int[] INVALIDATE_EVENTS = new int[]{26, 27, 22, 23};
    private final StyledText styledText;
    private final Listener invalidateListener;
    private final Color textColor;
    private String message;
    private int verticalOffsetLines;

    public StyledTextMessage(StyledText styledText) {
        this.styledText = Objects.requireNonNull(styledText);
        this.invalidateListener = this::handleInvalidatedEvent;
        this.textColor = this.getTextColor();
        this.message = "";
        this.initialize();
    }

    public void setMessage(String message) {
        this.message = Objects.requireNonNull(message);
        this.styledText.redraw();
    }

    public boolean isMessageShowing() {
        return !this.message.isEmpty() && this.styledText.getContent().getCharCount() == 0;
    }

    private void initialize() {
        this.styledText.addListener(9, this::handlePaintEvent);
        this.styledText.addListener(11, event -> this.styledText.redraw());
        this.styledText.addListener(12, this::handleDispose);
        int[] nArray = INVALIDATE_EVENTS;
        int n = INVALIDATE_EVENTS.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            this.styledText.getDisplay().addFilter(eventType, this.invalidateListener);
            ++n2;
        }
    }

    private Color getTextColor() {
        return this.styledText.getDisplay().getSystemColor(15);
    }

    private void handlePaintEvent(Event event) {
        if (this.isMessageShowing()) {
            this.drawHint(event.gc, event.x, event.y);
        }
    }

    private void handleDispose(Event event) {
        int[] nArray = INVALIDATE_EVENTS;
        int n = INVALIDATE_EVENTS.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            this.styledText.getDisplay().removeFilter(eventType, this.invalidateListener);
            ++n2;
        }
    }

    private void handleInvalidatedEvent(Event event) {
        this.styledText.redraw();
    }

    private void drawHint(GC gc, int x, int y) {
        int verticalOffset = this.verticalOffsetLines * gc.getFontMetrics().getHeight();
        gc.setForeground(this.textColor);
        gc.drawText(this.message, x + 2, y - verticalOffset, 3);
    }
}

