/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.DialogUtil;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class TreeEntitySelectionNoFilterDialog
extends ElementTreeSelectionDialog {
    private IEntityLabelProvider labelProvider;
    private TreeViewer treeViewer;
    private String message;

    public TreeEntitySelectionNoFilterDialog(Shell parent, IEntityLabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, (IBaseLabelProvider)labelProvider, contentProvider);
        this.labelProvider = labelProvider;
    }

    public TreeViewer createTreeViewer(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        if (StringUtils.isNotBlank((String)this.message)) {
            Label lblMessage = new Label(parent, 0);
            lblMessage.setLayoutData((Object)new GridData(768));
            lblMessage.setText(this.message);
        }
        this.treeViewer = super.createTreeViewer(parent);
        this.expandTreeViewerToInitialElements();
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.getTree().setFocus();
        return this.treeViewer;
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    public void create() {
        super.create();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new CTreeViewer(parent, style);
    }

    protected void expandTreeViewerToInitialElements() {
        if (this.getInitialElementSelections() != null && !this.getInitialElementSelections().isEmpty()) {
            this.getTreeViewer().expandToLevel(this.getInitialElementSelections().get(0), -1);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void okPressed() {
        if (!DialogUtil.getCanClickOK((Shell)this.getShell())) {
            return;
        }
        super.okPressed();
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    protected void handleShellCloseEvent() {
        if (!DialogUtil.getCanClose((Shell)this.getShell())) {
            return;
        }
        super.handleShellCloseEvent();
    }

    protected void updateChildrenItems(TreeItem parent) {
        Item[] children = this.getChildren((Widget)parent);
        boolean state = parent.getChecked();
        Item[] itemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Item element = itemArray[n2];
            TreeItem curr = (TreeItem)element;
            if (curr.getData() != null && (curr.getChecked() != state || curr.getGrayed())) {
                curr.setChecked(state);
                curr.setGrayed(false);
                this.updateChildrenItems(curr);
            }
            ++n2;
        }
    }

    protected void updateParentItems(TreeItem item) {
        if (item != null) {
            try {
                TreeItem parent = item.getParentItem();
                if (parent != null && ArrayUtils.isNotEmpty((Object[])parent.getItems())) {
                    int fullCount = parent.getItemCount();
                    int numOfCheckedChildren = Math.toIntExact(Stream.of(parent.getItems()).filter(it -> it.getChecked()).count());
                    if (numOfCheckedChildren == fullCount) {
                        parent.setChecked(true);
                    } else if (numOfCheckedChildren == 0) {
                        parent.setChecked(false);
                    } else {
                        parent.setGrayed(true);
                    }
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private Item[] getChildren(Widget o) {
        if (o instanceof TreeItem) {
            return ((TreeItem)o).getItems();
        }
        if (o instanceof Tree) {
            return ((Tree)o).getItems();
        }
        return null;
    }
}

