/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.transfer.TreeEntityTransfer;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.tree.TooltipPropertyDescription;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class CheckpointTreeEntity
extends AbstractTreeEntity {
    private static final long serialVersionUID = 6128596821855400571L;
    public static final String[] SEARCH_TAGS = new String[]{"id", "name", "description"};
    public static final String KEY_WORD = "cp";

    public CheckpointTreeEntity(CheckpointEntity entity, ITreeEntity parentTreeEntity) {
        super((FileEntity)entity, parentTreeEntity);
    }

    public CheckpointEntity getObject() {
        return (CheckpointEntity)this.entity;
    }

    public Object[] getChildren() {
        return null;
    }

    public Image getImage() {
        return ImageConstants.IMG_16_CHECKPOINT;
    }

    public String getTypeName() {
        return StringConstants.CHECKPOINT;
    }

    public String getCopyTag() {
        return FolderEntity.FolderType.CHECKPOINT.toString();
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean isRemoveable() {
        return true;
    }

    public boolean isRenamable() {
        return true;
    }

    public Transfer getEntityTransfer() {
        return TreeEntityTransfer.getInstance();
    }

    @Override
    public void setObject(Object object) {
        if (object instanceof CheckpointEntity) {
            this.entity = (CheckpointEntity)object;
        }
    }

    @Override
    public FolderTreeEntity getParent() {
        return (FolderTreeEntity)this.parentTreeEntity;
    }

    @Override
    public String getText() {
        if (this.entity == null) {
            return "";
        }
        return this.entity.getName();
    }

    public String getKeyWord() {
        return KEY_WORD;
    }

    public String[] getSearchTags() {
        return SEARCH_TAGS;
    }

    public String getPropertyValue(String key) {
        CheckpointEntity checkpoint = this.getObject();
        if (checkpoint == null) {
            return "";
        }
        switch (key) {
            case "id": {
                return checkpoint.getIdForDisplay();
            }
            case "name": {
                return checkpoint.getName();
            }
            case "description": {
                return checkpoint.getDescription();
            }
        }
        return "";
    }

    public Image getEntryImage() {
        return this.getImage();
    }

    public void loadAllDescentdantEntities() {
    }

    @Override
    public List<TooltipPropertyDescription> getTooltipDescriptions() {
        List<TooltipPropertyDescription> properties = super.getTooltipDescriptions();
        Date takenDate = ((CheckpointEntity)this.entity).getTakenDate();
        properties.add(TooltipPropertyDescription.create((String)StringConstants.TREE_CHECK_POINT_PROP_TAKEN_DATE, (String)(takenDate != null ? takenDate.toString() : StringConstants.EMPTY)));
        return properties;
    }
}

