/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.transfer.TreeEntityTransfer;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.tree.TooltipPropertyDescription;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import java.io.File;
import java.util.List;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class TestDataTreeEntity
extends AbstractTreeEntity {
    private static final long serialVersionUID = 7158033879727783488L;
    private static final String TEST_DATA_TYPE_NAME = StringConstants.TREE_TEST_DATA_TYPE_NAME;
    public static final String KEY_WORD = "td";
    public static final String[] SEARCH_TAGS = new String[]{"id", "name", "description", "source name"};
    private DataFileEntity testData;

    public TestDataTreeEntity(DataFileEntity testData, ITreeEntity parentTreeEntity) {
        super((FileEntity)testData, parentTreeEntity);
        this.testData = testData;
    }

    public DataFileEntity getObject() throws Exception {
        TestDataController.getInstance().reloadTestData(this.testData, (Entity)this.entity);
        this.loadAllDescentdantEntities();
        return this.testData;
    }

    public Object[] getChildren() throws Exception {
        return null;
    }

    public boolean hasChildren() throws Exception {
        return false;
    }

    public Image getImage() throws Exception {
        return ImageConstants.IMG_16_TEST_DATA;
    }

    public String getTypeName() throws Exception {
        return TEST_DATA_TYPE_NAME;
    }

    public boolean isRemoveable() throws Exception {
        return true;
    }

    public boolean isRenamable() throws Exception {
        return true;
    }

    public Transfer getEntityTransfer() throws Exception {
        return TreeEntityTransfer.getInstance();
    }

    public String getCopyTag() throws Exception {
        return FolderEntity.FolderType.DATAFILE.toString();
    }

    @Override
    public void setObject(Object object) throws Exception {
        if (object instanceof DataFileEntity) {
            this.entity = (FileEntity)object;
            this.testData = (DataFileEntity)object;
        }
    }

    public String getKeyWord() throws Exception {
        return KEY_WORD;
    }

    public String[] getSearchTags() throws Exception {
        return SEARCH_TAGS;
    }

    public String getPropertyValue(String key) {
        if (this.testData != null) {
            if (key.equals("name")) {
                return this.testData.getName();
            }
            if (key.equals("id")) {
                return this.testData.getRelativePathForUI().replace(File.separator, "/");
            }
            if (key.equals("description")) {
                return this.testData.getDescription();
            }
            if (key.equals("source name")) {
                return this.testData.getLocation();
            }
        }
        return "";
    }

    public Image getEntryImage() throws Exception {
        return this.getImage();
    }

    public void loadAllDescentdantEntities() throws Exception {
    }

    @Override
    public List<TooltipPropertyDescription> getTooltipDescriptions() {
        List<TooltipPropertyDescription> properties = super.getTooltipDescriptions();
        properties.add(TooltipPropertyDescription.createWithDefaultLength((String)StringConstants.TREE_TEST_DATA_PROP_DATA_TYPE, (String)this.testData.getDriver().toString()));
        return properties;
    }
}

