/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing.ana;

import graphql.Assert;
import graphql.Internal;
import graphql.VisibleForTesting;
import graphql.schema.GraphQLSchema;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.EditOperation;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Vertex;
import graphql.schema.diffing.ana.EditOperationAnalysisResult;
import graphql.schema.diffing.ana.SchemaDifference;
import graphql.schema.idl.ScalarInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@Internal
public class EditOperationAnalyzer {
    private final GraphQLSchema oldSchema;
    private final GraphQLSchema newSchema;
    private final SchemaGraph oldSchemaGraph;
    private final SchemaGraph newSchemaGraph;
    private final Map<String, SchemaDifference.ObjectDifference> objectDifferences = new LinkedHashMap<String, SchemaDifference.ObjectDifference>();
    private final Map<String, SchemaDifference.InterfaceDifference> interfaceDifferences = new LinkedHashMap<String, SchemaDifference.InterfaceDifference>();
    private final Map<String, SchemaDifference.UnionDifference> unionDifferences = new LinkedHashMap<String, SchemaDifference.UnionDifference>();
    private final Map<String, SchemaDifference.EnumDifference> enumDifferences = new LinkedHashMap<String, SchemaDifference.EnumDifference>();
    private final Map<String, SchemaDifference.InputObjectDifference> inputObjectDifferences = new LinkedHashMap<String, SchemaDifference.InputObjectDifference>();
    private final Map<String, SchemaDifference.ScalarDifference> scalarDifferences = new LinkedHashMap<String, SchemaDifference.ScalarDifference>();
    private final Map<String, SchemaDifference.DirectiveDifference> directiveDifferences = new LinkedHashMap<String, SchemaDifference.DirectiveDifference>();
    private static final List<EditOperation.Operation> OPERATION_TRAVERSAL_ORDER = List.of(EditOperation.Operation.CHANGE_VERTEX, EditOperation.Operation.INSERT_VERTEX, EditOperation.Operation.DELETE_VERTEX, EditOperation.Operation.CHANGE_EDGE, EditOperation.Operation.INSERT_EDGE, EditOperation.Operation.DELETE_EDGE);
    private static final List<String> TYPE_TRAVERSAL_ORDER = List.of("Schema", "Object", "Interface", "Union", "Scalar", "Enum", "InputObject", "Directive", "Field", "InputField", "EnumValue", "Argument", "AppliedDirective", "AppliedArgument", "__ISOLATED");

    public EditOperationAnalyzer(GraphQLSchema oldSchema, GraphQLSchema newSchema, SchemaGraph oldSchemaGraph, SchemaGraph newSchemaGraph) {
        this.oldSchema = oldSchema;
        this.newSchema = newSchema;
        this.oldSchemaGraph = oldSchemaGraph;
        this.newSchemaGraph = newSchemaGraph;
    }

    public EditOperationAnalysisResult analyzeEdits(List<EditOperation> editOperations, Mapping mapping) {
        editOperations = EditOperationAnalyzer.getTraversalOrder(editOperations);
        this.handleTypeVertexChanges(editOperations);
        for (EditOperation editOperation : editOperations) {
            switch (editOperation.getOperation()) {
                case CHANGE_VERTEX: {
                    if (editOperation.getTargetVertex().isOfType("Field")) {
                        this.fieldChanged(editOperation);
                        break;
                    }
                    if (editOperation.getTargetVertex().isOfType("Argument")) {
                        this.handleArgumentChange(editOperation, mapping);
                        break;
                    }
                    if (!editOperation.getTargetVertex().isOfType("InputField")) break;
                    this.handleInputFieldChange(editOperation);
                    break;
                }
                case INSERT_VERTEX: {
                    if (editOperation.getTargetVertex().isOfType("Field")) {
                        this.fieldAdded(editOperation);
                        break;
                    }
                    if (editOperation.getTargetVertex().isOfType("Argument")) {
                        this.argumentAdded(editOperation);
                        break;
                    }
                    if (!editOperation.getTargetVertex().isOfType("InputField")) break;
                    this.inputFieldAdded(editOperation);
                    break;
                }
                case DELETE_VERTEX: {
                    if (editOperation.getSourceVertex().isOfType("Argument")) {
                        this.argumentDeleted(editOperation);
                        break;
                    }
                    if (editOperation.getSourceVertex().isOfType("Field")) {
                        this.fieldDeleted(editOperation);
                        break;
                    }
                    if (!editOperation.getSourceVertex().isOfType("InputField")) break;
                    this.inputFieldDeleted(editOperation);
                }
            }
        }
        this.handleTypeChanges(editOperations, mapping);
        this.handleImplementsChanges(editOperations, mapping);
        this.handleUnionMemberChanges(editOperations, mapping);
        this.handleEnumValuesChanges(editOperations, mapping);
        this.handleAppliedDirectives(editOperations, mapping);
        this.handleArgumentChanges(editOperations, mapping);
        return new EditOperationAnalysisResult(this.objectDifferences, this.interfaceDifferences, this.unionDifferences, this.enumDifferences, this.inputObjectDifferences, this.scalarDifferences, this.directiveDifferences);
    }

    private void handleArgumentChanges(List<EditOperation> editOperations, Mapping mapping) {
        for (EditOperation editOperation : editOperations) {
            switch (editOperation.getOperation()) {
                case INSERT_EDGE: {
                    if (!editOperation.getTargetEdge().getTo().isOfType("Argument")) break;
                    this.argumentAdded(editOperation);
                    break;
                }
                case DELETE_EDGE: {
                    if (!editOperation.getSourceEdge().getTo().isOfType("Argument")) break;
                    this.argumentDeleted(editOperation);
                }
            }
        }
    }

    private void handleAppliedDirectives(List<EditOperation> editOperations, Mapping mapping) {
        for (EditOperation editOperation : editOperations) {
            switch (editOperation.getOperation()) {
                case INSERT_VERTEX: {
                    if (!editOperation.getTargetVertex().isOfType("AppliedDirective")) break;
                    this.appliedDirectiveAdded(editOperation);
                    break;
                }
                case CHANGE_VERTEX: {
                    break;
                }
                case DELETE_VERTEX: {
                    if (!editOperation.getSourceVertex().isOfType("AppliedDirective")) break;
                    this.appliedDirectiveDeleted(editOperation);
                }
            }
        }
        for (EditOperation editOperation : editOperations) {
            switch (editOperation.getOperation()) {
                case INSERT_VERTEX: {
                    if (!editOperation.getTargetVertex().isOfType("AppliedArgument")) break;
                    this.appliedDirectiveArgumentAdded(editOperation);
                    break;
                }
                case CHANGE_VERTEX: {
                    if (!editOperation.getTargetVertex().isOfType("AppliedArgument")) break;
                    this.appliedDirectiveArgumentChanged(editOperation);
                    break;
                }
                case DELETE_VERTEX: {
                    if (!editOperation.getSourceVertex().isOfType("AppliedArgument")) break;
                    this.appliedDirectiveArgumentDeleted(editOperation);
                }
            }
        }
    }

    private void appliedDirectiveDeleted(EditOperation editOperation) {
        Vertex appliedDirective = editOperation.getSourceVertex();
        Vertex container = this.oldSchemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
        if (container.isOfType("Field")) {
            this.appliedDirectiveDeletedFromField(appliedDirective, container);
        } else if (container.isOfType("Argument")) {
            this.appliedDirectiveDeletedFromArgument(appliedDirective, container);
        } else if (container.isOfType("Object")) {
            Vertex object = container;
            if (this.isObjectDeleted(object.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveObjectLocation location = new SchemaDifference.AppliedDirectiveObjectLocation(object.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getObjectModification(object.getName()).getDetails().add(appliedDirectiveDeletion);
        } else if (container.isOfType("Interface")) {
            Vertex interfaze = container;
            if (this.isInterfaceDeleted(interfaze.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInterfaceLocation location = new SchemaDifference.AppliedDirectiveInterfaceLocation(interfaze.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getInterfaceModification(interfaze.getName()).getDetails().add(appliedDirectiveDeletion);
        } else if (container.isOfType("Scalar")) {
            Vertex scalar = container;
            if (this.isScalarDeleted(scalar.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveScalarLocation location = new SchemaDifference.AppliedDirectiveScalarLocation(scalar.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getScalarModification(scalar.getName()).getDetails().add(appliedDirectiveDeletion);
        } else if (container.isOfType("Enum")) {
            Vertex enumVertex = container;
            if (this.isEnumDeleted(enumVertex.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveEnumLocation location = new SchemaDifference.AppliedDirectiveEnumLocation(enumVertex.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getEnumModification(enumVertex.getName()).getDetails().add(appliedDirectiveDeletion);
        } else if (container.isOfType("EnumValue")) {
            Vertex enumValue = container;
            Vertex enumVertex = this.oldSchemaGraph.getEnumForEnumValue(enumValue);
            if (this.isEnumDeleted(enumVertex.getName())) {
                return;
            }
            if (this.isEnumValueDeletedFromExistingEnum(enumVertex.getName(), enumValue.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveEnumValueLocation location = new SchemaDifference.AppliedDirectiveEnumValueLocation(enumVertex.getName(), enumValue.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getEnumModification(enumVertex.getName()).getDetails().add(appliedDirectiveDeletion);
        } else if (container.isOfType("InputObject")) {
            Vertex inputObject = container;
            if (this.isInputObjectDeleted(inputObject.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInputObjectLocation location = new SchemaDifference.AppliedDirectiveInputObjectLocation(inputObject.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getInputObjectModification(inputObject.getName()).getDetails().add(appliedDirectiveDeletion);
        } else if (container.isOfType("InputField")) {
            Vertex inputField = container;
            Vertex inputObject = this.oldSchemaGraph.getInputObjectForInputField(inputField);
            if (this.isInputObjectDeleted(inputObject.getName())) {
                return;
            }
            if (this.isInputFieldDeletedFromExistingInputObject(inputObject.getName(), inputField.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInputObjectFieldLocation location = new SchemaDifference.AppliedDirectiveInputObjectFieldLocation(inputObject.getName(), inputField.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getInputObjectModification(inputObject.getName()).getDetails().add(appliedDirectiveDeletion);
        } else if (container.isOfType("Union")) {
            Vertex union = container;
            if (this.isUnionDeleted(union.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveUnionLocation location = new SchemaDifference.AppliedDirectiveUnionLocation(union.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getUnionModification(union.getName()).getDetails().add(appliedDirectiveDeletion);
        }
    }

    private void appliedDirectiveArgumentDeleted(EditOperation editOperation) {
        Vertex deletedArgument = editOperation.getSourceVertex();
        Vertex appliedDirective = this.oldSchemaGraph.getAppliedDirectiveForAppliedArgument(deletedArgument);
        Vertex container = this.oldSchemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
        if (container.isOfType("Argument")) {
            Vertex argument = container;
            Vertex fieldOrDirective = this.oldSchemaGraph.getFieldOrDirectiveForArgument(argument);
            if (fieldOrDirective.isOfType("Field")) {
                Vertex field = fieldOrDirective;
                Vertex fieldsContainer = this.oldSchemaGraph.getFieldsContainerForField(field);
                if (fieldsContainer.isOfType("Object")) {
                    Vertex object = fieldsContainer;
                    if (this.isObjectDeleted(object.getName())) {
                        return;
                    }
                    if (this.isFieldDeletedFromExistingObject(object.getName(), field.getName())) {
                        return;
                    }
                    if (this.isArgumentDeletedFromExistingObjectField(object.getName(), field.getName(), argument.getName())) {
                        return;
                    }
                    if (this.isAppliedDirectiveDeleted(object, appliedDirective.getName())) {
                        return;
                    }
                    SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation(object.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                    this.getObjectModification(object.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
                } else if (fieldsContainer.isOfType("Interface")) {
                    Vertex interfaze = fieldsContainer;
                    if (this.isInterfaceDeleted(interfaze.getName())) {
                        return;
                    }
                    if (this.isFieldNewForExistingInterface(interfaze.getName(), field.getName())) {
                        return;
                    }
                    if (this.isArgumentDeletedFromExistingInterfaceField(interfaze.getName(), field.getName(), argument.getName())) {
                        return;
                    }
                    if (this.isAppliedDirectiveDeleted(interfaze, appliedDirective.getName())) {
                        return;
                    }
                    SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation(interfaze.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                    this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
                }
            } else if (fieldOrDirective.isOfType("Directive")) {
                Vertex directive = fieldOrDirective;
                if (this.isDirectiveDeleted(directive.getName())) {
                    return;
                }
                if (this.isArgumentDeletedFromExistingDirective(directive.getName(), argument.getName())) {
                    return;
                }
                if (this.isAppliedDirectiveDeleted(fieldOrDirective, appliedDirective.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveDirectiveArgumentLocation location = new SchemaDifference.AppliedDirectiveDirectiveArgumentLocation(directive.getName(), argument.getName(), appliedDirective.getName());
                this.getDirectiveModification(directive.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
            }
        } else if (container.isOfType("Field")) {
            Vertex field = container;
            Vertex interfaceOrObjective = this.oldSchemaGraph.getFieldsContainerForField(field);
            if (interfaceOrObjective.isOfType("Object")) {
                Vertex object = interfaceOrObjective;
                if (this.isObjectDeleted(object.getName())) {
                    return;
                }
                if (this.isFieldDeletedFromExistingObject(object.getName(), field.getName())) {
                    return;
                }
                if (this.isAppliedDirectiveDeleted(object, appliedDirective.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveObjectFieldLocation location = new SchemaDifference.AppliedDirectiveObjectFieldLocation(object.getName(), field.getName(), appliedDirective.getName());
                this.getObjectModification(object.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
            } else {
                Assert.assertTrue(interfaceOrObjective.isOfType("Interface"));
                Vertex interfaze = interfaceOrObjective;
                if (this.isInterfaceDeleted(interfaze.getName())) {
                    return;
                }
                if (this.isFieldDeletedFromExistingInterface(interfaze.getName(), field.getName())) {
                    return;
                }
                if (this.isAppliedDirectiveDeleted(interfaze, appliedDirective.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveInterfaceFieldLocation location = new SchemaDifference.AppliedDirectiveInterfaceFieldLocation(interfaze.getName(), field.getName(), appliedDirective.getName());
                this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
            }
        } else if (container.isOfType("Scalar")) {
            Vertex scalar = container;
            if (this.isScalarDeleted(scalar.getName())) {
                return;
            }
            if (this.isAppliedDirectiveDeleted(scalar, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveScalarLocation location = new SchemaDifference.AppliedDirectiveScalarLocation(scalar.getName(), appliedDirective.getName());
            this.getScalarModification(scalar.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
        } else if (container.isOfType("Enum")) {
            Vertex enumVertex = container;
            if (this.isEnumDeleted(enumVertex.getName())) {
                return;
            }
            if (this.isAppliedDirectiveDeleted(enumVertex, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveEnumLocation location = new SchemaDifference.AppliedDirectiveEnumLocation(enumVertex.getName(), appliedDirective.getName());
            this.getEnumModification(enumVertex.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
        } else if (container.isOfType("EnumValue")) {
            Vertex enumValue = container;
            Vertex enumVertex = this.oldSchemaGraph.getEnumForEnumValue(enumValue);
            if (this.isEnumDeleted(enumVertex.getName())) {
                return;
            }
            if (this.isNewEnumValueForExistingEnum(enumVertex.getName(), enumValue.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveEnumValueLocation location = new SchemaDifference.AppliedDirectiveEnumValueLocation(enumVertex.getName(), enumValue.getName(), appliedDirective.getName());
            this.getEnumModification(enumVertex.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
        } else if (container.isOfType("Union")) {
            Vertex union = container;
            if (this.isUnionDeleted(union.getName())) {
                return;
            }
            if (this.isAppliedDirectiveDeleted(union, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveUnionLocation location = new SchemaDifference.AppliedDirectiveUnionLocation(union.getName(), appliedDirective.getName());
            this.getUnionModification(union.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
        } else if (container.isOfType("Object")) {
            Vertex object = container;
            if (this.isObjectDeleted(object.getName())) {
                return;
            }
            if (this.isAppliedDirectiveDeleted(object, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveObjectLocation location = new SchemaDifference.AppliedDirectiveObjectLocation(object.getName(), appliedDirective.getName());
            this.getObjectModification(object.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
        } else if (container.isOfType("Interface")) {
            Vertex interfaze = container;
            if (this.isInterfaceDeleted(interfaze.getName())) {
                return;
            }
            if (this.isAppliedDirectiveDeleted(interfaze, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInterfaceLocation location = new SchemaDifference.AppliedDirectiveInterfaceLocation(interfaze.getName(), appliedDirective.getName());
            this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
        } else if (container.isOfType("InputObject")) {
            Vertex inputObject = container;
            if (this.isInputObjectDeleted(inputObject.getName())) {
                return;
            }
            if (this.isAppliedDirectiveDeleted(inputObject, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInputObjectLocation location = new SchemaDifference.AppliedDirectiveInputObjectLocation(inputObject.getName(), appliedDirective.getName());
            this.getInputObjectModification(inputObject.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
        } else if (container.isOfType("InputField")) {
            Vertex inputField = container;
            Vertex inputObject = this.oldSchemaGraph.getInputObjectForInputField(inputField);
            if (this.isInputObjectDeleted(inputObject.getName())) {
                return;
            }
            if (this.isNewInputFieldExistingInputObject(inputObject.getName(), inputField.getName())) {
                return;
            }
            if (this.isAppliedDirectiveDeleted(inputField, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInputObjectFieldLocation location = new SchemaDifference.AppliedDirectiveInputObjectFieldLocation(inputObject.getName(), inputField.getName(), appliedDirective.getName());
            this.getInputObjectModification(inputObject.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentDeletion(location, deletedArgument.getName()));
        } else {
            Assert.assertShouldNeverHappen("Unexpected container " + container, new Object[0]);
        }
    }

    private void appliedDirectiveArgumentAdded(EditOperation editOperation) {
        Vertex addedArgument = editOperation.getTargetVertex();
        Vertex appliedDirective = this.newSchemaGraph.getAppliedDirectiveForAppliedArgument(addedArgument);
        Vertex container = this.newSchemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
        if (container.isOfType("Argument")) {
            Vertex argument = container;
            Vertex fieldOrDirective = this.newSchemaGraph.getFieldOrDirectiveForArgument(argument);
            if (fieldOrDirective.isOfType("Field")) {
                Vertex field = fieldOrDirective;
                Vertex fieldsContainer = this.newSchemaGraph.getFieldsContainerForField(field);
                if (fieldsContainer.isOfType("Object")) {
                    Vertex object = fieldsContainer;
                    if (this.isObjectAdded(object.getName())) {
                        return;
                    }
                    if (this.isFieldNewForExistingObject(object.getName(), field.getName())) {
                        return;
                    }
                    if (this.isArgumentNewForExistingObjectField(object.getName(), field.getName(), argument.getName())) {
                        return;
                    }
                    if (this.isAppliedDirectiveAdded(object, appliedDirective.getName())) {
                        return;
                    }
                    SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation(object.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                    this.getObjectModification(object.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
                } else if (fieldsContainer.isOfType("Interface")) {
                    Vertex interfaze = fieldsContainer;
                    if (this.isInterfaceAdded(interfaze.getName())) {
                        return;
                    }
                    if (this.isFieldNewForExistingInterface(interfaze.getName(), field.getName())) {
                        return;
                    }
                    if (this.isArgumentNewForExistingInterfaceField(interfaze.getName(), field.getName(), argument.getName())) {
                        return;
                    }
                    if (this.isAppliedDirectiveAdded(interfaze, appliedDirective.getName())) {
                        return;
                    }
                    SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation(interfaze.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                    this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
                }
            } else if (fieldOrDirective.isOfType("Directive")) {
                Vertex directive = fieldOrDirective;
                if (this.isAppliedDirectiveAdded(directive, appliedDirective.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveDirectiveArgumentLocation location = new SchemaDifference.AppliedDirectiveDirectiveArgumentLocation(directive.getName(), argument.getName(), appliedDirective.getName());
                this.getDirectiveModification(directive.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
            }
        } else if (container.isOfType("Field")) {
            Vertex field = container;
            Vertex interfaceOrObjective = this.newSchemaGraph.getFieldsContainerForField(field);
            if (interfaceOrObjective.isOfType("Object")) {
                Vertex object = interfaceOrObjective;
                if (this.isObjectAdded(object.getName())) {
                    return;
                }
                if (this.isFieldNewForExistingObject(object.getName(), field.getName())) {
                    return;
                }
                if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveObjectFieldLocation location = new SchemaDifference.AppliedDirectiveObjectFieldLocation(object.getName(), field.getName(), appliedDirective.getName());
                this.getObjectModification(object.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
            } else if (interfaceOrObjective.isOfType("Interface")) {
                Vertex interfaze = interfaceOrObjective;
                if (this.isInterfaceAdded(interfaze.getName())) {
                    return;
                }
                if (this.isFieldNewForExistingInterface(interfaze.getName(), field.getName())) {
                    return;
                }
                if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveInterfaceFieldLocation location = new SchemaDifference.AppliedDirectiveInterfaceFieldLocation(interfaze.getName(), field.getName(), appliedDirective.getName());
                this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
            } else {
                Assert.assertShouldNeverHappen("Unexpected field container " + interfaceOrObjective, new Object[0]);
            }
        } else if (container.isOfType("Scalar")) {
            Vertex scalar = container;
            if (this.isScalarAdded(scalar.getName())) {
                return;
            }
            if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveScalarLocation location = new SchemaDifference.AppliedDirectiveScalarLocation(scalar.getName(), appliedDirective.getName());
            this.getScalarModification(scalar.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
        } else if (container.isOfType("Enum")) {
            Vertex enumVertex = container;
            if (this.isEnumAdded(enumVertex.getName())) {
                return;
            }
            if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveEnumLocation location = new SchemaDifference.AppliedDirectiveEnumLocation(enumVertex.getName(), appliedDirective.getName());
            this.getEnumModification(enumVertex.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
        } else if (container.isOfType("EnumValue")) {
            Vertex enumValue = container;
            Vertex enumVertex = this.newSchemaGraph.getEnumForEnumValue(enumValue);
            if (this.isEnumAdded(enumVertex.getName())) {
                return;
            }
            if (this.isNewEnumValueForExistingEnum(enumVertex.getName(), enumValue.getName())) {
                return;
            }
            if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveEnumValueLocation location = new SchemaDifference.AppliedDirectiveEnumValueLocation(enumVertex.getName(), enumValue.getName(), appliedDirective.getName());
            this.getEnumModification(enumVertex.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
        } else if (container.isOfType("Union")) {
            Vertex union = container;
            if (this.isUnionAdded(union.getName())) {
                return;
            }
            if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveUnionLocation location = new SchemaDifference.AppliedDirectiveUnionLocation(union.getName(), appliedDirective.getName());
            this.getUnionModification(union.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
        } else if (container.isOfType("Interface")) {
            Vertex interfaze = container;
            if (this.isInterfaceAdded(interfaze.getName())) {
                return;
            }
            if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInterfaceLocation location = new SchemaDifference.AppliedDirectiveInterfaceLocation(interfaze.getName(), appliedDirective.getName());
            this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
        } else if (container.isOfType("Object")) {
            Vertex interfaze = container;
            if (this.isObjectAdded(interfaze.getName())) {
                return;
            }
            if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveObjectLocation location = new SchemaDifference.AppliedDirectiveObjectLocation(interfaze.getName(), appliedDirective.getName());
            this.getObjectModification(interfaze.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
        } else if (container.isOfType("InputObject")) {
            Vertex inputObject = container;
            if (this.isInputObjectAdded(inputObject.getName())) {
                return;
            }
            if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInputObjectLocation location = new SchemaDifference.AppliedDirectiveInputObjectLocation(inputObject.getName(), appliedDirective.getName());
            this.getInputObjectModification(inputObject.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
        } else if (container.isOfType("InputField")) {
            Vertex inputField = container;
            Vertex inputObject = this.newSchemaGraph.getInputObjectForInputField(inputField);
            if (this.isInputObjectAdded(inputObject.getName())) {
                return;
            }
            if (this.isNewInputFieldExistingInputObject(inputObject.getName(), inputField.getName())) {
                return;
            }
            if (this.isAppliedDirectiveAdded(container, appliedDirective.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInputObjectFieldLocation location = new SchemaDifference.AppliedDirectiveInputObjectFieldLocation(inputObject.getName(), inputField.getName(), appliedDirective.getName());
            this.getInputObjectModification(inputObject.getName()).getDetails().add(new SchemaDifference.AppliedDirectiveArgumentAddition(location, addedArgument.getName()));
        } else {
            Assert.assertShouldNeverHappen("Unexpected applied argument container " + container, new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appliedDirectiveArgumentChanged(EditOperation editOperation) {
        String newArgumentName;
        Vertex appliedArgument = editOperation.getTargetVertex();
        String oldArgumentName = editOperation.getSourceVertex().getName();
        boolean nameChanged = !oldArgumentName.equals(newArgumentName = editOperation.getTargetVertex().getName());
        String oldValue = (String)editOperation.getSourceVertex().get("value");
        String newValue = (String)editOperation.getTargetVertex().get("value");
        boolean valueChanged = !oldValue.equals(newValue);
        Vertex appliedDirective = this.newSchemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
        Vertex container = this.newSchemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
        if (container.isOfType("Field")) {
            Vertex field = container;
            Vertex interfaceOrObjective = this.newSchemaGraph.getFieldsContainerForField(field);
            if (interfaceOrObjective.isOfType("Object")) {
                Vertex object = interfaceOrObjective;
                SchemaDifference.AppliedDirectiveObjectFieldLocation location = new SchemaDifference.AppliedDirectiveObjectFieldLocation(object.getName(), field.getName(), appliedDirective.getName());
                if (valueChanged) {
                    SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                    this.getObjectModification(object.getName()).getDetails().add(argumentValueModification);
                }
                if (!nameChanged) return;
                SchemaDifference.AppliedDirectiveArgumentRename argumentRename = new SchemaDifference.AppliedDirectiveArgumentRename(location, oldArgumentName, newArgumentName);
                this.getObjectModification(object.getName()).getDetails().add(argumentRename);
                return;
            }
            if (!interfaceOrObjective.isOfType("Interface")) return;
            Vertex interfaze = interfaceOrObjective;
            SchemaDifference.AppliedDirectiveInterfaceFieldLocation location = new SchemaDifference.AppliedDirectiveInterfaceFieldLocation(interfaze.getName(), field.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getInterfaceModification(interfaze.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        }
        if (container.isOfType("Argument")) {
            Vertex argument = container;
            Vertex fieldOrDirective = this.newSchemaGraph.getFieldOrDirectiveForArgument(argument);
            if (!fieldOrDirective.isOfType("Field")) {
                if (!fieldOrDirective.isOfType("Directive")) return;
                Vertex directive = fieldOrDirective;
                SchemaDifference.AppliedDirectiveDirectiveArgumentLocation location = new SchemaDifference.AppliedDirectiveDirectiveArgumentLocation(directive.getName(), argument.getName(), appliedDirective.getName());
                if (!valueChanged) return;
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getDirectiveModification(directive.getName()).getDetails().add(argumentValueModification);
                return;
            }
            Vertex field = fieldOrDirective;
            Vertex fieldsContainer = this.newSchemaGraph.getFieldsContainerForField(field);
            if (fieldsContainer.isOfType("Object")) {
                Vertex object = fieldsContainer;
                SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation(object.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                if (valueChanged) {
                    SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                    this.getObjectModification(object.getName()).getDetails().add(argumentValueModification);
                }
                if (!nameChanged) return;
                return;
            } else {
                if (!fieldsContainer.isOfType("Interface")) return;
                Vertex interfaze = fieldsContainer;
                SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation(interfaze.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                if (valueChanged) {
                    SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                    this.getInterfaceModification(interfaze.getName()).getDetails().add(argumentValueModification);
                }
                if (!nameChanged) return;
            }
            return;
        }
        if (container.isOfType("InputField")) {
            Vertex inputField = container;
            Vertex inputObject = this.newSchemaGraph.getInputObjectForInputField(inputField);
            SchemaDifference.AppliedDirectiveInputObjectFieldLocation location = new SchemaDifference.AppliedDirectiveInputObjectFieldLocation(inputObject.getName(), inputField.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getInputObjectModification(inputObject.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        } else if (container.isOfType("Object")) {
            Vertex object = container;
            SchemaDifference.AppliedDirectiveObjectLocation location = new SchemaDifference.AppliedDirectiveObjectLocation(object.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getObjectModification(object.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        } else if (container.isOfType("Interface")) {
            Vertex interfaze = container;
            SchemaDifference.AppliedDirectiveInterfaceLocation location = new SchemaDifference.AppliedDirectiveInterfaceLocation(interfaze.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getInterfaceModification(interfaze.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        } else if (container.isOfType("InputObject")) {
            Vertex inputObject = container;
            SchemaDifference.AppliedDirectiveInputObjectLocation location = new SchemaDifference.AppliedDirectiveInputObjectLocation(inputObject.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getInputObjectModification(inputObject.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        } else if (container.isOfType("Enum")) {
            Vertex enumVertex = container;
            SchemaDifference.AppliedDirectiveEnumLocation location = new SchemaDifference.AppliedDirectiveEnumLocation(enumVertex.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getEnumModification(enumVertex.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        } else if (container.isOfType("EnumValue")) {
            Vertex enumValue = container;
            Vertex enumVertex = this.newSchemaGraph.getEnumForEnumValue(enumValue);
            SchemaDifference.AppliedDirectiveEnumValueLocation location = new SchemaDifference.AppliedDirectiveEnumValueLocation(enumVertex.getName(), enumValue.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getEnumModification(enumVertex.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        } else if (container.isOfType("Union")) {
            Vertex union = container;
            SchemaDifference.AppliedDirectiveUnionLocation location = new SchemaDifference.AppliedDirectiveUnionLocation(union.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getUnionModification(union.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        } else if (container.isOfType("Scalar")) {
            Vertex scalar = container;
            SchemaDifference.AppliedDirectiveScalarLocation location = new SchemaDifference.AppliedDirectiveScalarLocation(scalar.getName(), appliedDirective.getName());
            if (valueChanged) {
                SchemaDifference.AppliedDirectiveArgumentValueModification argumentValueModification = new SchemaDifference.AppliedDirectiveArgumentValueModification(location, newArgumentName, oldValue, newValue);
                this.getScalarModification(scalar.getName()).getDetails().add(argumentValueModification);
            }
            if (!nameChanged) return;
            return;
        } else {
            Assert.assertShouldNeverHappen("Unexpected applied argument container " + container, new Object[0]);
        }
    }

    private void appliedDirectiveAdded(EditOperation editOperation) {
        Vertex appliedDirective = editOperation.getTargetVertex();
        Vertex container = this.newSchemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
        if (container.isOfType("Field")) {
            this.appliedDirectiveAddedToField(appliedDirective, container);
        } else if (container.isOfType("Argument")) {
            this.appliedDirectiveAddedToArgument(appliedDirective, container);
        } else if (container.isOfType("Object")) {
            Vertex object = container;
            if (this.isObjectAdded(object.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveObjectLocation location = new SchemaDifference.AppliedDirectiveObjectLocation(object.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getObjectModification(object.getName()).getDetails().add(appliedDirectiveAddition);
        } else if (container.isOfType("Interface")) {
            Vertex interfaze = container;
            if (this.isInterfaceAdded(interfaze.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInterfaceLocation location = new SchemaDifference.AppliedDirectiveInterfaceLocation(interfaze.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getInterfaceModification(interfaze.getName()).getDetails().add(appliedDirectiveAddition);
        } else if (container.isOfType("Scalar")) {
            Vertex scalar = container;
            if (this.isScalarAdded(scalar.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveScalarLocation location = new SchemaDifference.AppliedDirectiveScalarLocation(scalar.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getScalarModification(scalar.getName()).getDetails().add(appliedDirectiveAddition);
        } else if (container.isOfType("Enum")) {
            Vertex enumVertex = container;
            if (this.isEnumAdded(enumVertex.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveEnumLocation location = new SchemaDifference.AppliedDirectiveEnumLocation(enumVertex.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getEnumModification(enumVertex.getName()).getDetails().add(appliedDirectiveAddition);
        } else if (container.isOfType("EnumValue")) {
            Vertex enumValue = container;
            Vertex enumVertex = this.newSchemaGraph.getEnumForEnumValue(enumValue);
            if (this.isEnumAdded(enumVertex.getName())) {
                return;
            }
            if (this.isNewEnumValueForExistingEnum(enumVertex.getName(), enumValue.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveEnumValueLocation location = new SchemaDifference.AppliedDirectiveEnumValueLocation(enumVertex.getName(), enumValue.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getEnumModification(enumVertex.getName()).getDetails().add(appliedDirectiveAddition);
        } else if (container.isOfType("InputObject")) {
            Vertex inputObject = container;
            if (this.isInputObjectAdded(inputObject.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInputObjectLocation location = new SchemaDifference.AppliedDirectiveInputObjectLocation(inputObject.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getInputObjectModification(inputObject.getName()).getDetails().add(appliedDirectiveAddition);
        } else if (container.isOfType("InputField")) {
            Vertex inputField = container;
            Vertex inputObject = this.newSchemaGraph.getInputObjectForInputField(inputField);
            if (this.isInputObjectAdded(inputObject.getName())) {
                return;
            }
            if (this.isNewInputFieldExistingInputObject(inputObject.getName(), inputField.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveInputObjectFieldLocation location = new SchemaDifference.AppliedDirectiveInputObjectFieldLocation(inputObject.getName(), inputField.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getInputObjectModification(inputObject.getName()).getDetails().add(appliedDirectiveAddition);
        } else if (container.isOfType("Union")) {
            Vertex union = container;
            if (this.isUnionAdded(union.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveUnionLocation location = new SchemaDifference.AppliedDirectiveUnionLocation(union.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getUnionModification(union.getName()).getDetails().add(appliedDirectiveAddition);
        }
    }

    private void appliedDirectiveDeletedFromField(Vertex appliedDirective, Vertex container) {
        Vertex field = container;
        Vertex interfaceOrObjective = this.oldSchemaGraph.getFieldsContainerForField(field);
        if (interfaceOrObjective.isOfType("Object")) {
            Vertex object = interfaceOrObjective;
            if (this.isObjectDeleted(object.getName())) {
                return;
            }
            if (this.isFieldDeletedFromExistingObject(object.getName(), field.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveObjectFieldLocation location = new SchemaDifference.AppliedDirectiveObjectFieldLocation(object.getName(), field.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getObjectModification(object.getName()).getDetails().add(appliedDirectiveDeletion);
        }
    }

    private void appliedDirectiveAddedToField(Vertex appliedDirective, Vertex container) {
        Vertex field = container;
        Vertex interfaceOrObjective = this.newSchemaGraph.getFieldsContainerForField(field);
        if (interfaceOrObjective.isOfType("Object")) {
            Vertex object = interfaceOrObjective;
            if (this.isObjectAdded(object.getName())) {
                return;
            }
            if (this.isFieldNewForExistingObject(object.getName(), field.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveObjectFieldLocation location = new SchemaDifference.AppliedDirectiveObjectFieldLocation(object.getName(), field.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getObjectModification(object.getName()).getDetails().add(appliedDirectiveAddition);
        }
    }

    private void appliedDirectiveDeletedFromArgument(Vertex appliedDirective, Vertex container) {
        Vertex argument = container;
        Vertex fieldOrDirective = this.oldSchemaGraph.getFieldOrDirectiveForArgument(argument);
        if (fieldOrDirective.isOfType("Field")) {
            Vertex field = fieldOrDirective;
            Vertex interfaceOrObjective = this.oldSchemaGraph.getFieldsContainerForField(field);
            if (interfaceOrObjective.isOfType("Object")) {
                Vertex object = interfaceOrObjective;
                if (this.isObjectDeleted(object.getName())) {
                    return;
                }
                if (this.isFieldDeletedFromExistingObject(object.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentDeletedFromExistingObjectField(object.getName(), field.getName(), argument.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation(object.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
                this.getObjectModification(object.getName()).getDetails().add(appliedDirectiveDeletion);
            } else {
                Assert.assertTrue(interfaceOrObjective.isOfType("Interface"));
                Vertex interfaze = interfaceOrObjective;
                if (this.isInterfaceDeleted(interfaze.getName())) {
                    return;
                }
                if (this.isFieldDeletedFromExistingInterface(interfaze.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentDeletedFromExistingInterfaceField(interfaze.getName(), field.getName(), argument.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation(interfaze.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
                this.getInterfaceModification(interfaze.getName()).getDetails().add(appliedDirectiveDeletion);
            }
        } else {
            Assert.assertTrue(fieldOrDirective.isOfType("Directive"));
            Vertex directive = fieldOrDirective;
            if (this.isDirectiveDeleted(directive.getName())) {
                return;
            }
            if (this.isArgumentDeletedFromExistingDirective(directive.getName(), argument.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveDirectiveArgumentLocation location = new SchemaDifference.AppliedDirectiveDirectiveArgumentLocation(directive.getName(), argument.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveDeletion appliedDirectiveDeletion = new SchemaDifference.AppliedDirectiveDeletion(location, appliedDirective.getName());
            this.getDirectiveModification(directive.getName()).getDetails().add(appliedDirectiveDeletion);
        }
    }

    private void appliedDirectiveAddedToArgument(Vertex appliedDirective, Vertex container) {
        Vertex argument = container;
        Vertex fieldOrDirective = this.newSchemaGraph.getFieldOrDirectiveForArgument(argument);
        if (fieldOrDirective.isOfType("Field")) {
            Vertex field = fieldOrDirective;
            Vertex interfaceOrObjective = this.newSchemaGraph.getFieldsContainerForField(field);
            if (interfaceOrObjective.isOfType("Object")) {
                Vertex object = interfaceOrObjective;
                if (this.isObjectAdded(object.getName())) {
                    return;
                }
                if (this.isFieldNewForExistingObject(object.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentNewForExistingObjectField(object.getName(), field.getName(), argument.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveObjectFieldArgumentLocation(object.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
                this.getObjectModification(object.getName()).getDetails().add(appliedDirectiveAddition);
            } else {
                Assert.assertTrue(interfaceOrObjective.isOfType("Interface"));
                Vertex interfaze = interfaceOrObjective;
                if (this.isInterfaceAdded(interfaze.getName())) {
                    return;
                }
                if (this.isFieldNewForExistingInterface(interfaze.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentNewForExistingInterfaceField(interfaze.getName(), field.getName(), argument.getName())) {
                    return;
                }
                SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation location = new SchemaDifference.AppliedDirectiveInterfaceFieldArgumentLocation(interfaze.getName(), field.getName(), argument.getName(), appliedDirective.getName());
                SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
                this.getInterfaceModification(interfaze.getName()).getDetails().add(appliedDirectiveAddition);
            }
        } else {
            Assert.assertTrue(fieldOrDirective.isOfType("Directive"));
            Vertex directive = fieldOrDirective;
            if (this.isDirectiveAdded(directive.getName())) {
                return;
            }
            if (this.isArgumentNewForExistingDirective(directive.getName(), argument.getName())) {
                return;
            }
            SchemaDifference.AppliedDirectiveDirectiveArgumentLocation location = new SchemaDifference.AppliedDirectiveDirectiveArgumentLocation(directive.getName(), argument.getName(), appliedDirective.getName());
            SchemaDifference.AppliedDirectiveAddition appliedDirectiveAddition = new SchemaDifference.AppliedDirectiveAddition(location, appliedDirective.getName());
            this.getDirectiveModification(directive.getName()).getDetails().add(appliedDirectiveAddition);
        }
    }

    private void handleTypeChanges(List<EditOperation> editOperations, Mapping mapping) {
        for (EditOperation editOperation : editOperations) {
            Edge newEdge = editOperation.getTargetEdge();
            switch (editOperation.getOperation()) {
                case INSERT_EDGE: {
                    if (!newEdge.getLabel().startsWith("type=")) break;
                    this.typeEdgeInserted(editOperation, editOperations, mapping);
                    break;
                }
                case CHANGE_EDGE: {
                    if (!newEdge.getLabel().startsWith("type=")) break;
                    this.typeEdgeChanged(editOperation, mapping);
                }
            }
        }
    }

    private void handleUnionMemberChanges(List<EditOperation> editOperations, Mapping mapping) {
        for (EditOperation editOperation : editOperations) {
            switch (editOperation.getOperation()) {
                case INSERT_EDGE: {
                    Edge newEdge = editOperation.getTargetEdge();
                    if (!newEdge.getFrom().isOfType("Union")) break;
                    this.handleUnionMemberAdded(editOperation);
                    break;
                }
                case DELETE_EDGE: {
                    Edge oldEdge = editOperation.getSourceEdge();
                    if (!oldEdge.getFrom().isOfType("Union") || oldEdge.getTo().isOfType("AppliedDirective")) break;
                    this.handleUnionMemberDeleted(editOperation);
                }
            }
        }
    }

    private void handleEnumValuesChanges(List<EditOperation> editOperations, Mapping mapping) {
        for (EditOperation editOperation : editOperations) {
            switch (editOperation.getOperation()) {
                case INSERT_EDGE: {
                    Edge newEdge = editOperation.getTargetEdge();
                    if (!newEdge.getFrom().isOfType("Enum") || !newEdge.getTo().isOfType("EnumValue")) break;
                    this.handleEnumValueAdded(editOperation);
                    break;
                }
                case DELETE_EDGE: {
                    Edge oldEdge = editOperation.getSourceEdge();
                    if (!oldEdge.getFrom().isOfType("Enum") || !oldEdge.getTo().isOfType("EnumValue")) break;
                    this.handleEnumValueDeleted(editOperation);
                    break;
                }
                case CHANGE_VERTEX: {
                    if (!editOperation.getSourceVertex().isOfType("EnumValue") || !editOperation.getTargetVertex().isOfType("EnumValue")) break;
                    this.handleEnumValueChanged(editOperation);
                }
            }
        }
    }

    private void handleInputFieldChange(EditOperation editOperation) {
        String newName;
        Vertex inputField = editOperation.getTargetVertex();
        Vertex inputObject = this.newSchemaGraph.getInputObjectForInputField(inputField);
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName = inputField.getName())) {
            return;
        }
        if (this.isInputObjectAdded(inputObject.getName())) {
            return;
        }
        this.getInputObjectModification(inputObject.getName()).getDetails().add(new SchemaDifference.InputObjectFieldRename(oldName, newName));
    }

    private void handleArgumentChange(EditOperation editOperation, Mapping mapping) {
        String newName;
        Vertex oldArgument = editOperation.getSourceVertex();
        Vertex argument = editOperation.getTargetVertex();
        String oldName = oldArgument.getName();
        if (oldName.equals(newName = argument.getName())) {
            return;
        }
        if (!this.doesArgumentChangeMakeSense(oldArgument, argument, mapping)) {
            return;
        }
        Vertex fieldOrDirective = this.newSchemaGraph.getFieldOrDirectiveForArgument(argument);
        if (fieldOrDirective.isOfType("Directive")) {
            Vertex directive = fieldOrDirective;
            SchemaDifference.DirectiveModification directiveModification = this.getDirectiveModification(directive.getName());
            directiveModification.getDetails().add(new SchemaDifference.DirectiveArgumentRename(oldName, newName));
        } else {
            Assert.assertTrue(fieldOrDirective.isOfType("Field"));
            Vertex field = fieldOrDirective;
            String fieldName = field.getName();
            Vertex fieldsContainerForField = this.newSchemaGraph.getFieldsContainerForField(field);
            if (fieldsContainerForField.isOfType("Object")) {
                Vertex object = fieldsContainerForField;
                SchemaDifference.ObjectModification objectModification = this.getObjectModification(object.getName());
                objectModification.getDetails().add(new SchemaDifference.ObjectFieldArgumentRename(fieldName, oldName, newName));
            } else {
                Assert.assertTrue(fieldsContainerForField.isOfType("Interface"));
                Vertex interfaze = fieldsContainerForField;
                SchemaDifference.InterfaceModification interfaceModification = this.getInterfaceModification(interfaze.getName());
                interfaceModification.getDetails().add(new SchemaDifference.InterfaceFieldArgumentRename(fieldName, oldName, newName));
            }
        }
    }

    private void handleImplementsChanges(List<EditOperation> editOperations, Mapping mapping) {
        for (EditOperation editOperation : editOperations) {
            switch (editOperation.getOperation()) {
                case INSERT_EDGE: {
                    Edge newEdge = editOperation.getTargetEdge();
                    if (!newEdge.getLabel().startsWith("implements ")) break;
                    this.newInterfaceAddedToInterfaceOrObject(newEdge);
                    break;
                }
                case DELETE_EDGE: {
                    Edge oldEdge = editOperation.getSourceEdge();
                    if (!oldEdge.getLabel().startsWith("implements ")) break;
                    this.interfaceImplementationDeleted(oldEdge);
                }
            }
        }
    }

    private void handleUnionMemberAdded(EditOperation editOperation) {
        Edge newEdge = editOperation.getTargetEdge();
        Vertex union = newEdge.getFrom();
        if (this.isUnionAdded(union.getName())) {
            return;
        }
        Vertex newMemberObject = newEdge.getTo();
        SchemaDifference.UnionModification unionModification = this.getUnionModification(union.getName());
        unionModification.getDetails().add(new SchemaDifference.UnionMemberAddition(newMemberObject.getName()));
    }

    private void handleUnionMemberDeleted(EditOperation editOperation) {
        Edge deletedEdge = editOperation.getSourceEdge();
        Vertex union = deletedEdge.getFrom();
        if (this.isUnionDeleted(union.getName())) {
            return;
        }
        Vertex memberObject = deletedEdge.getTo();
        SchemaDifference.UnionModification unionModification = this.getUnionModification(union.getName());
        unionModification.getDetails().add(new SchemaDifference.UnionMemberDeletion(memberObject.getName()));
    }

    private void handleEnumValueAdded(EditOperation editOperation) {
        Edge newEdge = editOperation.getTargetEdge();
        Vertex enumVertex = newEdge.getFrom();
        if (this.isEnumAdded(enumVertex.getName())) {
            return;
        }
        Vertex newValue = newEdge.getTo();
        SchemaDifference.EnumModification enumModification = this.getEnumModification(enumVertex.getName());
        enumModification.getDetails().add(new SchemaDifference.EnumValueAddition(newValue.getName()));
    }

    private void handleEnumValueDeleted(EditOperation editOperation) {
        Edge deletedEdge = editOperation.getSourceEdge();
        Vertex enumVertex = deletedEdge.getFrom();
        if (this.isEnumDeleted(enumVertex.getName())) {
            return;
        }
        Vertex value = deletedEdge.getTo();
        SchemaDifference.EnumModification enumModification = this.getEnumModification(enumVertex.getName());
        enumModification.getDetails().add(new SchemaDifference.EnumValueDeletion(value.getName()));
    }

    private void handleEnumValueChanged(EditOperation editOperation) {
        Vertex enumVertex = this.newSchemaGraph.getEnumForEnumValue(editOperation.getTargetVertex());
        SchemaDifference.EnumModification enumModification = this.getEnumModification(enumVertex.getName());
        String oldName = editOperation.getSourceVertex().getName();
        String newName = editOperation.getTargetVertex().getName();
        enumModification.getDetails().add(new SchemaDifference.EnumValueRenamed(oldName, newName));
    }

    private void fieldChanged(EditOperation editOperation) {
        String newName;
        Vertex field = editOperation.getTargetVertex();
        Vertex fieldsContainerForField = this.newSchemaGraph.getFieldsContainerForField(field);
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName = field.getName())) {
            return;
        }
        if (fieldsContainerForField.isOfType("Object")) {
            Vertex object = fieldsContainerForField;
            if (this.isObjectAdded(object.getName())) {
                return;
            }
            SchemaDifference.ObjectModification objectModification = this.getObjectModification(object.getName());
            objectModification.getDetails().add(new SchemaDifference.ObjectFieldRename(oldName, newName));
        } else {
            Assert.assertTrue(fieldsContainerForField.isOfType("Interface"));
            Vertex interfaze = fieldsContainerForField;
            if (this.isInterfaceAdded(interfaze.getName())) {
                return;
            }
            SchemaDifference.InterfaceModification interfaceModification = this.getInterfaceModification(interfaze.getName());
            interfaceModification.getDetails().add(new SchemaDifference.InterfaceFieldRename(oldName, newName));
        }
    }

    private void inputFieldAdded(EditOperation editOperation) {
        Vertex inputField = editOperation.getTargetVertex();
        Vertex inputObject = this.newSchemaGraph.getInputObjectForInputField(inputField);
        if (this.isInputObjectAdded(inputObject.getName())) {
            return;
        }
        SchemaDifference.InputObjectModification modification = this.getInputObjectModification(inputObject.getName());
        modification.getDetails().add(new SchemaDifference.InputObjectFieldAddition(inputField.getName()));
    }

    private void fieldAdded(EditOperation editOperation) {
        Vertex field = editOperation.getTargetVertex();
        Vertex fieldsContainerForField = this.newSchemaGraph.getFieldsContainerForField(field);
        if (fieldsContainerForField.isOfType("Object")) {
            Vertex object = fieldsContainerForField;
            if (this.isObjectAdded(object.getName())) {
                return;
            }
            SchemaDifference.ObjectModification objectModification = this.getObjectModification(object.getName());
            String name = field.getName();
            objectModification.getDetails().add(new SchemaDifference.ObjectFieldAddition(name));
        } else {
            Assert.assertTrue(fieldsContainerForField.isOfType("Interface"));
            Vertex interfaze = fieldsContainerForField;
            if (this.isInterfaceAdded(interfaze.getName())) {
                return;
            }
            SchemaDifference.InterfaceModification interfaceModification = this.getInterfaceModification(interfaze.getName());
            String name = field.getName();
            interfaceModification.getDetails().add(new SchemaDifference.InterfaceFieldAddition(name));
        }
    }

    private void inputFieldDeleted(EditOperation editOperation) {
        Vertex inputField = editOperation.getSourceVertex();
        Vertex inputObject = this.oldSchemaGraph.getInputObjectForInputField(inputField);
        if (this.isInputObjectDeleted(inputObject.getName())) {
            return;
        }
        this.getInputObjectModification(inputObject.getName()).getDetails().add(new SchemaDifference.InputObjectFieldDeletion(inputField.getName()));
    }

    private void fieldDeleted(EditOperation editOperation) {
        Vertex deletedField = editOperation.getSourceVertex();
        Vertex fieldsContainerForField = this.oldSchemaGraph.getFieldsContainerForField(deletedField);
        if (fieldsContainerForField.isOfType("Object")) {
            Vertex object = fieldsContainerForField;
            if (this.isObjectDeleted(object.getName())) {
                return;
            }
            SchemaDifference.ObjectModification objectModification = this.getObjectModification(object.getName());
            String name = deletedField.getName();
            objectModification.getDetails().add(new SchemaDifference.ObjectFieldDeletion(name));
        } else {
            Assert.assertTrue(fieldsContainerForField.isOfType("Interface"));
            Vertex interfaze = fieldsContainerForField;
            if (this.isInterfaceDeleted(interfaze.getName())) {
                return;
            }
            SchemaDifference.InterfaceModification interfaceModification = this.getInterfaceModification(interfaze.getName());
            String name = deletedField.getName();
            interfaceModification.getDetails().add(new SchemaDifference.InterfaceFieldDeletion(name));
        }
    }

    private void handleTypeVertexChanges(List<EditOperation> editOperations) {
        for (EditOperation editOperation : editOperations) {
            switch (editOperation.getOperation()) {
                case INSERT_VERTEX: {
                    this.insertedTypeVertex(editOperation);
                    break;
                }
                case DELETE_VERTEX: {
                    this.deletedTypeVertex(editOperation);
                    break;
                }
                case CHANGE_VERTEX: {
                    this.changedTypeVertex(editOperation);
                }
            }
        }
    }

    private void insertedTypeVertex(EditOperation editOperation) {
        switch (editOperation.getTargetVertex().getType()) {
            case "Object": {
                this.addedObject(editOperation);
                break;
            }
            case "Interface": {
                this.addedInterface(editOperation);
                break;
            }
            case "Union": {
                this.addedUnion(editOperation);
                break;
            }
            case "InputObject": {
                this.addedInputObject(editOperation);
                break;
            }
            case "Enum": {
                this.addedEnum(editOperation);
                break;
            }
            case "Scalar": {
                this.addedScalar(editOperation);
                break;
            }
            case "Directive": {
                this.addedDirective(editOperation);
            }
        }
    }

    private void deletedTypeVertex(EditOperation editOperation) {
        switch (editOperation.getSourceVertex().getType()) {
            case "Object": {
                this.removedObject(editOperation);
                break;
            }
            case "Interface": {
                this.removedInterface(editOperation);
                break;
            }
            case "Union": {
                this.removedUnion(editOperation);
                break;
            }
            case "InputObject": {
                this.removedInputObject(editOperation);
                break;
            }
            case "Enum": {
                this.removedEnum(editOperation);
                break;
            }
            case "Scalar": {
                this.deletedScalar(editOperation);
                break;
            }
            case "Directive": {
                this.deletedDirective(editOperation);
            }
        }
    }

    private void changedTypeVertex(EditOperation editOperation) {
        switch (editOperation.getTargetVertex().getType()) {
            case "Object": {
                this.changedObject(editOperation);
                break;
            }
            case "Interface": {
                this.changedInterface(editOperation);
                break;
            }
            case "Union": {
                this.changedUnion(editOperation);
                break;
            }
            case "InputObject": {
                this.changedInputObject(editOperation);
                break;
            }
            case "Enum": {
                this.changedEnum(editOperation);
                break;
            }
            case "Scalar": {
                this.changedScalar(editOperation);
                break;
            }
            case "Directive": {
                this.changedDirective(editOperation);
            }
        }
    }

    private void typeEdgeInserted(EditOperation editOperation, List<EditOperation> editOperations, Mapping mapping) {
        Edge newEdge = editOperation.getTargetEdge();
        Vertex from = newEdge.getFrom();
        if (from.isOfType("Field")) {
            this.typeEdgeInsertedForField(editOperation, editOperations, mapping);
        } else if (from.isOfType("Argument")) {
            this.typeEdgeInsertedForArgument(editOperation, editOperations, mapping);
        } else if (from.isOfType("InputField")) {
            this.typeEdgeInsertedForInputField(editOperation, editOperations, mapping);
        }
    }

    private void typeEdgeInsertedForInputField(EditOperation editOperation, List<EditOperation> editOperations, Mapping mapping) {
        Vertex inputField = editOperation.getTargetEdge().getFrom();
        Vertex inputObject = this.newSchemaGraph.getInputObjectForInputField(inputField);
        if (this.isInputObjectAdded(inputObject.getName())) {
            return;
        }
        if (this.isNewInputFieldExistingInputObject(inputObject.getName(), inputField.getName())) {
            return;
        }
        String newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge());
        EditOperation deletedTypeEdgeOperation = this.findDeletedEdge(inputField, editOperations, mapping, this::isTypeEdge);
        String oldType = this.getTypeFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
        SchemaDifference.InputObjectFieldTypeModification inputObjectFieldTypeModification = new SchemaDifference.InputObjectFieldTypeModification(inputField.getName(), oldType, newType);
        this.getInputObjectModification(inputObject.getName()).getDetails().add(inputObjectFieldTypeModification);
    }

    private void typeEdgeInsertedForArgument(EditOperation editOperation, List<EditOperation> editOperations, Mapping mapping) {
        Vertex argument = editOperation.getTargetEdge().getFrom();
        Vertex fieldOrDirective = this.newSchemaGraph.getFieldOrDirectiveForArgument(argument);
        if (fieldOrDirective.isOfType("Field")) {
            Vertex field = fieldOrDirective;
            Vertex objectOrInterface = this.newSchemaGraph.getFieldsContainerForField(field);
            if (objectOrInterface.isOfType("Object")) {
                Vertex object = objectOrInterface;
                if (this.isObjectAdded(object.getName())) {
                    return;
                }
                if (this.isFieldNewForExistingObject(object.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentNewForExistingObjectField(object.getName(), field.getName(), argument.getName())) {
                    return;
                }
                String newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge());
                EditOperation deletedTypeEdgeOperation = this.findDeletedEdge(argument, editOperations, mapping, this::isTypeEdge);
                String oldType = this.getTypeFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
                SchemaDifference.ObjectFieldArgumentTypeModification objectFieldArgumentTypeModification = new SchemaDifference.ObjectFieldArgumentTypeModification(field.getName(), argument.getName(), oldType, newType);
                this.getObjectModification(object.getName()).getDetails().add(objectFieldArgumentTypeModification);
                String oldDefaultValue = this.getDefaultValueFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
                String newDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getTargetEdge());
                if (!oldDefaultValue.equals(newDefaultValue)) {
                    this.getObjectModification(object.getName()).getDetails().add(new SchemaDifference.ObjectFieldArgumentDefaultValueModification(field.getName(), argument.getName(), oldDefaultValue, newDefaultValue));
                }
            } else {
                Assert.assertTrue(objectOrInterface.isOfType("Interface"));
                Vertex interfaze = objectOrInterface;
                if (this.isInterfaceAdded(interfaze.getName())) {
                    return;
                }
                if (this.isFieldNewForExistingInterface(interfaze.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentNewForExistingInterfaceField(interfaze.getName(), field.getName(), argument.getName())) {
                    return;
                }
                String newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge());
                EditOperation deletedTypeEdgeOperation = this.findDeletedEdge(argument, editOperations, mapping, this::isTypeEdge);
                String oldType = this.getTypeFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
                SchemaDifference.InterfaceFieldArgumentTypeModification interfaceFieldArgumentTypeModification = new SchemaDifference.InterfaceFieldArgumentTypeModification(field.getName(), argument.getName(), oldType, newType);
                this.getInterfaceModification(interfaze.getName()).getDetails().add(interfaceFieldArgumentTypeModification);
                String oldDefaultValue = this.getDefaultValueFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
                String newDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getTargetEdge());
                if (!oldDefaultValue.equals(newDefaultValue)) {
                    this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.InterfaceFieldArgumentDefaultValueModification(field.getName(), argument.getName(), oldDefaultValue, newDefaultValue));
                }
            }
        } else {
            Assert.assertTrue(fieldOrDirective.isOfType("Directive"));
            Vertex directive = fieldOrDirective;
            if (this.isDirectiveAdded(directive.getName())) {
                return;
            }
            if (this.isArgumentNewForExistingDirective(directive.getName(), argument.getName())) {
                return;
            }
            String newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge());
            EditOperation deletedTypeEdgeOperation = this.findDeletedEdge(argument, editOperations, mapping, this::isTypeEdge);
            String oldType = this.getTypeFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
            SchemaDifference.DirectiveArgumentTypeModification directiveArgumentTypeModification = new SchemaDifference.DirectiveArgumentTypeModification(argument.getName(), oldType, newType);
            this.getDirectiveModification(directive.getName()).getDetails().add(directiveArgumentTypeModification);
            String oldDefaultValue = this.getDefaultValueFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
            String newDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getTargetEdge());
            if (!oldDefaultValue.equals(newDefaultValue)) {
                this.getDirectiveModification(directive.getName()).getDetails().add(new SchemaDifference.DirectiveArgumentDefaultValueModification(argument.getName(), oldDefaultValue, newDefaultValue));
            }
        }
    }

    private void typeEdgeInsertedForField(EditOperation editOperation, List<EditOperation> editOperations, Mapping mapping) {
        Vertex field = editOperation.getTargetEdge().getFrom();
        Vertex objectOrInterface = this.newSchemaGraph.getFieldsContainerForField(field);
        if (objectOrInterface.isOfType("Object")) {
            Vertex object = objectOrInterface;
            if (this.isObjectAdded(object.getName())) {
                return;
            }
            if (this.isFieldNewForExistingObject(object.getName(), field.getName())) {
                return;
            }
            String newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge());
            EditOperation deletedTypeEdgeOperation = this.findDeletedEdge(field, editOperations, mapping, this::isTypeEdge);
            String oldType = this.getTypeFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
            SchemaDifference.ObjectFieldTypeModification objectFieldTypeModification = new SchemaDifference.ObjectFieldTypeModification(field.getName(), oldType, newType);
            this.getObjectModification(object.getName()).getDetails().add(objectFieldTypeModification);
        } else {
            Assert.assertTrue(objectOrInterface.isOfType("Interface"));
            Vertex interfaze = objectOrInterface;
            if (this.isInterfaceAdded(interfaze.getName())) {
                return;
            }
            if (this.isFieldNewForExistingInterface(interfaze.getName(), field.getName())) {
                return;
            }
            String newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge());
            EditOperation deletedTypeEdgeOperation = this.findDeletedEdge(field, editOperations, mapping, this::isTypeEdge);
            String oldType = this.getTypeFromEdgeLabel(deletedTypeEdgeOperation.getSourceEdge());
            SchemaDifference.InterfaceFieldTypeModification interfaceFieldTypeModification = new SchemaDifference.InterfaceFieldTypeModification(field.getName(), oldType, newType);
            this.getInterfaceModification(interfaze.getName()).getDetails().add(interfaceFieldTypeModification);
        }
    }

    private EditOperation findDeletedEdge(Vertex targetVertexFrom, List<EditOperation> editOperations, Mapping mapping, Predicate<Edge> edgePredicate) {
        Vertex sourceVertexFrom = mapping.getSource(targetVertexFrom);
        for (EditOperation editOperation : editOperations) {
            Edge deletedEdge;
            if (editOperation.getOperation() != EditOperation.Operation.DELETE_EDGE || (deletedEdge = editOperation.getSourceEdge()).getFrom() != sourceVertexFrom || !edgePredicate.test(deletedEdge)) continue;
            return editOperation;
        }
        return (EditOperation)Assert.assertShouldNeverHappen();
    }

    private void typeEdgeChanged(EditOperation editOperation, Mapping mapping) {
        Edge targetEdge = editOperation.getTargetEdge();
        Vertex from = targetEdge.getFrom();
        if (from.isOfType("Field")) {
            this.outputFieldTypeChanged(editOperation);
        } else if (from.isOfType("Argument")) {
            this.argumentTypeOrDefaultValueChanged(editOperation, mapping);
        } else if (from.isOfType("InputField")) {
            this.inputFieldTypeOrDefaultValueChanged(editOperation);
        }
    }

    private void inputFieldTypeOrDefaultValueChanged(EditOperation editOperation) {
        String newType;
        String oldType;
        String newDefaultValue;
        Edge targetEdge = editOperation.getTargetEdge();
        Vertex inputField = targetEdge.getFrom();
        Vertex inputObject = this.newSchemaGraph.getInputObjectForInputField(inputField);
        if (this.isInputObjectAdded(inputObject.getName())) {
            return;
        }
        String oldDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getSourceEdge());
        if (!oldDefaultValue.equals(newDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getTargetEdge()))) {
            SchemaDifference.InputObjectFieldDefaultValueModification modification = new SchemaDifference.InputObjectFieldDefaultValueModification(inputField.getName(), oldDefaultValue, newDefaultValue);
            this.getInputObjectModification(inputObject.getName()).getDetails().add(modification);
        }
        if (!(oldType = this.getTypeFromEdgeLabel(editOperation.getSourceEdge())).equals(newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge()))) {
            SchemaDifference.InputObjectFieldTypeModification inputObjectFieldTypeModification = new SchemaDifference.InputObjectFieldTypeModification(inputField.getName(), oldType, newType);
            this.getInputObjectModification(inputObject.getName()).getDetails().add(inputObjectFieldTypeModification);
        }
    }

    private void argumentTypeOrDefaultValueChanged(EditOperation editOperation, Mapping mapping) {
        Vertex argument;
        Vertex oldArgument = editOperation.getSourceEdge().getFrom();
        if (!this.doesArgumentChangeMakeSense(oldArgument, argument = editOperation.getTargetEdge().getFrom(), mapping)) {
            return;
        }
        Vertex fieldOrDirective = this.newSchemaGraph.getFieldOrDirectiveForArgument(argument);
        if (fieldOrDirective.isOfType("Field")) {
            String newType;
            String oldType;
            String newDefaultValue;
            Vertex field = fieldOrDirective;
            Vertex objectOrInterface = this.newSchemaGraph.getFieldsContainerForField(field);
            String oldDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getSourceEdge());
            if (!oldDefaultValue.equals(newDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getTargetEdge()))) {
                Object defaultValueModification;
                if (objectOrInterface.isOfType("Object")) {
                    defaultValueModification = new SchemaDifference.ObjectFieldArgumentDefaultValueModification(field.getName(), argument.getName(), oldDefaultValue, newDefaultValue);
                    this.getObjectModification(objectOrInterface.getName()).getDetails().add((SchemaDifference.ObjectModificationDetail)defaultValueModification);
                } else {
                    Assert.assertTrue(objectOrInterface.isOfType("Interface"));
                    defaultValueModification = new SchemaDifference.InterfaceFieldArgumentDefaultValueModification(field.getName(), argument.getName(), oldDefaultValue, newDefaultValue);
                    this.getInterfaceModification(objectOrInterface.getName()).getDetails().add((SchemaDifference.InterfaceModificationDetail)defaultValueModification);
                }
            }
            if (!(oldType = this.getTypeFromEdgeLabel(editOperation.getSourceEdge())).equals(newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge()))) {
                if (objectOrInterface.isOfType("Object")) {
                    SchemaDifference.ObjectFieldArgumentTypeModification objectFieldArgumentTypeModification = new SchemaDifference.ObjectFieldArgumentTypeModification(field.getName(), argument.getName(), oldType, newType);
                    this.getObjectModification(objectOrInterface.getName()).getDetails().add(objectFieldArgumentTypeModification);
                } else {
                    Assert.assertTrue(objectOrInterface.isOfType("Interface"));
                    SchemaDifference.InterfaceFieldArgumentTypeModification interfaceFieldArgumentTypeModification = new SchemaDifference.InterfaceFieldArgumentTypeModification(field.getName(), argument.getName(), oldType, newType);
                    this.getInterfaceModification(objectOrInterface.getName()).getDetails().add(interfaceFieldArgumentTypeModification);
                }
            }
        } else {
            String newType;
            String oldType;
            Assert.assertTrue(fieldOrDirective.isOfType("Directive"));
            Vertex directive = fieldOrDirective;
            String oldDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getSourceEdge());
            String newDefaultValue = this.getDefaultValueFromEdgeLabel(editOperation.getTargetEdge());
            if (!oldDefaultValue.equals(newDefaultValue)) {
                this.getDirectiveModification(directive.getName()).getDetails().add(new SchemaDifference.DirectiveArgumentDefaultValueModification(argument.getName(), oldDefaultValue, newDefaultValue));
            }
            if (!(oldType = this.getTypeFromEdgeLabel(editOperation.getSourceEdge())).equals(newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge()))) {
                this.getDirectiveModification(directive.getName()).getDetails().add(new SchemaDifference.DirectiveArgumentTypeModification(argument.getName(), oldType, newType));
            }
        }
    }

    private boolean doesArgumentChangeMakeSense(Vertex oldArgument, Vertex newArgument, Mapping mapping) {
        Vertex oldContainer = this.oldSchemaGraph.getFieldOrDirectiveForArgument(oldArgument);
        Vertex newContainer = this.newSchemaGraph.getFieldOrDirectiveForArgument(newArgument);
        return mapping.getTarget(oldContainer) == newContainer;
    }

    private void outputFieldTypeChanged(EditOperation editOperation) {
        Edge targetEdge = editOperation.getTargetEdge();
        Vertex field = targetEdge.getFrom();
        Vertex container = this.newSchemaGraph.getFieldsContainerForField(field);
        if (container.isOfType("Object")) {
            Vertex object = container;
            SchemaDifference.ObjectModification objectModification = this.getObjectModification(object.getName());
            String fieldName = field.getName();
            String oldType = this.getTypeFromEdgeLabel(editOperation.getSourceEdge());
            String newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge());
            objectModification.getDetails().add(new SchemaDifference.ObjectFieldTypeModification(fieldName, oldType, newType));
        } else {
            Assert.assertTrue(container.isOfType("Interface"));
            Vertex interfaze = container;
            SchemaDifference.InterfaceModification interfaceModification = this.getInterfaceModification(interfaze.getName());
            String fieldName = field.getName();
            String oldType = this.getTypeFromEdgeLabel(editOperation.getSourceEdge());
            String newType = this.getTypeFromEdgeLabel(editOperation.getTargetEdge());
            interfaceModification.getDetails().add(new SchemaDifference.InterfaceFieldTypeModification(fieldName, oldType, newType));
        }
    }

    private String getTypeFromEdgeLabel(Edge edge) {
        String label = edge.getLabel();
        Assert.assertTrue(label.startsWith("type="));
        String type = label.substring("type=".length(), label.indexOf(";"));
        return type;
    }

    private String getDefaultValueFromEdgeLabel(Edge edge) {
        String label = edge.getLabel();
        Assert.assertTrue(label.startsWith("type="));
        String defaultValue = label.substring(label.indexOf(";defaultValue=") + ";defaultValue=".length());
        return defaultValue;
    }

    private boolean isTypeEdge(Edge edge) {
        String label = edge.getLabel();
        return label.startsWith("type=");
    }

    private void interfaceImplementationDeleted(Edge deletedEdge) {
        Vertex from = deletedEdge.getFrom();
        if (from.isOfType("Object")) {
            if (this.isObjectDeleted(from.getName())) {
                return;
            }
            Vertex objectVertex = deletedEdge.getFrom();
            Vertex interfaceVertex = deletedEdge.getTo();
            SchemaDifference.ObjectInterfaceImplementationDeletion deletion = new SchemaDifference.ObjectInterfaceImplementationDeletion(interfaceVertex.getName());
            this.getObjectModification(objectVertex.getName()).getDetails().add(deletion);
        } else {
            Assert.assertTrue(from.isOfType("Interface"));
            if (this.isInterfaceDeleted(from.getName())) {
                return;
            }
            Vertex interfaceFromVertex = deletedEdge.getFrom();
            Vertex interfaceVertex = deletedEdge.getTo();
            SchemaDifference.InterfaceInterfaceImplementationDeletion deletion = new SchemaDifference.InterfaceInterfaceImplementationDeletion(interfaceVertex.getName());
            this.getInterfaceModification(interfaceFromVertex.getName()).getDetails().add(deletion);
        }
    }

    private void newInterfaceAddedToInterfaceOrObject(Edge newEdge) {
        Vertex from = newEdge.getFrom();
        if (from.isOfType("Object")) {
            if (this.isObjectAdded(from.getName())) {
                return;
            }
            Vertex objectVertex = newEdge.getFrom();
            Vertex interfaceVertex = newEdge.getTo();
            SchemaDifference.ObjectInterfaceImplementationAddition objectInterfaceImplementationAddition = new SchemaDifference.ObjectInterfaceImplementationAddition(interfaceVertex.getName());
            this.getObjectModification(objectVertex.getName()).getDetails().add(objectInterfaceImplementationAddition);
        } else {
            Assert.assertTrue(from.isOfType("Interface"));
            if (this.isInterfaceAdded(from.getName())) {
                return;
            }
            Vertex interfaceFromVertex = newEdge.getFrom();
            Vertex interfaceVertex = newEdge.getTo();
            SchemaDifference.InterfaceInterfaceImplementationAddition addition = new SchemaDifference.InterfaceInterfaceImplementationAddition(interfaceVertex.getName());
            this.getInterfaceModification(interfaceFromVertex.getName()).getDetails().add(addition);
        }
    }

    private boolean isDirectiveAdded(String name) {
        return this.directiveDifferences.containsKey(name) && this.directiveDifferences.get(name) instanceof SchemaDifference.DirectiveAddition;
    }

    private boolean isDirectiveDeleted(String name) {
        return this.directiveDifferences.containsKey(name) && this.directiveDifferences.get(name) instanceof SchemaDifference.DirectiveDeletion;
    }

    private boolean isObjectAdded(String name) {
        return this.objectDifferences.containsKey(name) && this.objectDifferences.get(name) instanceof SchemaDifference.ObjectAddition;
    }

    private boolean isUnionAdded(String name) {
        return this.unionDifferences.containsKey(name) && this.unionDifferences.get(name) instanceof SchemaDifference.UnionAddition;
    }

    private boolean isUnionDeleted(String name) {
        return this.unionDifferences.containsKey(name) && this.unionDifferences.get(name) instanceof SchemaDifference.UnionDeletion;
    }

    private boolean isEnumDeleted(String name) {
        return this.enumDifferences.containsKey(name) && this.enumDifferences.get(name) instanceof SchemaDifference.EnumDeletion;
    }

    private boolean isEnumAdded(String name) {
        return this.enumDifferences.containsKey(name) && this.enumDifferences.get(name) instanceof SchemaDifference.EnumAddition;
    }

    private boolean isInputObjectAdded(String name) {
        return this.inputObjectDifferences.containsKey(name) && this.inputObjectDifferences.get(name) instanceof SchemaDifference.InputObjectAddition;
    }

    private boolean isInputObjectDeleted(String name) {
        return this.inputObjectDifferences.containsKey(name) && this.inputObjectDifferences.get(name) instanceof SchemaDifference.InputObjectDeletion;
    }

    private boolean isInputFieldAdded(String name) {
        return this.inputObjectDifferences.containsKey(name) && this.inputObjectDifferences.get(name) instanceof SchemaDifference.InputObjectAddition;
    }

    private boolean isAppliedDirectiveAdded(Vertex container, String appliedDirectiveName) {
        SchemaDifference.DirectiveDifference directiveDifference;
        if (container.isOfType("Scalar")) {
            SchemaDifference.ScalarDifference scalarDifference;
            if (this.scalarDifferences.containsKey(container.getName()) && (scalarDifference = this.scalarDifferences.get(container.getName())) instanceof SchemaDifference.ScalarModification) {
                SchemaDifference.ScalarModification scalarModification = (SchemaDifference.ScalarModification)scalarDifference;
                List<SchemaDifference.AppliedDirectiveAddition> appliedDirectiveAdditions = scalarModification.getDetails(SchemaDifference.AppliedDirectiveAddition.class);
                return appliedDirectiveAdditions.stream().anyMatch(addition -> addition.getName().equals(appliedDirectiveName));
            }
        } else if (container.isOfType("Enum")) {
            SchemaDifference.EnumDifference enumDifference;
            if (this.enumDifferences.containsKey(container.getName()) && (enumDifference = this.enumDifferences.get(container.getName())) instanceof SchemaDifference.EnumModification) {
                SchemaDifference.EnumModification enumModification = (SchemaDifference.EnumModification)enumDifference;
                List<SchemaDifference.AppliedDirectiveAddition> appliedDirectiveAdditions = enumModification.getDetails(SchemaDifference.AppliedDirectiveAddition.class);
                return appliedDirectiveAdditions.stream().anyMatch(addition -> addition.getName().equals(appliedDirectiveName));
            }
        } else if (container.isOfType("Object")) {
            SchemaDifference.ObjectDifference objectDifference;
            if (this.objectDifferences.containsKey(container.getName()) && (objectDifference = this.objectDifferences.get(container.getName())) instanceof SchemaDifference.ObjectModification) {
                SchemaDifference.ObjectModification objectModification = (SchemaDifference.ObjectModification)objectDifference;
                List<SchemaDifference.AppliedDirectiveAddition> appliedDirectiveAdditions = objectModification.getDetails(SchemaDifference.AppliedDirectiveAddition.class);
                return appliedDirectiveAdditions.stream().anyMatch(addition -> addition.getName().equals(appliedDirectiveName));
            }
        } else if (container.isOfType("Interface")) {
            SchemaDifference.InterfaceDifference interfaceDifference;
            if (this.interfaceDifferences.containsKey(container.getName()) && (interfaceDifference = this.interfaceDifferences.get(container.getName())) instanceof SchemaDifference.InterfaceModification) {
                SchemaDifference.InterfaceModification interfaceModification = (SchemaDifference.InterfaceModification)interfaceDifference;
                List<SchemaDifference.AppliedDirectiveAddition> appliedDirectiveAdditions = interfaceModification.getDetails(SchemaDifference.AppliedDirectiveAddition.class);
                return appliedDirectiveAdditions.stream().anyMatch(addition -> addition.getName().equals(appliedDirectiveName));
            }
        } else if (container.isOfType("InputObject")) {
            SchemaDifference.InputObjectDifference inputObjectDifference;
            if (this.inputObjectDifferences.containsKey(container.getName()) && (inputObjectDifference = this.inputObjectDifferences.get(container.getName())) instanceof SchemaDifference.InputObjectModification) {
                SchemaDifference.InputObjectModification inputObjectModification = (SchemaDifference.InputObjectModification)inputObjectDifference;
                List<SchemaDifference.AppliedDirectiveAddition> appliedDirectiveAdditions = inputObjectModification.getDetails(SchemaDifference.AppliedDirectiveAddition.class);
                return appliedDirectiveAdditions.stream().anyMatch(addition -> addition.getName().equals(appliedDirectiveName));
            }
        } else if (container.isOfType("Union")) {
            SchemaDifference.UnionDifference unionDifference;
            if (this.unionDifferences.containsKey(container.getName()) && (unionDifference = this.unionDifferences.get(container.getName())) instanceof SchemaDifference.UnionModification) {
                SchemaDifference.UnionModification unionModification = (SchemaDifference.UnionModification)unionDifference;
                List<SchemaDifference.AppliedDirectiveAddition> appliedDirectiveAdditions = unionModification.getDetails(SchemaDifference.AppliedDirectiveAddition.class);
                return appliedDirectiveAdditions.stream().anyMatch(addition -> addition.getName().equals(appliedDirectiveName));
            }
        } else if (container.isOfType("Directive") && this.directiveDifferences.containsKey(container.getName()) && (directiveDifference = this.directiveDifferences.get(container.getName())) instanceof SchemaDifference.DirectiveModification) {
            SchemaDifference.DirectiveModification directiveModification = (SchemaDifference.DirectiveModification)directiveDifference;
            List<SchemaDifference.AppliedDirectiveAddition> appliedDirectiveAdditions = directiveModification.getDetails(SchemaDifference.AppliedDirectiveAddition.class);
            return appliedDirectiveAdditions.stream().anyMatch(addition -> addition.getName().equals(appliedDirectiveName));
        }
        return false;
    }

    private boolean isAppliedDirectiveDeleted(Vertex rootContainer, String appliedDirectiveName) {
        SchemaDifference.DirectiveDifference directiveDifference;
        if (rootContainer.isOfType("Scalar")) {
            SchemaDifference.ScalarDifference scalarDifference;
            if (this.scalarDifferences.containsKey(rootContainer.getName()) && (scalarDifference = this.scalarDifferences.get(rootContainer.getName())) instanceof SchemaDifference.ScalarModification) {
                SchemaDifference.ScalarModification scalarModification = (SchemaDifference.ScalarModification)scalarDifference;
                List<SchemaDifference.AppliedDirectiveDeletion> appliedDirectiveDeletions = scalarModification.getDetails(SchemaDifference.AppliedDirectiveDeletion.class);
                return appliedDirectiveDeletions.stream().anyMatch(deletion -> deletion.getName().equals(appliedDirectiveName));
            }
        } else if (rootContainer.isOfType("Enum")) {
            SchemaDifference.EnumDifference enumDifference;
            if (this.enumDifferences.containsKey(rootContainer.getName()) && (enumDifference = this.enumDifferences.get(rootContainer.getName())) instanceof SchemaDifference.EnumModification) {
                SchemaDifference.EnumModification enumModification = (SchemaDifference.EnumModification)enumDifference;
                List<SchemaDifference.AppliedDirectiveDeletion> appliedDirectiveDeletions = enumModification.getDetails(SchemaDifference.AppliedDirectiveDeletion.class);
                return appliedDirectiveDeletions.stream().anyMatch(deletion -> deletion.getName().equals(appliedDirectiveName));
            }
        } else if (rootContainer.isOfType("Object")) {
            SchemaDifference.ObjectDifference objectDifference;
            if (this.objectDifferences.containsKey(rootContainer.getName()) && (objectDifference = this.objectDifferences.get(rootContainer.getName())) instanceof SchemaDifference.ObjectModification) {
                SchemaDifference.ObjectModification objectModification = (SchemaDifference.ObjectModification)objectDifference;
                List<SchemaDifference.AppliedDirectiveDeletion> appliedDirectiveDeletions = objectModification.getDetails(SchemaDifference.AppliedDirectiveDeletion.class);
                return appliedDirectiveDeletions.stream().anyMatch(deletion -> deletion.getName().equals(appliedDirectiveName));
            }
        } else if (rootContainer.isOfType("Interface")) {
            SchemaDifference.InterfaceDifference interfaceDifference;
            if (this.interfaceDifferences.containsKey(rootContainer.getName()) && (interfaceDifference = this.interfaceDifferences.get(rootContainer.getName())) instanceof SchemaDifference.InterfaceModification) {
                SchemaDifference.InterfaceModification interfaceModification = (SchemaDifference.InterfaceModification)interfaceDifference;
                List<SchemaDifference.AppliedDirectiveDeletion> appliedDirectiveDeletions = interfaceModification.getDetails(SchemaDifference.AppliedDirectiveDeletion.class);
                return appliedDirectiveDeletions.stream().anyMatch(deletion -> deletion.getName().equals(appliedDirectiveName));
            }
        } else if (rootContainer.isOfType("InputObject")) {
            SchemaDifference.InputObjectDifference inputObjectDifference;
            if (this.inputObjectDifferences.containsKey(rootContainer.getName()) && (inputObjectDifference = this.inputObjectDifferences.get(rootContainer.getName())) instanceof SchemaDifference.InputObjectModification) {
                SchemaDifference.InputObjectModification inputObjectModification = (SchemaDifference.InputObjectModification)inputObjectDifference;
                List<SchemaDifference.AppliedDirectiveDeletion> appliedDirectiveDeletions = inputObjectModification.getDetails(SchemaDifference.AppliedDirectiveDeletion.class);
                return appliedDirectiveDeletions.stream().anyMatch(deletion -> deletion.getName().equals(appliedDirectiveName));
            }
        } else if (rootContainer.isOfType("Union")) {
            SchemaDifference.UnionDifference unionDifference;
            if (this.unionDifferences.containsKey(rootContainer.getName()) && (unionDifference = this.unionDifferences.get(rootContainer.getName())) instanceof SchemaDifference.UnionModification) {
                SchemaDifference.UnionModification unionModification = (SchemaDifference.UnionModification)unionDifference;
                List<SchemaDifference.AppliedDirectiveDeletion> appliedDirectiveDeletions = unionModification.getDetails(SchemaDifference.AppliedDirectiveDeletion.class);
                return appliedDirectiveDeletions.stream().anyMatch(deletion -> deletion.getName().equals(appliedDirectiveName));
            }
        } else if (rootContainer.isOfType("Directive") && this.directiveDifferences.containsKey(rootContainer.getName()) && (directiveDifference = this.directiveDifferences.get(rootContainer.getName())) instanceof SchemaDifference.DirectiveModification) {
            SchemaDifference.DirectiveModification directiveModification = (SchemaDifference.DirectiveModification)directiveDifference;
            List<SchemaDifference.AppliedDirectiveDeletion> appliedDirectiveDeletions = directiveModification.getDetails(SchemaDifference.AppliedDirectiveDeletion.class);
            return appliedDirectiveDeletions.stream().anyMatch(deletion -> deletion.getName().equals(appliedDirectiveName));
        }
        return false;
    }

    private boolean isNewInputFieldExistingInputObject(String inputObjectName, String fieldName) {
        if (!this.inputObjectDifferences.containsKey(inputObjectName)) {
            return false;
        }
        if (!(this.inputObjectDifferences.get(inputObjectName) instanceof SchemaDifference.InputObjectModification)) {
            return false;
        }
        SchemaDifference.InputObjectModification modification = (SchemaDifference.InputObjectModification)this.inputObjectDifferences.get(inputObjectName);
        List<SchemaDifference.InputObjectFieldAddition> newFields = modification.getDetails(SchemaDifference.InputObjectFieldAddition.class);
        return newFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
    }

    private boolean isInputFieldDeletedFromExistingInputObject(String inputObjectName, String fieldName) {
        if (!this.inputObjectDifferences.containsKey(inputObjectName)) {
            return false;
        }
        if (!(this.inputObjectDifferences.get(inputObjectName) instanceof SchemaDifference.InputObjectModification)) {
            return false;
        }
        SchemaDifference.InputObjectModification modification = (SchemaDifference.InputObjectModification)this.inputObjectDifferences.get(inputObjectName);
        List<SchemaDifference.InputObjectFieldDeletion> deletedFields = modification.getDetails(SchemaDifference.InputObjectFieldDeletion.class);
        return deletedFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
    }

    private boolean isArgumentNewForExistingDirective(String directiveName, String argumentName) {
        if (!this.directiveDifferences.containsKey(directiveName)) {
            return false;
        }
        if (!(this.directiveDifferences.get(directiveName) instanceof SchemaDifference.DirectiveModification)) {
            return false;
        }
        SchemaDifference.DirectiveModification directiveModification = (SchemaDifference.DirectiveModification)this.directiveDifferences.get(directiveName);
        List<SchemaDifference.DirectiveArgumentAddition> newArgs = directiveModification.getDetails(SchemaDifference.DirectiveArgumentAddition.class);
        return newArgs.stream().anyMatch(detail -> detail.getName().equals(argumentName));
    }

    private boolean isArgumentDeletedFromExistingDirective(String directiveName, String argumentName) {
        if (!this.directiveDifferences.containsKey(directiveName)) {
            return false;
        }
        if (!(this.directiveDifferences.get(directiveName) instanceof SchemaDifference.DirectiveModification)) {
            return false;
        }
        SchemaDifference.DirectiveModification directiveModification = (SchemaDifference.DirectiveModification)this.directiveDifferences.get(directiveName);
        List<SchemaDifference.DirectiveArgumentDeletion> deletedArgs = directiveModification.getDetails(SchemaDifference.DirectiveArgumentDeletion.class);
        return deletedArgs.stream().anyMatch(detail -> detail.getName().equals(argumentName));
    }

    private boolean isArgumentNewForExistingObjectField(String objectName, String fieldName, String argumentName) {
        if (!this.objectDifferences.containsKey(objectName)) {
            return false;
        }
        if (!(this.objectDifferences.get(objectName) instanceof SchemaDifference.ObjectModification)) {
            return false;
        }
        SchemaDifference.ObjectModification objectModification = (SchemaDifference.ObjectModification)this.objectDifferences.get(objectName);
        List<SchemaDifference.ObjectFieldAddition> newFields = objectModification.getDetails(SchemaDifference.ObjectFieldAddition.class);
        boolean newField = newFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
        if (newField) {
            return false;
        }
        List<SchemaDifference.ObjectFieldArgumentAddition> newArgs = objectModification.getDetails(SchemaDifference.ObjectFieldArgumentAddition.class);
        return newArgs.stream().anyMatch(detail -> detail.getFieldName().equals(fieldName) && detail.getName().equals(argumentName));
    }

    private boolean isArgumentDeletedFromExistingObjectField(String objectName, String fieldName, String argumentName) {
        if (!this.objectDifferences.containsKey(objectName)) {
            return false;
        }
        if (!(this.objectDifferences.get(objectName) instanceof SchemaDifference.ObjectModification)) {
            return false;
        }
        SchemaDifference.ObjectModification objectModification = (SchemaDifference.ObjectModification)this.objectDifferences.get(objectName);
        List<SchemaDifference.ObjectFieldDeletion> deletedFields = objectModification.getDetails(SchemaDifference.ObjectFieldDeletion.class);
        boolean deletedField = deletedFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
        if (deletedField) {
            return false;
        }
        List<SchemaDifference.ObjectFieldArgumentDeletion> deletedArgs = objectModification.getDetails(SchemaDifference.ObjectFieldArgumentDeletion.class);
        return deletedArgs.stream().anyMatch(detail -> detail.getFieldName().equals(fieldName) && detail.getName().equals(argumentName));
    }

    private boolean isArgumentDeletedFromExistingInterfaceField(String interfaceName, String fieldName, String argumentName) {
        if (!this.interfaceDifferences.containsKey(interfaceName)) {
            return false;
        }
        if (!(this.interfaceDifferences.get(interfaceName) instanceof SchemaDifference.InterfaceModification)) {
            return false;
        }
        SchemaDifference.InterfaceModification interfaceModification = (SchemaDifference.InterfaceModification)this.interfaceDifferences.get(interfaceName);
        List<SchemaDifference.InterfaceFieldDeletion> deletedFields = interfaceModification.getDetails(SchemaDifference.InterfaceFieldDeletion.class);
        boolean deletedField = deletedFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
        if (deletedField) {
            return false;
        }
        List<SchemaDifference.InterfaceFieldArgumentDeletion> deletedArgs = interfaceModification.getDetails(SchemaDifference.InterfaceFieldArgumentDeletion.class);
        return deletedArgs.stream().anyMatch(detail -> detail.getFieldName().equals(fieldName) && detail.getName().equals(argumentName));
    }

    private boolean isArgumentNewForExistingInterfaceField(String objectName, String fieldName, String argumentName) {
        if (!this.interfaceDifferences.containsKey(objectName)) {
            return false;
        }
        if (!(this.interfaceDifferences.get(objectName) instanceof SchemaDifference.InterfaceModification)) {
            return false;
        }
        SchemaDifference.InterfaceModification interfaceModification = (SchemaDifference.InterfaceModification)this.interfaceDifferences.get(objectName);
        List<SchemaDifference.InterfaceFieldAddition> newFields = interfaceModification.getDetails(SchemaDifference.InterfaceFieldAddition.class);
        boolean newField = newFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
        if (newField) {
            return false;
        }
        List<SchemaDifference.InterfaceFieldArgumentAddition> newArgs = interfaceModification.getDetails(SchemaDifference.InterfaceFieldArgumentAddition.class);
        return newArgs.stream().anyMatch(detail -> detail.getFieldName().equals(fieldName) && detail.getName().equals(argumentName));
    }

    private boolean isFieldNewForExistingObject(String objectName, String fieldName) {
        if (!this.objectDifferences.containsKey(objectName)) {
            return false;
        }
        if (!(this.objectDifferences.get(objectName) instanceof SchemaDifference.ObjectModification)) {
            return false;
        }
        SchemaDifference.ObjectModification objectModification = (SchemaDifference.ObjectModification)this.objectDifferences.get(objectName);
        List<SchemaDifference.ObjectFieldAddition> newFields = objectModification.getDetails(SchemaDifference.ObjectFieldAddition.class);
        return newFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
    }

    private boolean isFieldDeletedFromExistingInterface(String interfaceName, String fieldName) {
        if (!this.interfaceDifferences.containsKey(interfaceName)) {
            return false;
        }
        if (!(this.interfaceDifferences.get(interfaceName) instanceof SchemaDifference.InterfaceModification)) {
            return false;
        }
        SchemaDifference.InterfaceModification interfaceModification = (SchemaDifference.InterfaceModification)this.interfaceDifferences.get(interfaceName);
        List<SchemaDifference.InterfaceFieldDeletion> deletedFields = interfaceModification.getDetails(SchemaDifference.InterfaceFieldDeletion.class);
        return deletedFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
    }

    private boolean isFieldDeletedFromExistingObject(String objectName, String fieldName) {
        if (!this.objectDifferences.containsKey(objectName)) {
            return false;
        }
        if (!(this.objectDifferences.get(objectName) instanceof SchemaDifference.ObjectModification)) {
            return false;
        }
        SchemaDifference.ObjectModification objectModification = (SchemaDifference.ObjectModification)this.objectDifferences.get(objectName);
        List<SchemaDifference.ObjectFieldDeletion> deletedFields = objectModification.getDetails(SchemaDifference.ObjectFieldDeletion.class);
        return deletedFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
    }

    private boolean isNewEnumValueForExistingEnum(String enumName, String valueName) {
        if (!this.enumDifferences.containsKey(enumName)) {
            return false;
        }
        if (!(this.enumDifferences.get(enumName) instanceof SchemaDifference.EnumModification)) {
            return false;
        }
        SchemaDifference.EnumModification enumModification = (SchemaDifference.EnumModification)this.enumDifferences.get(enumName);
        List<SchemaDifference.EnumValueAddition> newValues = enumModification.getDetails(SchemaDifference.EnumValueAddition.class);
        return newValues.stream().anyMatch(detail -> detail.getName().equals(valueName));
    }

    private boolean isEnumValueDeletedFromExistingEnum(String enumName, String valueName) {
        if (!this.enumDifferences.containsKey(enumName)) {
            return false;
        }
        if (!(this.enumDifferences.get(enumName) instanceof SchemaDifference.EnumModification)) {
            return false;
        }
        SchemaDifference.EnumModification enumModification = (SchemaDifference.EnumModification)this.enumDifferences.get(enumName);
        List<SchemaDifference.EnumValueDeletion> deletedValues = enumModification.getDetails(SchemaDifference.EnumValueDeletion.class);
        return deletedValues.stream().anyMatch(detail -> detail.getName().equals(valueName));
    }

    private boolean isFieldNewForExistingInterface(String interfaceName, String fieldName) {
        if (!this.interfaceDifferences.containsKey(interfaceName)) {
            return false;
        }
        if (!(this.interfaceDifferences.get(interfaceName) instanceof SchemaDifference.InterfaceModification)) {
            return false;
        }
        SchemaDifference.InterfaceModification interfaceModification = (SchemaDifference.InterfaceModification)this.interfaceDifferences.get(interfaceName);
        List<SchemaDifference.InterfaceFieldAddition> newFields = interfaceModification.getDetails(SchemaDifference.InterfaceFieldAddition.class);
        return newFields.stream().anyMatch(detail -> detail.getName().equals(fieldName));
    }

    private boolean isObjectDeleted(String name) {
        return this.objectDifferences.containsKey(name) && this.objectDifferences.get(name) instanceof SchemaDifference.ObjectDeletion;
    }

    private boolean isInterfaceDeleted(String name) {
        return this.interfaceDifferences.containsKey(name) && this.interfaceDifferences.get(name) instanceof SchemaDifference.InterfaceDeletion;
    }

    private boolean isInterfaceAdded(String name) {
        return this.interfaceDifferences.containsKey(name) && this.interfaceDifferences.get(name) instanceof SchemaDifference.InterfaceAddition;
    }

    private boolean isScalarAdded(String name) {
        return this.scalarDifferences.containsKey(name) && this.scalarDifferences.get(name) instanceof SchemaDifference.ScalarAddition;
    }

    private boolean isScalarDeleted(String name) {
        return this.scalarDifferences.containsKey(name) && this.scalarDifferences.get(name) instanceof SchemaDifference.ScalarDeletion;
    }

    private SchemaDifference.ObjectModification getObjectModification(String newName) {
        if (!this.objectDifferences.containsKey(newName)) {
            this.objectDifferences.put(newName, new SchemaDifference.ObjectModification(newName));
        }
        Assert.assertTrue(this.objectDifferences.get(newName) instanceof SchemaDifference.ObjectModification);
        return (SchemaDifference.ObjectModification)this.objectDifferences.get(newName);
    }

    private SchemaDifference.UnionModification getUnionModification(String newName) {
        if (!this.unionDifferences.containsKey(newName)) {
            this.unionDifferences.put(newName, new SchemaDifference.UnionModification(newName));
        }
        Assert.assertTrue(this.unionDifferences.get(newName) instanceof SchemaDifference.UnionModification);
        return (SchemaDifference.UnionModification)this.unionDifferences.get(newName);
    }

    private SchemaDifference.EnumModification getEnumModification(String newName) {
        if (!this.enumDifferences.containsKey(newName)) {
            this.enumDifferences.put(newName, new SchemaDifference.EnumModification(newName));
        }
        Assert.assertTrue(this.enumDifferences.get(newName) instanceof SchemaDifference.EnumModification);
        return (SchemaDifference.EnumModification)this.enumDifferences.get(newName);
    }

    private SchemaDifference.InputObjectModification getInputObjectModification(String newName) {
        if (!this.inputObjectDifferences.containsKey(newName)) {
            this.inputObjectDifferences.put(newName, new SchemaDifference.InputObjectModification(newName));
        }
        Assert.assertTrue(this.inputObjectDifferences.get(newName) instanceof SchemaDifference.InputObjectModification);
        return (SchemaDifference.InputObjectModification)this.inputObjectDifferences.get(newName);
    }

    private SchemaDifference.DirectiveModification getDirectiveModification(String newName) {
        if (!this.directiveDifferences.containsKey(newName)) {
            this.directiveDifferences.put(newName, new SchemaDifference.DirectiveModification(newName));
        }
        Assert.assertTrue(this.directiveDifferences.get(newName) instanceof SchemaDifference.DirectiveModification);
        return (SchemaDifference.DirectiveModification)this.directiveDifferences.get(newName);
    }

    private SchemaDifference.InterfaceModification getInterfaceModification(String newName) {
        if (!this.interfaceDifferences.containsKey(newName)) {
            this.interfaceDifferences.put(newName, new SchemaDifference.InterfaceModification(newName));
        }
        Assert.assertTrue(this.interfaceDifferences.get(newName) instanceof SchemaDifference.InterfaceModification);
        return (SchemaDifference.InterfaceModification)this.interfaceDifferences.get(newName);
    }

    private SchemaDifference.ScalarModification getScalarModification(String newName) {
        if (!this.scalarDifferences.containsKey(newName)) {
            this.scalarDifferences.put(newName, new SchemaDifference.ScalarModification(newName));
        }
        Assert.assertTrue(this.scalarDifferences.get(newName) instanceof SchemaDifference.ScalarModification);
        return (SchemaDifference.ScalarModification)this.scalarDifferences.get(newName);
    }

    private void addedObject(EditOperation editOperation) {
        String objectName = editOperation.getTargetVertex().getName();
        SchemaDifference.ObjectAddition objectAddition = new SchemaDifference.ObjectAddition(objectName);
        this.objectDifferences.put(objectName, objectAddition);
    }

    private void addedInterface(EditOperation editOperation) {
        String objectName = editOperation.getTargetVertex().getName();
        SchemaDifference.InterfaceAddition interfaceAddition = new SchemaDifference.InterfaceAddition(objectName);
        this.interfaceDifferences.put(objectName, interfaceAddition);
    }

    private void addedUnion(EditOperation editOperation) {
        String unionName = editOperation.getTargetVertex().getName();
        SchemaDifference.UnionAddition addition = new SchemaDifference.UnionAddition(unionName);
        this.unionDifferences.put(unionName, addition);
    }

    private void addedInputObject(EditOperation editOperation) {
        String inputObjectName = editOperation.getTargetVertex().getName();
        SchemaDifference.InputObjectAddition addition = new SchemaDifference.InputObjectAddition(inputObjectName);
        this.inputObjectDifferences.put(inputObjectName, addition);
    }

    private void addedEnum(EditOperation editOperation) {
        String enumName = editOperation.getTargetVertex().getName();
        SchemaDifference.EnumAddition enumAddition = new SchemaDifference.EnumAddition(enumName);
        this.enumDifferences.put(enumName, enumAddition);
    }

    private void addedScalar(EditOperation editOperation) {
        String scalarName = editOperation.getTargetVertex().getName();
        if (ScalarInfo.isGraphqlSpecifiedScalar(scalarName)) {
            return;
        }
        SchemaDifference.ScalarAddition addition = new SchemaDifference.ScalarAddition(scalarName);
        this.scalarDifferences.put(scalarName, addition);
    }

    private void addedDirective(EditOperation editOperation) {
        String directiveName = editOperation.getTargetVertex().getName();
        SchemaDifference.DirectiveAddition addition = new SchemaDifference.DirectiveAddition(directiveName);
        this.directiveDifferences.put(directiveName, addition);
    }

    private void removedObject(EditOperation editOperation) {
        String objectName = editOperation.getSourceVertex().getName();
        SchemaDifference.ObjectDeletion change = new SchemaDifference.ObjectDeletion(objectName);
        this.objectDifferences.put(objectName, change);
    }

    private void removedInterface(EditOperation editOperation) {
        String interfaceName = editOperation.getSourceVertex().getName();
        SchemaDifference.InterfaceDeletion change = new SchemaDifference.InterfaceDeletion(interfaceName);
        this.interfaceDifferences.put(interfaceName, change);
    }

    private void removedUnion(EditOperation editOperation) {
        String unionName = editOperation.getSourceVertex().getName();
        SchemaDifference.UnionDeletion change = new SchemaDifference.UnionDeletion(unionName);
        this.unionDifferences.put(unionName, change);
    }

    private void removedInputObject(EditOperation editOperation) {
        String name = editOperation.getSourceVertex().getName();
        SchemaDifference.InputObjectDeletion change = new SchemaDifference.InputObjectDeletion(name);
        this.inputObjectDifferences.put(name, change);
    }

    private void removedEnum(EditOperation editOperation) {
        String enumName = editOperation.getSourceVertex().getName();
        SchemaDifference.EnumDeletion deletion = new SchemaDifference.EnumDeletion(enumName);
        this.enumDifferences.put(enumName, deletion);
    }

    private void deletedScalar(EditOperation editOperation) {
        String scalarName = editOperation.getSourceVertex().getName();
        SchemaDifference.ScalarDeletion change = new SchemaDifference.ScalarDeletion(scalarName);
        this.scalarDifferences.put(scalarName, change);
    }

    private void deletedDirective(EditOperation editOperation) {
        String directiveName = editOperation.getSourceVertex().getName();
        SchemaDifference.DirectiveDeletion change = new SchemaDifference.DirectiveDeletion(directiveName);
        this.directiveDifferences.put(directiveName, change);
    }

    private void argumentDeleted(EditOperation editOperation) {
        Vertex fieldOrDirective;
        Vertex deletedArgument = editOperation.getSourceVertex();
        if (deletedArgument == null) {
            deletedArgument = editOperation.getSourceEdge().getTo();
        }
        if ((fieldOrDirective = this.oldSchemaGraph.getFieldOrDirectiveForArgument(deletedArgument)).isOfType("Field")) {
            Vertex field = fieldOrDirective;
            Vertex fieldsContainerForField = this.oldSchemaGraph.getFieldsContainerForField(field);
            if (fieldsContainerForField.isOfType("Object")) {
                Vertex object = fieldsContainerForField;
                if (this.isObjectDeleted(object.getName())) {
                    return;
                }
                if (this.isFieldDeletedFromExistingObject(object.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentDeletedFromExistingObjectField(object.getName(), field.getName(), deletedArgument.getName())) {
                    return;
                }
                this.getObjectModification(object.getName()).getDetails().add(new SchemaDifference.ObjectFieldArgumentDeletion(field.getName(), deletedArgument.getName()));
            } else {
                Assert.assertTrue(fieldsContainerForField.isOfType("Interface"));
                Vertex interfaze = fieldsContainerForField;
                if (this.isInterfaceDeleted(interfaze.getName())) {
                    return;
                }
                if (this.isFieldDeletedFromExistingInterface(interfaze.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentDeletedFromExistingInterfaceField(interfaze.getName(), field.getName(), deletedArgument.getName())) {
                    return;
                }
                this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.InterfaceFieldArgumentDeletion(field.getName(), deletedArgument.getName()));
            }
        } else {
            Assert.assertTrue(fieldOrDirective.isOfType("Directive"));
            Vertex directive = fieldOrDirective;
            if (this.isDirectiveDeleted(directive.getName())) {
                return;
            }
            if (this.isArgumentDeletedFromExistingDirective(directive.getName(), deletedArgument.getName())) {
                return;
            }
            this.getDirectiveModification(directive.getName()).getDetails().add(new SchemaDifference.DirectiveArgumentDeletion(deletedArgument.getName()));
        }
    }

    private void argumentAdded(EditOperation editOperation) {
        Vertex fieldOrDirective;
        Vertex addedArgument = editOperation.getTargetVertex();
        if (addedArgument == null) {
            addedArgument = editOperation.getTargetEdge().getTo();
        }
        if ((fieldOrDirective = this.newSchemaGraph.getFieldOrDirectiveForArgument(addedArgument)).isOfType("Field")) {
            Vertex field = fieldOrDirective;
            Vertex fieldsContainerForField = this.newSchemaGraph.getFieldsContainerForField(field);
            if (fieldsContainerForField.isOfType("Object")) {
                Vertex object = fieldsContainerForField;
                if (this.isObjectAdded(object.getName())) {
                    return;
                }
                if (this.isFieldNewForExistingObject(object.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentNewForExistingObjectField(object.getName(), field.getName(), addedArgument.getName())) {
                    return;
                }
                this.getObjectModification(object.getName()).getDetails().add(new SchemaDifference.ObjectFieldArgumentAddition(field.getName(), addedArgument.getName()));
            } else {
                Assert.assertTrue(fieldsContainerForField.isOfType("Interface"));
                Vertex interfaze = fieldsContainerForField;
                if (this.isInterfaceAdded(interfaze.getName())) {
                    return;
                }
                if (this.isFieldNewForExistingInterface(interfaze.getName(), field.getName())) {
                    return;
                }
                if (this.isArgumentNewForExistingInterfaceField(interfaze.getName(), field.getName(), addedArgument.getName())) {
                    return;
                }
                this.getInterfaceModification(interfaze.getName()).getDetails().add(new SchemaDifference.InterfaceFieldArgumentAddition(field.getName(), addedArgument.getName()));
            }
        } else {
            Assert.assertTrue(fieldOrDirective.isOfType("Directive"));
            Vertex directive = fieldOrDirective;
            if (this.isDirectiveAdded(directive.getName())) {
                return;
            }
            if (this.isArgumentNewForExistingDirective(directive.getName(), addedArgument.getName())) {
                return;
            }
            this.getDirectiveModification(directive.getName()).getDetails().add(new SchemaDifference.DirectiveArgumentAddition(addedArgument.getName()));
        }
    }

    private void changedEnum(EditOperation editOperation) {
        String newName;
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName = editOperation.getTargetVertex().getName())) {
            return;
        }
        SchemaDifference.EnumModification modification = new SchemaDifference.EnumModification(oldName, newName);
        this.enumDifferences.put(oldName, modification);
        this.enumDifferences.put(newName, modification);
    }

    private void changedScalar(EditOperation editOperation) {
        String newName;
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName = editOperation.getTargetVertex().getName())) {
            return;
        }
        SchemaDifference.ScalarModification modification = new SchemaDifference.ScalarModification(oldName, newName);
        this.scalarDifferences.put(oldName, modification);
        this.scalarDifferences.put(newName, modification);
    }

    private void changedInputObject(EditOperation editOperation) {
        String newName;
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName = editOperation.getTargetVertex().getName())) {
            return;
        }
        SchemaDifference.InputObjectModification modification = new SchemaDifference.InputObjectModification(oldName, newName);
        this.inputObjectDifferences.put(oldName, modification);
        this.inputObjectDifferences.put(newName, modification);
    }

    private void changedDirective(EditOperation editOperation) {
        String newName;
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName = editOperation.getTargetVertex().getName())) {
            return;
        }
        SchemaDifference.DirectiveModification modification = new SchemaDifference.DirectiveModification(oldName, newName);
        this.directiveDifferences.put(oldName, modification);
        this.directiveDifferences.put(newName, modification);
    }

    private void changedObject(EditOperation editOperation) {
        String newName;
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName = editOperation.getTargetVertex().getName())) {
            return;
        }
        SchemaDifference.ObjectModification objectModification = new SchemaDifference.ObjectModification(oldName, newName);
        this.objectDifferences.put(oldName, objectModification);
        this.objectDifferences.put(newName, objectModification);
    }

    private void changedInterface(EditOperation editOperation) {
        String newName;
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName = editOperation.getTargetVertex().getName())) {
            return;
        }
        SchemaDifference.InterfaceModification interfaceModification = new SchemaDifference.InterfaceModification(oldName, newName);
        this.interfaceDifferences.put(oldName, interfaceModification);
        this.interfaceDifferences.put(newName, interfaceModification);
    }

    private void changedUnion(EditOperation editOperation) {
        String newName = editOperation.getTargetVertex().getName();
        String oldName = editOperation.getSourceVertex().getName();
        if (oldName.equals(newName)) {
            return;
        }
        SchemaDifference.UnionModification objectModification = new SchemaDifference.UnionModification(oldName, newName);
        this.unionDifferences.put(oldName, objectModification);
        this.unionDifferences.put(newName, objectModification);
    }

    @VisibleForTesting
    static List<EditOperation> getTraversalOrder(List<EditOperation> editOperations) {
        ArrayList<EditOperation> sorted = new ArrayList<EditOperation>(editOperations);
        sorted.sort(Comparator.comparingInt(editOperation -> {
            int i = OPERATION_TRAVERSAL_ORDER.indexOf((Object)editOperation.getOperation());
            if (i < 0) {
                return (Integer)Assert.assertShouldNeverHappen("Unknown operation: " + editOperation.getOperation(), new Object[0]);
            }
            return i;
        }).thenComparing(editOperation -> {
            for (int i = 0; i < TYPE_TRAVERSAL_ORDER.size(); ++i) {
                String type = TYPE_TRAVERSAL_ORDER.get(i);
                if (!EditOperationAnalyzer.isAnyVertexOfType(editOperation, type)) continue;
                return i;
            }
            return (Integer)Assert.assertShouldNeverHappen("Unable to determine edit operation subject for: " + editOperation, new Object[0]);
        }));
        return sorted;
    }

    private static boolean isAnyVertexOfType(EditOperation edit, String type) {
        return edit.getSourceVertex() != null && edit.getSourceVertex().isOfType(type) || edit.getTargetVertex() != null && edit.getTargetVertex().isOfType(type) || edit.getSourceEdge() != null && EditOperationAnalyzer.isAnyVertexOfType(edit.getSourceEdge(), type) || edit.getTargetEdge() != null && EditOperationAnalyzer.isAnyVertexOfType(edit.getTargetEdge(), type);
    }

    private static boolean isAnyVertexOfType(Edge edge, String type) {
        return edge.getFrom().isOfType(type) || edge.getTo().isOfType(type);
    }
}

