/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.file;

import com.kms.katalon.entity.file.FileEntity;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class UserFileEntity
extends FileEntity {
    private static final long serialVersionUID = 5232182810796545943L;
    private File file;

    public UserFileEntity(File file) {
        this.setFile(file);
    }

    @Override
    public String getFileExtension() {
        return "." + FilenameUtils.getExtension((String)this.file.getName());
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.name = FilenameUtils.getName((String)file.getName());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof UserFileEntity)) {
            return false;
        }
        UserFileEntity that = (UserFileEntity)object;
        return this.getFile() != null && this.getFile().equals(that.getFile());
    }

    @Override
    public String getLocation() {
        if (this.parentFolder != null) {
            return this.parentFolder.getLocation() + File.separator + this.name;
        }
        if (this.project != null) {
            return this.project.getFolderLocation() + File.separator + this.name;
        }
        return this.name + this.getFileExtension();
    }

    @Override
    public String getRelativePath() {
        if (this.parentFolder != null) {
            return this.parentFolder.getRelativePath() + File.separator + this.name;
        }
        return this.name;
    }

    @Override
    public String getRelativePathForUI() {
        if (this.parentFolder != null) {
            return this.parentFolder.getRelativePath() + File.separator + this.name;
        }
        return this.name;
    }

    @Override
    public String getIdForDisplay() {
        return this.getRelativePathForUI().replace(File.separator, "/");
    }
}

