/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.codehaus.groovy.antlr.LocationSupport;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.eclipse.jdt.groovy.core.util.DepthFirstVisitor;

public class BreakpointLocationFinder {
    protected final LocationSupport locator;
    protected final Iterable<ASTNode> nodes;

    public BreakpointLocationFinder(ModuleNode module) {
        this.locator = (LocationSupport)module.getNodeMetaData(LocationSupport.class);
        final TreeSet<ASTNode> nodes = new TreeSet<ASTNode>(Comparator.comparing(this::lineNumber).thenComparing(ASTNode::getColumnNumber).thenComparing(Comparator.comparing(ASTNode::getLastLineNumber).thenComparing(ASTNode::getLastColumnNumber).reversed()));
        new DepthFirstVisitor(){

            protected void visitAnnotation(AnnotationNode annotation) {
                for (Expression expression : annotation.getMembers().values()) {
                    if (!(expression instanceof ClosureExpression)) continue;
                    expression.visit((GroovyCodeVisitor)this);
                }
            }

            protected void visitExpression(Expression expression) {
                if (expression.getLineNumber() > 0 && !(expression instanceof ClosureExpression) && !(expression instanceof TupleExpression)) {
                    nodes.add(expression);
                }
                super.visitExpression(expression);
            }

            public void visitMethod(MethodNode node) {
                if (node.getLineNumber() > 0) {
                    nodes.add(node);
                }
                super.visitMethod(node);
            }

            public void visitField(FieldNode node) {
                if (node.getLineNumber() > 0) {
                    nodes.add(node);
                }
                super.visitField(node);
            }

            public void visitClass(ClassNode node) {
                if (node.getLineNumber() > 0) {
                    nodes.add(node);
                }
                super.visitClass(node);
            }
        }.visitModule(module);
        this.nodes = Collections.unmodifiableSet(nodes);
    }

    public ASTNode findBreakpointLocation(int lineNumber) {
        ASTNode bestMatch = null;
        boolean skipNext = false;
        for (ASTNode node : this.nodes) {
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (node instanceof DeclarationExpression) {
                Expression rightExpression = ((DeclarationExpression)node).getRightExpression();
                if (rightExpression != null && !"null".equals(rightExpression.getText())) continue;
                skipNext = true;
                continue;
            }
            if (this.lineNumber(node) < lineNumber) continue;
            bestMatch = node;
            break;
        }
        return bestMatch;
    }

    protected int lineNumber(ASTNode node) {
        int[] row_col;
        if (this.locator != null && node instanceof AnnotatedNode && !(node instanceof Expression) && (row_col = this.locator.getRowCol(((AnnotatedNode)node).getNameStart())) != null && row_col.length > 0) {
            return row_col[0];
        }
        return node.getLineNumber();
    }
}

