/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.eclipse.debug.ui.ToggleBreakpointAdapter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class GroovyBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private final IEditorStatusLine fStatusLine;
    private final ToggleBreakpointAdapter fBreakpointAdapter;

    public GroovyBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor, IEditorPart editorPart) {
        super("Toggle &Breakpoint");
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fStatusLine = (IEditorStatusLine)Adapters.adapt((Object)editorPart, IEditorStatusLine.class);
        this.fBreakpointAdapter = new ToggleBreakpointAdapter();
    }

    public void dispose() {
        this.fTextEditor = null;
        this.fRuler = null;
    }

    public void run() {
        try {
            List<IMarker> list = this.getMarkers();
            if (list.isEmpty()) {
                IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
                int lineNumber = this.fRuler.getLineOfLastMouseButtonActivity();
                if (lineNumber >= document.getNumberOfLines()) {
                    return;
                }
                try {
                    IRegion line = document.getLineInformation(lineNumber);
                    TextSelection selection = new TextSelection(document, line.getOffset(), line.getLength());
                    this.fBreakpointAdapter.toggleLineBreakpoints((IWorkbenchPart)this.fTextEditor, (ISelection)selection);
                }
                catch (BadLocationException line) {}
            } else {
                IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                for (IMarker marker : list) {
                    IBreakpoint breakpoint = manager.getBreakpoint(marker);
                    if (breakpoint == null) continue;
                    breakpoint.delete();
                }
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog((String)"Failed to add breakpoint", (IStatus)e.getStatus());
        }
        catch (RuntimeException e) {
            JDIDebugUIPlugin.errorDialog((String)"Failed to add breakpoint", (Throwable)e);
        }
    }

    protected List<IMarker> getMarkers() {
        List<IMarker> breakpoints = Collections.emptyList();
        try {
            IMarker[] markers;
            IEditorInput editorInput = this.fTextEditor.getEditorInput();
            IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
            IAnnotationModel model = provider.getAnnotationModel((Object)editorInput);
            if (model instanceof AbstractMarkerAnnotationModel && (markers = editorInput instanceof IFileEditorInput ? ((IFileEditorInput)editorInput).getFile().findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2) : ResourcesPlugin.getWorkspace().getRoot().findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2)) != null) {
                IDocument document = provider.getDocument((Object)editorInput);
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    IBreakpoint breakpoint = breakpointManager.getBreakpoint(marker);
                    if (breakpoint != null && breakpointManager.isRegistered(breakpoint) && this.includesRulerLine(((AbstractMarkerAnnotationModel)model).getMarkerPosition(marker), document)) {
                        if (breakpoints.isEmpty()) {
                            breakpoints = new ArrayList<IMarker>();
                        }
                        breakpoints.add(marker);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log((IStatus)e.getStatus());
        }
        catch (RuntimeException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        return breakpoints;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void report(String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(() -> {
            if (this.fStatusLine != null) {
                this.fStatusLine.setMessage(true, message, null);
            }
            if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                Display.getCurrent().beep();
            }
        });
    }
}

