/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.HashMap;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.debug.ui.BreakpointLocationFinder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IDebugElement && target.canResume()) {
            IDebugTarget debugTarget = ((IDebugElement)target).getDebugTarget();
            IJavaDebugTarget adapter = (IJavaDebugTarget)debugTarget.getAdapter(IJavaDebugTarget.class);
            return adapter != null;
        }
        return false;
    }

    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        ModuleNode moduleNode = (ModuleNode)Adapters.adapt((Object)this.getTextEditor(part), ModuleNode.class);
        int lineNumber = ((ITextSelection)selection).getStartLine() + 1;
        if (moduleNode != null && lineNumber > 0) {
            ASTNode found = new BreakpointLocationFinder(moduleNode).findBreakpointLocation(lineNumber);
            if (found != null && found.getLineNumber() == lineNumber) {
                HashMap attributes = new HashMap(4);
                BreakpointUtils.addRunToLineAttributes(attributes);
                String typeName = ((ClassNode)moduleNode.getClasses().get(0)).getName();
                IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)typeName, (int)lineNumber, (int)-1, (int)-1, (int)1, (boolean)false, attributes);
                IDebugTarget debugTarget = ((IDebugElement)target).getDebugTarget();
                if (debugTarget != null) {
                    RunToLineHandler handler = new RunToLineHandler(debugTarget, target, (IBreakpoint)breakpoint);
                    handler.run((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
            } else {
                String errorMessage = ((ITextSelection)selection).getLength() > 0 ? "Selected line is not a valid location to run to" : "Cursor position is not a valid location to run to";
                throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
        }
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }
}

