/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedSourceField;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.editor.outline.GroovyOutlinePage;
import org.codehaus.groovy.eclipse.editor.outline.IOutlineExtender;
import org.codehaus.groovy.eclipse.editor.outline.OCompilationUnit;
import org.codehaus.groovy.eclipse.editor.outline.OField;
import org.codehaus.groovy.eclipse.editor.outline.OType;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.core.JavaElement;

public class GroovyScriptOutlineExtender
implements IOutlineExtender {
    @Override
    public GroovyOutlinePage getGroovyOutlinePageForEditor(String contextMenuID, GroovyEditor editor) {
        return new GroovyOutlinePage(contextMenuID, editor, new GroovyScriptOCompilationUnit(editor.getGroovyCompilationUnit()));
    }

    @Override
    public boolean appliesTo(GroovyCompilationUnit unit) {
        ModuleNode moduleNode = unit.getModuleNode();
        return moduleNode != null && !moduleNode.getClasses().isEmpty() && GroovyUtils.isScript((ClassNode)((ClassNode)moduleNode.getClasses().get(0)));
    }

    private static class GroovyScriptOCompilationUnit
    extends OCompilationUnit {
        GroovyScriptOCompilationUnit(GroovyCompilationUnit unit) {
            super(unit);
        }

        @Override
        public IJavaElement[] refreshChildren() {
            ModuleNode module = (ModuleNode)this.getNode();
            ClassNode scriptClassDummy = null;
            String scriptName = null;
            if (module != null) {
                scriptClassDummy = module.getScriptClassDummy();
                if (scriptClassDummy == null && !module.getClasses().isEmpty()) {
                    scriptClassDummy = (ClassNode)module.getClasses().get(0);
                }
                scriptName = scriptClassDummy == null ? "Problem" : scriptClassDummy.getNameWithoutPackage();
            }
            if (module == null || module.encounteredUnrecoverableError() || scriptClassDummy == null) {
                return new IJavaElement[]{new OType((IJavaElement)this.getUnit(), (ASTNode)module, scriptName + " -- No structure found")};
            }
            try {
                final ArrayList<Object> outlineElements = new ArrayList<Object>();
                IType candidate = null;
                IJavaElement[] iJavaElementArray = this.getUnit().getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    if (child.getElementName().equals(scriptName)) {
                        candidate = (IType)child;
                    } else {
                        outlineElements.add(child);
                    }
                    ++n2;
                }
                final IType scriptType = candidate;
                if (scriptType != null) {
                    IJavaElement[] iJavaElementArray2 = scriptType.getChildren();
                    int n3 = iJavaElementArray2.length;
                    n = 0;
                    while (n < n3) {
                        IJavaElement child = iJavaElementArray2[n];
                        if (child instanceof IMember && !GroovyScriptOCompilationUnit.isRunMethod(child) && !GroovyScriptOCompilationUnit.isMainMethod(child) && !GroovyScriptOCompilationUnit.isConstructor(child)) {
                            outlineElements.add(child);
                        }
                        ++n;
                    }
                    for (FieldNode field : scriptClassDummy.getFields()) {
                        if (field.isSynthetic()) continue;
                        outlineElements.add(new GroovyResolvedSourceField((JavaElement)scriptType, field.getName(), null, null, (ASTNode)field));
                    }
                    ClassCodeVisitorSupport visitor = new ClassCodeVisitorSupport(){

                        public void visitClosureExpression(ClosureExpression expression) {
                        }

                        public void visitDeclarationExpression(DeclarationExpression expression) {
                            outlineElements.add(new GroovyScriptVariable((JavaElement)scriptType, expression));
                            super.visitDeclarationExpression(expression);
                        }
                    };
                    visitor.visitBlockStatement(module.getStatementBlock());
                }
                return GroovyScriptOCompilationUnit.sort(outlineElements.toArray(new IJavaElement[outlineElements.size()]));
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)"Encountered exception when calculating children", (Throwable)e);
                return new IJavaElement[]{new OType((IJavaElement)this.getUnit(), (ASTNode)module, scriptName + " -- Encountered exception.  See log.")};
            }
        }

        private static boolean isConstructor(IJavaElement scriptElem) throws JavaModelException {
            if (scriptElem.getElementType() != 9) {
                return false;
            }
            return ((IMethod)scriptElem).isConstructor();
        }

        private static boolean isMainMethod(IJavaElement scriptElem) throws JavaModelException {
            if (scriptElem.getElementType() != 9) {
                return false;
            }
            return ((IMethod)scriptElem).isMainMethod();
        }

        private static boolean isRunMethod(IJavaElement scriptElem) throws JavaModelException {
            if (scriptElem.getElementType() != 9) {
                return false;
            }
            if (!scriptElem.getElementName().equals("run")) {
                return false;
            }
            String[] parammeterTypes = ((IMethod)scriptElem).getParameterTypes();
            return parammeterTypes == null || parammeterTypes.length == 0;
        }

        private static IJavaElement[] sort(IJavaElement[] scriptElems) {
            Arrays.sort(scriptElems, (e1, e2) -> {
                try {
                    Assert.isTrue((boolean)(e1 instanceof ISourceReference), (String)("Expecting a ISourceReference, but found " + String.valueOf(e1)));
                    Assert.isTrue((boolean)(e2 instanceof ISourceReference), (String)("Expecting a ISourceReference, but found " + String.valueOf(e2)));
                    return ((ISourceReference)e1).getSourceRange().getOffset() - ((ISourceReference)e2).getSourceRange().getOffset();
                }
                catch (JavaModelException e) {
                    GroovyCore.logException((String)("Exception when comparing " + String.valueOf(e1) + " and " + String.valueOf(e2)), (Throwable)e);
                    return 0;
                }
            });
            return scriptElems;
        }
    }

    private static class GroovyScriptVariable
    extends OField {
        private String typeSignature;

        GroovyScriptVariable(JavaElement parent, DeclarationExpression node) {
            super(parent, (ASTNode)node, GroovyScriptVariable.extractName(node));
            ClassNode fieldType = node.getLeftExpression().getType();
            this.typeSignature = ClassHelper.isDynamicTyped((ClassNode)fieldType) ? "Qdef;" : GroovyUtils.getTypeSignature((ClassNode)fieldType, (boolean)true, (boolean)false);
        }

        private static String extractName(DeclarationExpression node) {
            Expression leftExpression = node.getLeftExpression();
            if (leftExpression instanceof VariableExpression) {
                return ((VariableExpression)leftExpression).getName();
            }
            if (leftExpression instanceof TupleExpression) {
                List exprs = ((TupleExpression)leftExpression).getExpressions();
                StringBuilder sb = new StringBuilder();
                Iterator exprIter = exprs.iterator();
                while (exprIter.hasNext()) {
                    Expression expr = (Expression)exprIter.next();
                    sb.append(expr.getText());
                    if (!exprIter.hasNext()) continue;
                    sb.append(", ");
                }
                return sb.toString();
            }
            return "no name";
        }

        @Override
        public ASTNode getElementNameNode() {
            DeclarationExpression decl = (DeclarationExpression)this.getNode();
            return decl.getLeftExpression();
        }

        public ISourceRange getSourceRange() throws JavaModelException {
            ISourceRange range = super.getSourceRange();
            if (range.getLength() < 1) {
                ASTNode lhs = this.getElementNameNode();
                range = new SourceRange(lhs.getStart(), lhs.getLength());
            }
            return range;
        }

        @Override
        public String getTypeSignature() {
            return this.typeSignature;
        }
    }
}

