/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.launchers;

import java.io.File;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.launchers.AbstractGroovyLaunchShortcut;
import org.codehaus.groovy.eclipse.launchers.LaunchShortcutHelper;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class GroovyScriptLaunchShortcut
extends AbstractGroovyLaunchShortcut {
    @Override
    public ILaunchConfigurationType getGroovyLaunchConfigType() {
        return GroovyScriptLaunchShortcut.getLaunchManager().getLaunchConfigurationType("org.codehaus.groovy.eclipse.groovyScriptLaunchConfiguration");
    }

    @Override
    protected String applicationOrConsole() {
        return "script";
    }

    @Override
    protected boolean canLaunchWithNoType() {
        return false;
    }

    @Override
    protected String mainArgs(IType runType, IJavaProject javaProject) {
        CompilerOptions compilerOptions = new CompilerOptions(javaProject.getOptions(true));
        StringBuilder mainArgs = new StringBuilder("groovy.ui.GroovyMain");
        if (compilerOptions.groovyCompilerConfigScript != null && !compilerOptions.groovyCompilerConfigScript.isEmpty() && (runType == null || javaProject.isOnClasspath((IJavaElement)runType) && !GroovyScriptLaunchShortcut.matchesScriptFilter(runType.getResource()))) {
            mainArgs.append(" --configscript \"${workspace_loc:").append(javaProject.getElementName()).append('}').append(File.separatorChar).append(compilerOptions.groovyCompilerConfigScript).append('\"');
        }
        if (compilerOptions.defaultEncoding != null && !compilerOptions.defaultEncoding.isEmpty()) {
            mainArgs.append(" --encoding ").append(compilerOptions.defaultEncoding);
        }
        if ((compilerOptions.groovyFlags & 2) != 0) {
            mainArgs.append(" --indy");
        }
        if (compilerOptions.produceMethodParameters) {
            mainArgs.append(" --parameters");
        }
        if (compilerOptions.enablePreviewFeatures) {
            mainArgs.append(" --enable-preview");
        }
        if (runType != null) {
            try {
                mainArgs.append(" \"${workspace_loc:").append(runType.getResource().getFullPath().toOSString().substring(1)).append("}\"");
            }
            catch (NullPointerException e) {
                GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_failureToLaunch, (Object)this.applicationOrConsole()), (Throwable)new IllegalArgumentException(LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_notFound, (Object)runType.getElementName())));
            }
        }
        return mainArgs.toString();
    }
}

