/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.decorators;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.ui.decorators.GroovyImageProvider;
import org.codehaus.groovy.eclipse.ui.decorators.GroovyPluginImages;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class GroovyImageDecorator
extends BaseLabelProvider
implements ILabelDecorator {
    private boolean preventRecursion;
    private ILabelDecorator defaultDecorator;
    private GroovyImageProvider baseImageProvider = new GroovyImageProvider();
    private Map<IProject, ScriptFolderSelector> scriptFolderSelectors = new HashMap<IProject, ScriptFolderSelector>();

    public void dispose() {
        this.baseImageProvider.disconnect();
    }

    private Image applyDefaultDecorator(Image image, Object element) {
        this.preventRecursion = true;
        try {
            if (this.defaultDecorator == null) {
                this.defaultDecorator = WorkbenchPlugin.getDefault().getDecoratorManager();
            }
            Image image2 = this.defaultDecorator.decorateImage(image, element);
            return image2;
        }
        finally {
            this.preventRecursion = false;
        }
    }

    public Image decorateImage(Image image, Object element) {
        if (this.preventRecursion) {
            return null;
        }
        if (element instanceof GroovyCompilationUnit) {
            return this.decorateImage((ImageDescriptor)new ImageImageDescriptor(image), ((GroovyCompilationUnit)element).getResource(), this.getImageSize(image));
        }
        boolean isGradle = false;
        if (element instanceof IFile && ContentTypeUtils.isGroovyLikeFileName((CharSequence)((IFile)element).getName()) && !(isGradle = ContentTypeUtils.isGradleLikeFileName((CharSequence)((IFile)element).getName()))) {
            return this.decorateImage((ImageDescriptor)new ImageImageDescriptor(image), (IResource)((IFile)element), this.getImageSize(image));
        }
        if (isGradle) {
            ImageDescriptor base = GroovyPluginImages.DESC_GRADLE_FILE != null ? GroovyPluginImages.DESC_GRADLE_FILE : GroovyPluginImages.DESC_GROOVY_FILE;
            return this.applyDefaultDecorator(this.getImage(base, 0, this.getImageSize(image)), element);
        }
        return null;
    }

    private Image decorateImage(ImageDescriptor base, IResource rsrc, Point size) {
        int flags = 0;
        if (!this.isExternalProject(rsrc.getProject())) {
            try {
                if (this.isGroovyProject(rsrc.getProject())) {
                    if (this.isRuntimeCompiled(rsrc)) {
                        flags |= 0x8000;
                    }
                } else {
                    flags |= 0x2000;
                }
            }
            catch (Exception e) {
                GroovyPlugin.getDefault().logError("Failed to apply image overlay(s) to: " + rsrc.getName(), e);
            }
        }
        return this.getImage(base, flags, size);
    }

    private Image getImage(ImageDescriptor base, int flags, Point size) {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(base, flags, size));
    }

    private Point getImageSize(Image image) {
        Point size = JavaElementImageProvider.SMALL_SIZE;
        if (image.getBounds().width > 16) {
            size = JavaElementImageProvider.BIG_SIZE;
        }
        return size;
    }

    private boolean isExternalProject(IProject project) {
        return project.getName().equals(" ");
    }

    private boolean isGroovyProject(IProject project) throws CoreException {
        return project.hasNature("org.eclipse.jdt.groovy.core.groovyNature");
    }

    private boolean isRuntimeCompiled(IResource resource) throws CoreException {
        return this.scriptFolderSelectors.computeIfAbsent(resource.getProject(), ScriptFolderSelector::new).isScript(resource);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public String decorateText(String text, Object element) {
        return null;
    }
}

