/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testobject.events.TestObjectUpdatedEvent;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestObjectHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object eventData = event.getProperty("org.eclipse.e4.data");
                if (eventData instanceof WebElementTreeEntity) {
                    WebElementTreeEntity webElementTreeEntity = (WebElementTreeEntity)eventData;
                    RenameTestObjectHandler.this.execute(webElementTreeEntity);
                }
            }
        });
    }

    private void execute(final WebElementTreeEntity webElementTreeEntity) {
        try {
            Object object = webElementTreeEntity.getObject();
            if (object instanceof WebElementEntity) {
                final WebElementEntity webElement = (WebElementEntity)object;
                List existingNames = FolderController.getInstance().getChildrenNames(webElement.getParentFolder());
                final String oldName = webElement.getName();
                RenameWizard renameWizard = new RenameWizard((ITreeEntity)webElementTreeEntity, existingNames);
                CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
                if (wizardDialog.open() == 0) {
                    final String newNameValue = renameWizard.getNewNameValue();
                    if (StringUtils.equals((String)newNameValue, (String)oldName)) {
                        return;
                    }
                    final String pk = webElement.getId();
                    final String oldIdForDisplay = webElement.getIdForDisplay();
                    new ProgressMonitorDialog(this.parentShell).run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                monitor.beginTask(ComposerObjectRepositoryMessageConstants.MSG_RENAMING_TEST_OBJECT, -1);
                                webElement.setName(newNameValue);
                                ObjectRepositoryController.getInstance().updateTestObject(webElement);
                                String newIdForDisplay = webElement.getIdForDisplay();
                                RenameTestObjectHandler.this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, newIdForDisplay});
                                RenameTestObjectHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)webElementTreeEntity.getParent());
                                RenameTestObjectHandler.this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new TestObjectUpdatedEvent(pk, (FileEntity)webElement, TestObjectUpdatedEvent.TriggeredBy.RENAME_TEST_OBJECT));
                                RenameTestObjectHandler.this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)webElementTreeEntity);
                                UISynchronizeService.asyncExec(() -> {
                                    boolean bl = RenameTestObjectHandler.this.partService.saveAll(false);
                                });
                                return;
                            }
                            catch (Exception ex) {
                                webElement.setName(oldName);
                                LoggerSingleton.logError((Throwable)ex);
                                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)RenameTestObjectHandler.this.parentShell, (String)GlobalMessageConstants.ERROR, (String)RenameTestObjectHandler.this.extractErrorMessage(ex)));
                                return;
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String extractErrorMessage(Exception e) {
        if (e instanceof FilePathTooLongException) {
            return e.getMessage();
        }
        return ComposerObjectRepositoryMessageConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_TEST_OBJECT;
    }
}

