/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.composer.objectrepository.constant.ImageConstants;
import com.kms.katalon.composer.objectrepository.part.UnusedTestObjectsPart;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class ShowUnusedTestObjectHandler {
    private static final String UNUSED_TEST_OBJECTS_PART_URI = "bundleclass://com.kms.katalon.composer.objectrepository/" + UnusedTestObjectsPart.class.getName();
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;

    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @Execute
    public void execute(Shell shell) throws IOException, InterruptedException {
        if (!this.featureController.canUse(ProductFeature.TEST_OBJECT_REFACTORING)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.TEST_OBJECT_REFACTORING);
            return;
        }
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
        final ArrayList<FileEntity> unusedTestObject = new ArrayList<FileEntity>();
        final ArrayList usedParentTestObject = new ArrayList();
        try {
            monitor.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                            FolderEntity folder = FolderController.getInstance().getObjectRepositoryRoot(project);
                            List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(folder);
                            monitor.beginTask(ComposerObjectRepositoryMessageConstants.DIA_TITLE_FIND_UNUSED_TEST_OBJECT, descendantEntities.size());
                            for (Object entity : descendantEntities) {
                                FileEntity element;
                                String testObjectId;
                                List affectedScripts;
                                if (entity instanceof WebElementEntity) {
                                    boolean isParent = false;
                                    FileEntity element2 = (FileEntity)entity;
                                    String testObjectId2 = element2.getIdForDisplay();
                                    String refElement = ((WebElementEntity)element2).getPropertyValue("ref_element");
                                    WebElementEntity webElementParent = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(refElement);
                                    isParent = descendantEntities.contains(webElementParent);
                                    List affectedScripts2 = TestArtifactScriptRefactor.createForTestObjectEntity((String)testObjectId2).findReferrersInScriptsAndVariables(project);
                                    if (affectedScripts2.isEmpty()) {
                                        unusedTestObject.add(element2);
                                    } else if (isParent) {
                                        usedParentTestObject.add(webElementParent);
                                        usedParentTestObject.addAll(ShowUnusedTestObjectHandler.this.findListParentWebElement(descendantEntities, webElementParent));
                                    }
                                } else if (entity instanceof WindowsElementEntity && (affectedScripts = TestArtifactScriptRefactor.createForWindowsObjectEntity((String)(testObjectId = (element = (FileEntity)entity).getIdForDisplay())).findReferrersInScriptsAndVariables(project)).isEmpty()) {
                                    unusedTestObject.add(element);
                                }
                                monitor.worked(1);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            if (StringUtils.isEmpty((String)exception.getMessage())) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)GlobalMessageConstants.ERROR, (String)ComposerObjectRepositoryMessageConstants.INVALID_TEST_OBECTS_RELATIONSHIP);
            }
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)GlobalMessageConstants.ERROR, (String)exception.getMessage());
        }
        for (Object entity : usedParentTestObject) {
            unusedTestObject.remove(entity);
        }
        this.openTab(unusedTestObject);
    }

    private void openTab(List<FileEntity> unusedTestObjects) {
        String partId = EntityPartUtil.getUnusedTestObjectsPartId();
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
        if (mPart == null) {
            mPart = (MPart)this.modelService.createModelElement(MPart.class);
            mPart.setElementId(partId);
            mPart.setLabel(ComposerObjectRepositoryMessageConstants.UNUSED_TEST_OBJECT_LABEL);
            mPart.setContributionURI(UNUSED_TEST_OBJECTS_PART_URI);
            mPart.setIconURI(ImageConstants.URL_16_UNUSED_TEST_OBJECT);
            mPart.setCloseable(true);
            mPart.getTags().add("removeOnHide");
            stack.getChildren().add(mPart);
        } else {
            this.eventBroker.post("UNUSED_TESTOBJECT/EXPORT", unusedTestObjects);
        }
        if (mPart.getObject() == null) {
            mPart.setObject(unusedTestObjects);
        }
        this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
        this.partService.bringToTop(mPart);
        stack.setSelectedElement((MUIElement)mPart);
        Trackings.trackOpenObject((String)"unusedTestObject", (Object[])new Object[0]);
    }

    private List<FileEntity> findListParentWebElement(List<Object> descendantEntities, WebElementEntity webElement) throws ControllerException {
        ArrayList<FileEntity> usedTestObject = new ArrayList<FileEntity>();
        String refElement = webElement.getPropertyValue("ref_element");
        WebElementEntity webElementParent = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(refElement);
        if (webElementParent != null) {
            usedTestObject.addAll(this.findListParentWebElement(descendantEntities, webElementParent));
            usedTestObject.add((FileEntity)webElementParent);
        }
        return usedTestObject;
    }
}

