/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.part;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.composer.objectrepository.constant.ImageConstants;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.testdata.reader.CsvWriter;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.entity.file.FileEntity;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.EventHandler;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class UnusedTestObjectsPart
extends CPart
implements EventHandler {
    private static final String[] FILTER_NAMES = new String[]{"Comma Separated Values Files (*.csv)"};
    private static final String[] FILTER_EXTS = new String[]{"*.csv"};
    private MPart mPart;
    private Composite testObjectComposite;
    private TableViewer tableViewer;
    private ToolItem toolItemDeleteAll;
    private ToolItem toolItemExportCSV;
    List<FileEntity> unusedTestObjects;
    @Inject
    private Shell shell;
    @Inject
    protected EPartService partService;
    @Inject
    protected MApplication application;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void createComposite(Composite parent, MPart part) {
        this.mPart = part;
        this.initialize(this.mPart, this.partService);
        this.eventBroker.subscribe("UNUSED_TESTOBJECT/EXPORT", (EventHandler)this);
        this.createTestObjectTable(parent);
        this.updateContent((List)this.mPart.getObject());
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        if (event.getTopic().equals("UNUSED_TESTOBJECT/EXPORT")) {
            try {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof List) {
                    this.updateContent((List)object);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void createTestObjectTable(Composite parent) {
        this.testObjectComposite = new Composite(parent, 0);
        this.testObjectComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout glCompositeTable = new GridLayout();
        glCompositeTable.marginWidth = 0;
        glCompositeTable.marginHeight = 0;
        this.testObjectComposite.setLayout((Layout)glCompositeTable);
        this.createTestObjectTableToolbar(this.testObjectComposite);
        this.createTestObjectTableDetails(this.testObjectComposite);
    }

    private void createTestObjectTableDetails(Composite parent) {
        Composite compositeTableDetails = new Composite(parent, 0);
        compositeTableDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glCompositeTableDetails = new GridLayout(1, false);
        glCompositeTableDetails.marginWidth = 0;
        glCompositeTableDetails.marginHeight = 0;
        compositeTableDetails.setLayout((Layout)glCompositeTableDetails);
        this.tableViewer = new TableViewer(compositeTableDetails, 67586);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        GridData gridDataTable = new GridData(4, 4, true, true, 3, 1);
        gridDataTable.minimumHeight = 150;
        table.setLayoutData((Object)gridDataTable);
        TableViewerColumn tableViewerColumnOrder = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnOrder = tableViewerColumnOrder.getColumn();
        tblclmnOrder.setText(GlobalMessageConstants.NO_);
        tblclmnOrder.setWidth(50);
        tableViewerColumnOrder.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(UnusedTestObjectsPart.this.unusedTestObjects.indexOf((FileEntity)element) + 1);
            }
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn trclmnColumnName = tableViewerColumnName.getColumn();
        trclmnColumnName.setText(GlobalMessageConstants.NAME);
        trclmnColumnName.setWidth(600);
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((FileEntity)element).getIdForDisplay();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(this.unusedTestObjects);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                UnusedTestObjectsPart.this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", element);
            }
        });
        this.tableViewer.getTable().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Table table = UnusedTestObjectsPart.this.tableViewer.getTable();
                Menu menu = table.getMenu();
                if (menu != null) {
                    menu.dispose();
                }
                menu = new Menu((Control)table);
                MenuItem openTestObjectMenuItem = new MenuItem(menu, 8);
                openTestObjectMenuItem.setText(ComposerObjectRepositoryMessageConstants.ADAP_MENU_CONTEXT_OPEN_TEST_OBJECT);
                openTestObjectMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IStructuredSelection selection = (IStructuredSelection)(this).UnusedTestObjectsPart.this.tableViewer.getSelection();
                        Object element = selection.getFirstElement();
                        (this).UnusedTestObjectsPart.this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", element);
                    }
                });
                table.setMenu(menu);
            }
        });
    }

    private void createTestObjectTableToolbar(Composite parent) {
        Composite compositeTableToolBar = new Composite(parent, 0);
        compositeTableToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeTableToolBar.setLayout((Layout)new FillLayout(256));
        ToolBar tableToolbar = new ToolBar(compositeTableToolBar, 0x820000);
        tableToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.toolItemDeleteAll = new ToolItem(tableToolbar, 0);
        this.toolItemDeleteAll.setText(ComposerObjectRepositoryMessageConstants.UNUSED_TEST_OBJECT_TOOLBAR_DELETE_ALL);
        this.toolItemDeleteAll.setToolTipText(ComposerObjectRepositoryMessageConstants.UNUSED_TEST_OBJECT_TOOLBAR_DELETE_ALL);
        this.toolItemDeleteAll.setImage(ImageConstants.IMG_16_REMOVE);
        this.toolItemDeleteAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)UnusedTestObjectsPart.this.shell, (String)GlobalMessageConstants.DELETE, (String)ComposerObjectRepositoryMessageConstants.DIA_UNUSED_TEST_OBJECT_DELETE_MESSAGE)) {
                    UnusedTestObjectsPart.this.deleteAll();
                }
            }
        });
        this.toolItemExportCSV = new ToolItem(tableToolbar, 0);
        this.toolItemExportCSV.setText(ComposerObjectRepositoryMessageConstants.UNUSED_TEST_OBJECT_TOOLBAR_EXPORT_CSV);
        this.toolItemExportCSV.setToolTipText(ComposerObjectRepositoryMessageConstants.UNUSED_TEST_OBJECT_TOOLBAR_EXPORT_CSV);
        this.toolItemExportCSV.setImage(ImageConstants.IMG_16_EXPORT_CSV);
        this.toolItemExportCSV.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnusedTestObjectsPart.this.exportCSV();
            }
        });
    }

    private void updateContent(List<FileEntity> content) {
        this.unusedTestObjects = content;
        this.tableViewer.setInput(this.unusedTestObjects);
    }

    private void deleteAll() {
        try {
            for (FileEntity element : this.unusedTestObjects) {
                EntityFileServiceManager.delete((FileEntity)element);
            }
            this.eventBroker.post("EXPLORER/REFRESH", null);
            this.updateContent(Collections.emptyList());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.shell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
        }
    }

    private void exportCSV() {
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        fileDialog.setText("Export");
        fileDialog.setFilterExtensions(FILTER_EXTS);
        fileDialog.setFilterNames(FILTER_NAMES);
        fileDialog.setFileName("Unused Test Objects.csv");
        String filePath = fileDialog.open();
        if (filePath == null) {
            return;
        }
        try {
            File exportedFile = new File(filePath);
            String[] headers = new String[]{GlobalMessageConstants.NO_, GlobalMessageConstants.NAME};
            ArrayList<String[]> datas = new ArrayList<String[]>();
            CellProcessor[] cellProcessor = new CellProcessor[]{new NotNull(), new NotNull()};
            int index = 1;
            this.unusedTestObjects.stream().map(element -> element.getIdForDisplay()).toArray();
            for (FileEntity element2 : this.unusedTestObjects) {
                datas.add(new String[]{String.valueOf(index++), element2.getIdForDisplay()});
            }
            CsvWriter.writeArraysToCsv((String[])headers, datas, (File)exportedFile, (CellProcessor[])cellProcessor);
            UISynchronizeService.syncExec(() -> {
                boolean bl = Program.launch((String)exportedFile.toURI().toString());
            });
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.shell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
        }
    }

    @PreDestroy
    public void onClose() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }
}

