/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassScope;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class GroovyTypeDeclaration
extends TypeDeclaration {
    private final ClassNode classNode;
    private GroovyTypeDeclaration[] anonymousTypes;
    private static final GroovyTypeDeclaration[] NO_TYPES = new GroovyTypeDeclaration[0];

    public GroovyTypeDeclaration(CompilationResult compilationResult, ClassNode classNode) {
        super(compilationResult);
        this.classNode = classNode;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public void parseMethods(Parser parser, CompilationUnitDeclaration unit) {
    }

    public boolean isScannerUsableOnThisDeclaration() {
        return false;
    }

    public ClassScope newClassScope(Scope outer) {
        return new GroovyClassScope(outer, this);
    }

    public void resolve() {
        int n;
        int n2;
        TypeDeclaration[] typeDeclarationArray;
        if (this.memberTypes != null) {
            typeDeclarationArray = this.memberTypes;
            n2 = this.memberTypes.length;
            n = 0;
            while (n < n2) {
                TypeDeclaration type = typeDeclarationArray[n];
                type.resolve(this.scope);
                ++n;
            }
        }
        if (this.methods != null) {
            typeDeclarationArray = this.methods;
            n2 = this.methods.length;
            n = 0;
            while (n < n2) {
                TypeDeclaration method = typeDeclarationArray[n];
                method.resolve(this.scope);
                if (method.isClinit()) {
                    method.resolveStatements();
                }
                ++n;
            }
        }
        if (this.fields != null) {
            typeDeclarationArray = this.fields;
            n2 = this.fields.length;
            n = 0;
            while (n < n2) {
                TypeDeclaration field = typeDeclarationArray[n];
                if (field instanceof Initializer) {
                    field.resolve(field.isStatic() ? this.staticInitializerScope : this.initializerScope);
                }
                ++n;
            }
        }
    }

    public GroovyTypeDeclaration[] getAnonymousTypes() {
        return this.anonymousTypes != null ? this.anonymousTypes : NO_TYPES;
    }

    public void addAnonymousType(GroovyTypeDeclaration anonymousType) {
        this.anonymousTypes = (GroovyTypeDeclaration[])ArrayUtils.add((Object[])this.getAnonymousTypes(), (Object)anonymousType);
    }
}

