/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.tools.GrapeUtil;
import org.codehaus.jdt.groovy.model.GrabDeclaration;
import org.codehaus.jdt.groovy.model.GrapesContainer;
import org.codehaus.jdt.groovy.model.GrapesContainerInfo;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.jdt.internal.core.JavaElement;

class GroovyCompilationUnitStructureRequestor
extends CompilationUnitStructureRequestor {
    protected GrapesContainer grapesContainer;
    protected GrapesContainerInfo grapesContainerInfo;

    protected GroovyCompilationUnitStructureRequestor(ICompilationUnit unit, CompilationUnitElementInfo unitInfo, Map elements) {
        super(unit, unitInfo, elements);
    }

    protected IAnnotation acceptAnnotation(Annotation annotation, AnnotatableInfo parentInfo, JavaElement parentHandle) {
        IAnnotation result;
        block19: {
            result = super.acceptAnnotation(annotation, parentInfo, parentHandle);
            if (!result.getElementName().endsWith("Grab")) break block19;
            String group = null;
            String module = null;
            String version = null;
            MemberValuePair[] memberValuePairArray = annotation.memberValuePairs();
            int n = memberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                MemberValuePair mvp = memberValuePairArray[n2];
                switch (String.valueOf(mvp.name)) {
                    case "value": {
                        String value = mvp.value.toString();
                        if (!value.contains(":") || value.contains("#")) break;
                        Map parts = GrapeUtil.getIvyParts((String)value.substring(1, value.length() - 1));
                        group = (String)parts.get("group");
                        module = (String)parts.get("module");
                        version = (String)parts.get("version");
                        break;
                    }
                    case "group": {
                        group = mvp.value.toString();
                        group = group.substring(1, group.length() - 1);
                        break;
                    }
                    case "module": {
                        module = mvp.value.toString();
                        module = module.substring(1, module.length() - 1);
                        break;
                    }
                    case "version": {
                        version = mvp.value.toString();
                        version = version.substring(1, version.length() - 1);
                    }
                }
                ++n2;
            }
            if (group != null && module != null && version != null) {
                if (this.grapesContainer == null) {
                    this.grapesContainer = new GrapesContainer(this.unit);
                    this.grapesContainerInfo = new GrapesContainerInfo();
                    this.newElements.put(this.grapesContainer, this.grapesContainerInfo);
                    this.addToChildren(this.unitInfo, (JavaElement)this.grapesContainer);
                }
                this.addToChildren((Object)this.grapesContainerInfo, (JavaElement)new GrabDeclaration(this.grapesContainer, annotation.sourceStart, annotation.sourceEnd, group, module, version));
            }
        }
        return result;
    }

    private void addToChildren(Object parentInfo, JavaElement handle) {
        List elements = this.children.computeIfAbsent(parentInfo, x -> new ArrayList());
        elements.add(handle);
    }

    public void exitCompilationUnit(int unitDeclarationEnd) {
        super.exitCompilationUnit(unitDeclarationEnd);
        if (this.grapesContainerInfo != null) {
            List elements = (List)this.children.get((Object)this.grapesContainerInfo);
            this.grapesContainerInfo.children = elements.toArray(new IJavaElement[elements.size()]);
        }
    }

    protected void setParser(SourceElementParser parser) {
        this.parser = parser;
    }
}

