/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jdt.groovy.core.util.CharArraySequence;
import org.eclipse.jdt.internal.core.util.Util;

public class ContentTypeUtils {
    private static Set<String> GROOVY_FILE_NAMES;
    private static char[][] GROOVY_LIKE_EXTENSIONS;
    private static char[][] GRADLE_LIKE_EXTENSIONS;
    private static char[][] JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS;
    private static final String GRADLE_SCRIPT_CONTENT_TYPE = "org.eclipse.jdt.groovy.core.gradleScript";
    private static final String GROOVY_SOURCE_CONTENT_TYPE = "org.eclipse.jdt.groovy.core.groovySource";
    private static boolean noGroovyContentTypesErrorLogged;

    static {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        if (contentTypeManager != null) {
            contentTypeManager.addContentTypeChangeListener(event -> {
                GROOVY_FILE_NAMES = null;
                GROOVY_LIKE_EXTENSIONS = null;
                GRADLE_LIKE_EXTENSIONS = null;
                JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS = null;
            });
        }
    }

    private ContentTypeUtils() {
    }

    public static char[][] getGradleLikeExtensions() {
        if (GRADLE_LIKE_EXTENSIONS == null) {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            if (contentTypeManager != null) {
                IContentType gradleContentType = contentTypeManager.getContentType(GRADLE_SCRIPT_CONTENT_TYPE);
                String[] gradleFileExtensions = gradleContentType.getFileSpecs(8);
                GRADLE_LIKE_EXTENSIONS = ContentTypeUtils.toCharArrayArray(Arrays.asList(gradleFileExtensions));
            } else {
                GRADLE_LIKE_EXTENSIONS = new char[][]{"gradle".toCharArray()};
            }
        }
        return GRADLE_LIKE_EXTENSIONS;
    }

    public static char[][] getGroovyLikeExtensions() {
        if (GROOVY_LIKE_EXTENSIONS == null) {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            if (contentTypeManager != null) {
                TreeSet<String> extensions = new TreeSet<String>((s1, s2) -> {
                    if (s1.equals("groovy")) {
                        return -1;
                    }
                    if (s2.equals("groovy")) {
                        return 1;
                    }
                    return s1.compareTo((String)s2);
                });
                IContentType groovyContentType = contentTypeManager.getContentType(GROOVY_SOURCE_CONTENT_TYPE);
                IContentType[] iContentTypeArray = contentTypeManager.getAllContentTypes();
                int n = iContentTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentType contentType = iContentTypeArray[n2];
                    if (contentType.isKindOf(groovyContentType)) {
                        String[] stringArray = contentType.getFileSpecs(8);
                        int n3 = stringArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String fileExtension = stringArray[n4];
                            extensions.add(fileExtension);
                            ++n4;
                        }
                    }
                    ++n2;
                }
                if (extensions.isEmpty()) {
                    if (!noGroovyContentTypesErrorLogged) {
                        noGroovyContentTypesErrorLogged = true;
                        Util.log((Throwable)new IllegalStateException("No Groovy Content Types found. This shouldn't happen. Is the workspace metadata corrupted?"));
                    }
                    return new char[][]{"groovy".toCharArray()};
                }
                GROOVY_LIKE_EXTENSIONS = ContentTypeUtils.toCharArrayArray(extensions);
            } else {
                GROOVY_LIKE_EXTENSIONS = new char[][]{"groovy".toCharArray()};
            }
        }
        return GROOVY_LIKE_EXTENSIONS;
    }

    public static char[][] getJavaButNotGroovyLikeExtensions() {
        if (JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS == null) {
            Object object;
            if (Platform.getContentTypeManager() != null) {
                object = Util.getJavaLikeExtensions();
            } else {
                char[][] cArrayArray = new char[1][];
                object = cArrayArray;
                cArrayArray[0] = "java".toCharArray();
            }
            char[][] javaLikeExtensions = object;
            char[][] groovyLikeExtensiosn = ContentTypeUtils.getGroovyLikeExtensions();
            ArrayList<char[]> interestingExtensions = new ArrayList<char[]>();
            char[][] cArray = javaLikeExtensions;
            int n = javaLikeExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                char[] javaLike = cArray[n2];
                boolean found = false;
                char[][] cArray2 = groovyLikeExtensiosn;
                int n3 = groovyLikeExtensiosn.length;
                int n4 = 0;
                while (n4 < n3) {
                    char[] groovyLike = cArray2[n4];
                    if (Arrays.equals(javaLike, groovyLike)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    interestingExtensions.add(javaLike);
                }
                ++n2;
            }
            JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS = (char[][])interestingExtensions.toArray((T[])new char[interestingExtensions.size()][]);
            char[] javaChars = "java".toCharArray();
            int javaIndex = 0;
            while (javaIndex < JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS.length) {
                if (Arrays.equals(javaChars, JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[javaIndex])) break;
                ++javaIndex;
            }
            if (javaIndex < JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS.length) {
                ContentTypeUtils.JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[javaIndex] = JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[0];
                ContentTypeUtils.JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[0] = javaChars;
            } else {
                Util.log(null, (String)"'java' not registered as a java-like extension");
            }
        }
        return JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS;
    }

    public static boolean isGradleLikeFileName(char[] fileName) {
        if (fileName != null && fileName.length > 0) {
            return ContentTypeUtils.isGradleLikeFileName(new CharArraySequence(fileName));
        }
        return false;
    }

    public static boolean isGradleLikeFileName(CharSequence fileName) {
        return fileName != null && fileName.length() > 0 && ContentTypeUtils.endsWithAny(fileName, ContentTypeUtils.getGradleLikeExtensions());
    }

    public static boolean isGroovyLikeFileName(char[] fileName) {
        if (fileName != null && fileName.length > 0) {
            return ContentTypeUtils.isGroovyLikeFileName(new CharArraySequence(fileName));
        }
        return false;
    }

    public static boolean isGroovyLikeFileName(CharSequence fileName) {
        if (fileName != null && fileName.length() > 0) {
            if (ContentTypeUtils.endsWithAny(fileName, ContentTypeUtils.getGroovyLikeExtensions())) {
                return true;
            }
            if (GROOVY_FILE_NAMES == null) {
                GROOVY_FILE_NAMES = ContentTypeUtils.loadGroovyFileNames();
            }
            fileName = fileName.subSequence(ContentTypeUtils.lastIndexOf(fileName, '/') + 1, fileName.length());
            return GROOVY_FILE_NAMES.contains(fileName.toString());
        }
        return false;
    }

    public static boolean isJavaLikeButNotGroovyLikeFileName(CharSequence fileName) {
        return fileName != null && fileName.length() > 0 && ContentTypeUtils.endsWithAny(fileName, ContentTypeUtils.getJavaButNotGroovyLikeExtensions());
    }

    private static Set<String> loadGroovyFileNames() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        if (contentTypeManager != null) {
            TreeSet<String> names = null;
            IContentType groovyContentType = contentTypeManager.getContentType(GROOVY_SOURCE_CONTENT_TYPE);
            IContentType[] iContentTypeArray = contentTypeManager.getAllContentTypes();
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType contentType = iContentTypeArray[n2];
                if (contentType.isKindOf(groovyContentType)) {
                    String[] stringArray = contentType.getFileSpecs(4);
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String fileName = stringArray[n4];
                        if (names == null) {
                            names = new TreeSet<String>();
                        }
                        names.add(fileName);
                        ++n4;
                    }
                }
                ++n2;
            }
            if (names != null) {
                return names;
            }
        }
        return Collections.emptySet();
    }

    private static boolean endsWithAny(CharSequence sequence, char[] ... extensions) {
        int length = sequence.length();
        char[][] cArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            char[] extension = cArray[n2];
            int offset = length - extension.length;
            if (offset >= 1 && sequence.charAt(offset - 1) == '.' && sequence.subSequence(offset, length).toString().equals(String.valueOf(extension))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int lastIndexOf(CharSequence sequence, char character) {
        int i = sequence.length() - 1;
        while (i >= 0) {
            if (sequence.charAt(i) == character) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static char[][] toCharArrayArray(Collection<String> strings) {
        int i = 0;
        int n = strings.size();
        char[][] arrays = new char[n][];
        for (String string : strings) {
            arrays[i++] = string.toCharArray();
        }
        return arrays;
    }
}

