/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.element.tree;

import com.kms.katalon.objectspy.element.HTMLRawElement;
import com.kms.katalon.objectspy.util.DOMUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.w3c.dom.NodeList;

public class HTMLRawElementTreeViewerFilter
extends ViewerFilter {
    private List<String> filteredElementsXpath;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof HTMLRawElement)) {
            return false;
        }
        if (this.filteredElementsXpath == null || this.filteredElementsXpath.isEmpty()) {
            return true;
        }
        String elementAbsoluteXpath = ((HTMLRawElement)element).getAbsoluteXpath();
        if (this.filteredElementsXpath.contains(elementAbsoluteXpath)) {
            return true;
        }
        boolean isChildSelected = false;
        for (HTMLRawElement childElement : ((HTMLRawElement)element).getChildElements()) {
            isChildSelected |= this.select(viewer, element, childElement);
        }
        return isChildSelected;
    }

    public void setFilteredElements(NodeList filteredElements) {
        if (this.filteredElementsXpath == null) {
            this.filteredElementsXpath = new ArrayList<String>();
        }
        this.filteredElementsXpath.clear();
        if (filteredElements != null) {
            int i = 0;
            while (i < filteredElements.getLength()) {
                this.filteredElementsXpath.add(DOMUtils.getXpathForNode(filteredElements.item(i)));
                ++i;
            }
        }
    }
}

