/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.objectspy.element.HTMLElement;
import com.kms.katalon.objectspy.element.HTMLFrameElement;
import com.kms.katalon.objectspy.element.HTMLPageElement;
import com.kms.katalon.objectspy.element.HTMLRawElement;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HTMLElementUtil {
    private static final String PAGE_ELEMENT_NAME_PREFIX = "Page_";
    private static final String ELEMENT_ATTRIBUTES_STYLE_KEY = "style";
    private static final int NAME_LENGTH_LIMIT = 30;
    public static final String PAGE_TITLE_KEY = "title";
    private static final String PAGE_URL_KEY = "url";
    private static final String ELEMENT_CHILDREN_KEY = "children";
    private static final String ELEMENT_PARENT_KEY = "parent";
    private static final String ELEMENT_PAGE_KEY = "page";
    private static final String ELEMENT_ATTRIBUTES_KEY = "attributes";
    private static final String ELEMENT_CONTENT_KEY = "content";
    private static final String ELEMENT_TEXT_KEY = "text";
    private static final String ELEMENT_ID_KEY = "id";
    private static final String ELEMENT_NAME_KEY = "name";
    private static final String ELEMENT_CLASS_KEY = "class";
    private static final String ELEMENT_TYPE_KEY = "type";
    private static final String ELEMENT_TAG_KEY = "tag";
    private static final String XPATH_KEY = "xpath";
    private static final Set<String> COMMON_ATTRIBUTES = new HashSet<String>();

    static {
        COMMON_ATTRIBUTES.add(ELEMENT_ID_KEY);
        COMMON_ATTRIBUTES.add(ELEMENT_NAME_KEY);
        COMMON_ATTRIBUTES.add("alt");
        COMMON_ATTRIBUTES.add("checked");
        COMMON_ATTRIBUTES.add("form");
        COMMON_ATTRIBUTES.add("href");
        COMMON_ATTRIBUTES.add("placeholder");
        COMMON_ATTRIBUTES.add("selected");
        COMMON_ATTRIBUTES.add("src");
        COMMON_ATTRIBUTES.add(PAGE_TITLE_KEY);
        COMMON_ATTRIBUTES.add(ELEMENT_TYPE_KEY);
        COMMON_ATTRIBUTES.add(ELEMENT_TEXT_KEY);
        COMMON_ATTRIBUTES.add("link_text");
    }

    public static String generateHTMLElementName(String elementType, Map<String, String> attributes) {
        String content = attributes.get(ELEMENT_TEXT_KEY);
        if (content != null) {
            return elementType + "_" + HTMLElementUtil.toValidFileName(content);
        }
        String name = attributes.get(ELEMENT_NAME_KEY);
        if (name != null) {
            return elementType + "_" + HTMLElementUtil.toValidFileName(name);
        }
        String id = attributes.get(ELEMENT_ID_KEY);
        if (id != null) {
            return elementType + "_" + HTMLElementUtil.toValidFileName(id);
        }
        String cssClass = attributes.get(ELEMENT_CLASS_KEY);
        if (cssClass != null) {
            return elementType + "_" + HTMLElementUtil.toValidFileName(cssClass);
        }
        return elementType;
    }

    public static String decodeURIComponent(String encodedString) throws UnsupportedEncodingException {
        return URLDecoder.decode(encodedString.replace("+", "%2B"), "UTF-8").replace("%2B", "+");
    }

    public static HTMLElement buildHTMLElement(String jsonString) throws Exception {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(HTMLElementUtil.decodeURIComponent(jsonString).trim());
        if (jsonElement instanceof JsonObject) {
            return HTMLElementUtil.buildHTMLElement((JsonObject)jsonElement, false);
        }
        return null;
    }

    public static HTMLElement buildHTMLElement(JsonObject elementJsonObject, boolean isFrame) throws UnsupportedEncodingException {
        if (elementJsonObject == null || !elementJsonObject.get(ELEMENT_TYPE_KEY).isJsonPrimitive()) {
            return null;
        }
        String elementType = elementJsonObject.getAsJsonPrimitive(ELEMENT_TYPE_KEY).getAsString();
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        HTMLElementUtil.collectElementContents(elementJsonObject, attributesMap);
        HTMLElementUtil.collectElementAttributes(elementJsonObject, attributesMap);
        String xpathString = HTMLElementUtil.getElementXpath(elementJsonObject);
        if (xpathString != null) {
            attributesMap.put(XPATH_KEY, xpathString);
        }
        HTMLFrameElement parentElement = HTMLElementUtil.getParentElement(elementJsonObject);
        String newName = HTMLElementUtil.generateHTMLElementName(elementType, attributesMap);
        if (newName.length() > 30) {
            newName = newName.substring(0, 30);
        }
        if (isFrame) {
            return new HTMLFrameElement(newName, elementType, attributesMap, parentElement, new ArrayList<HTMLElement>());
        }
        return new HTMLElement(newName, elementType, attributesMap, parentElement);
    }

    public static String toValidFileName(String fileName) {
        return fileName.trim().replaceAll("[^A-Za-z-0-9_().\\- ]", "");
    }

    private static HTMLFrameElement getParentElement(JsonObject elementJsonObject) throws UnsupportedEncodingException {
        HTMLFrameElement parentElement = null;
        if (elementJsonObject.has(ELEMENT_PARENT_KEY) && elementJsonObject.get(ELEMENT_PARENT_KEY).isJsonObject()) {
            HTMLElement tempParentElement = HTMLElementUtil.buildHTMLElement(elementJsonObject.getAsJsonObject(ELEMENT_PARENT_KEY), true);
            if (tempParentElement instanceof HTMLFrameElement) {
                parentElement = (HTMLFrameElement)tempParentElement;
            }
        } else {
            parentElement = HTMLElementUtil.buildHTMLPageElement(elementJsonObject.getAsJsonObject(ELEMENT_PAGE_KEY));
        }
        return parentElement;
    }

    private static String getElementXpath(JsonObject elementJsonObject) {
        if (elementJsonObject.has(XPATH_KEY) && elementJsonObject.get(XPATH_KEY).isJsonPrimitive()) {
            return elementJsonObject.getAsJsonPrimitive(XPATH_KEY).getAsString();
        }
        return null;
    }

    private static void collectElementAttributes(JsonObject elementJsonObject, Map<String, String> attributesMap) {
        if (!HTMLElementUtil.isElementAttributesSet(elementJsonObject)) {
            return;
        }
        for (Map.Entry entry : elementJsonObject.getAsJsonObject(ELEMENT_ATTRIBUTES_KEY).entrySet()) {
            if (!HTMLElementUtil.isValidElementAttribute(entry)) continue;
            attributesMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }

    private static boolean isElementAttributesSet(JsonObject elementJsonObject) {
        return elementJsonObject.has(ELEMENT_ATTRIBUTES_KEY) && elementJsonObject.get(ELEMENT_ATTRIBUTES_KEY).isJsonObject();
    }

    private static boolean isValidElementAttribute(Map.Entry<String, JsonElement> attributeEntry) {
        return attributeEntry.getValue() != null && !StringUtils.isBlank((String)attributeEntry.getValue().getAsString()) && !attributeEntry.getKey().equals(ELEMENT_ATTRIBUTES_STYLE_KEY);
    }

    private static void collectElementContents(JsonObject elementJsonObject, Map<String, String> attributesMap) {
        if (!HTMLElementUtil.isElementContent(elementJsonObject)) {
            return;
        }
        JsonArray contentArray = elementJsonObject.getAsJsonArray(ELEMENT_CONTENT_KEY);
        if (!HTMLElementUtil.isValidElementContent(contentArray)) {
            return;
        }
        attributesMap.put(ELEMENT_TEXT_KEY, contentArray.get(0).getAsString());
    }

    private static boolean isElementContent(JsonObject elementJsonObject) {
        return elementJsonObject.has(ELEMENT_CONTENT_KEY) && elementJsonObject.get(ELEMENT_CONTENT_KEY).isJsonArray();
    }

    private static boolean isValidElementContent(JsonArray contentArray) {
        return contentArray != null && contentArray.size() == 1 && contentArray.get(0).isJsonPrimitive() && !StringUtils.isBlank((String)contentArray.get(0).getAsString());
    }

    private static HTMLPageElement buildHTMLPageElement(JsonObject parentPageJsonObject) {
        if (parentPageJsonObject == null) {
            return null;
        }
        String pageUrlString = parentPageJsonObject.getAsJsonPrimitive(PAGE_URL_KEY).getAsString();
        String pageTitleString = parentPageJsonObject.getAsJsonPrimitive(PAGE_TITLE_KEY).getAsString();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put(PAGE_URL_KEY, pageUrlString);
        attributeMap.put(PAGE_TITLE_KEY, pageTitleString);
        return new HTMLPageElement(HTMLElementUtil.generateHTMLPageElementName(pageTitleString), attributeMap, new ArrayList<HTMLElement>(), pageUrlString);
    }

    private static String generateHTMLPageElementName(String pageTitleString) {
        return PAGE_ELEMENT_NAME_PREFIX + StringUtils.substring((String)HTMLElementUtil.toValidFileName(pageTitleString), (int)0, (int)30);
    }

    public static WebElementEntity convertElementToWebElementEntity(HTMLElement element, WebElementEntity refElement, FolderEntity parentFolder) throws Exception {
        WebElementEntity newWebElement = new WebElementEntity();
        newWebElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(parentFolder, HTMLElementUtil.toValidFileName(StringUtils.trim((String)element.getName()))));
        newWebElement.setParentFolder(parentFolder);
        newWebElement.setElementGuidId(Util.generateGuid());
        newWebElement.setProject(parentFolder.getProject());
        newWebElement.setWebElementProperties(new ArrayList());
        List webElementProperties = newWebElement.getWebElementProperties();
        webElementProperties.add(new WebElementPropertyEntity(ELEMENT_TAG_KEY, element.getType()));
        boolean haveCommonAttribute = false;
        WebElementPropertyEntity xpathProperty = null;
        for (Map.Entry<String, String> entry : element.getAttributes().entrySet()) {
            WebElementPropertyEntity webElementPropertyEntity = new WebElementPropertyEntity();
            String propertyKey = entry.getKey();
            webElementPropertyEntity.setName(propertyKey);
            webElementPropertyEntity.setValue(entry.getValue());
            webElementProperties.add(webElementPropertyEntity);
            if (propertyKey.equals(XPATH_KEY)) {
                xpathProperty = webElementPropertyEntity;
            }
            if (!COMMON_ATTRIBUTES.contains(propertyKey)) continue;
            haveCommonAttribute = true;
            webElementPropertyEntity.setIsSelected(Boolean.valueOf(true));
            String value = webElementPropertyEntity.getValue();
            if (!ELEMENT_TEXT_KEY.equals(propertyKey) || !StringUtils.isNotEmpty((String)value)) continue;
            webElementPropertyEntity.setMatchCondition(WebElementPropertyEntity.MATCH_CONDITION.CONTAINS.getText());
            webElementPropertyEntity.setValue(value.trim());
        }
        if (!haveCommonAttribute && xpathProperty != null) {
            xpathProperty.setIsSelected(Boolean.valueOf(true));
        }
        if (refElement != null) {
            WebElementPropertyEntity webElementPropertyEntity = new WebElementPropertyEntity();
            webElementPropertyEntity.setName("ref_element");
            webElementPropertyEntity.setValue(refElement.getIdForDisplay());
            webElementPropertyEntity.setIsSelected(Boolean.valueOf(true));
            webElementProperties.add(webElementPropertyEntity);
        }
        return newWebElement;
    }

    public static FolderEntity convertPageElementToFolderEntity(HTMLPageElement pageElement, FolderEntity parentFolder) throws Exception {
        FolderEntity newFolder = new FolderEntity();
        newFolder.setName(HTMLElementUtil.toValidFileName(StringUtils.trim((String)pageElement.getName())));
        newFolder.setParentFolder(parentFolder);
        newFolder.setDescription("folder");
        newFolder.setFolderType(parentFolder.getFolderType());
        newFolder.setProject(parentFolder.getProject());
        return newFolder;
    }

    public static HTMLPageElement generateNewPageElement() {
        long currentTime = System.currentTimeMillis();
        String title = String.valueOf(currentTime);
        String url = PAGE_URL_KEY + currentTime + ".com";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(PAGE_TITLE_KEY, title);
        attributes.put(PAGE_URL_KEY, url);
        return new HTMLPageElement(PAGE_ELEMENT_NAME_PREFIX + currentTime, attributes, new ArrayList<HTMLElement>(), url);
    }

    public static HTMLFrameElement generateNewFrameElement(HTMLFrameElement parentElement) {
        long currentTime = System.currentTimeMillis();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(XPATH_KEY, XPATH_KEY + currentTime);
        return new HTMLFrameElement("Frame_" + currentTime, "IFRAME", attributes, parentElement, new ArrayList<HTMLElement>());
    }

    public static HTMLElement generateNewElement(HTMLFrameElement parentElement) {
        long currentTime = System.currentTimeMillis();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(XPATH_KEY, XPATH_KEY + currentTime);
        return new HTMLElement("Element_" + currentTime, "DIV", attributes, parentElement);
    }

    public static HTMLRawElement buildHTMLRawElement(Document document, String jsonString) throws Exception {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(HTMLElementUtil.decodeURIComponent(jsonString).trim());
        if (jsonElement instanceof JsonObject) {
            HTMLRawElement rootElement = HTMLElementUtil.buildHTMLRawElement(document, 1, null, (JsonObject)jsonElement);
            document.appendChild(rootElement.getDomElement());
            return rootElement;
        }
        return null;
    }

    public static HTMLRawElement buildHTMLRawElement(Document document, int index, HTMLRawElement parentElement, JsonObject elementJsonObject) throws Exception {
        if (elementJsonObject != null) {
            String elementType = null;
            ArrayList<HTMLRawElement> childrenElements = new ArrayList<HTMLRawElement>();
            JsonPrimitive elementTypeObject = elementJsonObject.getAsJsonPrimitive(ELEMENT_TYPE_KEY);
            if (elementTypeObject == null) {
                return null;
            }
            elementType = elementTypeObject.getAsString();
            Element element = null;
            try {
                element = document.createElement(elementType);
            }
            catch (DOMException dOMException) {
                return null;
            }
            JsonObject elementAttributesObject = elementJsonObject.getAsJsonObject(ELEMENT_ATTRIBUTES_KEY);
            if (elementAttributesObject != null) {
                Set entrySet = elementAttributesObject.entrySet();
                for (Map.Entry entry : entrySet) {
                    if (entry.getValue() == null || ((String)entry.getKey()).equals(ELEMENT_ATTRIBUTES_STYLE_KEY)) continue;
                    element.setAttribute((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString().trim());
                    if (((String)entry.getKey()).equals(ELEMENT_TEXT_KEY)) {
                        element.setTextContent(((JsonElement)entry.getValue()).getAsString().trim());
                        continue;
                    }
                    if (!((String)entry.getKey()).equals(ELEMENT_ID_KEY)) continue;
                    element.setIdAttribute(ELEMENT_ID_KEY, true);
                }
            }
            String xpathString = elementJsonObject.getAsJsonPrimitive(XPATH_KEY).getAsString();
            HTMLRawElement htmlRawElement = new HTMLRawElement(element, index, parentElement, xpathString, childrenElements);
            int count = 0;
            JsonElement childrenArrayObject = elementJsonObject.get(ELEMENT_CHILDREN_KEY);
            if (childrenArrayObject != null && childrenArrayObject.isJsonArray()) {
                JsonArray childrenArray = childrenArrayObject.getAsJsonArray();
                int i = 0;
                while (i < childrenArray.size()) {
                    HTMLRawElement htmlChildElement = HTMLElementUtil.buildHTMLRawElement(document, count + 1, htmlRawElement, childrenArray.get(i).getAsJsonObject());
                    if (htmlChildElement != null) {
                        childrenElements.add(htmlChildElement);
                        element.appendChild(htmlChildElement.getDomElement());
                        ++count;
                    }
                    ++i;
                }
            }
            return htmlRawElement;
        }
        return null;
    }

    public static String buildXpathForHTMLElement(HTMLElement element) {
        if (element != null && element.getParentElement() instanceof HTMLFrameElement) {
            if (element.getXpath().startsWith("/")) {
                return HTMLElementUtil.buildXpathForHTMLElement(element.getParentElement()) + element.getXpath();
            }
            return element.getXpath();
        }
        return "";
    }

    public static List<HTMLPageElement> createHTMLElementFromFolder(FolderEntity folder, Map<String, HTMLElement> elementsMap) {
        ArrayList<HTMLPageElement> pageElements = new ArrayList<HTMLPageElement>();
        if (folder != null) {
            if (elementsMap.get(folder.getId()) != null) {
                pageElements.add((HTMLPageElement)elementsMap.get(folder.getId()));
                return pageElements;
            }
            HTMLPageElement pageElement = HTMLElementUtil.generateNewPageElement();
            pageElement.setName(folder.getName());
            elementsMap.put(folder.getId(), pageElement);
            pageElements.add(pageElement);
            try {
                for (FileEntity entity : FolderController.getInstance().getChildren(folder)) {
                    if (entity instanceof WebElementEntity) {
                        HTMLElementUtil.createHTMLElementFromWebElement((WebElementEntity)entity, false, pageElement, elementsMap);
                        continue;
                    }
                    if (!(entity instanceof FolderEntity)) continue;
                    List<HTMLPageElement> childPageElements = HTMLElementUtil.createHTMLElementFromFolder((FolderEntity)entity, elementsMap);
                    pageElements.addAll(childPageElements);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return pageElements;
    }

    public static HTMLElement createHTMLElementFromWebElement(WebElementEntity webElement, boolean isFrame, HTMLPageElement pageElement, Map<String, HTMLElement> elementsMap) {
        if (webElement != null) {
            if (elementsMap.get(webElement.getId()) != null) {
                if (isFrame && !(elementsMap.get(webElement.getId()) instanceof HTMLFrameElement)) {
                    HTMLElement htmlElement = elementsMap.get(webElement.getId());
                    elementsMap.remove(webElement.getId());
                    HTMLFrameElement parentElementOfFrame = htmlElement.getParentElement();
                    parentElementOfFrame.getChildElements().remove(htmlElement);
                    HTMLFrameElement replacedElement = new HTMLFrameElement(htmlElement.getName(), htmlElement.getType(), htmlElement.getAttributes(), parentElementOfFrame, new ArrayList<HTMLElement>());
                    elementsMap.put(webElement.getId(), replacedElement);
                    return replacedElement;
                }
                return elementsMap.get(webElement.getId());
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            HTMLFrameElement parentFrameElement = null;
            for (WebElementPropertyEntity property : webElement.getWebElementProperties()) {
                if (!property.getMatchCondition().equals(WebElementPropertyEntity.MATCH_CONDITION.EQUAL.toString())) continue;
                if (property.getName().equals("ref_element")) {
                    try {
                        parentFrameElement = (HTMLFrameElement)HTMLElementUtil.createHTMLElementFromWebElement(ObjectRepositoryController.getInstance().getWebElementByDisplayPk(property.getValue()), true, pageElement, elementsMap);
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                    continue;
                }
                attributes.put(property.getName(), property.getValue());
            }
            HTMLElement element = null;
            String type = StringUtils.defaultString((String)webElement.getPropertyValue(ELEMENT_TAG_KEY));
            element = isFrame ? new HTMLFrameElement(webElement.getName(), type, attributes, parentFrameElement != null ? parentFrameElement : pageElement, new ArrayList<HTMLElement>()) : new HTMLElement(webElement.getName(), type, attributes, parentFrameElement != null ? parentFrameElement : pageElement);
            elementsMap.put(webElement.getId(), element);
            return element;
        }
        return null;
    }
}

