/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.part.job;

import com.katalon.platform.api.event.ExecutionEvent;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MissingMobileDriverWarningDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.launcher.IDETestSuiteCollectionLauncher;
import com.kms.katalon.composer.execution.launcher.SubIDELauncher;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.windows.driver.FlaUIDriverManager;
import com.kms.katalon.core.windows.driver.WindowsDriverType;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.TestSuiteRunConfigurationBuilder;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.entity.DefaultReportSetting;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutionEvent;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.TestSuiteCollectionLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestSuiteCollectionBuilderJob
extends Job {
    @Inject
    private IEclipseContext context;
    private TestSuiteCollectionEntity testSuiteCollectionEntity;

    public TestSuiteCollectionBuilderJob(TestSuiteCollectionEntity testSuiteCollectionEntity) {
        super(ComposerTestsuiteCollectionMessageConstants.JOB_TITLE_TEST_SUITE_COLLECTION_BUILDER);
        this.testSuiteCollectionEntity = testSuiteCollectionEntity;
    }

    protected IStatus run(IProgressMonitor monitor) {
        UISynchronizeService.syncExec(() -> this.safeProcessToRun(monitor));
        return Status.OK_STATUS;
    }

    protected IStatus safeProcessToRun(IProgressMonitor monitor) {
        try {
            int totalSize = this.testSuiteCollectionEntity.getTestSuiteRunConfigurations().size() + 1;
            monitor.beginTask(ComposerTestsuiteCollectionMessageConstants.JOB_TASK_BUILDING_TEST_SUITE_COLLECTION, totalSize);
            TestSuiteCollectionExecutedEntity executedEntity = new TestSuiteCollectionExecutedEntity(this.testSuiteCollectionEntity);
            executedEntity.setReportable((Reportable)new DefaultReportSetting());
            ProjectEntity project = this.testSuiteCollectionEntity.getProject();
            ReportController reportController = ReportController.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String executionSessionId = dateFormat.format(new Date());
            ReportCollectionEntity reportCollection = reportController.newReportCollection(project, this.testSuiteCollectionEntity, executionSessionId, executedEntity.getId());
            ArrayList<SubIDELauncher> tsLaunchers = new ArrayList<SubIDELauncher>();
            boolean cancelInstallWebDriver = false;
            Map variables = EmailVariableBinding.getVariablesForTestSuiteCollectionEmailSettings((TestSuiteCollectionEntity)this.testSuiteCollectionEntity);
            MailUtil.overrideEmailSettings((EmailConfig)executedEntity.getEmailConfig(project), (ExecutionProfileEntity)GlobalVariableController.getInstance().getDefaultExecutionProfile(project), (Map)variables);
            for (TestSuiteRunConfiguration tsRunConfig : this.testSuiteCollectionEntity.getTestSuiteRunConfigurations()) {
                if (!cancelInstallWebDriver) {
                    cancelInstallWebDriver = !this.checkInstallWebDriver(tsRunConfig);
                }
                monitor.subTask(MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.JOB_TASK_BUILDING_LAUNCHER, tsRunConfig.getTestSuiteEntity().getIdForDisplay()));
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (!tsRunConfig.isRunEnabled()) continue;
                String tscId = ExecutionUtil.getTestSuiteCollectionId((String)this.testSuiteCollectionEntity.getId());
                SubIDELauncher subLauncher = this.buildLauncher(tsRunConfig, reportCollection, executionSessionId, tscId);
                if (subLauncher == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)subLauncher.getRunConfig().getExecutionSetting().getExecutedEntity();
                if (tsExecutedEntity.getTotalTestCases() == 0) {
                    this.openWarningDialogForEmptyTestSuite(tsExecutedEntity);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                Map tsVariables = EmailVariableBinding.getVariablesForTestSuiteEmailSettings((TestSuiteEntity)((TestSuiteEntity)tsExecutedEntity.getEntity()));
                MailUtil.overrideEmailSettings((EmailConfig)tsExecutedEntity.getEmailConfig(project), (ExecutionProfileEntity)((ExecutionProfileEntity)subLauncher.getRunConfig().getExecutionProfile()), (Map)tsVariables);
                executedEntity.addTestSuiteExecutedEntity(tsExecutedEntity);
                tsLaunchers.add(subLauncher);
            }
            LauncherManager launcherManager = LauncherManager.getInstance();
            IDETestSuiteCollectionLauncher launcher = new IDETestSuiteCollectionLauncher(executedEntity, launcherManager, tsLaunchers, this.testSuiteCollectionEntity.getExecutionMode(), reportCollection);
            ContextInjectionFactory.inject((Object)launcher, (IEclipseContext)this.context);
            this.registerToTerminateDriverAfterEachTestSuite((TestSuiteCollectionLauncher)launcher);
            launcherManager.addLauncher((ILauncher)launcher);
            reportController.updateReportCollection(reportCollection);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (ControllerException | DALException e) {
            LoggerSingleton.logError((Throwable)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void registerToTerminateDriverAfterEachTestSuite(TestSuiteCollectionLauncher launcher) {
        final HashMap<String, IRunConfiguration> testSuiteSourceIdsNeedToTerminateDriverAfterRun = new HashMap<String, IRunConfiguration>();
        final HashSet<String> testSuiteSourceIds = new HashSet<String>();
        for (ReportableLauncher reportableLauncher : launcher.getSubLaunchers()) {
            IRunConfiguration runConfig = reportableLauncher.getRunConfig();
            String testSuiteSourceId = reportableLauncher.buildTestSuiteExecutionContext().getSourceId();
            if (runConfig.shouldTerminateDriverAfterTestSuite()) {
                testSuiteSourceIdsNeedToTerminateDriverAfterRun.put(testSuiteSourceId, runConfig);
            }
            testSuiteSourceIds.add(testSuiteSourceId);
        }
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("EXECUTE/EXECUTE_TEST_SUITE_ENDED", new EventHandler(){

            public void handleEvent(Event event) {
                ExecutionEvent eventObject = (ExecutionEvent)event.getProperty("org.eclipse.e4.data");
                TestSuiteExecutionEvent testSuiteExecutionEvent = (TestSuiteExecutionEvent)eventObject;
                String testSuiteSourceId = testSuiteExecutionEvent.getExecutionContext().getSourceId();
                IRunConfiguration runConfig = (IRunConfiguration)testSuiteSourceIdsNeedToTerminateDriverAfterRun.get(testSuiteSourceId);
                boolean isWindowTestSuite = runConfig.getDriverConnectors().values().stream().anyMatch(connector -> WindowsDriverType.getInstance().equals(connector.getDriverType()));
                if (isWindowTestSuite) {
                    FlaUIDriverManager.getInstance().stopLocalServer();
                }
                testSuiteSourceIds.remove(testSuiteSourceId);
                if (testSuiteSourceIds.isEmpty()) {
                    LoggerSingleton.logDebug((String)"TSC: unsubscribe from event 'EXECUTE_TEST_SUITE_ENDED'");
                    EventBrokerSingleton.getInstance().getEventBroker().unsubscribe((EventHandler)this);
                }
            }
        });
    }

    private boolean checkInstallWebDriver(TestSuiteRunConfiguration tsRunConfig) {
        return true;
    }

    private void openWarningDialogForEmptyTestSuite(final TestSuiteExecutedEntity tsExecutedEntity) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)GlobalStringConstants.WARN, (String)MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.JOB_MSG_EMPTY_TEST_SUITE, tsExecutedEntity.getSourceId()));
            }
        });
    }

    private SubIDELauncher buildLauncher(final TestSuiteRunConfiguration tsRunConfig, ReportCollectionEntity reportCollection, String executionSessionId, String testSuiteCollectionId) {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        try {
            RunConfigurationDescription configuration = tsRunConfig.getConfiguration();
            IRunConfigurationContributor runConfigContributor = RunConfigurationCollector.getInstance().getRunContributor(configuration.getRunConfigurationId());
            LauncherManager launcherManager = LauncherManager.getInstance();
            TestSuiteRunConfigurationBuilder runConfigBuilder = new TestSuiteRunConfigurationBuilder().withRunConfigDescription(configuration).withBrowserType(configuration.getRunConfigurationId()).withProjectDir(projectDir).withContributor(runConfigContributor).withTestSuiteEntity(tsRunConfig.getTestSuiteEntity()).withFailedThreshold(launcherManager.getFailedThreshold()).withExecutionSessionId(executionSessionId);
            AbstractRunConfiguration runConfig = (AbstractRunConfiguration)runConfigBuilder.build();
            SubIDELauncher launcher = new SubIDELauncher((IRunConfiguration)runConfig, LaunchMode.RUN, configuration);
            launcher.configureToLazilyRebuildRunConfigDriverConnector(runConfigContributor, projectDir, configuration);
            RunConfigurationDescription clonedConfiguration = (RunConfigurationDescription)configuration.clone();
            clonedConfiguration = this.removeSensitiveDataFromTestCloud(clonedConfiguration);
            reportCollection.getReportItemDescriptions().add(ReportItemDescription.from((String)launcher.getReportEntity().getIdForDisplay(), (RunConfigurationDescription)clonedConfiguration));
            return launcher;
        }
        catch (MobileSetupException e) {
            UISynchronizeService.syncExec(() -> MissingMobileDriverWarningDialog.showWarning((Shell)Display.getCurrent().getActiveShell(), (String)e.getMessage()));
            return null;
        }
        catch (Exception e) {
            UISynchronizeService.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.JOB_MSG_UNABLE_TO_EXECUTE_TEST_SUITE, tsRunConfig.getTestSuiteEntity().getIdForDisplay()), (String)e.getMessage());
                }
            });
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private RunConfigurationDescription removeSensitiveDataFromTestCloud(RunConfigurationDescription configuration) {
        if (TestCloudPropertyUtil.getInstance().isRunFromTestCloud()) {
            TestCloudPropertyUtil.getInstance().hideConfigurationData(configuration.getRunConfigurationData());
        }
        return configuration;
    }
}

