/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.part.support;

import com.kms.katalon.composer.components.dialogs.AbstractDialogCellEditor;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.execution.collection.dialog.ExecutionProfileSelectionDialog;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.composer.testsuite.collection.part.provider.TableViewerProvider;
import com.kms.katalon.composer.testsuite.collection.part.support.EditingSupportWithTableProvider;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExecutionProfileEditingSupport
extends EditingSupportWithTableProvider {
    public ExecutionProfileEditingSupport(TableViewerProvider provider) {
        super(provider);
    }

    protected CellEditor getCellEditorByElement(TestSuiteRunConfiguration element) {
        return new ExectionProfileDialogCellEditor(this.getComposite(), element.getConfiguration().getProfileName());
    }

    protected boolean canEditElement(TestSuiteRunConfiguration element) {
        return true;
    }

    protected Object getElementValue(TestSuiteRunConfiguration element) {
        return element.getConfiguration().getProfileName();
    }

    protected void setElementValue(TestSuiteRunConfiguration element, Object profileName) {
        RunConfigurationDescription configuration = element.getConfiguration();
        if (!configuration.getProfileName().equals(profileName)) {
            configuration.setProfileName((String)profileName);
            this.refreshElementAndMarkDirty(element);
        }
    }

    private class ExectionProfileDialogCellEditor
    extends AbstractDialogCellEditor {
        private String profileName;

        protected ExectionProfileDialogCellEditor(Composite parent, String profileName) {
            super(parent);
            this.profileName = profileName;
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            try {
                List profiles = GlobalVariableController.getInstance().getAllGlobalVariableCollections(ProjectController.getInstance().getCurrentProject());
                ExecutionProfileEntity selectedProfile = profiles.stream().filter(p -> p.getName().equals(this.profileName)).findFirst().get();
                ExecutionProfileSelectionDialog dialog = new ExecutionProfileSelectionDialog(this.getParentShell(), profiles, selectedProfile);
                if (dialog.open() != 0) {
                    return this.profileName;
                }
                return dialog.getSelectedProfile().getName();
            }
            catch (ControllerException e) {
                MultiStatusErrorDialog.showErrorDialog((String)ComposerTestsuiteCollectionMessageConstants.PA_MSG_UNABLE_TO_SELECT_EXECUTION_PROFILES, (String)e.getMessage(), (String)ExceptionsUtil.getMessageForThrowable((Throwable)e));
                return this.profileName;
            }
        }
    }
}

