/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.GroovyClassLoader;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.apache.groovy.util.Maps;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.tools.GroovyClass;
import org.codehaus.groovy.transform.stc.ExtensionMethodCache;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.TypeCheckingContext;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;
import org.codehaus.groovy.transform.trait.Traits;

public abstract class StaticTypeCheckingSupport {
    protected static final ClassNode Matcher_TYPE = ClassHelper.makeWithoutCaching(Matcher.class);
    protected static final ClassNode ArrayList_TYPE = ClassHelper.makeWithoutCaching(ArrayList.class);
    protected static final ClassNode Collection_TYPE = ClassHelper.makeWithoutCaching(Collection.class);
    protected static final ClassNode Deprecated_TYPE = ClassHelper.makeWithoutCaching(Deprecated.class);
    protected static final ClassNode LinkedHashMap_TYPE = ClassHelper.makeWithoutCaching(LinkedHashMap.class);
    protected static final ClassNode LinkedHashSet_TYPE = ClassHelper.makeWithoutCaching(LinkedHashSet.class);
    protected static final Map<ClassNode, Integer> NUMBER_TYPES = Maps.of((Object)ClassHelper.byte_TYPE, (Object)0, (Object)ClassHelper.Byte_TYPE, (Object)0, (Object)ClassHelper.short_TYPE, (Object)1, (Object)ClassHelper.Short_TYPE, (Object)1, (Object)ClassHelper.int_TYPE, (Object)2, (Object)ClassHelper.Integer_TYPE, (Object)2, (Object)ClassHelper.long_TYPE, (Object)3, (Object)ClassHelper.Long_TYPE, (Object)3, (Object)ClassHelper.float_TYPE, (Object)4, (Object)ClassHelper.Float_TYPE, (Object)4, (Object)ClassHelper.double_TYPE, (Object)5, (Object)ClassHelper.Double_TYPE, (Object)5);
    protected static final Map<String, Integer> NUMBER_OPS = Maps.of((Object)"plus", (Object)200, (Object)"minus", (Object)201, (Object)"multiply", (Object)202, (Object)"div", (Object)203, (Object)"or", (Object)340, (Object)"and", (Object)341, (Object)"xor", (Object)342, (Object)"mod", (Object)205, (Object)"intdiv", (Object)204, (Object)"leftShift", (Object)280, (Object)"rightShift", (Object)281, (Object)"rightShiftUnsigned", (Object)282);
    protected static final ClassNode GSTRING_STRING_CLASSNODE = WideningCategories.lowestUpperBound(ClassHelper.STRING_TYPE, ClassHelper.GSTRING_TYPE);
    protected static final ClassNode UNKNOWN_PARAMETER_TYPE = ClassHelper.make("<unknown parameter type>");
    protected static final Comparator<MethodNode> DGM_METHOD_NODE_COMPARATOR = new Comparator<MethodNode>(){

        @Override
        public int compare(MethodNode o1, MethodNode o2) {
            if (o1.getName().equals(o2.getName())) {
                Parameter[] o2ps;
                Parameter[] o1ps = o1.getParameters();
                if (o1ps.length == (o2ps = o2.getParameters()).length) {
                    boolean allEqual = true;
                    int i = 0;
                    while (i < o1ps.length && allEqual) {
                        allEqual = o1ps[i].getType().equals(o2ps[i].getType());
                        ++i;
                    }
                    if (allEqual) {
                        if (o1 instanceof ExtensionMethodNode && o2 instanceof ExtensionMethodNode) {
                            return this.compare(((ExtensionMethodNode)o1).getExtensionMethodNode(), ((ExtensionMethodNode)o2).getExtensionMethodNode());
                        }
                        return 0;
                    }
                } else {
                    return o1ps.length - o2ps.length;
                }
            }
            return 1;
        }
    };
    protected static final ExtensionMethodCache EXTENSION_METHOD_CACHE = ExtensionMethodCache.INSTANCE;

    public static void clearExtensionMethodCache() {
        StaticTypeCheckingSupport.EXTENSION_METHOD_CACHE.cache.clearAll();
    }

    public static void clearExtensionMethodCache(ClassLoader loader) {
        StaticTypeCheckingSupport.EXTENSION_METHOD_CACHE.cache.remove((Object)loader);
    }

    protected static boolean isArrayAccessExpression(Expression expression) {
        return expression instanceof BinaryExpression && StaticTypeCheckingSupport.isArrayOp(((BinaryExpression)expression).getOperation().getType());
    }

    public static boolean isWithCall(String name, Expression arguments) {
        List args;
        return "with".equals(name) && arguments instanceof ArgumentListExpression && (args = ((ArgumentListExpression)arguments).getExpressions()).size() == 1 && args.get(0) instanceof ClosureExpression;
    }

    protected static Variable findTargetVariable(VariableExpression ve) {
        Variable accessedVariable = ve.getAccessedVariable();
        if (accessedVariable != null && accessedVariable != ve) {
            if (accessedVariable instanceof VariableExpression) {
                return StaticTypeCheckingSupport.findTargetVariable((VariableExpression)accessedVariable);
            }
            return accessedVariable;
        }
        return ve;
    }

    @Deprecated
    protected static Set<MethodNode> findDGMMethodsForClassNode(ClassNode clazz, String name) {
        return StaticTypeCheckingSupport.findDGMMethodsForClassNode(MetaClassRegistryImpl.class.getClassLoader(), clazz, name);
    }

    public static Set<MethodNode> findDGMMethodsForClassNode(ClassLoader loader, ClassNode clazz, String name) {
        TreeSet<MethodNode> accumulator = new TreeSet<MethodNode>(DGM_METHOD_NODE_COMPARATOR);
        StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, clazz, name, accumulator);
        return accumulator;
    }

    @Deprecated
    protected static void findDGMMethodsForClassNode(ClassNode clazz, String name, TreeSet<MethodNode> accumulator) {
        StaticTypeCheckingSupport.findDGMMethodsForClassNode(MetaClassRegistryImpl.class.getClassLoader(), clazz, name, accumulator);
    }

    protected static void findDGMMethodsForClassNode(ClassLoader loader, ClassNode clazz, String name, TreeSet<MethodNode> accumulator) {
        ClassNode componentClass;
        List fromDGM = (List)EXTENSION_METHOD_CACHE.get(loader).get(clazz.getName());
        if (fromDGM != null) {
            for (AnnotatedNode node : fromDGM) {
                if (!node.getName().equals(name)) continue;
                accumulator.add((MethodNode)node);
            }
        }
        ClassNode[] classNodeArray = clazz.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotatedNode node;
            node = classNodeArray[n2];
            StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, (ClassNode)node, name, accumulator);
            ++n2;
        }
        if (clazz.isArray() && !(componentClass = clazz.getComponentType()).equals(ClassHelper.OBJECT_TYPE) && !ClassHelper.isPrimitiveType(componentClass)) {
            if (componentClass.isInterface()) {
                StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, ClassHelper.OBJECT_TYPE.makeArray(), name, accumulator);
            } else {
                StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, componentClass.getSuperClass().makeArray(), name, accumulator);
            }
        }
        if (clazz.getSuperClass() != null) {
            StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, clazz.getSuperClass(), name, accumulator);
        } else if (!clazz.equals(ClassHelper.OBJECT_TYPE)) {
            StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, ClassHelper.OBJECT_TYPE, name, accumulator);
        }
    }

    public static int allParametersAndArgumentsMatch(Parameter[] parameters, ClassNode[] argumentTypes) {
        int nParameters;
        if (parameters == null) {
            parameters = Parameter.EMPTY_ARRAY;
        }
        if (argumentTypes.length < (nParameters = parameters.length)) {
            return -1;
        }
        int dist = 0;
        int i = 0;
        while (i < nParameters) {
            ClassNode aType = argumentTypes[i];
            ClassNode pType = parameters[i].getType();
            if (!StaticTypeCheckingSupport.isAssignableTo(aType, pType)) {
                return -1;
            }
            if (!aType.equals(pType)) {
                dist += StaticTypeCheckingSupport.getDistance(aType, pType);
            }
            ++i;
        }
        return dist;
    }

    static int allParametersAndArgumentsMatchWithDefaultParams(Parameter[] parameters, ClassNode[] argumentTypes) {
        int dist = 0;
        ClassNode ptype = null;
        int i = 0;
        int j = 0;
        int n = parameters.length;
        while (i < n) {
            ClassNode arg;
            Parameter param = parameters[i];
            ClassNode paramType = param.getType();
            ClassNode classNode = arg = j >= argumentTypes.length ? null : argumentTypes[j];
            if (arg == null || !StaticTypeCheckingSupport.isAssignableTo(arg, paramType)) {
                if (!(param.hasInitialExpression() || ptype != null && ptype.equals(paramType))) {
                    return -1;
                }
                ptype = null;
            } else {
                ++j;
                if (!paramType.equals(arg)) {
                    dist += StaticTypeCheckingSupport.getDistance(arg, paramType);
                }
                ptype = param.hasInitialExpression() ? arg : null;
            }
            ++i;
        }
        return dist;
    }

    static int excessArgumentsMatchesVargsParameter(Parameter[] parameters, ClassNode[] argumentTypes) {
        int dist = 0;
        ClassNode vargsBase = parameters[parameters.length - 1].getType().getComponentType();
        int i = parameters.length;
        while (i < argumentTypes.length) {
            if (!StaticTypeCheckingSupport.isAssignableTo(argumentTypes[i], vargsBase)) {
                return -1;
            }
            dist += StaticTypeCheckingSupport.getClassDistance(vargsBase, argumentTypes[i]);
            ++i;
        }
        return dist;
    }

    static int lastArgMatchesVarg(Parameter[] parameters, ClassNode ... argumentTypes) {
        if (!StaticTypeCheckingSupport.isVargs(parameters)) {
            return -1;
        }
        int lastParamIndex = parameters.length - 1;
        if (lastParamIndex == argumentTypes.length) {
            return 0;
        }
        ClassNode arrayType = parameters[lastParamIndex].getType();
        ClassNode elementType = arrayType.getComponentType();
        ClassNode argumentType = argumentTypes[argumentTypes.length - 1];
        if (ClassHelper.isNumberType(elementType) && ClassHelper.isNumberType(argumentType) && !ClassHelper.getWrapper(elementType).equals(ClassHelper.getWrapper(argumentType))) {
            return -1;
        }
        return StaticTypeCheckingSupport.isAssignableTo(argumentType, elementType) ? Math.min(StaticTypeCheckingSupport.getDistance(argumentType, arrayType), StaticTypeCheckingSupport.getDistance(argumentType, elementType)) : -1;
    }

    public static boolean isAssignableTo(ClassNode type, ClassNode toBeAssignedTo) {
        if (type == toBeAssignedTo || type == UNKNOWN_PARAMETER_TYPE) {
            return true;
        }
        if (ClassHelper.isPrimitiveType(type)) {
            type = ClassHelper.getWrapper(type);
        }
        if (ClassHelper.isPrimitiveType(toBeAssignedTo)) {
            toBeAssignedTo = ClassHelper.getWrapper(toBeAssignedTo);
        }
        Integer source = NUMBER_TYPES.get(type);
        Integer target = NUMBER_TYPES.get(toBeAssignedTo);
        if (source != null && target != null) {
            return source.compareTo(target) <= 0;
        }
        if (ClassHelper.BigDecimal_TYPE.equals(type) && (ClassHelper.Double_TYPE.equals(toBeAssignedTo) || ClassHelper.Float_TYPE.equals(toBeAssignedTo))) {
            return true;
        }
        if (type.isArray() && toBeAssignedTo.isArray()) {
            ClassNode sourceComponent = type.getComponentType();
            ClassNode targetComponent = toBeAssignedTo.getComponentType();
            return ClassHelper.isPrimitiveType(targetComponent) ? sourceComponent.equals(targetComponent) : !ClassHelper.isPrimitiveType(sourceComponent) && StaticTypeCheckingSupport.isAssignableTo(sourceComponent, targetComponent);
        }
        if (type.isDerivedFrom(ClassHelper.GSTRING_TYPE) && toBeAssignedTo.equals(ClassHelper.STRING_TYPE)) {
            return true;
        }
        if (type.equals(ClassHelper.STRING_TYPE) && toBeAssignedTo.isDerivedFrom(ClassHelper.GSTRING_TYPE)) {
            return true;
        }
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, toBeAssignedTo)) {
            if (toBeAssignedTo.getGenericsTypes() != null) {
                GenericsType gt = toBeAssignedTo.isGenericsPlaceHolder() ? toBeAssignedTo.getGenericsTypes()[0] : GenericsUtils.buildWildcardType(toBeAssignedTo);
                return gt.isCompatibleWith(type);
            }
            return true;
        }
        if (type.isGenericsPlaceHolder() && type.getUnresolvedName().charAt(0) == '#') {
            return type.getGenericsTypes()[0].isCompatibleWith(toBeAssignedTo);
        }
        return type.isDerivedFrom(ClassHelper.CLOSURE_TYPE) && ClassHelper.isSAMType(toBeAssignedTo);
    }

    static boolean isVargs(Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return false;
        }
        return parameters[parameters.length - 1].getType().isArray();
    }

    public static boolean isCompareToBoolean(int op) {
        return op == 124 || op == 125 || op == 126 || op == 127;
    }

    static boolean isArrayOp(int op) {
        return op == 30;
    }

    static boolean isBoolIntrinsicOp(int op) {
        switch (op) {
            case 94: 
            case 121: 
            case 122: 
            case 130: 
            case 162: 
            case 164: 
            case 544: {
                return true;
            }
        }
        return false;
    }

    static boolean isPowerOperator(int op) {
        return op == 206 || op == 216;
    }

    static String getOperationName(int op) {
        switch (op) {
            case 120: 
            case 123: {
                return "equals";
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                return "compareTo";
            }
            case 341: 
            case 351: {
                return "and";
            }
            case 340: 
            case 350: {
                return "or";
            }
            case 342: 
            case 352: {
                return "xor";
            }
            case 200: 
            case 210: {
                return "plus";
            }
            case 201: 
            case 211: {
                return "minus";
            }
            case 202: 
            case 212: {
                return "multiply";
            }
            case 203: 
            case 213: {
                return "div";
            }
            case 204: 
            case 214: {
                return "intdiv";
            }
            case 205: 
            case 215: {
                return "mod";
            }
            case 206: 
            case 216: {
                return "power";
            }
            case 280: 
            case 285: {
                return "leftShift";
            }
            case 281: 
            case 286: {
                return "rightShift";
            }
            case 282: 
            case 287: {
                return "rightShiftUnsigned";
            }
            case 573: {
                return "isCase";
            }
            case 129: {
                return "isNotCase";
            }
        }
        return null;
    }

    static boolean isShiftOperation(String name) {
        return "leftShift".equals(name) || "rightShift".equals(name) || "rightShiftUnsigned".equals(name);
    }

    static boolean isOperationInGroup(int op) {
        switch (op) {
            case 200: 
            case 201: 
            case 202: 
            case 210: 
            case 211: 
            case 212: {
                return true;
            }
        }
        return false;
    }

    static boolean isBitOperator(int op) {
        switch (op) {
            case 340: 
            case 341: 
            case 342: 
            case 350: 
            case 351: 
            case 352: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignment(int op) {
        return Types.isAssignment((int)op);
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right) {
        return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(left, right, null);
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right, Expression rightExpression) {
        return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(left, right, rightExpression, true);
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right, Expression rightExpression, boolean allowConstructorCoercion) {
        GenericsType[] genericsTypes;
        ClassNode rightRedirect;
        if (!ClassHelper.isPrimitiveType(left) && ExpressionUtils.isNullConstant(rightExpression)) {
            return true;
        }
        if (left.isArray() && right.isArray()) {
            ClassNode leftComponent = left.getComponentType();
            ClassNode rightComponent = right.getComponentType();
            return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponent, rightComponent, rightExpression, false);
        }
        if (left.isArray() && GeneralUtils.isOrImplements((ClassNode)right, (ClassNode)Collection_TYPE) && !(rightExpression instanceof ListExpression)) {
            GenericsType elementType = GenericsUtils.parameterizeType(right, Collection_TYPE).getGenericsTypes()[0];
            return ClassHelper.OBJECT_TYPE.equals(left.getComponentType()) || elementType.getLowerBound() == null && StaticTypeCheckingSupport.isCovariant(StaticTypeCheckingSupport.extractType(elementType), left.getComponentType());
        }
        ClassNode leftRedirect = left.redirect();
        if (leftRedirect == (rightRedirect = right.redirect())) {
            return true;
        }
        if (rightRedirect == ClassHelper.void_WRAPPER_TYPE) {
            return leftRedirect == ClassHelper.VOID_TYPE;
        }
        if (rightRedirect == ClassHelper.VOID_TYPE) {
            return leftRedirect == ClassHelper.void_WRAPPER_TYPE;
        }
        if (ClassHelper.isNumberType(rightRedirect) || WideningCategories.isNumberCategory(rightRedirect)) {
            if (leftRedirect.equals(ClassHelper.BigDecimal_TYPE) || leftRedirect.equals(ClassHelper.Number_TYPE)) {
                return true;
            }
            if (leftRedirect.equals(ClassHelper.BigInteger_TYPE)) {
                return WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(rightRedirect)) || rightRedirect.isDerivedFrom(ClassHelper.BigInteger_TYPE);
            }
        }
        if (StaticTypeCheckingSupport.isWildcardLeftHandSide(left) && (leftRedirect != ClassHelper.boolean_TYPE || !ExpressionUtils.isNullConstant(rightExpression))) {
            return true;
        }
        if (leftRedirect == ClassHelper.char_TYPE && rightRedirect == ClassHelper.Character_TYPE) {
            return true;
        }
        if (leftRedirect == ClassHelper.Character_TYPE && rightRedirect == ClassHelper.char_TYPE) {
            return true;
        }
        if ((leftRedirect == ClassHelper.char_TYPE || leftRedirect == ClassHelper.Character_TYPE) && rightRedirect == ClassHelper.STRING_TYPE) {
            return rightExpression instanceof ConstantExpression && rightExpression.getText().length() == 1;
        }
        if (leftRedirect.isDerivedFrom(ClassHelper.Enum_Type) && (rightRedirect.equals(ClassHelper.STRING_TYPE) || rightRedirect.equals(ClassHelper.GSTRING_TYPE))) {
            return true;
        }
        if (allowConstructorCoercion && StaticTypeCheckingSupport.isGroovyConstructorCompatible(rightExpression)) {
            if (leftRedirect.isArray() && rightRedirect.isArray()) {
                return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect.getComponentType(), rightRedirect.getComponentType());
            }
            return !rightRedirect.isArray() || leftRedirect.isArray();
        }
        if (ClassHelper.isPrimitiveType(leftRedirect) && ClassHelper.isPrimitiveType(rightRedirect)) {
            return true;
        }
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            return true;
        }
        if (WideningCategories.isFloatingCategory(leftRedirect) && ClassHelper.BigDecimal_TYPE.equals(rightRedirect)) {
            return true;
        }
        if (WideningCategories.implementsInterfaceOrSubclassOf(ClassHelper.getWrapper(right), left)) {
            return true;
        }
        if (leftRedirect.equals(ClassHelper.GROOVY_OBJECT_TYPE) && StaticTypeCheckingSupport.isBeingCompiled(right)) {
            return true;
        }
        if (right.isDerivedFrom(ClassHelper.CLOSURE_TYPE) && ClassHelper.isSAMType(left)) {
            return true;
        }
        if (left.isGenericsPlaceHolder() && (genericsTypes = left.getGenericsTypes()) != null && genericsTypes.length == 1) {
            return genericsTypes[0].isCompatibleWith(right);
        }
        return right.isGenericsPlaceHolder() && right.asGenericsType().isCompatibleWith(left);
    }

    private static boolean isGroovyConstructorCompatible(Expression rightExpression) {
        return rightExpression instanceof ListExpression || rightExpression instanceof MapExpression || rightExpression instanceof ArrayExpression;
    }

    public static boolean isWildcardLeftHandSide(ClassNode node) {
        return ClassHelper.OBJECT_TYPE.equals(node) || ClassHelper.STRING_TYPE.equals(node) || ClassHelper.boolean_TYPE.equals(node) || ClassHelper.Boolean_TYPE.equals(node) || ClassHelper.CLASS_Type.equals(node);
    }

    public static boolean isBeingCompiled(ClassNode node) {
        return node.getCompileUnit() != null;
    }

    @Deprecated
    static boolean checkPossibleLooseOfPrecision(ClassNode left, ClassNode right, Expression rightExpr) {
        return StaticTypeCheckingSupport.checkPossibleLossOfPrecision(left, right, rightExpr);
    }

    static boolean checkPossibleLossOfPrecision(ClassNode left, ClassNode right, Expression rightExpr) {
        int rightIndex;
        if (left == right || left.equals(right)) {
            return false;
        }
        int leftIndex = NUMBER_TYPES.get(left);
        if (leftIndex >= (rightIndex = NUMBER_TYPES.get(right).intValue())) {
            return false;
        }
        if (rightExpr instanceof ConstantExpression) {
            Object value = ((ConstantExpression)rightExpr).getValue();
            if (!(value instanceof Number)) {
                return true;
            }
            Number number = (Number)value;
            switch (leftIndex) {
                case 0: {
                    byte val = number.byteValue();
                    if (number instanceof Short) {
                        return !Short.valueOf(val).equals(number);
                    }
                    if (number instanceof Integer) {
                        return !Integer.valueOf(val).equals(number);
                    }
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 1: {
                    short val = number.shortValue();
                    if (number instanceof Integer) {
                        return !Integer.valueOf(val).equals(number);
                    }
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 2: {
                    int val = number.intValue();
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 3: {
                    long val = number.longValue();
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 4: {
                    float val = number.floatValue();
                    return !Double.valueOf(val).equals(number);
                }
            }
            return false;
        }
        return true;
    }

    static String toMethodParametersString(String methodName, ClassNode ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return String.valueOf(methodName) + "()";
        }
        StringJoiner joiner = new StringJoiner(", ", String.valueOf(methodName) + "(", ")");
        ClassNode[] classNodeArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode parameter = classNodeArray[n2];
            joiner.add(StaticTypeCheckingSupport.prettyPrintType(parameter));
            ++n2;
        }
        return joiner.toString();
    }

    static String prettyPrintType(ClassNode type) {
        if (type instanceof UnionTypeClassNode) {
            StringJoiner joiner = new StringJoiner(" or ");
            ClassNode[] classNodeArray = ((UnionTypeClassNode)type).getDelegates();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode cn = classNodeArray[n2];
                joiner.add(StaticTypeCheckingSupport.prettyPrintType(cn));
                ++n2;
            }
            return joiner.toString();
        }
        if (type.getUnresolvedName().charAt(0) == '#') {
            return type.redirect().toString(false);
        }
        return type.toString(false);
    }

    static String prettyPrintTypeName(ClassNode type) {
        if (type.isArray()) {
            return String.valueOf(StaticTypeCheckingSupport.prettyPrintTypeName(type.getComponentType())) + "[]";
        }
        return type.isGenericsPlaceHolder() ? type.getUnresolvedName() : type.getText();
    }

    public static boolean implementsInterfaceOrIsSubclassOf(ClassNode type, ClassNode superOrInterface) {
        boolean result;
        boolean bl = result = type.equals(superOrInterface) || type.isDerivedFrom(superOrInterface) || type.implementsInterface(superOrInterface) || type == UNKNOWN_PARAMETER_TYPE;
        if (result) {
            return true;
        }
        if (superOrInterface instanceof WideningCategories.LowestUpperBoundClassNode) {
            WideningCategories.LowestUpperBoundClassNode cn = (WideningCategories.LowestUpperBoundClassNode)superOrInterface;
            result = StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, cn.getSuperClass());
            if (result) {
                ClassNode[] classNodeArray = cn.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode interfaceNode = classNodeArray[n2];
                    result = type.implementsInterface(interfaceNode);
                    if (!result) break;
                    ++n2;
                }
            }
            if (result) {
                return true;
            }
        } else if (superOrInterface instanceof UnionTypeClassNode) {
            UnionTypeClassNode union = (UnionTypeClassNode)superOrInterface;
            ClassNode[] classNodeArray = union.getDelegates();
            int n = classNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                ClassNode delegate = classNodeArray[n3];
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, delegate)) {
                    return true;
                }
                ++n3;
            }
        }
        if (type.isArray() && superOrInterface.isArray()) {
            return StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type.getComponentType(), superOrInterface.getComponentType());
        }
        return superOrInterface.equals(ClassHelper.GROOVY_OBJECT_TYPE) && !type.isInterface() && StaticTypeCheckingSupport.isBeingCompiled(type);
    }

    static int getPrimitiveDistance(ClassNode primA, ClassNode primB) {
        return Math.abs(NUMBER_TYPES.get(primA) - NUMBER_TYPES.get(primB));
    }

    static int getDistance(ClassNode receiver, ClassNode compare) {
        if (receiver.isArray() && compare.isArray()) {
            return StaticTypeCheckingSupport.getDistance(receiver.getComponentType(), compare.getComponentType());
        }
        int dist = 0;
        ClassNode unwrapReceiver = ClassHelper.getUnwrapper(receiver);
        ClassNode unwrapCompare = ClassHelper.getUnwrapper(compare);
        if (ClassHelper.isPrimitiveType(unwrapReceiver) && ClassHelper.isPrimitiveType(unwrapCompare) && unwrapReceiver != unwrapCompare) {
            dist = StaticTypeCheckingSupport.getPrimitiveDistance(unwrapReceiver, unwrapCompare);
        }
        if (ClassHelper.isPrimitiveType(receiver) ^ ClassHelper.isPrimitiveType(compare)) {
            dist = dist + 1 << 1;
        }
        if (unwrapCompare.equals(unwrapReceiver)) {
            return dist;
        }
        if (receiver.isArray() && !compare.isArray()) {
            dist += 256;
        }
        if (receiver == UNKNOWN_PARAMETER_TYPE) {
            return dist;
        }
        ClassNode ref = ClassHelper.isPrimitiveType(receiver) && !ClassHelper.isPrimitiveType(compare) ? ClassHelper.getWrapper(receiver) : receiver;
        while (ref != null) {
            if (compare.equals(ref)) break;
            if (compare.isInterface() && ref.implementsInterface(compare)) {
                dist += StaticTypeCheckingSupport.getMaximumInterfaceDistance(ref, compare);
                break;
            }
            ref = ref.getSuperClass();
            ++dist;
            if (ClassHelper.OBJECT_TYPE.equals(ref)) {
                ++dist;
            }
            dist = dist + 1 << 1;
        }
        return dist;
    }

    private static int getMaximumInterfaceDistance(ClassNode c, ClassNode interfaceClass) {
        if (c == null) {
            return -1;
        }
        if (c.equals(interfaceClass)) {
            return 0;
        }
        ClassNode[] interfaces = c.getInterfaces();
        int max = -1;
        ClassNode[] classNodeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode anInterface = classNodeArray[n2];
            int sub = StaticTypeCheckingSupport.getMaximumInterfaceDistance(anInterface, interfaceClass);
            if (sub != -1) {
                ++sub;
            }
            max = Math.max(max, sub);
            ++n2;
        }
        int superClassMax = StaticTypeCheckingSupport.getMaximumInterfaceDistance(c.getSuperClass(), interfaceClass);
        return Math.max(max, superClassMax);
    }

    @Deprecated
    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassNode receiver, String name, ClassNode[] args) {
        return StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(MetaClassRegistryImpl.class.getClassLoader(), receiver, name, args);
    }

    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassLoader loader, ClassNode receiver, String name, ClassNode[] args) {
        return StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(loader, receiver, name, args, new LinkedList<MethodNode>());
    }

    @Deprecated
    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassNode receiver, String name, ClassNode[] args, List<MethodNode> methods) {
        return StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(MetaClassRegistryImpl.class.getClassLoader(), receiver, name, args, methods);
    }

    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassLoader loader, ClassNode receiver, String name, ClassNode[] args, List<MethodNode> methods) {
        methods.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, receiver, name));
        return methods.isEmpty() ? methods : StaticTypeCheckingSupport.chooseBestMethod(receiver, methods, args);
    }

    public static boolean isUsingUncheckedGenerics(ClassNode node) {
        return GenericsUtils.hasUnresolvedGenerics(node);
    }

    public static List<MethodNode> chooseBestMethod(ClassNode receiver, Collection<MethodNode> methods, ClassNode ... argumentTypes) {
        if (!DefaultGroovyMethods.asBoolean(methods)) {
            return Collections.emptyList();
        }
        int bestDist = Integer.MAX_VALUE;
        LinkedList<MethodNode> bestChoices = new LinkedList<MethodNode>();
        boolean noCulling = methods.size() <= 1 || "<init>".equals(methods.iterator().next().getName());
        Collection<MethodNode> candidates = noCulling ? methods : StaticTypeCheckingSupport.removeCovariantsAndInterfaceEquivalents(methods);
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            ClassNode actualReceiver;
            ClassNode declaringClass;
            Parameter[] simpleParams;
            int dist;
            MethodNode candidate;
            MethodNode safeNode = candidate = (MethodNode)iterator.next();
            ClassNode[] safeArgs = argumentTypes;
            boolean isExtensionMethod = candidate instanceof ExtensionMethodNode;
            if (isExtensionMethod) {
                int nArgs = argumentTypes.length;
                safeArgs = new ClassNode[nArgs + 1];
                System.arraycopy(argumentTypes, 0, safeArgs, 1, nArgs);
                safeArgs[0] = receiver;
                safeNode = ((ExtensionMethodNode)candidate).getExtensionMethodNode();
            }
            if ((dist = StaticTypeCheckingSupport.measureParametersAndArgumentsDistance(simpleParams = StaticTypeCheckingSupport.getSafeParameters(safeNode, declaringClass = candidate.getDeclaringClass(), actualReceiver = receiver != null ? receiver : declaringClass), safeArgs)) < 0) continue;
            dist += StaticTypeCheckingSupport.getClassDistance(declaringClass, actualReceiver);
            if ((dist += StaticTypeCheckingSupport.getExtensionDistance(isExtensionMethod)) < bestDist) {
                bestDist = dist;
                bestChoices.clear();
                bestChoices.add(candidate);
                continue;
            }
            if (dist != bestDist) continue;
            bestChoices.add(candidate);
        }
        if (bestChoices.size() > 1) {
            LinkedList<MethodNode> onlyExtensionMethods = new LinkedList<MethodNode>();
            for (MethodNode choice : bestChoices) {
                if (!(choice instanceof ExtensionMethodNode)) continue;
                onlyExtensionMethods.add(choice);
            }
            if (onlyExtensionMethods.size() == 1) {
                return onlyExtensionMethods;
            }
        }
        return bestChoices;
    }

    private static Parameter[] getSafeParameters(MethodNode methodNode, ClassNode declaringClass, ClassNode actualReceiver) {
        Parameter[] params = methodNode.getParameters();
        if (params.length > 0) {
            Map<GenericsType.GenericsTypeName, GenericsType> spec;
            if (methodNode.isStatic()) {
                spec = Collections.emptyMap();
            } else {
                spec = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                StaticTypeCheckingSupport.extractGenericsConnections(spec, actualReceiver, declaringClass);
                GenericsType[] methodGenerics = methodNode.getGenericsTypes();
                if (methodGenerics != null) {
                    GenericsType[] genericsTypeArray = methodGenerics;
                    int n = methodGenerics.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GenericsType tp = genericsTypeArray[n2];
                        spec.remove(new GenericsType.GenericsTypeName(tp.getName()));
                        ++n2;
                    }
                }
            }
            params = (Parameter[])params.clone();
            int i = 0;
            while (i < params.length) {
                ClassNode t;
                ClassNode x = t = params[i].getOriginType();
                while (x.isArray()) {
                    x = x.getComponentType();
                }
                if (x.isGenericsPlaceHolder()) {
                    params[i] = new Parameter(GenericsUtils.nonGeneric(StaticTypeCheckingSupport.applyGenericsContext(spec, t)), params[i].getName());
                } else if (x.getGenericsTypes() != null) {
                    params[i] = new Parameter(GenericsUtils.nonGeneric(t), params[i].getName());
                }
                ++i;
            }
        }
        return params;
    }

    private static int measureParametersAndArgumentsDistance(Parameter[] parameters, ClassNode[] argumentTypes) {
        int dist = -1;
        if (parameters.length == argumentTypes.length) {
            int endDist;
            dist = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(parameters, argumentTypes);
            if (StaticTypeCheckingSupport.isVargs(parameters) && StaticTypeCheckingSupport.firstParametersAndArgumentsMatch(parameters, argumentTypes) >= 0 && (endDist = StaticTypeCheckingSupport.lastArgMatchesVarg(parameters, argumentTypes)) >= 0) {
                dist = dist < 0 ? endDist : Math.min(dist, endDist += StaticTypeCheckingSupport.getVarargsDistance(parameters));
            }
        } else if (StaticTypeCheckingSupport.isVargs(parameters) && (dist = StaticTypeCheckingSupport.firstParametersAndArgumentsMatch(parameters, argumentTypes)) >= 0) {
            dist += StaticTypeCheckingSupport.getVarargsDistance(parameters);
            if (parameters.length < argumentTypes.length) {
                int excessArgumentsDistance = StaticTypeCheckingSupport.excessArgumentsMatchesVargsParameter(parameters, argumentTypes);
                dist = excessArgumentsDistance >= 0 ? (dist += excessArgumentsDistance) : -1;
            }
        }
        return dist;
    }

    private static int firstParametersAndArgumentsMatch(Parameter[] parameters, ClassNode[] safeArgumentTypes) {
        int dist = 0;
        if (parameters.length > 0) {
            Parameter[] firstParams = new Parameter[parameters.length - 1];
            System.arraycopy(parameters, 0, firstParams, 0, firstParams.length);
            dist = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(firstParams, safeArgumentTypes);
        }
        return dist;
    }

    private static int getVarargsDistance(Parameter[] parameters) {
        return 256 - parameters.length;
    }

    private static int getClassDistance(ClassNode declaringClassForDistance, ClassNode actualReceiverForDistance) {
        if (actualReceiverForDistance.equals(declaringClassForDistance)) {
            return 0;
        }
        return StaticTypeCheckingSupport.getDistance(actualReceiverForDistance, declaringClassForDistance);
    }

    private static int getExtensionDistance(boolean isExtensionMethodNode) {
        return isExtensionMethodNode ? 0 : 1;
    }

    private static List<MethodNode> removeCovariantsAndInterfaceEquivalents(Collection<MethodNode> collection) {
        ArrayList<MethodNode> list = new ArrayList<MethodNode>(new LinkedHashSet<MethodNode>(collection));
        ArrayList<MethodNode> toBeRemoved = new ArrayList<MethodNode>();
        int i = 0;
        int n = list.size();
        while (i < n - 1) {
            MethodNode one = (MethodNode)list.get(i);
            int j = i + 1;
            while (j < n && !toBeRemoved.contains(one)) {
                MethodNode two = (MethodNode)list.get(j);
                if (!toBeRemoved.contains(two) && one.getParameters().length == two.getParameters().length) {
                    ClassNode twoDC;
                    ClassNode oneDC = one.getDeclaringClass();
                    if (oneDC == (twoDC = two.getDeclaringClass())) {
                        if (ParameterUtils.parametersEqual((Parameter[])one.getParameters(), (Parameter[])two.getParameters())) {
                            ClassNode twoRT;
                            ClassNode oneRT = one.getReturnType();
                            if (StaticTypeCheckingSupport.isCovariant(oneRT, twoRT = two.getReturnType())) {
                                toBeRemoved.add(two);
                            } else if (StaticTypeCheckingSupport.isCovariant(twoRT, oneRT)) {
                                toBeRemoved.add(one);
                            }
                        } else if (StaticTypeCheckingSupport.isSynthetic(one, two)) {
                            toBeRemoved.add(one);
                        } else if (StaticTypeCheckingSupport.isSynthetic(two, one)) {
                            toBeRemoved.add(two);
                        }
                    } else if (!oneDC.equals(twoDC) && ParameterUtils.parametersEqual((Parameter[])one.getParameters(), (Parameter[])two.getParameters())) {
                        if (!twoDC.isInterface() ? oneDC.isDerivedFrom(twoDC) : oneDC.implementsInterface(twoDC) || !one.isAbstract() && !(two instanceof ExtensionMethodNode)) {
                            toBeRemoved.add(two);
                        } else if (oneDC.isInterface() ? twoDC.isInterface() : twoDC.isDerivedFrom(oneDC)) {
                            toBeRemoved.add(one);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (toBeRemoved.isEmpty()) {
            return list;
        }
        LinkedList<MethodNode> result = new LinkedList<MethodNode>(list);
        result.removeAll(toBeRemoved);
        return result;
    }

    private static boolean isCovariant(ClassNode one, ClassNode two) {
        if (one.isArray() && two.isArray()) {
            return StaticTypeCheckingSupport.isCovariant(one.getComponentType(), two.getComponentType());
        }
        return one.isDerivedFrom(two) || one.implementsInterface(two);
    }

    private static boolean isSynthetic(MethodNode one, MethodNode two) {
        return (one.getModifiers() & 0x1000) != 0 && (two.getModifiers() & 0x1000) == 0;
    }

    public static Parameter[] parameterizeArguments(ClassNode receiver, MethodNode m) {
        Map<GenericsType.GenericsTypeName, GenericsType> genericFromReceiver = GenericsUtils.extractPlaceholders(receiver);
        Map<GenericsType.GenericsTypeName, GenericsType> contextPlaceholders = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(m);
        Parameter[] methodParameters = m.getParameters();
        Parameter[] params = new Parameter[methodParameters.length];
        int i = 0;
        int n = methodParameters.length;
        while (i < n) {
            Parameter methodParameter = methodParameters[i];
            ClassNode paramType = methodParameter.getType();
            params[i] = StaticTypeCheckingSupport.buildParameter(genericFromReceiver, contextPlaceholders, methodParameter, paramType);
            ++i;
        }
        return params;
    }

    private static Parameter buildParameter(Map<GenericsType.GenericsTypeName, GenericsType> genericFromReceiver, Map<GenericsType.GenericsTypeName, GenericsType> placeholdersFromContext, Parameter methodParameter, ClassNode paramType) {
        if (genericFromReceiver.isEmpty() && (placeholdersFromContext == null || placeholdersFromContext.isEmpty())) {
            return methodParameter;
        }
        if (paramType.isArray()) {
            ClassNode componentType = paramType.getComponentType();
            Parameter subMethodParameter = new Parameter(componentType, methodParameter.getName());
            Parameter component = StaticTypeCheckingSupport.buildParameter(genericFromReceiver, placeholdersFromContext, subMethodParameter, componentType);
            return new Parameter(component.getType().makeArray(), component.getName());
        }
        ClassNode resolved = StaticTypeCheckingSupport.resolveClassNodeGenerics(genericFromReceiver, placeholdersFromContext, paramType);
        return new Parameter(resolved, methodParameter.getName());
    }

    public static boolean isUsingGenericsOrIsArrayUsingGenerics(ClassNode cn) {
        if (cn.isArray()) {
            return StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(cn.getComponentType());
        }
        return cn.isUsingGenerics() && (cn.getGenericsTypes() != null || cn.isGenericsPlaceHolder());
    }

    protected static GenericsType fullyResolve(GenericsType gt, Map<GenericsType.GenericsTypeName, GenericsType> placeholders) {
        ClassNode[] upperBounds;
        GenericsType fromMap = placeholders.get(new GenericsType.GenericsTypeName(gt.getName()));
        if (gt.isPlaceholder() && fromMap != null) {
            gt = fromMap;
        }
        ClassNode type = StaticTypeCheckingSupport.fullyResolveType(gt.getType(), placeholders);
        ClassNode lowerBound = gt.getLowerBound();
        if (lowerBound != null) {
            lowerBound = StaticTypeCheckingSupport.fullyResolveType(lowerBound, placeholders);
        }
        if ((upperBounds = gt.getUpperBounds()) != null) {
            ClassNode[] copy = new ClassNode[upperBounds.length];
            int i = 0;
            int upperBoundsLength = upperBounds.length;
            while (i < upperBoundsLength) {
                ClassNode upperBound = upperBounds[i];
                copy[i] = StaticTypeCheckingSupport.fullyResolveType(upperBound, placeholders);
                ++i;
            }
            upperBounds = copy;
        }
        GenericsType genericsType = new GenericsType(type, upperBounds, lowerBound);
        genericsType.setWildcard(gt.isWildcard());
        return genericsType;
    }

    protected static ClassNode fullyResolveType(ClassNode type, Map<GenericsType.GenericsTypeName, GenericsType> placeholders) {
        if (type.isArray()) {
            return StaticTypeCheckingSupport.fullyResolveType(type.getComponentType(), placeholders).makeArray();
        }
        if (type.isGenericsPlaceHolder()) {
            GenericsType gt = placeholders.get(new GenericsType.GenericsTypeName(type.getUnresolvedName()));
            if (gt != null) {
                return gt.getType();
            }
            return type.redirect();
        }
        if (!type.isUsingGenerics()) {
            return type;
        }
        Object[] gts = type.getGenericsTypes();
        if (DefaultGroovyMethods.asBoolean((Object[])gts)) {
            gts = (GenericsType[])gts.clone();
            int i = 0;
            int n = gts.length;
            while (i < n) {
                Object gt = gts[i];
                if (((GenericsType)gt).isPlaceholder()) {
                    String name = ((GenericsType)gt).getName();
                    if ((gt = placeholders.get(new GenericsType.GenericsTypeName(name))) == null) {
                        gt = StaticTypeCheckingSupport.extractType((GenericsType)gts[i]).asGenericsType();
                    }
                    if (!((GenericsType)gt).isPlaceholder() || !((GenericsType)gt).getName().equals(name)) {
                        gts[i] = gt;
                    }
                } else {
                    gts[i] = StaticTypeCheckingSupport.fullyResolve((GenericsType)gt, placeholders);
                }
                ++i;
            }
        }
        ClassNode cn = type.getPlainNodeReference();
        cn.setGenericsTypes((GenericsType[])gts);
        return cn;
    }

    protected static boolean typeCheckMethodArgumentWithGenerics(ClassNode parameterType, ClassNode argumentType, boolean lastArg) {
        if (UNKNOWN_PARAMETER_TYPE == argumentType) {
            return !ClassHelper.isPrimitiveType(parameterType);
        }
        if (!StaticTypeCheckingSupport.isAssignableTo(argumentType, parameterType) && !lastArg) {
            return false;
        }
        if (!StaticTypeCheckingSupport.isAssignableTo(argumentType, parameterType) && lastArg) {
            if (parameterType.isArray()) {
                if (!StaticTypeCheckingSupport.isAssignableTo(argumentType, parameterType.getComponentType())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (parameterType.isUsingGenerics() && argumentType.isUsingGenerics()) {
            GenericsType gt = GenericsUtils.buildWildcardType(parameterType);
            if (!gt.isCompatibleWith(argumentType)) {
                boolean samCoercion;
                boolean bl = samCoercion = ClassHelper.isSAMType(parameterType) && argumentType.equals(ClassHelper.CLOSURE_TYPE);
                if (!samCoercion) {
                    return false;
                }
            }
        } else {
            if (parameterType.isArray() && argumentType.isArray()) {
                return StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(parameterType.getComponentType(), argumentType.getComponentType(), lastArg);
            }
            if (lastArg && parameterType.isArray()) {
                return StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(parameterType.getComponentType(), argumentType, lastArg);
            }
        }
        return true;
    }

    protected static boolean typeCheckMethodsWithGenerics(ClassNode receiver, ClassNode[] argumentTypes, MethodNode candidateMethod) {
        if (candidateMethod instanceof ExtensionMethodNode) {
            ClassNode[] realTypes = new ClassNode[argumentTypes.length + 1];
            realTypes[0] = receiver;
            System.arraycopy(argumentTypes, 0, realTypes, 1, argumentTypes.length);
            MethodNode realMethod = ((ExtensionMethodNode)candidateMethod).getExtensionMethodNode();
            return StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(realMethod.getDeclaringClass(), realTypes, realMethod, true);
        }
        if (receiver.isUsingGenerics() && receiver.equals(ClassHelper.CLASS_Type) && !candidateMethod.getDeclaringClass().equals(ClassHelper.CLASS_Type)) {
            return StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver.getGenericsTypes()[0].getType(), argumentTypes, candidateMethod);
        }
        return StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(StaticTypeCheckingVisitor.wrapTypeIfNecessary(receiver), argumentTypes, candidateMethod, false);
    }

    private static boolean typeCheckMethodsWithGenerics(ClassNode receiver, ClassNode[] argumentTypes, MethodNode candidateMethod, boolean isExtensionMethod) {
        Parameter[] parameters = candidateMethod.getParameters();
        if (parameters.length == 0 || parameters.length > argumentTypes.length) {
            return true;
        }
        boolean failure = false;
        Set<GenericsType.GenericsTypeName> fixedPlaceHolders = Collections.emptySet();
        Map<Object, Object> candidateGenerics = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(receiver, candidateMethod.getDeclaringClass())) {
            if ("<init>".equals(candidateMethod.getName())) {
                candidateGenerics = GenericsUtils.extractPlaceholders(receiver);
                fixedPlaceHolders = new HashSet<Object>(candidateGenerics.keySet());
            } else {
                failure = StaticTypeCheckingSupport.inferenceCheck(fixedPlaceHolders, candidateGenerics, candidateMethod.getDeclaringClass(), receiver, false);
                GenericsType[] gts = candidateMethod.getGenericsTypes();
                if (candidateMethod.isStatic()) {
                    candidateGenerics.clear();
                } else if (gts != null) {
                    GenericsType[] genericsTypeArray = gts;
                    int n = gts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GenericsType gt = genericsTypeArray[n2];
                        candidateGenerics.remove(new GenericsType.GenericsTypeName(gt.getName()));
                        ++n2;
                    }
                    gts = StaticTypeCheckingSupport.applyGenericsContext(candidateGenerics, gts);
                }
                GenericsUtils.extractPlaceholders(GenericsUtils.makeClassSafe0(ClassHelper.OBJECT_TYPE, gts), candidateGenerics);
                fixedPlaceHolders = StaticTypeCheckingSupport.extractResolvedPlaceHolders(candidateGenerics);
            }
        }
        int i = 0;
        int n = argumentTypes.length;
        int nthParameter = parameters.length - 1;
        while (i < n) {
            ClassNode argumentType = argumentTypes[i];
            ClassNode parameterType = parameters[Math.min(i, nthParameter)].getOriginType();
            failure |= StaticTypeCheckingSupport.inferenceCheck(fixedPlaceHolders, candidateGenerics, parameterType, argumentType, i >= nthParameter);
            if (i == 0 && isExtensionMethod) {
                fixedPlaceHolders = StaticTypeCheckingSupport.extractResolvedPlaceHolders(candidateGenerics);
            }
            ++i;
        }
        return !failure;
    }

    private static Set<GenericsType.GenericsTypeName> extractResolvedPlaceHolders(Map<GenericsType.GenericsTypeName, GenericsType> resolvedMethodGenerics) {
        if (resolvedMethodGenerics.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<GenericsType.GenericsTypeName> result = new HashSet<GenericsType.GenericsTypeName>();
        for (Map.Entry<GenericsType.GenericsTypeName, GenericsType> entry : resolvedMethodGenerics.entrySet()) {
            GenericsType value = entry.getValue();
            if (value.isPlaceholder()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private static boolean inferenceCheck(Set<GenericsType.GenericsTypeName> fixedGenericsPlaceHolders, Map<GenericsType.GenericsTypeName, GenericsType> resolvedMethodGenerics, ClassNode type, ClassNode wrappedArgument, boolean lastArg) {
        HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        if (ClassHelper.isPrimitiveType(wrappedArgument)) {
            wrappedArgument = ClassHelper.getWrapper(wrappedArgument);
        }
        if (lastArg && type.isArray() && StaticTypeCheckingSupport.dimensions(type) != StaticTypeCheckingSupport.dimensions(wrappedArgument) && StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(type.getComponentType())) {
            type = type.getComponentType();
        }
        StaticTypeCheckingSupport.extractGenericsConnections(connections, wrappedArgument, type);
        boolean failure = !StaticTypeCheckingSupport.compatibleConnections(connections, resolvedMethodGenerics, fixedGenericsPlaceHolders);
        connections.keySet().removeAll(fixedGenericsPlaceHolders);
        StaticTypeCheckingSupport.applyGenericsConnections(connections, resolvedMethodGenerics);
        StaticTypeCheckingSupport.addMissingEntries(connections, resolvedMethodGenerics);
        type = StaticTypeCheckingSupport.applyGenericsContext(resolvedMethodGenerics, type);
        return failure || !StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(type, wrappedArgument, lastArg);
    }

    private static GenericsType buildWildcardType(GenericsType origin) {
        ClassNode lowerBound = origin.getType().getPlainNodeReference();
        if (StaticTypeCheckingSupport.hasNonTrivialBounds(origin)) {
            lowerBound.setGenericsTypes(new GenericsType[]{origin});
        }
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        GenericsType gt = new GenericsType(base, null, lowerBound);
        gt.setWildcard(true);
        return gt;
    }

    private static boolean compatibleConnections(Map<GenericsType.GenericsTypeName, GenericsType> connections, Map<GenericsType.GenericsTypeName, GenericsType> resolvedMethodGenerics, Set<GenericsType.GenericsTypeName> fixedGenericsPlaceHolders) {
        for (Map.Entry<GenericsType.GenericsTypeName, GenericsType> entry : connections.entrySet()) {
            GenericsType connection;
            GenericsType resolved = resolvedMethodGenerics.get(entry.getKey());
            if (resolved == null || (connection = entry.getValue()).isPlaceholder() && !StaticTypeCheckingSupport.hasNonTrivialBounds(connection) || StaticTypeCheckingSupport.compatibleConnection(resolved, connection)) continue;
            if (!(resolved.isPlaceholder() || resolved.isWildcard() || fixedGenericsPlaceHolders.contains(entry.getKey()))) {
                if (StaticTypeCheckingSupport.compatibleConnection(connection, resolved)) {
                    resolvedMethodGenerics.put(entry.getKey(), connection);
                    continue;
                }
                if (!connection.isPlaceholder() && !connection.isWildcard()) {
                    ClassNode lub = WideningCategories.lowestUpperBound(connection.getType(), resolved.getType());
                    resolvedMethodGenerics.put(entry.getKey(), lub.asGenericsType());
                    continue;
                }
            }
            return false;
        }
        return true;
    }

    private static int dimensions(ClassNode cn) {
        int dims = 0;
        while (cn.isArray()) {
            cn = cn.getComponentType();
            ++dims;
        }
        return dims;
    }

    private static boolean compatibleConnection(GenericsType resolved, GenericsType connection) {
        GenericsType gt;
        ClassNode compareNode;
        if (resolved.isPlaceholder() && resolved.getUpperBounds() != null && resolved.getUpperBounds().length == 1 && !resolved.getUpperBounds()[0].isGenericsPlaceHolder() && resolved.getUpperBounds()[0].getName().equals("java.lang.Object")) {
            return true;
        }
        if (StaticTypeCheckingSupport.hasNonTrivialBounds(resolved)) {
            compareNode = StaticTypeCheckingSupport.getCombinedBoundType(resolved);
            compareNode = compareNode.getPlainNodeReference();
        } else if (!resolved.isPlaceholder()) {
            compareNode = resolved.getType().getPlainNodeReference();
        } else {
            return true;
        }
        if (connection.isWildcard()) {
            gt = connection;
        } else {
            if (!connection.isPlaceholder() && connection.getType().equals(ClassHelper.CLOSURE_TYPE) && ClassHelper.isSAMType(compareNode)) {
                return true;
            }
            gt = StaticTypeCheckingSupport.buildWildcardType(connection);
        }
        return gt.isCompatibleWith(compareNode);
    }

    private static void addMissingEntries(Map<GenericsType.GenericsTypeName, GenericsType> connections, Map<GenericsType.GenericsTypeName, GenericsType> resolved) {
        for (Map.Entry<GenericsType.GenericsTypeName, GenericsType> entry : connections.entrySet()) {
            GenericsType gt;
            ClassNode cn;
            if (resolved.containsKey(entry.getKey()) || (cn = (gt = entry.getValue()).getType()).redirect() == UNKNOWN_PARAMETER_TYPE) continue;
            resolved.put(entry.getKey(), gt);
        }
    }

    public static ClassNode resolveClassNodeGenerics(Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders, Map<GenericsType.GenericsTypeName, GenericsType> placeholdersFromContext, ClassNode currentType) {
        ClassNode type = currentType;
        type = StaticTypeCheckingSupport.applyGenericsContext(resolvedPlaceholders, type);
        type = StaticTypeCheckingSupport.applyGenericsContext(placeholdersFromContext, type);
        return type;
    }

    static void applyGenericsConnections(Map<GenericsType.GenericsTypeName, GenericsType> connections, Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders) {
        if (connections == null || connections.isEmpty()) {
            return;
        }
        for (Map.Entry<GenericsType.GenericsTypeName, GenericsType> entry : resolvedPlaceholders.entrySet()) {
            ClassNode suitabilityType;
            GenericsType.GenericsTypeName name;
            GenericsType newValue;
            GenericsType oldValue = entry.getValue();
            if (!oldValue.isPlaceholder() || (newValue = connections.get(name = new GenericsType.GenericsTypeName(oldValue.getName()))) == oldValue) continue;
            if (newValue == null && (newValue = connections.get(entry.getKey())) != null) {
                newValue = StaticTypeCheckingSupport.getCombinedGenericsType(oldValue, newValue);
            }
            if (newValue == null) {
                newValue = StaticTypeCheckingSupport.applyGenericsContext(connections, oldValue);
                entry.setValue(newValue);
                continue;
            }
            if (newValue.isPlaceholder() && newValue == resolvedPlaceholders.get(name)) continue;
            ClassNode replacementType = StaticTypeCheckingSupport.extractType(newValue);
            ClassNode classNode = suitabilityType = !replacementType.isGenericsPlaceHolder() ? replacementType : Optional.ofNullable(replacementType.getGenericsTypes()).map(gts -> StaticTypeCheckingSupport.extractType(gts[0])).orElse(replacementType.redirect());
            if (!oldValue.isCompatibleWith(suitabilityType)) continue;
            if (newValue.isWildcard() && newValue.getLowerBound() == null && newValue.getUpperBounds() == null) {
                entry.setValue(replacementType.asGenericsType());
                continue;
            }
            entry.setValue(newValue);
        }
    }

    private static ClassNode extractType(GenericsType gt) {
        ClassNode cn;
        if (!gt.isPlaceholder()) {
            cn = StaticTypeCheckingSupport.getCombinedBoundType(gt);
        } else {
            cn = gt.getType().redirect();
            if (gt.getType().getGenericsTypes() != null) {
                gt = gt.getType().getGenericsTypes()[0];
            }
            if (gt.getLowerBound() != null) {
                cn = gt.getLowerBound();
            } else if (DefaultGroovyMethods.asBoolean((Object[])gt.getUpperBounds())) {
                cn = gt.getUpperBounds()[0];
            }
        }
        return cn;
    }

    private static boolean equalIncludingGenerics(GenericsType orig, GenericsType copy) {
        ClassNode[] upper2;
        ClassNode lower2;
        if (orig == copy) {
            return true;
        }
        if (orig.isPlaceholder() != copy.isPlaceholder()) {
            return false;
        }
        if (orig.isWildcard() != copy.isWildcard()) {
            return false;
        }
        if (!StaticTypeCheckingSupport.equalIncludingGenerics(orig.getType(), copy.getType())) {
            return false;
        }
        ClassNode lower1 = orig.getLowerBound();
        if (lower1 == null ^ (lower2 = copy.getLowerBound()) == null) {
            return false;
        }
        if (lower1 != lower2 && !StaticTypeCheckingSupport.equalIncludingGenerics(lower1, lower2)) {
            return false;
        }
        ClassNode[] upper1 = orig.getUpperBounds();
        if (upper1 == null ^ (upper2 = copy.getUpperBounds()) == null) {
            return false;
        }
        if (upper1 != upper2) {
            if (upper1.length != upper2.length) {
                return false;
            }
            int i = 0;
            int n = upper1.length;
            while (i < n) {
                if (!StaticTypeCheckingSupport.equalIncludingGenerics(upper1[i], upper2[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean equalIncludingGenerics(ClassNode orig, ClassNode copy) {
        GenericsType[] gt2;
        if (orig == copy) {
            return true;
        }
        if (orig.isGenericsPlaceHolder() != copy.isGenericsPlaceHolder()) {
            return false;
        }
        if (!orig.equals(copy)) {
            return false;
        }
        GenericsType[] gt1 = orig.getGenericsTypes();
        if (gt1 == null ^ (gt2 = orig.getGenericsTypes()) == null) {
            return false;
        }
        if (gt1 != gt2) {
            if (gt1.length != gt2.length) {
                return false;
            }
            int i = 0;
            int n = gt1.length;
            while (i < n) {
                if (!StaticTypeCheckingSupport.equalIncludingGenerics(gt1[i], gt2[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    static void extractGenericsConnections(Map<GenericsType.GenericsTypeName, GenericsType> connections, ClassNode type, ClassNode target) {
        if (target == null || target == type || !target.isGenericsPlaceHolder() && !StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(target)) {
            return;
        }
        if (type == null || type == UNKNOWN_PARAMETER_TYPE) {
            return;
        }
        if (target.isGenericsPlaceHolder()) {
            connections.put(new GenericsType.GenericsTypeName(target.getUnresolvedName()), new GenericsType(type));
        } else if (type.isGenericsPlaceHolder()) {
            StaticTypeCheckingSupport.extractGenericsConnections(connections, StaticTypeCheckingSupport.extractType(new GenericsType(type)), target);
        } else if (type.isArray() && target.isArray()) {
            StaticTypeCheckingSupport.extractGenericsConnections(connections, type.getComponentType(), target.getComponentType());
        } else if (type.equals(ClassHelper.CLOSURE_TYPE) && ClassHelper.isSAMType(target)) {
            ClassNode returnType = StaticTypeCheckingVisitor.wrapTypeIfNecessary((ClassNode)GenericsUtils.parameterizeSAM(target).getV2());
            StaticTypeCheckingSupport.extractGenericsConnections(connections, type.getGenericsTypes(), new GenericsType[]{new GenericsType(returnType)});
        } else if (type.equals(target)) {
            StaticTypeCheckingSupport.extractGenericsConnections(connections, type.getGenericsTypes(), target.getGenericsTypes());
        } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, target)) {
            ClassNode superClass = GenericsUtils.getSuperClass(type, target);
            if (superClass != null) {
                GenericsType[] tp;
                if (GenericsUtils.hasUnresolvedGenerics(superClass) && (tp = type.redirect().getGenericsTypes()) != null) {
                    Object[] ta = type.getGenericsTypes();
                    if (!DefaultGroovyMethods.asBoolean((Object[])ta) || !type.isRedirectNode()) {
                        ta = (GenericsType[])Arrays.stream(tp).map(gt -> GenericsUtils.buildWildcardType(gt.getUpperBounds() != null ? gt.getUpperBounds()[0] : gt.getType().redirect())).toArray(GenericsType[]::new);
                    }
                    HashMap<GenericsType.GenericsTypeName, GenericsType> spec = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                    StaticTypeCheckingSupport.extractGenericsConnections(spec, (GenericsType[])ta, tp);
                    superClass = StaticTypeCheckingSupport.applyGenericsContext(spec, superClass);
                }
                StaticTypeCheckingSupport.extractGenericsConnections(connections, superClass, target);
            } else {
                throw new GroovyBugError("The type " + type + " seems not to normally extend " + target + ". Sorry, I cannot handle this.");
            }
        }
    }

    public static ClassNode getCorrectedClassNode(ClassNode type, ClassNode superClass, boolean handlingGenerics) {
        if (handlingGenerics && GenericsUtils.hasUnresolvedGenerics(type)) {
            return superClass.getPlainNodeReference();
        }
        return GenericsUtils.correctToGenericsSpecRecurse(GenericsUtils.createGenericsSpec(type), superClass);
    }

    private static void extractGenericsConnections(Map<GenericsType.GenericsTypeName, GenericsType> connections, GenericsType[] usage, GenericsType[] declaration) {
        if (usage == null || declaration == null || declaration.length == 0) {
            return;
        }
        int n = usage.length;
        if (n != declaration.length) {
            return;
        }
        int i = 0;
        while (i < n) {
            GenericsType ui = usage[i];
            GenericsType di = declaration[i];
            if (di.isPlaceholder()) {
                connections.put(new GenericsType.GenericsTypeName(di.getName()), ui);
            } else if (di.isWildcard()) {
                if (!StaticTypeCheckingSupport.isUnboundedWildcard(di)) {
                    ClassNode boundType;
                    boolean lowerBound = di.getLowerBound() != null;
                    ClassNode classNode = boundType = lowerBound ? di.getLowerBound() : di.getUpperBounds()[0];
                    if (ui.isWildcard()) {
                        if (lowerBound) {
                            StaticTypeCheckingSupport.extractGenericsConnections(connections, ui.getLowerBound(), boundType);
                        } else if (ui.getUpperBounds() != null) {
                            ClassNode[] classNodeArray = ui.getUpperBounds();
                            int n2 = classNodeArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                ClassNode ub = classNodeArray[n3];
                                StaticTypeCheckingSupport.extractGenericsConnections(connections, ub, boundType);
                                ++n3;
                            }
                        }
                    } else if (boundType.isGenericsPlaceHolder()) {
                        ui = new GenericsType(ui.getType());
                        if (lowerBound) {
                            ui.setWildcard(true);
                        }
                        String placeholderName = boundType.getUnresolvedName();
                        connections.put(new GenericsType.GenericsTypeName(placeholderName), ui);
                    } else {
                        StaticTypeCheckingSupport.extractGenericsConnections(connections, ui.getType(), boundType);
                    }
                }
            } else {
                StaticTypeCheckingSupport.extractGenericsConnections(connections, ui.getType(), di.getType());
            }
            ++i;
        }
    }

    static GenericsType[] getGenericsWithoutArray(ClassNode type) {
        if (type.isArray()) {
            return StaticTypeCheckingSupport.getGenericsWithoutArray(type.getComponentType());
        }
        return type.getGenericsTypes();
    }

    static GenericsType[] applyGenericsContext(Map<GenericsType.GenericsTypeName, GenericsType> spec, GenericsType[] gts) {
        if (gts == null || spec == null || spec.isEmpty()) {
            return gts;
        }
        GenericsType[] newGTs = new GenericsType[gts.length];
        int i = 0;
        int n = gts.length;
        while (i < n) {
            GenericsType gt = gts[i];
            newGTs[i] = StaticTypeCheckingSupport.applyGenericsContext(spec, gt);
            ++i;
        }
        return newGTs;
    }

    private static GenericsType applyGenericsContext(Map<GenericsType.GenericsTypeName, GenericsType> spec, GenericsType gt) {
        ClassNode newType;
        if (gt.isPlaceholder()) {
            GenericsType.GenericsTypeName name = new GenericsType.GenericsTypeName(gt.getName());
            GenericsType specType = spec.get(name);
            if (specType != null) {
                return specType;
            }
            if (StaticTypeCheckingSupport.hasNonTrivialBounds(gt)) {
                GenericsType newGT = new GenericsType(gt.getType(), StaticTypeCheckingSupport.applyGenericsContext(spec, gt.getUpperBounds()), StaticTypeCheckingSupport.applyGenericsContext(spec, gt.getLowerBound()));
                newGT.setPlaceholder(true);
                return newGT;
            }
            return gt;
        }
        if (gt.isWildcard()) {
            GenericsType newGT = new GenericsType(gt.getType(), StaticTypeCheckingSupport.applyGenericsContext(spec, gt.getUpperBounds()), StaticTypeCheckingSupport.applyGenericsContext(spec, gt.getLowerBound()));
            newGT.setWildcard(true);
            return newGT;
        }
        ClassNode type = gt.getType();
        if (type.isArray()) {
            newType = StaticTypeCheckingSupport.applyGenericsContext(spec, type.getComponentType()).makeArray();
        } else {
            if (type.getGenericsTypes() == null) {
                return gt;
            }
            newType = type.getPlainNodeReference();
            newType.setGenericsPlaceHolder(type.isGenericsPlaceHolder());
            newType.setGenericsTypes(StaticTypeCheckingSupport.applyGenericsContext(spec, type.getGenericsTypes()));
        }
        return new GenericsType(newType);
    }

    private static boolean hasNonTrivialBounds(GenericsType gt) {
        if (gt.isWildcard()) {
            return true;
        }
        if (gt.getLowerBound() != null) {
            return true;
        }
        ClassNode[] upperBounds = gt.getUpperBounds();
        if (upperBounds != null) {
            return upperBounds.length != 1 || upperBounds[0].isGenericsPlaceHolder() || !ClassHelper.OBJECT_TYPE.equals(upperBounds[0]);
        }
        return false;
    }

    static ClassNode[] applyGenericsContext(Map<GenericsType.GenericsTypeName, GenericsType> spec, ClassNode[] types) {
        if (types == null) {
            return null;
        }
        int nTypes = types.length;
        ClassNode[] newTypes = new ClassNode[nTypes];
        int i = 0;
        while (i < nTypes) {
            newTypes[i] = StaticTypeCheckingSupport.applyGenericsContext(spec, types[i]);
            ++i;
        }
        return newTypes;
    }

    static ClassNode applyGenericsContext(Map<GenericsType.GenericsTypeName, GenericsType> spec, ClassNode type) {
        if (type == null || !StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(type)) {
            return type;
        }
        if (type.isArray()) {
            return StaticTypeCheckingSupport.applyGenericsContext(spec, type.getComponentType()).makeArray();
        }
        GenericsType[] gt = type.getGenericsTypes();
        if (gt == null) {
            return type;
        }
        if (DefaultGroovyMethods.asBoolean(spec)) {
            gt = StaticTypeCheckingSupport.applyGenericsContext(spec, gt);
        }
        if (!type.isGenericsPlaceHolder()) {
            ClassNode cn = type.getPlainNodeReference();
            cn.setGenericsTypes(gt);
            return cn;
        }
        if (!gt[0].isPlaceholder()) {
            return StaticTypeCheckingSupport.getCombinedBoundType(gt[0]);
        }
        if (type.getGenericsTypes()[0] != gt[0]) {
            ClassNode cn = ClassHelper.make(gt[0].getName());
            ClassNode erasure = StaticTypeCheckingSupport.getCombinedBoundType(gt[0]).redirect();
            cn.setGenericsPlaceHolder(true);
            cn.setGenericsTypes(gt);
            cn.setRedirect(erasure);
            return cn;
        }
        return type;
    }

    static ClassNode getCombinedBoundType(GenericsType genericsType) {
        if (StaticTypeCheckingSupport.hasNonTrivialBounds(genericsType)) {
            if (genericsType.getLowerBound() != null) {
                return ClassHelper.OBJECT_TYPE;
            }
            if (genericsType.getUpperBounds() != null) {
                return genericsType.getUpperBounds()[0];
            }
        }
        return genericsType.getType();
    }

    static GenericsType getCombinedGenericsType(GenericsType gt1, GenericsType gt2) {
        if (StaticTypeCheckingSupport.isUnboundedWildcard(gt1) != StaticTypeCheckingSupport.isUnboundedWildcard(gt2)) {
            return StaticTypeCheckingSupport.isUnboundedWildcard(gt2) ? gt1 : gt2;
        }
        ClassNode cn1 = GenericsUtils.makeClassSafe0(ClassHelper.CLASS_Type, gt1);
        ClassNode cn2 = GenericsUtils.makeClassSafe0(ClassHelper.CLASS_Type, gt2);
        ClassNode lub = WideningCategories.lowestUpperBound(cn1, cn2);
        return lub.getGenericsTypes()[0];
    }

    private static Map<GenericsType.GenericsTypeName, GenericsType> getGenericsParameterMapOfThis(ClassNode cn) {
        if (cn == null) {
            return null;
        }
        Map<GenericsType.GenericsTypeName, GenericsType> map = null;
        if (cn.getEnclosingMethod() != null) {
            map = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(cn.getEnclosingMethod());
        } else if (cn.getOuterClass() != null) {
            map = StaticTypeCheckingSupport.getGenericsParameterMapOfThis(cn.getOuterClass());
        }
        map = StaticTypeCheckingSupport.mergeGenerics(map, cn.getGenericsTypes());
        return map;
    }

    static ClassNode boundUnboundedWildcards(ClassNode type) {
        if (type.isArray()) {
            return StaticTypeCheckingSupport.boundUnboundedWildcards(type.getComponentType()).makeArray();
        }
        ClassNode redirect = type.redirect();
        if (redirect == null || redirect == type || !StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(redirect)) {
            return type;
        }
        ClassNode newType = type.getPlainNodeReference();
        newType.setGenericsPlaceHolder(type.isGenericsPlaceHolder());
        newType.setGenericsTypes(StaticTypeCheckingSupport.boundUnboundedWildcards(type.getGenericsTypes(), redirect.getGenericsTypes()));
        return newType;
    }

    private static GenericsType[] boundUnboundedWildcards(GenericsType[] actual, GenericsType[] declared) {
        int n = actual.length;
        GenericsType[] newTypes = new GenericsType[n];
        int i = 0;
        while (i < n) {
            newTypes[i] = StaticTypeCheckingSupport.boundUnboundedWildcard(actual[i], declared[i]);
            ++i;
        }
        return newTypes;
    }

    private static GenericsType boundUnboundedWildcard(GenericsType actual, GenericsType declared) {
        if (!StaticTypeCheckingSupport.isUnboundedWildcard(actual)) {
            return actual;
        }
        ClassNode lowerBound = declared.getLowerBound();
        ClassNode[] upperBounds = declared.getUpperBounds();
        if (lowerBound != null) {
            assert (upperBounds == null);
        } else if (upperBounds == null) {
            upperBounds = new ClassNode[]{ClassHelper.OBJECT_TYPE};
        } else if (declared.isPlaceholder()) {
            upperBounds = (ClassNode[])upperBounds.clone();
            int i = 0;
            int n = upperBounds.length;
            while (i < n) {
                if (GenericsUtils.extractPlaceholders(upperBounds[i]).containsKey(new GenericsType.GenericsTypeName(declared.getName()))) {
                    upperBounds[i] = upperBounds[i].getPlainNodeReference();
                }
                ++i;
            }
        }
        GenericsType newType = new GenericsType(ClassHelper.makeWithoutCaching("?"), upperBounds, lowerBound);
        newType.setWildcard(true);
        return newType;
    }

    public static boolean isUnboundedWildcard(GenericsType gt) {
        if (gt.isWildcard() && gt.getLowerBound() == null) {
            ClassNode[] upperBounds = gt.getUpperBounds();
            return upperBounds == null || upperBounds.length == 0 || upperBounds.length == 1 && upperBounds[0].equals(ClassHelper.OBJECT_TYPE) && !upperBounds[0].isGenericsPlaceHolder();
        }
        return false;
    }

    static Map<GenericsType.GenericsTypeName, GenericsType> extractGenericsParameterMapOfThis(TypeCheckingContext context) {
        ClassNode cn = context.getEnclosingClassNode();
        MethodNode mn = context.getEnclosingMethod();
        if (cn != null && cn.getEnclosingMethod() == mn) {
            return StaticTypeCheckingSupport.getGenericsParameterMapOfThis(cn);
        }
        return StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(mn);
    }

    private static Map<GenericsType.GenericsTypeName, GenericsType> extractGenericsParameterMapOfThis(MethodNode mn) {
        if (mn == null) {
            return null;
        }
        Map<Object, Object> map = mn.isStatic() ? new HashMap() : StaticTypeCheckingSupport.getGenericsParameterMapOfThis(mn.getDeclaringClass());
        return StaticTypeCheckingSupport.mergeGenerics(map, mn.getGenericsTypes());
    }

    private static Map<GenericsType.GenericsTypeName, GenericsType> mergeGenerics(Map<GenericsType.GenericsTypeName, GenericsType> current, GenericsType[] newGenerics) {
        if (newGenerics == null || newGenerics.length == 0) {
            return current;
        }
        if (current == null) {
            current = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        }
        GenericsType[] genericsTypeArray = newGenerics;
        int n = newGenerics.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType.GenericsTypeName name;
            GenericsType gt = genericsTypeArray[n2];
            if (gt.isPlaceholder() && !current.containsKey(name = new GenericsType.GenericsTypeName(gt.getName()))) {
                current.put(name, gt);
            }
            ++n2;
        }
        return current;
    }

    public static List<MethodNode> filterMethodsByVisibility(List<MethodNode> methodNodeList, ClassNode enclosingClassNode) {
        if (!DefaultGroovyMethods.asBoolean(methodNodeList)) {
            return Collections.emptyList();
        }
        LinkedList<MethodNode> result = new LinkedList<MethodNode>();
        List<ClassNode> outers = enclosingClassNode.getOuterClasses();
        block0: for (MethodNode methodNode : methodNodeList) {
            if (methodNode instanceof ExtensionMethodNode) {
                result.add(methodNode);
                continue;
            }
            ClassNode declaringClass = methodNode.getDeclaringClass();
            if (DefaultGroovyMethods.asBoolean(outers)) {
                for (ClassNode outerClass : outers) {
                    if (!outerClass.isDerivedFrom(declaringClass)) continue;
                    if (outerClass.equals(declaringClass)) {
                        result.add(methodNode);
                        continue block0;
                    }
                    if (!methodNode.isPublic() && !methodNode.isProtected()) continue;
                    result.add(methodNode);
                    continue block0;
                }
            }
            if (declaringClass.getOuterClass() != null && declaringClass.getOuterClasses().contains(enclosingClassNode)) {
                result.add(methodNode);
                continue;
            }
            if (methodNode.isPrivate() && !enclosingClassNode.equals(declaringClass) || methodNode.isProtected() && !enclosingClassNode.isDerivedFrom(declaringClass) && !ClassNodeUtils.samePackageName((ClassNode)enclosingClassNode, (ClassNode)declaringClass) || methodNode.isPackageScope() && !ClassNodeUtils.samePackageName((ClassNode)enclosingClassNode, (ClassNode)declaringClass)) continue;
            result.add(methodNode);
        }
        return result;
    }

    public static boolean isGStringOrGStringStringLUB(ClassNode node) {
        return ClassHelper.GSTRING_TYPE.equals(node) || GSTRING_STRING_CLASSNODE.equals(node);
    }

    public static boolean isParameterizedWithGStringOrGStringString(ClassNode node) {
        GenericsType[] genericsTypes;
        if (node.isArray()) {
            return StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(node.getComponentType());
        }
        if (node.isUsingGenerics() && (genericsTypes = node.getGenericsTypes()) != null) {
            GenericsType[] genericsTypeArray = genericsTypes;
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (StaticTypeCheckingSupport.isGStringOrGStringStringLUB(genericsType.getType())) {
                    return true;
                }
                ++n2;
            }
        }
        return node.getSuperClass() != null && StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(node.getUnresolvedSuperClass());
    }

    public static boolean isParameterizedWithString(ClassNode node) {
        GenericsType[] genericsTypes;
        if (node.isArray()) {
            return StaticTypeCheckingSupport.isParameterizedWithString(node.getComponentType());
        }
        if (node.isUsingGenerics() && (genericsTypes = node.getGenericsTypes()) != null) {
            GenericsType[] genericsTypeArray = genericsTypes;
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (ClassHelper.STRING_TYPE.equals(genericsType.getType())) {
                    return true;
                }
                ++n2;
            }
        }
        return node.getSuperClass() != null && StaticTypeCheckingSupport.isParameterizedWithString(node.getUnresolvedSuperClass());
    }

    public static boolean missesGenericsTypes(ClassNode cn) {
        while (cn.isArray()) {
            cn = cn.getComponentType();
        }
        GenericsType[] cnGenerics = cn.getGenericsTypes();
        GenericsType[] rnGenerics = cn.redirect().getGenericsTypes();
        return cnGenerics == null || cnGenerics.length == 0 ? rnGenerics != null : GenericsUtils.hasUnresolvedGenerics(cn);
    }

    public static Object evaluateExpression(Expression expr, CompilerConfiguration config) {
        return StaticTypeCheckingSupport.evaluateExpression(expr, config, null);
    }

    public static Object evaluateExpression(Expression expr, CompilerConfiguration config, GroovyClassLoader loader) {
        Expression ce;
        Expression expression = ce = expr instanceof CastExpression ? ((CastExpression)expr).getExpression() : expr;
        if (ce instanceof ConstantExpression) {
            if (expr.getType().equals(ClassHelper.getWrapper(ce.getType())) || ((ConstantExpression)ce).isNullExpression()) {
                return ((ConstantExpression)ce).getValue();
            }
        } else if (ce instanceof ListExpression && expr.getType().isArray() && expr.getType().getComponentType().equals(ClassHelper.STRING_TYPE)) {
            return ((ListExpression)ce).getExpressions().stream().map(e -> StaticTypeCheckingSupport.evaluateExpression(e, config, loader)).toArray(String[]::new);
        }
        String className = "Expression$" + UUID.randomUUID().toString().replace('-', '$');
        ClassNode classNode = new ClassNode(className, 1, ClassHelper.OBJECT_TYPE);
        ClassNodeUtils.addGeneratedMethod((ClassNode)classNode, (String)"eval", (int)9, (ClassNode)ClassHelper.OBJECT_TYPE, (Parameter[])Parameter.EMPTY_ARRAY, (ClassNode[])ClassNode.EMPTY_ARRAY, (Statement)new ReturnStatement(expr));
        CompilerConfiguration cc = new CompilerConfiguration(config);
        cc.setPreviewFeatures(false);
        cc.setScriptBaseClass(null);
        cc.setTargetBytecode(CompilerConfiguration.DEFAULT.getTargetBytecode());
        CompilationUnit cu = new CompilationUnit(cc, null, loader);
        try {
            cu.addClassNode(classNode);
            cu.compile(7);
            GroovyClass gc = cu.getClasses().get(0);
            Class c = cu.getClassLoader().defineClass(className, gc.getBytes());
            Object object = c.getMethod("eval", new Class[0]).invoke(null, new Object[0]);
            return object;
        }
        catch (ReflectiveOperationException e2) {
            throw new GroovyBugError((Exception)e2);
        }
        finally {
            if (loader == null) {
                DefaultGroovyMethodsSupport.closeQuietly((Closeable)cu.getClassLoader());
            }
        }
    }

    public static Set<ClassNode> collectAllInterfaces(ClassNode node) {
        HashSet<ClassNode> result = new HashSet<ClassNode>();
        StaticTypeCheckingSupport.collectAllInterfaces(node, result);
        return result;
    }

    private static void collectAllInterfaces(ClassNode node, Set<ClassNode> out) {
        if (node == null) {
            return;
        }
        Set<ClassNode> allInterfaces = node.getAllInterfaces();
        out.addAll(allInterfaces);
        StaticTypeCheckingSupport.collectAllInterfaces(node.getSuperClass(), out);
    }

    public static boolean isClassClassNodeWrappingConcreteType(ClassNode classNode) {
        GenericsType[] genericsTypes = classNode.getGenericsTypes();
        return ClassHelper.CLASS_Type.equals(classNode) && classNode.isUsingGenerics() && genericsTypes != null && !genericsTypes[0].isPlaceholder() && !genericsTypes[0].isWildcard();
    }

    public static List<MethodNode> findSetters(ClassNode cn, String setterName, boolean voidOnly) {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        if (!cn.isInterface()) {
            for (MethodNode method : cn.getMethods(setterName)) {
                if (!StaticTypeCheckingSupport.isSetter(method, voidOnly)) continue;
                result.add(method);
            }
        }
        for (ClassNode in : cn.getAllInterfaces()) {
            for (MethodNode method : in.getDeclaredMethods(setterName)) {
                if (!StaticTypeCheckingSupport.isSetter(method, voidOnly)) continue;
                result.add(method);
            }
        }
        return result;
    }

    private static boolean isSetter(MethodNode mn, boolean voidOnly) {
        return (!voidOnly || mn.isVoidMethod()) && mn.getParameters().length == 1;
    }

    public static ClassNode isTraitSelf(VariableExpression vexp) {
        if ("$self".equals(vexp.getName())) {
            ClassNode type;
            Variable accessedVariable = vexp.getAccessedVariable();
            ClassNode classNode = type = accessedVariable != null ? accessedVariable.getType() : null;
            if (accessedVariable instanceof Parameter && Traits.isTrait(type)) {
                return type;
            }
        }
        return null;
    }

    public static class BooleanArrayStaticTypesHelper {
        public static Boolean getAt(boolean[] array, int index) {
            return array != null ? Boolean.valueOf(array[index]) : null;
        }

        public static void putAt(boolean[] array, int index, boolean value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }

    public static class ByteArrayStaticTypesHelper {
        public static Byte getAt(byte[] array, int index) {
            return array != null ? Byte.valueOf(array[index]) : null;
        }

        public static void putAt(byte[] array, int index, byte value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }

    public static class CharArrayStaticTypesHelper {
        public static Character getAt(char[] array, int index) {
            return array != null ? Character.valueOf(array[index]) : null;
        }

        public static void putAt(char[] array, int index, char value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }

    public static class DoubleArrayStaticTypesHelper {
        public static Double getAt(double[] array, int index) {
            return array != null ? Double.valueOf(array[index]) : null;
        }

        public static void putAt(double[] array, int index, double value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }

    public static class FloatArrayStaticTypesHelper {
        public static Float getAt(float[] array, int index) {
            return array != null ? Float.valueOf(array[index]) : null;
        }

        public static void putAt(float[] array, int index, float value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }

    public static class IntArrayStaticTypesHelper {
        public static Integer getAt(int[] array, int index) {
            return array != null ? Integer.valueOf(array[index]) : null;
        }

        public static void putAt(int[] array, int index, int value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }

    public static class LongArrayStaticTypesHelper {
        public static Long getAt(long[] array, int index) {
            return array != null ? Long.valueOf(array[index]) : null;
        }

        public static void putAt(long[] array, int index, long value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }

    public static class ObjectArrayStaticTypesHelper {
        public static <T> T getAt(T[] array, int index) {
            return array != null ? (T)array[index] : null;
        }

        public static <T, U extends T> void putAt(T[] array, int index, U value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }

    public static class ShortArrayStaticTypesHelper {
        public static Short getAt(short[] array, int index) {
            return array != null ? Short.valueOf(array[index]) : null;
        }

        public static void putAt(short[] array, int index, short value) {
            if (array != null) {
                array[index] = value;
            }
        }
    }
}

