/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.classpath;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.keyword.internal.KeywordContributorCollection;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.classpath.BuildPathEntry;
import com.kms.katalon.execution.classpath.BundleBuildPath;
import com.kms.katalon.execution.classpath.FolderBuildPath;
import com.kms.katalon.execution.classpath.IBuildPath;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.selenium.TempClass;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.FrameworkUtil;

public class ProjectBuildPath {
    private static final String EXTERNAL_DRIVERS_FOLDER = "Drivers";
    private static final String PLUGINS_FOLDER = "Plugins";
    public static final String DF_OUT_PUT_LOC = "bin";
    private ProjectEntity project;

    public ProjectBuildPath(ProjectEntity project) {
        this.project = project;
    }

    public FolderBuildPath getLibBuildPath() {
        return new FolderBuildPath(this.project.getFolderLocation()){

            @Override
            public String getInputLocation() {
                return new File(ProjectBuildPath.this.project.getFolderLocation(), "Libs").getAbsolutePath();
            }

            @Override
            public File[] getBuildableFiles() {
                ArrayList<File> builtFiles = new ArrayList<File>();
                File[] fileArray = new File(this.getInputLocation()).listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!f.getName().startsWith("Temp")) {
                        builtFiles.add(f);
                    }
                    ++n2;
                }
                return builtFiles.toArray(new File[builtFiles.size()]);
            }
        };
    }

    public FolderBuildPath getKeywordBuildPath() {
        return new FolderBuildPath(this.project.getFolderLocation()){

            @Override
            public String getInputLocation() {
                return new File(ProjectBuildPath.this.project.getFolderLocation(), "Keywords").getAbsolutePath();
            }

            @Override
            public File[] getBuildableFiles() {
                return FileUtils.listFiles((File)new File(this.getInputLocation()), (String[])new String[]{"groovy"}, (boolean)false).toArray(new File[0]);
            }
        };
    }

    public List<IBuildPath> getCustomKeywordPaths() throws ControllerException {
        List customKeywordPluginFiles = ProjectController.getInstance().getCustomKeywordPlugins(this.project);
        ArrayList<IBuildPath> customKeywordBuildPaths = new ArrayList<IBuildPath>();
        for (File jarFile : customKeywordPluginFiles) {
            BuildPathEntry jarFileEntry = new BuildPathEntry(jarFile.getAbsolutePath());
            customKeywordBuildPaths.add(jarFileEntry);
        }
        return customKeywordBuildPaths;
    }

    public List<String> getCustomKeywordPathLocations() throws ControllerException, IOException {
        ArrayList<String> customKeywordPluginPaths = new ArrayList<String>();
        for (IBuildPath entryBuildPath : this.getCustomKeywordPaths()) {
            customKeywordPluginPaths.add(entryBuildPath.getBuildPathLocation());
        }
        return customKeywordPluginPaths;
    }

    public List<BundleBuildPath> getBundleBuildpaths() {
        ArrayList<BundleBuildPath> bundlePaths = new ArrayList<BundleBuildPath>();
        bundlePaths.add(new BundleBuildPath(Platform.getBundle((String)"com.kms.katalon.core")));
        for (IKeywordContributor contributor : KeywordContributorCollection.getKeywordContributors()) {
            bundlePaths.add(new BundleBuildPath(FrameworkUtil.getBundle(contributor.getClass())));
        }
        bundlePaths.add(new BundleBuildPath(FrameworkUtil.getBundle(AppiumDriverManager.class)));
        bundlePaths.add(new BundleBuildPath(FrameworkUtil.getBundle(TempClass.class)));
        bundlePaths.add(new BundleBuildPath(FrameworkUtil.getBundle(CryptoUtil.class)));
        bundlePaths.add(new BundleBuildPath(FrameworkUtil.getBundle(IProgressMonitor.class)));
        return bundlePaths;
    }

    private List<IBuildPath> getExternalBuildPaths() throws IOException {
        File externalDriversFolder = this.getExternalLibrariesDir();
        if (!externalDriversFolder.exists()) {
            return Collections.emptyList();
        }
        ArrayList<IBuildPath> externalLibBuildPaths = new ArrayList<IBuildPath>();
        File[] fileArray = externalDriversFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            externalLibBuildPaths.add(new BuildPathEntry(jarFile.getAbsolutePath()));
            ++n2;
        }
        return externalLibBuildPaths;
    }

    public File getExternalLibrariesDir() {
        return new File(this.project.getFolderLocation(), EXTERNAL_DRIVERS_FOLDER);
    }

    private List<String> getExternalBuildPathLoc() throws IOException {
        ArrayList<String> bundleBpLocs = new ArrayList<String>();
        for (IBuildPath buildPath : this.getExternalBuildPaths()) {
            bundleBpLocs.add(buildPath.getBuildPathLocation());
        }
        return bundleBpLocs;
    }

    public List<String> getClassPaths() throws IOException, ControllerException {
        ArrayList<String> classPaths = new ArrayList<String>();
        classPaths.addAll(this.getBundleBuildPathLoc());
        classPaths.addAll(this.getExternalBuildPathLoc());
        classPaths.addAll(this.getCustomKeywordPathLocations());
        List excludedJarFileNames = GroovyUtil.getExcludedJarFileNames((ProjectEntity)this.project);
        for (String excludedJarFileName : excludedJarFileNames) {
            classPaths.removeIf(entry -> {
                String entryFileName = FilenameUtils.getName((String)entry);
                return entryFileName.equals(excludedJarFileName);
            });
        }
        return classPaths;
    }

    private List<String> getBundleBuildPathLoc() throws IOException {
        ArrayList<String> bundleBpLocs = new ArrayList<String>();
        for (BundleBuildPath bd : this.getBundleBuildpaths()) {
            bundleBpLocs.add(bd.getBuildPathLocation());
            for (IBuildPath requiredBp : bd.getChildBuildPaths()) {
                String bpLoc = requiredBp.getBuildPathLocation();
                if (bundleBpLocs.contains(bpLoc)) continue;
                bundleBpLocs.add(bpLoc);
            }
        }
        return bundleBpLocs;
    }
}

