/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration;

import com.google.gson.Gson;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IExecutionSetting;
import com.kms.katalon.configuration.core.interfaces.IHostConfiguration;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.custom.improvement.factory.NewPluginTestListenerFactory;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.collector.ExecutionPropertiesCollector;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.configuration.impl.LocalHostConfiguration;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.generator.FeatureFileScriptGenerator;
import com.kms.katalon.execution.generator.TestCaseBindingScriptGenerator;
import com.kms.katalon.execution.generator.TestCaseScriptGenerator;
import com.kms.katalon.execution.generator.TestSuiteScriptGenerator;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.logging.LogConfigurator;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.ISessionController;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractRunConfiguration
implements IRunConfiguration {
    protected IHostConfiguration hostConfiguration;
    protected DefaultExecutionSetting executionSetting;
    protected IEclipseContext context;
    private ExecutionProfileEntity executionProfile;
    private Map<String, Object> overridingParameters = new HashMap<String, Object>();
    private Map<String, Object> overridingGlobalVariables = new HashMap<String, Object>();
    private Map<String, Object> overridingProtectedGlobalVariables = new HashMap<String, Object>();
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private List<String> vmArgs = new ArrayList<String>();
    private Map<String, String> additionalData = new HashMap<String, String>();
    private Map<String, String> additionalInfo = new HashMap<String, String>();
    private String executionUUID;
    private String executionSessionId;
    private boolean isDebugLaunchMode = false;
    private ISessionController sessionController;
    private IFeatureController featureController;

    public AbstractRunConfiguration() {
        BundleContext bundleContext = FrameworkUtil.getBundle(AbstractRunConfiguration.class).getBundleContext();
        this.context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.sessionController = (ISessionController)this.context.get(ISessionController.class);
        this.featureController = (IFeatureController)this.context.get(IFeatureController.class);
        this.setupConfiguration();
    }

    protected void setupConfiguration() {
        this.doInitExecutionSetting();
        this.initVmArguments();
    }

    protected void doInitExecutionSetting() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        this.executionSessionId = dateFormat.format(new Date());
        this.initExecutionSetting();
    }

    protected void initVmArguments() {
        if (this.featureController.canUse(ProductFeature.LAUNCH_ARGUMENTS_SETTINGS)) {
            this.vmArgs.addAll(Arrays.asList(ExecutionUtil.getVmArgs()));
        }
    }

    public final IExecutionSetting build(FileEntity fileEntity, IExecutedEntity executedEntity) throws IOException, ExecutionException {
        this.init(fileEntity);
        this.executionSetting.setExecutedEntity(executedEntity);
        this.hostConfiguration = new LocalHostConfiguration();
        this.generateLogFolder(fileEntity);
        File scriptFile = this.generateTempScriptFile(fileEntity);
        this.generateExecutionProperties();
        this.executionSetting.setScriptFile(scriptFile);
        return this.executionSetting;
    }

    protected File generateTempScriptFile(FileEntity fileEntity) throws ExecutionException {
        try {
            if (fileEntity instanceof TestSuiteEntity) {
                String retryFailedExecutionsTcBindings;
                TestSuiteExecutedEntity t = (TestSuiteExecutedEntity)this.getExecutionSetting().getExecutedEntity();
                if (this.shouldRetryFailedExecutionsOnly(t, retryFailedExecutionsTcBindings = this.additionalData.getOrDefault("retryFailedExecutionsOnlyTcBinding", ""))) {
                    return this.generateTempScriptFileWithCustomRetry(fileEntity, retryFailedExecutionsTcBindings);
                }
                return this.generateTempScriptFileWithDefaultRetry(fileEntity);
            }
            if (fileEntity instanceof TestCaseEntity) {
                TestCaseEntity testCase = (TestCaseEntity)fileEntity;
                if (this.getExecutionSetting().getExecutedEntity() instanceof TestCaseExecutedEntity) {
                    return new TestCaseScriptGenerator(testCase, this).generateScriptFile();
                }
                TestCaseBindingExecutedEntity executedEntity = (TestCaseBindingExecutedEntity)this.getExecutionSetting().getExecutedEntity();
                return new TestCaseBindingScriptGenerator(testCase, this, executedEntity).generateScriptFile();
            }
            if (fileEntity instanceof SystemFileEntity) {
                return new FeatureFileScriptGenerator((SystemFileEntity)fileEntity, this).generateScriptFile();
            }
            throw new ExecutionException("The execution is not supported for this file");
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    private File generateTempScriptFileWithDefaultRetry(FileEntity fileEntity) throws Exception {
        return new TestSuiteScriptGenerator((TestSuiteEntity)fileEntity, this, (TestSuiteExecutedEntity)this.getExecutionSetting().getExecutedEntity()).generateScriptFile();
    }

    private File generateTempScriptFileWithCustomRetry(FileEntity fileEntity, String retryImmediatelyTcBindings) throws Exception {
        return new TestSuiteScriptGenerator((TestSuiteEntity)fileEntity, this, (TestSuiteExecutedEntity)this.getExecutionSetting().getExecutedEntity()).generateScriptFile(retryImmediatelyTcBindings);
    }

    private boolean shouldRetryFailedExecutionsOnly(TestSuiteExecutedEntity t, String retryFailedExecutionsTcBindings) {
        return DefaultRerunSetting.RetryStrategyValue.FAILED_EXECUTIONS.equals((Object)t.getRetryStrategy()) && !"".equals(retryFailedExecutionsTcBindings);
    }

    protected void init(FileEntity fileEntity) throws IOException {
        TestSuiteEntity tsEntity;
        if (fileEntity == null) {
            return;
        }
        if (fileEntity instanceof TestSuiteEntity && !(tsEntity = (TestSuiteEntity)fileEntity).isPageLoadTimeoutDefault()) {
            this.executionSetting.setTimeout(tsEntity.getPageLoadTimeout().shortValue());
        }
    }

    protected void initExecutionSetting() {
        this.executionSetting = new DefaultExecutionSetting();
    }

    protected String getTemporaryLogFolderLocation(FileEntity testCase) {
        try {
            return ReportController.getInstance().generateTemporaryExecutionFolder(testCase);
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected String getLogFolderLocation(TestSuiteEntity testSuite) {
        try {
            return ReportController.getInstance().generateReportFolder(testSuite, this.executionSessionId);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void generateLogFolder(FileEntity fileEntity) {
        String logFolderPath = "";
        if (fileEntity instanceof TestCaseEntity || fileEntity instanceof SystemFileEntity) {
            logFolderPath = this.getTemporaryLogFolderLocation(fileEntity);
        } else if (fileEntity instanceof TestSuiteEntity) {
            logFolderPath = this.getLogFolderLocation((TestSuiteEntity)fileEntity);
        }
        this.executionSetting.setFolderPath(logFolderPath);
    }

    public String getUserFullName() {
        UserInfo userInfo = this.sessionController.getUserInfo();
        return userInfo != null ? userInfo.getFullName() : "";
    }

    public String getProjectName() {
        return ProjectController.getInstance().getCurrentProject().getName();
    }

    public String getProjectFolderLocation() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation().replace(File.separator, "/");
    }

    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        propertyMap.put(StringConstants.NAME, this.getName());
        propertyMap.put("userFullName", this.getUserFullName());
        propertyMap.put("projectName", this.getProjectName());
        propertyMap.put("projectDir", this.getProjectFolderLocation());
        propertyMap.put("host", this.hostConfiguration.getProperties());
        if (this.executionSetting == null) {
            return propertyMap;
        }
        propertyMap.putAll(ExecutionUtil.getExecutionProperties(this.executionSetting, this.getDriverConnectors(), this.executionProfile));
        IExecutedEntity executedEntity = this.executionSetting.getExecutedEntity();
        if (executedEntity == null) {
            return propertyMap;
        }
        if (executedEntity instanceof TestCaseExecutedEntity) {
            propertyMap.put("executedEntity", "TestCase");
        } else {
            propertyMap.put("executedEntity", "TestSuite");
        }
        if (!this.overridingParameters.isEmpty()) {
            propertyMap.put("overridingGlobalVariables", this.overridingParameters);
        }
        propertyMap.put("id", executedEntity.getSourceId());
        propertyMap.put("name", executedEntity.getSourceName());
        propertyMap.put("description", executedEntity.getSourceDescription());
        propertyMap.put("source", executedEntity.getSourcePath());
        ExecutionSessionSocketServer sessionServer = ExecutionSessionSocketServer.getInstance();
        propertyMap.put("sessionServer.host", sessionServer.getServerHost());
        propertyMap.put("sessionServer.port", sessionServer.getServerPort());
        propertyMap.put("isDebugLaunchMode", this.isDebugLaunchMode);
        this.additionalInfo.forEach((key, value) -> propertyMap.put((String)key, value));
        String logbackConfigFileLocation = this.getLogbackConfigFileLocation();
        if (logbackConfigFileLocation != null) {
            propertyMap.put("logbackConfigFileLocation", logbackConfigFileLocation);
        }
        propertyMap.put("katalon.versionNumber", VersionUtil.getCurrentVersion().getVersion());
        propertyMap.put("katalon.buildNumber", String.valueOf(VersionUtil.getCurrentVersion().getBuildNumber()));
        propertyMap.put("runningMode", ApplicationRunningMode.get().name());
        propertyMap.put("pluginTestListeners", NewPluginTestListenerFactory.getInstance().getListeners());
        propertyMap.put("allowUsingSelfHealing", this.featureController.canUse(ProductFeature.SELF_HEALING));
        propertyMap.put("allowUsingTimeCapsule", true);
        propertyMap.put("allowCustomizeRequestTimeout", this.featureController.canUse(ProductFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT));
        propertyMap.put("allowCustomizeRequestResponseSizeLimit", this.featureController.canUse(ProductFeature.CUSTOM_WEB_SERVICE_RESPONSE_SIZE_LIMIT));
        propertyMap.put("allowMobileImageBasedTesting", this.featureController.canUse(ProductFeature.MOBILE_IMAGE_BASED_TESTING));
        propertyMap.put("maxFailedTests", executedEntity.getFailedThreshold());
        propertyMap.put("appiumDirectory", RunConfiguration.getInstance().getAppiumDirectoryDefinedWithArgument());
        AbstractRunConfiguration.setHttpsProtocol(propertyMap);
        ExecutionPropertiesCollector.getInstance().getPropertiesContributors().forEach(contributor -> propertyMap.put(contributor.getKey(), contributor.getExecutionProperties()));
        return propertyMap;
    }

    public static void setHttpsProtocol(Map<String, Object> propertyMap) {
        try {
            String path = new URL(String.valueOf(Platform.getInstallLocation().getURL()) + "katalon.ini").getPath();
            String protocol = PropertySettingStoreUtil.getSettings((String)path).getProperty("-https.protocol");
            if (protocol != null) {
                propertyMap.put("httpsProtocol", protocol);
            }
        }
        catch (IOException iOException) {}
    }

    private String getLogbackConfigFileLocation() {
        String logbackConfigFileLocation = null;
        try {
            File logbackConfigFile = LogConfigurator.getConfigFile((String)"logback-execution.xml");
            if (logbackConfigFile != null && logbackConfigFile.exists()) {
                logbackConfigFileLocation = logbackConfigFile.getAbsolutePath();
            }
        }
        catch (IOException iOException) {}
        return logbackConfigFileLocation;
    }

    public String getName() {
        StringBuilder nameStringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (IDriverConnector driverConnector : this.getDriverConnectors().values()) {
            if (!isFirst) {
                nameStringBuilder.append(" + ");
            }
            nameStringBuilder.append(driverConnector.getDriverType().toString());
            isFirst = false;
        }
        return nameStringBuilder.toString();
    }

    public String getReportDriverName() {
        return this.getName();
    }

    public IHostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public IExecutionSetting getExecutionSetting() {
        return this.executionSetting;
    }

    public final void generateExecutionProperties() throws IOException {
        File settingFile = new File(this.executionSetting.getSettingFilePath());
        Gson gsonObj = new Gson();
        String strJson = gsonObj.toJson(this.getProperties());
        FileUtils.writeStringToFile((File)settingFile, (String)strJson);
    }

    public Map<String, String> getAdditionalEnvironmentVariables() throws IOException, ExecutionException {
        return Collections.unmodifiableMap(this.environmentVariables);
    }

    public boolean allowsRecording() {
        return false;
    }

    public ExecutionProfileEntity getExecutionProfile() {
        return this.executionProfile;
    }

    public void setExecutionProfile(ExecutionProfileEntity executionProfile) {
        this.executionProfile = executionProfile;
    }

    public void setOverridingGlobalVariables(Map<String, Object> overridingGlobalVariables) {
        if (overridingGlobalVariables == null) {
            return;
        }
        this.overridingGlobalVariables.clear();
        this.overridingGlobalVariables.putAll(overridingGlobalVariables);
    }

    public Map<String, Object> getOverridingGlobalVariables() {
        return this.overridingGlobalVariables;
    }

    public void setOverridingProtectedGlobalVariables(Map<String, Object> overridingProtectedGlobalVariables) {
        if (overridingProtectedGlobalVariables == null) {
            return;
        }
        this.overridingProtectedGlobalVariables.clear();
        this.overridingProtectedGlobalVariables.putAll(overridingProtectedGlobalVariables);
    }

    public Map<String, Object> getOverridingProtectedGlobalVariables() {
        return this.overridingProtectedGlobalVariables;
    }

    public Map<String, String> getTestSuiteAdditionalData() {
        return Collections.unmodifiableMap(this.additionalData);
    }

    public void setTestSuiteAdditionalData(Map<String, String> data) {
        if (data != null) {
            this.additionalData.putAll(data);
        }
    }

    public String[] getVmArgs() {
        return this.vmArgs.toArray(new String[0]);
    }

    public void setVmArgs(String[] args) {
        if (args == null) {
            return;
        }
        this.vmArgs.addAll(Arrays.asList(args));
    }

    public void setAdditionalEnvironmentVariables(Map<String, String> addtionalEnv) {
        if (addtionalEnv != null) {
            this.environmentVariables.putAll(addtionalEnv);
        }
    }

    public String getExecutionUUID() {
        return this.executionUUID;
    }

    public void setExecutionUUID(String executionUUID) {
        this.executionUUID = executionUUID;
    }

    public String getExecutionSessionId() {
        return this.executionSessionId;
    }

    public void setExecutionSessionId(String executionSessionId) {
        this.executionSessionId = executionSessionId;
    }

    public void setAdditionalInfo(Map<String, String> data) {
        if (data != null) {
            this.additionalInfo.putAll(data);
        }
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public IRunConfiguration.Type getType() {
        return IRunConfiguration.Type.DEFAULT;
    }

    public void setFailedTestThreshold(int value) {
        IExecutedEntity executedEntity = this.executionSetting.getExecutedEntity();
        if (executedEntity instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutedEntity testSuiteEntity = (TestSuiteExecutedEntity)executedEntity;
            testSuiteEntity.setFailedThreshold(value);
        }
    }

    public void setDebugLaunchMode(boolean isDebugMode) {
        this.isDebugLaunchMode = isDebugMode;
    }

    public String getRemoteDomain() {
        return "";
    }

    public boolean shouldTerminateDriverAfterTestSuite() {
        Map<String, Object> generalProperties = this.executionSetting.getGeneralProperties();
        if (generalProperties == null) {
            return false;
        }
        return (Boolean)generalProperties.getOrDefault("terminateDriverAfterTestSuite", false);
    }

    public boolean shouldReloadDriverConnectorsBeforeLaunch() {
        return false;
    }

    public void copyDriverConnectorsFrom(AbstractRunConfiguration otherRunConfig) {
    }
}

