/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.ExistingDriverConnector;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExistingRunConfiguration
extends AbstractRunConfiguration {
    protected String sessionId;
    protected String remoteUrl;
    protected String driverName;
    protected String projectDir;
    protected String webSocketUrl;

    public ExistingRunConfiguration(String projectDir) {
        this.projectDir = projectDir;
    }

    public ExistingRunConfiguration(String projectDir, String sessionId, String remoteUrl, String driverName) {
        this.projectDir = projectDir;
        this.sessionId = sessionId;
        this.remoteUrl = remoteUrl;
        this.driverName = driverName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getWebSocketUrl() {
        return this.webSocketUrl;
    }

    public void setWebSocketUrl(String webSocketUrl) {
        this.webSocketUrl = webSocketUrl;
    }

    public Map<String, IDriverConnector> getDriverConnectors() {
        LinkedHashMap<String, IDriverConnector> webUIDriverCollector = new LinkedHashMap<String, IDriverConnector>();
        try {
            webUIDriverCollector.put("Existing", new ExistingDriverConnector(this.projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME, this.sessionId, this.remoteUrl, this.driverName, this.webSocketUrl));
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return webUIDriverCollector;
    }

    public IRunConfiguration cloneConfig() throws IOException, ExecutionException {
        return new ExistingRunConfiguration(this.projectDir, this.sessionId, this.remoteUrl, this.driverName);
    }

    @Override
    public String getReportDriverName() {
        return this.driverName;
    }
}

