/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration.impl;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.setting.MobileSettingStore;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CustomExecutionSetting
extends DefaultExecutionSetting {
    @Inject
    private IFeatureController featureController;
    private Map<String, IDriverConnector> driverConnectors;

    public CustomExecutionSetting(Map<String, IDriverConnector> driverConnectors) {
        this.driverConnectors = driverConnectors;
    }

    @Override
    public Map<String, Object> getGeneralProperties() {
        Map<String, Object> generalProperties = super.getGeneralProperties();
        if (this.driverConnectors != null && this.driverConnectors.size() > 0) {
            for (IDriverConnector driverConnector : this.driverConnectors.values()) {
                IDriverType driverType;
                if (driverConnector.getClass().getSimpleName().equals("RemoteWebDriverConnector")) {
                    try {
                        Method method = driverConnector.getClass().getMethod("getRemoteWebDriverConnectorType", new Class[0]);
                        Object type = method.invoke((Object)driverConnector, new Object[0]);
                        if (Objects.nonNull(type)) {
                            if ("selenium".equals(type.toString().toLowerCase())) {
                                generalProperties.putAll(this.getWebUiExecutionProperties());
                                continue;
                            }
                            if (!"appium".equals(type.toString().toLowerCase())) continue;
                            generalProperties.putAll(this.getMobileExecutionProperties());
                            continue;
                        }
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        LogUtil.logError((String)e.getMessage());
                    }
                }
                if ((driverType = driverConnector.getDriverType()) instanceof WebUIDriverType) {
                    generalProperties.putAll(this.getWebUiExecutionProperties());
                    continue;
                }
                if (!(driverType instanceof MobileDriverType)) continue;
                generalProperties.putAll(this.getMobileExecutionProperties());
            }
        }
        return generalProperties;
    }

    private Map<String, Object> getWebUiExecutionProperties() {
        WebUiExecutionSettingStore webUiSettingStore = WebUiExecutionSettingStore.getStore();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            props.put("enablePageLoadTimeout", webUiSettingStore.getEnablePageLoadTimeout());
            props.put("defaultPageLoadTimeout", webUiSettingStore.getPageLoadTimeout());
            props.put("actionDelay", webUiSettingStore.getActionDelay());
            props.put("useActionDelayInSecond", (Object)webUiSettingStore.getUseDelayActionTimeUnit());
            props.put("ignorePageLoadTimeoutException", webUiSettingStore.getIgnorePageLoadTimeout());
            props.put("excludeKeywords", webUiSettingStore.getExcludeKeywordList());
            props.put("methodsPriorityOrder", webUiSettingStore.getMethodsPriorityOrder());
            props.put("selfHealingEnabled", webUiSettingStore.getSelfHealingEnabled(this.canUseSelfHealing()));
            props.put("timeCapsuleEnabled", webUiSettingStore.getTimeCapsuleEnabled());
            props.put("flutterAppTestingEnabled", webUiSettingStore.isEnableFlutterAppTesting());
            props.put("canvasTextExtractionEnabled", webUiSettingStore.isEnableCanvasTextExtraction());
            props.put("closedShadowDOMEnabled", webUiSettingStore.isEnableClosedShadowDOMTesting());
            props.put("xpathsPriority", webUiSettingStore.getCapturedTestObjectXpathLocators());
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return props;
    }

    private Map<String, Object> getMobileExecutionProperties() {
        MobileSettingStore mobileSettingStore = MobileSettingStore.getStore();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            props.put("mobileSelfHealingEnabled", mobileSettingStore.getSelfHealingEnabled(this.canUseSelfHealing()));
            props.put("excludeMobileKeywords", mobileSettingStore.getExcludedKeywords());
            props.put("prioritizedLocatorStrategiesForAndroid", mobileSettingStore.getPrioritizedLocatorStrategies(MobilePlatform.ANDROID));
            props.put("prioritizedLocatorStrategiesForIos", mobileSettingStore.getPrioritizedLocatorStrategies(MobilePlatform.IOS));
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return props;
    }

    private boolean canUseSelfHealing() {
        return this.featureController.canUse(ProductFeature.SELF_HEALING);
    }
}

