/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.console.entity;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOptionContributor;
import com.kms.katalon.execution.console.entity.InfoOptionContributor;
import com.kms.katalon.execution.console.entity.LauncherOptionParser;
import com.kms.katalon.execution.console.entity.OverridingParametersConsoleOptionContributor;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.entity.DefaultReportSetting;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.WebServiceExecutionSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ReportableLauncherOptionParser
implements LauncherOptionParser {
    protected DefaultReportSetting reportableSetting;
    protected DefaultRerunSetting rerunSetting;
    protected InfoOptionContributor infoOptionContributor;
    protected WebServiceExecutionSettings webServiceSettings;
    protected StringConsoleOption executionUUIDOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "executionUUID";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private List<ConsoleOption<?>> overridingOptions = new ArrayList();

    public ReportableLauncherOptionParser() {
        this.webServiceSettings = new WebServiceExecutionSettings();
        this.reportableSetting = new DefaultReportSetting();
        this.rerunSetting = new DefaultRerunSetting();
        this.infoOptionContributor = new InfoOptionContributor();
    }

    protected List<ConsoleOptionContributor> getContributors() {
        return Arrays.asList(this.webServiceSettings, this.reportableSetting, this.rerunSetting, this.infoOptionContributor);
    }

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        ProjectEntity currentProject;
        ArrayList allOptions = new ArrayList();
        this.getContributors().forEach(contributor -> {
            boolean bl = allOptions.addAll(contributor.getConsoleOptionList());
        });
        allOptions.addAll(this.overridingOptions);
        if (this.overridingOptions.isEmpty() && (currentProject = ProjectController.getInstance().getCurrentProject()) != null) {
            this.overridingOptions = new OverridingParametersConsoleOptionContributor(currentProject).getConsoleOptionList();
            allOptions.addAll(this.overridingOptions);
        }
        allOptions.add(this.executionUUIDOption);
        return allOptions;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (consoleOption == this.executionUUIDOption) {
            consoleOption.setValue(argumentValue);
        }
        for (ConsoleOption<?> option : this.overridingOptions) {
            if (!option.getOption().equals(consoleOption.getOption())) continue;
            option.setValue(argumentValue);
        }
        for (ConsoleOptionContributor contributor : this.getContributors()) {
            if (!contributor.getConsoleOptionList().contains(consoleOption)) continue;
            contributor.setArgumentValue(consoleOption, argumentValue);
        }
    }

    public Map<String, Object> getOverridingGlobalVariables() {
        HashMap<String, Object> overridingGlobalVariables = new HashMap<String, Object>();
        this.overridingOptions.forEach(a -> {
            String option = a.getOption();
            if (option.startsWith("g_") && a.getValue() != null) {
                overridingGlobalVariables.put(a.getOption().replace("g_", ""), String.valueOf(a.getValue()));
            }
        });
        return overridingGlobalVariables;
    }

    public Map<String, Object> getOverridingProtectedGlobalVariables() {
        HashMap<String, Object> overridingGlobalVariables = new HashMap<String, Object>();
        this.overridingOptions.forEach(a -> {
            String option = a.getOption();
            if (option.startsWith("p_") && a.getValue() != null) {
                overridingGlobalVariables.put(a.getOption().replace("p_", ""), String.valueOf(a.getValue()));
            }
        });
        return overridingGlobalVariables;
    }
}

