/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.entity;

import com.katalon.platform.api.execution.TestCaseExecutionContext;
import com.katalon.platform.api.execution.TestSuiteExecutionContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestSuiteExecutionContextImpl
implements TestSuiteExecutionContext {
    private final Builder builder;

    private TestSuiteExecutionContextImpl(Builder builder) {
        this.builder = builder;
    }

    public String getId() {
        return this.builder.id;
    }

    public String getSourceId() {
        return this.builder.sourceId;
    }

    public long getStartTime() {
        return this.builder.startTime;
    }

    public long getEndTime() {
        return this.builder.endTime;
    }

    public String getReportId() {
        return this.builder.reportId;
    }

    public String getReportLocation() {
        return new File(this.builder.projectLocation, this.builder.reportId).getAbsolutePath();
    }

    public List<TestCaseExecutionContext> getTestCaseContexts() {
        return Collections.unmodifiableList(this.builder.testCaseContexts);
    }

    public String getHostName() {
        return this.builder.hostName;
    }

    public String getOs() {
        return this.builder.os;
    }

    public String getBrowser() {
        return this.builder.browser;
    }

    public String getDeviceId() {
        return this.builder.deviceId;
    }

    public String getDeviceName() {
        return this.builder.deviceName;
    }

    public String getSuiteName() {
        return this.builder.suiteName;
    }

    public String getExecutionProfile() {
        return this.builder.executionProfile;
    }

    public String toString() {
        return this.builder.toString();
    }

    public static class Builder {
        private String id;
        private String sourceId;
        private long startTime;
        private long endTime;
        private String reportId;
        private String projectLocation;
        private List<TestCaseExecutionContext> testCaseContexts = new ArrayList<TestCaseExecutionContext>();
        private String hostName;
        private String os;
        private String browser;
        private String deviceId;
        private String deviceName;
        private String suiteName;
        private String executionProfile;

        private Builder(String id, String sourceId, String projectLocation) {
            this.id = id;
            this.sourceId = sourceId;
            this.projectLocation = projectLocation;
        }

        public static Builder create(String id, String sourceId, String projectLocation) {
            return new Builder(id, sourceId, projectLocation);
        }

        public Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withReportId(String withReportId) {
            this.reportId = withReportId;
            return this;
        }

        public Builder withTestCaseContext(List<TestCaseExecutionContext> testCaseContexts) {
            this.testCaseContexts = testCaseContexts;
            return this;
        }

        public Builder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder withOs(String os) {
            this.os = os;
            return this;
        }

        public Builder withBrowser(String browser) {
            this.browser = browser;
            return this;
        }

        public Builder withDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder withDeviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Builder withSuiteName(String suiteName) {
            this.suiteName = suiteName;
            return this;
        }

        public Builder withExecutionProfile(String executionProfile) {
            this.executionProfile = executionProfile;
            return this;
        }

        public TestSuiteExecutionContextImpl build() {
            return new TestSuiteExecutionContextImpl(this);
        }
    }
}

